<?php

abstract class DgBase extends BaseFactory 
{	
	public function toGetDgHDInfo()
	{
		$this->setDgHdList();
	}
	
	public function toGetDgLDInfo()
	{
		$this->setDgLdList();
	}
	
	public function toGetDGInfo()
	{
		$handler = new DgInfoXmlHandler();
		$this->runCommand(XMLAPICommand::MV_DG_GetInfo, $handler);
	}

	public function toGetDGConfig()
	{		
		$handler = new DgConfigXmlHandler();
		$this->runCommand(XMLAPICommand::MV_DG_GetConfig, $handler);
	}

	public function setDgHdList()
	{
		$hdlist = new HdList();
		$hdlist->setAdapterID($this->getAdapterID());
		$hdlist->toGetHDInfo();
		$hdlist->toGetHDRaidStatus();
		//$hdlist->toGetHdFreeInfo();
		//$hdlist->toGetMPStatus();
		//$hdlist->toGetValidSize();
		
		$hds = $hdlist->getBaseClasses();
		
		//set HDs into array
		foreach ($this->BaseClasses as $dgInfo)
		{
			//get member disks
			$dgHds = array();
			foreach ($hds as $hd)
			{
				if(in_array($hd->getDeviceID(),$dgInfo->getHDIDs()))
				{
					$dgHds[$hd->getDeviceID()] = $hd;					
				}
			}
			ksort($dgHds);
			$dgInfo->setHDList($dgHds);
			
			//get dedicated spare disks
			$spareHds = array();
			foreach ($hds as $hd)
			{
				if(in_array($hd->getDeviceID(),$dgInfo->getSpareHDIDs()))
				{
					$spareHds[$hd->getDeviceID()] = $hd;					
				}
			}
			ksort($spareHds);
			$dgInfo->setSpareHDList($spareHds);			
		}
	}
	
	public function setDgLdList()
	{
		$ldlist = new LdOnDgList();
		$ldlist->setAdapterID($this->getAdapterID());
		$ldlist->toGetLDInfo();
		$ldlist->toGetLDStatus();
		
		$lds = $ldlist->getBaseClasses();
		
		//set LDs into array
		foreach ($this->BaseClasses as $dgInfo)
		{
			$dgLds = array();
			foreach ($lds as $ld)
			{
				if(in_array($ld->getID(),$dgInfo->getLDIDs()))
				{
					$dgLds[$ld->getID()] = $ld;					
				}
			}
			ksort($dgLds);
			$dgInfo->setLDList($dgLds);
		}
	}
	
	protected function createObject()
	{
		return new DG();
	}
}

?>