<?php
class HyperSSDInfo {
    public $ID;
    public $StartLBA;
    //public $EndLBA;
    public $Size;
    public $SizeGB;
    public $Type;
    public $Status;
    //public $RebuildPercentage;
    public $BgaString = 0;
    public $BgaStatusString = 0;
    public $StatusString;
    public $isRebuilding;
    public $isMissing;
    public $isHyperSSDNoneBind;

    public $Attributes;
    public $HyperImg; //image
    public $SerialNumber;
    public $Model;
    public $FilterDriverInstall;
    public $FilterDriverRun;
    public $Bga=0;
    public $BgaPercentage=0;
    public $BgaStateInt=0;
    public $BgaStateString=0;
    public $StatusColor = "#000000";
    public $needReboot = 0;
    public $CachePolicy;
    public $CachePolicyStr;
    public $canUnlink = 0;
    public $canLink = 0;

    public function setHyperSSDInfo($info) {
        $this->ID = $info->getID();
        $this->StartLBA = $info->getStart();
        //$this->EndLBA = ;
        $this->Size = $info->getSize();
        $this->SizeGB = FormatSize($this->Size);
        //$this->Type = SSDPartitionType::getPartitionTypeStr($info->getType());
        $this->Status = $info->getStatus();
        $this->StatusString = HyperSSDStatus::getStatusStr($this->Status);
        $this->CachePolicy = $info->getCachePolicy();
        $this->CachePolicyStr = HyperSSDCachePolicy::getPolicyStr($info->getCachePolicy());
        
        
        $this->HyperImg = "RAID_online.gif";

        $this->isRebuilding = $info->isHyperSSDRebuilding();
        $this->needReboot = $info->isHyperSSDNeedReboot();
        $this->isMissing = $info->isHyperSSDMissing();
        $this->isHyperSSDNoneBind = $info->isHyperSSDNoneBind();
        
        if ($this->isHyperSSDNoneBind || $this->needReboot) {  //if hyperssd not bind or need reboot, can not get correst size
            $this->SizeGB = "N/A";
        }

        //$isAdmin = getSessionPara('isAdmin');
        //if ($isAdmin){
            if ($this->isHyperSSDNoneBind) {
                $this->canLink = 1;
            } else {
                $this->canUnlink = 1;
            }
       // }

        if ($this->isRebuilding) {
            $this->BgaPercentage = $info->getBgaPercentage();
            $this->HyperImg = "RAID_online_bga.gif";
            $this->setBGAStrings();
        }

        if ($this->isMissing) {
            $this->HyperImg = "RAID_degrade.gif";
        }

        if ($this->isHyperSSDNoneBind) {
            $this->HyperImg = "RAID_offline.gif";
        }

        if ($this->needReboot) {
            $this->StatusColor = "#FF0000";
        }
        
        $disk = $info->getAssociatedDisk();

        if(isset($disk)) {
            $this->SerialNumber = $disk->getSerialNumber();
            $this->Model = $disk->getModel();
        }
    }

    private function setBGAStrings() {
            $this->StatusString = "Rebuilding";
            $this->BgaString = "Rebuild";
            $this->BgaStatusString = "Rebuild";
    }
}
?>
