<?php
class SSDVolumeInfo
{
	public $ID=0;
	public $AdapterID=0;
	public $rawCapacity=0;
	public $rawCapacityGB=0;
    //public $usableCapacity=0;
    public $opLevel=0;
    public $opLevelStr=0;
    public $totalSSDWrite=0;
    //public $healthStatus=0;
    public $lifeRemaining=0;
    public $Size=0;
    public $SizeGB=0;
    public $RaidModeInt=0;
    public $RaidMode=0;
    public $StatusInt=0;
    public $StatusString="";
    public $StatusColor="";
	public $VolumeImg = "";
	public $enableDelete = 0;
	public $Adapters;
	public $Bga=0;
	public $BgaString = 0;
	public $BgaStatusString = 0;
	public $BgaPercentage=0;
	public $BgaStateInt=0;
	public $BgaStateString=0;

	public function __construct()
	{
		$this->Adapters = array();
	}
	
	public function setSSDVolumeInfo($volume)
	{
		$this->AdapterID = $volume->getAdapterID();
		//total size
		$this->rawCapacity = $volume->getRawCapacity();
		$this->rawCapacityGB = FormatSize($this->rawCapacity);
		//usable size
		$this->Size = $volume->getVDSize();
		$this->SizeGB = FormatSize($this->Size);
		
		$this->opLevel = $volume->getOpLevel();
		$this->opLevelStr = SSDOpeatingLevel::getOplevelStr($this->opLevel);
		$this->totalSSDWrite = $volume->getTotalSSDWrite();
		//$this->healthStatus = $volume->getHealthStatus();
		$this->lifeRemaining = $volume->getLifeRemaining();
		$this->RaidModeInt = $volume->getRaidMode();
		$this->RaidMode = RAIDMode::GetSSDVolumeRAIDModeStr($this->RaidModeInt);
		
		$this->StatusInt = $volume->getVDStatus();
		$TmpStr = LDStatus::getLDStatusStr($this->StatusInt);
		$this->StatusString = gettext($TmpStr);
		$this->StatusColor = LDStatus::getSSDVolumeStatusStrFont($this->StatusInt);
		
		//$this->BGAStatus = $volume->getBGAStatus();
		$this->Bga = $volume->getBga();
		$this->BgaPercentage = $volume->getBgaPercentage();
		$this->BgaStateInt = $volume->getBgaState();
		
		$this->BgaCheck();
		$this->setBGAStrings();
		
		$this->VolumeImg = "SSD_" . LDStatus::getLDImg($this->StatusInt,$this->BgaStateInt);	
		
		$this->enableDelete = 1; //check ??
		
		$this->setVolumeMember($volume);
	}
	
	private function BgaCheck()
	{
		if (($this->Bga == LdBgaStatus::LD_BGA_NONE) || ($this->BgaStateInt == LdBgaState::LD_BGA_STATE_NONE)) {
			$this->Bga = LdBgaStatus::LD_BGA_NONE ;
			$this->BgaStateInt = LdBgaState::LD_BGA_STATE_NONE ;
			$this->BgaPercentage = 0;
		}
	}
	
	private function setBGAStrings()
	{
		$TmpStr = LDStatus::getLDStatusStr($this->StatusInt);
		$this->StatusString = gettext($TmpStr);
		
		$TmpStr = LdBgaStatus::getLdBgaString($this->Bga);
		$this->BgaString = gettext($TmpStr);
		
		$TmpStr = LdBgaStatus::getLdBgaStatusStr($this->Bga);
		$this->BgaStatusString = gettext($TmpStr);
		
		if ($this->BgaStateInt == LdBgaState::LD_BGA_STATE_RUNNING ||
			$this->BgaStateInt == LdBgaState::LD_BGA_STATE_NONE )
		{
			$this->BgaStateString = "";
		}
		else {
			$TmpStr = LdBgaState::getLdBgaStateStr($this->BgaStateInt);
			$this->BgaStateString = gettext($TmpStr);	
		}
	}
	
	private function setVolumeMember($volume)
	{
		//ld disks 
		$HDs = array();
		$Blks = $volume->getBlockList();
		foreach ($Blks as $Blk)
		{
			$HD = $Blk->belongHD();
			//var_dump($HD);
			if ($HD) {
				$notfound = true;
				foreach ($this->Adapters as $adpater)
				{
					if (intval($adpater->AdapterID) == $HD->getAdapterID()) {
						$disk = new Disk();
						if(($Blk->getFlag()) & (BlockFlag::BLOCK_FLAG_REBUILDING)){
							$disk->setRebuildingFlag();
						}
						$disk->setHDInfo($HD);
						$disk->LDUsedSize = FormatSize($Blk->getSize());
						$adpater->HDs[$HD->getDeviceID()] = $disk;
						$notfound = false;
					}
				}
				if ($notfound) {
					$adpater = new LDAdapter();
					$adpater->AdapterID = $HD->getAdapterID();
					$disk = new Disk();
					if(($Blk->getFlag()) & (BlockFlag::BLOCK_FLAG_REBUILDING)){
						$disk->setRebuildingFlag();
					}
					$disk->setHDInfo($HD);
					$disk->LDUsedSize = FormatSize($Blk->getSize());
					$adpater->HDs[$HD->getDeviceID()] = $disk;
					$this->Adapters[$adpater->AdapterID] = $adpater;
				}
			}
		}
		foreach ($this->Adapters as $adpater)
		{
			ksort($adpater->HDs);
		}
		ksort($this->Adapters);
	}
    
}
?>