/*
 * Decompiled with CFR 0.152.
 */
package manager.project;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import manager.app.AppData;
import manager.configure.Firmware;
import manager.project.ISSProjectData;
import manager.sensor.Sensor;
import manager.utils.ManagerEnums;
import manager.utils.ManagerFileUtils;

public class ProjectModificationTracker
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DATA_FILE_DEFAULT_NAME = "BuildModificationData";
    public static final String[] SCANNED_SOURCE_FILE_TYPES = new String[]{".c", ".h"};
    private transient ISSProjectData projectData;
    private HashMap<String, ComponentModificationTracker> componentsData = new HashMap();
    private long lastScanDate = Long.MIN_VALUE;
    private long lastProjectModificationDate = Long.MIN_VALUE;
    private String lastScannedFWVersion = null;
    private String lastScannedPlatform = null;

    public ProjectModificationTracker(ISSProjectData projectData) {
        this.projectData = projectData;
    }

    public ComponentModificationTracker getComponentData(String componentName) {
        return this.componentsData.get(componentName);
    }

    public void updateModificationData(ArrayList<Sensor> components, ManagerEnums.CompilationMode compMode) {
        for (Sensor selectedComponent : components) {
            ComponentModificationTracker component = new ComponentModificationTracker(this.projectData, selectedComponent.getSensorData().getFileName());
            component.updateModification(compMode);
            this.componentsData.put(selectedComponent.getSensorData().getFileName(), component);
        }
    }

    public void updateModificationApps(List<AppData> apps, ManagerEnums.CompilationMode compMode) {
        for (AppData app : apps) {
            ComponentModificationTracker component = new ComponentModificationTracker(this.projectData, app.getName());
            component.updateModification(compMode);
            this.componentsData.put(app.getName(), component);
        }
    }

    public void updateModificationData(ManagerEnums.CompilationMode compMode) {
        this.componentsData.clear();
        ArrayList<Sensor> selectedComponents = this.projectData.getUserSelectedSensors();
        this.updateModificationData(selectedComponents, compMode);
        this.updateModificationApps(this.projectData.getSelectedApps(), compMode);
        this.lastScanDate = new Date().getTime();
        try {
            Firmware fw = this.projectData.getFirmware();
            if (fw != null) {
                this.lastScannedFWVersion = fw.getVersion();
            }
            this.lastScannedPlatform = this.projectData.getPlatform().getName();
        }
        catch (Exception fw) {
            // empty catch block
        }
        try {
            this.serialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<String> getModifiedComponents(ManagerEnums.CompilationMode compMode) {
        ArrayList<Sensor> selectedComponents = this.projectData.getUserSelectedSensors();
        ArrayList<String> modifiedComponents = new ArrayList<String>();
        for (Sensor selectedComponent : selectedComponents) {
            String fileName = selectedComponent.getSensorData().getFileName();
            if (this.componentsData.containsKey(fileName) && !this.componentsData.get(fileName).isModified(compMode)) continue;
            modifiedComponents.add(selectedComponent.getSensorData().getFileName());
        }
        return modifiedComponents;
    }

    public ArrayList<String> getModifiedApps(ManagerEnums.CompilationMode compMode) {
        List<AppData> apps = this.projectData.getSelectedApps();
        ArrayList<String> modifiedComponents = new ArrayList<String>();
        for (AppData app : apps) {
            String fileName = app.getName();
            if (this.componentsData.containsKey(fileName) && !this.componentsData.get(fileName).isModified(compMode)) continue;
            modifiedComponents.add(fileName);
        }
        return modifiedComponents;
    }

    public long getLastProjectModificationDate() {
        return this.lastProjectModificationDate;
    }

    public void updateLastProjectModificationDate(long lastProjectModificationDate) {
        this.lastProjectModificationDate = Math.max(this.lastProjectModificationDate, lastProjectModificationDate);
    }

    public void reportModification() {
        this.updateLastProjectModificationDate(new Date().getTime());
    }

    public boolean hasFWVersionChanged() {
        String fw = this.projectData.getFwVersion();
        String plat = this.projectData.getPlatform().getName();
        if (this.lastScannedFWVersion == null || this.lastScannedPlatform == null) {
            return true;
        }
        return !plat.equals(this.lastScannedPlatform) || !fw.equals(this.lastScannedFWVersion);
    }

    public boolean isProjectModified(ManagerEnums.CompilationMode compMode) {
        return this.getModifiedComponents(compMode).size() > 0 || this.getModifiedApps(compMode).size() > 0 || this.lastProjectModificationDate > this.lastScanDate || this.hasFWVersionChanged();
    }

    public void setISSProjectData(ISSProjectData projectData) {
        this.projectData = projectData;
        for (String component : this.componentsData.keySet()) {
            this.componentsData.get(component).setISSProjectData(projectData);
        }
    }

    public void serialize() throws Exception {
        File dataFile = new File(String.valueOf(ManagerFileUtils.getProjectSettingsFolder(this.projectData)) + File.separator + DATA_FILE_DEFAULT_NAME);
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(dataFile);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
    }

    public static ProjectModificationTracker deserialize(ISSProjectData projectData) throws Exception {
        File dataFile = new File(String.valueOf(ManagerFileUtils.getProjectSettingsFolder(projectData)) + File.separator + DATA_FILE_DEFAULT_NAME);
        if (!dataFile.isFile()) {
            return null;
        }
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(dataFile);
            ois = new ObjectInputStream(fis);
            ProjectModificationTracker loadedObject = (ProjectModificationTracker)ois.readObject();
            if (loadedObject == null) {
                throw new Exception("Error while loading the preferences.");
            }
            loadedObject.setISSProjectData(projectData);
            ProjectModificationTracker projectModificationTracker = loadedObject;
            return projectModificationTracker;
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
    }

    public static class ComponentModificationTracker
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private HashMap<File, Long> filesModification = new HashMap();
        private ManagerEnums.CompilationMode lastCompMode;
        private transient ISSProjectData projectData;
        private String componentName;
        private String lastFirmware = null;
        private String lastPlatform = null;

        public ComponentModificationTracker(ISSProjectData projectData, String componentName) {
            this.projectData = projectData;
            this.componentName = componentName;
        }

        public void setISSProjectData(ISSProjectData projectData) {
            this.projectData = projectData;
        }

        private ArrayList<File> getSourceFiles() {
            ArrayList<String> allComponentFiles = ManagerFileUtils.getFilesListRecursive(new File(String.valueOf(this.projectData.getProjectPath()) + File.separator + this.componentName));
            ArrayList<File> componentSourceFiles = new ArrayList<File>();
            block0: for (String filePath : allComponentFiles) {
                String[] stringArray = SCANNED_SOURCE_FILE_TYPES;
                int n = SCANNED_SOURCE_FILE_TYPES.length;
                int n2 = 0;
                while (n2 < n) {
                    String allowedFileType = stringArray[n2];
                    if (filePath.endsWith(allowedFileType)) {
                        componentSourceFiles.add(new File(filePath));
                        continue block0;
                    }
                    ++n2;
                }
            }
            return componentSourceFiles;
        }

        public boolean isModified(ManagerEnums.CompilationMode compMode) {
            String fw = this.projectData.getFwVersion();
            String plat = this.projectData.getPlatform().getName();
            if (this.lastFirmware == null || this.lastPlatform == null) {
                return true;
            }
            if (!plat.equals(this.lastPlatform) || !fw.equals(this.lastFirmware)) {
                return true;
            }
            ArrayList<File> files = this.getSourceFiles();
            if (this.filesModification.size() != files.size() || compMode != this.lastCompMode) {
                return true;
            }
            for (File file : files) {
                if (this.filesModification.containsKey(file) && this.filesModification.get(file).equals(file.lastModified())) continue;
                return true;
            }
            return false;
        }

        public void updateModification(ManagerEnums.CompilationMode compMode) {
            this.filesModification.clear();
            for (File file : this.getSourceFiles()) {
                this.filesModification.put(file, file.lastModified());
            }
            this.lastCompMode = compMode;
            this.lastFirmware = this.projectData.getFwVersion();
            this.lastPlatform = this.projectData.getPlatform().getName();
        }
    }
}

