/*
 * Decompiled with CFR 0.152.
 */
package manager.sensor;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Random;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import manager.common.BiMap;
import manager.common.BuildVersion;
import manager.common.Field;
import manager.common.Interrupt;
import manager.common.SPI;
import manager.configure.Platform;
import manager.configure.VendorListConfiguration;
import manager.pack.PackUtils;
import manager.sensor.SensorData;
import manager.sensor.SensorDataWrapper;
import manager.utils.ManagerConfigs;
import manager.utils.ManagerEnums;
import manager.utils.ManagerExternalLibraryUtils;
import manager.utils.ManagerFileUtils;
import manager.utils.ManagerUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SensorDataManager {
    public static ArrayList<SensorData> getSensorsInfo(String fileName, String filesPath, boolean searchNameByIdInUser, Platform projPlatform) throws Exception {
        return SensorDataManager.getSensorsInfo(fileName, filesPath, ManagerFileUtils.DEFAULT_GCC_DIR(), searchNameByIdInUser, projPlatform);
    }

    public static ArrayList<SensorData> getSensorsInfo(String fileName, String filesPath, String gccLocation, boolean searchNameByIdInUser, Platform projPlatform) throws Exception {
        ArrayList<SensorData> dataList;
        block8: {
            dataList = new ArrayList<SensorData>();
            try {
                String oFilePath = SensorDataManager.findOFilePath(fileName.endsWith(".o") ? fileName.substring(0, fileName.length() - 2) : fileName, filesPath);
                if (!oFilePath.isEmpty()) {
                    String xmlTempFile = SensorDataManager.ExtractXmlFromOFile(oFilePath, gccLocation);
                    File tempFile = new File(xmlTempFile);
                    Document doc = SensorDataManager.readFromXML(tempFile);
                    NodeList nodeList = doc.getElementsByTagName("Sensor");
                    int i = 0;
                    while (i < nodeList.getLength()) {
                        Element sensorInfo = (Element)nodeList.item(i);
                        SensorData data = SensorDataManager.getSensorDataByElement(sensorInfo, true, searchNameByIdInUser, projPlatform);
                        if (data != null) {
                            dataList.add(data);
                        }
                        ++i;
                    }
                    if (tempFile.exists()) {
                        tempFile.delete();
                    }
                    if (Paths.get(xmlTempFile, new String[0]).getParent().toFile().exists()) {
                        Paths.get(xmlTempFile, new String[0]).getParent().toFile().delete();
                    }
                    if (dataList == null || dataList.size() == 0) {
                        throw new Exception("Failed to get " + fileName + " info.");
                    }
                    break block8;
                }
                throw new Exception("Failed to find " + fileName + " object file.");
            }
            catch (Exception e) {
                throw new Exception("Failed to get " + fileName + " info: " + (e != null && e.getMessage() != null ? e.getMessage() : ""));
            }
        }
        return dataList;
    }

    public static ArrayList<SensorData> getSensorsInfoFromAFile(String fileName, String filesPath, String gccLocation, boolean searchNameByIdInUser, Platform projPlatform) throws Exception {
        ArrayList<SensorData> dataList = new ArrayList<SensorData>();
        File aFilesTempDir = new File("..\\..\\VendorSensor\\a");
        File oFilesTempDir = new File("..\\..\\VendorSensor\\o");
        File sensorLibFile = new File(String.valueOf(fileName) + ".a");
        try {
            if (aFilesTempDir.exists()) {
                ManagerFileUtils.fastDeleteFileOrDirectory(aFilesTempDir);
            }
            aFilesTempDir.mkdirs();
            if (oFilesTempDir.exists()) {
                ManagerFileUtils.fastDeleteFileOrDirectory(oFilesTempDir);
            }
            oFilesTempDir.mkdirs();
            File DestPath = new File(String.valueOf(aFilesTempDir.getPath()) + File.separator + sensorLibFile.getName());
            Files.copy(sensorLibFile.toPath(), DestPath.toPath(), new CopyOption[0]);
            ManagerExternalLibraryUtils.importStaticLibrary(String.valueOf(aFilesTempDir.getPath()) + File.separator + sensorLibFile.getName(), oFilesTempDir.getPath(), gccLocation);
            File[] fileArray = oFilesTempDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File currentFile = fileArray[n2];
                if (SensorDataManager.hasMetadata(currentFile.getAbsolutePath(), gccLocation, projPlatform)) {
                    ArrayList<SensorData> sensors = SensorDataManager.getSensorsInfo(currentFile.getName(), currentFile.getParentFile().getAbsolutePath(), gccLocation, true, projPlatform);
                    dataList.addAll(sensors);
                }
                ++n2;
            }
        }
        finally {
            File tempFile = new File("..\\..\\VendorSensor");
            if (tempFile.exists()) {
                ManagerFileUtils.fastDeleteFileOrDirectory(tempFile);
            }
        }
        return dataList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SensorData getSensorDataByElement(Element sensorInfo, boolean toForceExtraFields, boolean searchNameByIdInUser, Platform projPlatform) throws Exception {
        try {
            Element dependencies;
            String notExposedFlagValue;
            String customFlagValue;
            String ftype;
            Element systemEvents;
            Element callbacks;
            String vendorID;
            String componentName = "";
            SensorData data = new SensorData();
            String objectType = sensorInfo.getAttribute("ObjectType");
            if (objectType == null || objectType.isEmpty()) {
                throw new Exception("This sensor's metadata is missing the content of the Object Type field.");
            }
            data.setObjectType(ManagerEnums.ObjectTypes.getValueByFriendlyName(objectType));
            componentName = data.getObjectType() != ManagerEnums.ObjectTypes.LIBRARY ? ManagerEnums.ComponentName.SENSOR.getFriendlyName() : ManagerEnums.ComponentName.LIBRARY.getFriendlyName();
            String platformString = sensorInfo.getAttribute("ISSVersion");
            Platform platform = projPlatform;
            if (platformString != null && !platformString.isEmpty()) {
                if (!platformString.equals("TOSTRING(VER_MAJOR)") && !platformString.equals("TOSTRING(VER_MAJOR).TOSTRING(VER_MINOR)")) {
                    try {
                        Double platformValue = Double.parseDouble(platformString);
                        platform = ManagerConfigs.getPlatformByValue(platformValue);
                    }
                    catch (Exception e) {
                        try {
                            platform = ManagerConfigs.getPlatformByName(platformString);
                            if (platform == null) {
                                throw new Exception("This " + componentName + "'s ISS Version (" + platformString + ") field can't be parsed.");
                            }
                        }
                        catch (NullPointerException e1) {
                            platform = new Platform(platformString);
                        }
                    }
                }
            } else if (toForceExtraFields) {
                throw new Exception("This " + componentName + "'s metadata is missing the content of the ISS Version field.");
            }
            if (platform == null) {
                throw new Exception("Error platform information.");
            }
            data.setPlatform(platform);
            BuildVersion buildVersion = BuildVersion.emptyVersion;
            String buildNumberString = sensorInfo.getAttribute("BuildNumber");
            if (buildNumberString == null || buildNumberString.isEmpty()) {
                buildNumberString = sensorInfo.getAttribute("OemProjectVersion");
            }
            if (buildNumberString != null && !buildNumberString.isEmpty()) {
                try {
                    buildVersion = BuildVersion.parseVersion(buildNumberString, platform);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            data.setBuildVersion(buildVersion);
            String SCAPIVersion = sensorInfo.getAttribute("SensorCoreAPIVersion");
            data.setSensorCoreAPIVersion(SCAPIVersion);
            String pluginVersion = sensorInfo.getAttribute("PluginVersion");
            if (pluginVersion != null && !pluginVersion.isEmpty()) {
                data.setPluginVersion(pluginVersion);
            }
            if (data.getObjectType() != ManagerEnums.ObjectTypes.LIBRARY) {
                String sensorName;
                String doNotAddSensorPostfix = sensorInfo.getAttribute("DoNotAddSensorPostfix");
                if (doNotAddSensorPostfix != null && !doNotAddSensorPostfix.isEmpty()) {
                    data.setDoNotAddSensorPostfix(Boolean.parseBoolean(doNotAddSensorPostfix));
                }
                if ((sensorName = sensorInfo.getAttribute("SensorName")) == null || sensorName.isEmpty()) {
                    throw new Exception("This " + componentName + "'s metadata is missing the content of the Sensor Name field.");
                }
                data.setName(sensorName);
                String modelID = sensorInfo.getAttribute("ModelId");
                if (modelID == null || modelID.isEmpty()) {
                    throw new Exception("This " + componentName + "'s metadata is missing the content of the Model Id field.");
                }
                data.setModelId(Integer.parseInt(modelID));
                String modelName = sensorInfo.getAttribute("ModelName");
                if (modelName != null && !modelName.isEmpty()) {
                    data.setModelName(modelName);
                } else {
                    data.setModelName("");
                }
                data.setFriendlyModelName(modelName);
                String autoStart = sensorInfo.getAttribute("AutoStart");
                if (autoStart != null && !autoStart.isEmpty()) {
                    data.setAutoStart(Boolean.parseBoolean(autoStart));
                    if (data.getAutoStart()) {
                        String asSensitivity = sensorInfo.getAttribute("AutoStartSensitivity");
                        if (asSensitivity == null || asSensitivity.isEmpty()) {
                            throw new Exception("This " + componentName + "'s metadata is missing the content of the Auto Start Sensitivity field.");
                        }
                        data.setAutoStartSensitivity(Integer.parseInt(asSensitivity));
                        String asMinRi = sensorInfo.getAttribute("AutoStartMinReportInterval");
                        if (asMinRi == null || asMinRi.isEmpty()) throw new Exception("This " + componentName + "'s metadata is missing the content of the Auto Start Min Report Interval field.");
                        data.setAutoStartMinRi(Integer.parseInt(asMinRi));
                    }
                }
            } else {
                String sensorName = sensorInfo.getAttribute("LibraryName");
                if (sensorName == null || sensorName.isEmpty()) {
                    throw new Exception("This " + componentName + "'s metadata is missing the content of the Library Name field.");
                }
                data.setName(sensorName);
                String modelID = sensorInfo.getAttribute("VersionId");
                if (modelID == null || modelID.isEmpty()) {
                    throw new Exception("This " + componentName + "'s metadata is missing the content of the Version Id field.");
                }
                data.setModelId(Integer.parseInt(modelID));
                String modelName = sensorInfo.getAttribute("VersionName");
                if (modelName != null && !modelName.isEmpty()) {
                    data.setModelName(modelName);
                } else {
                    data.setModelName("");
                }
                data.setFriendlyModelName(modelName);
            }
            if (data.getObjectType() != ManagerEnums.ObjectTypes.LIBRARY) {
                String flags = sensorInfo.getAttribute("Flags");
                if (flags == null || flags.isEmpty()) {
                    throw new Exception("This " + componentName + "'s metadata is missing the content of the Flags field.");
                }
                data.setFlags(Integer.parseInt(flags));
                String initName = sensorInfo.getAttribute("InitFunctionName");
                if (initName != null && !initName.isEmpty()) {
                    data.setInitFunction(initName);
                } else if (toForceExtraFields) {
                    throw new Exception("This " + componentName + "'s metadata is missing the content of the Init Function Name field.");
                }
            }
            if ((vendorID = sensorInfo.getAttribute("VendorId")) == null || vendorID.isEmpty()) {
                throw new Exception("This " + componentName + "'s metadata is missing the content of the Vendor Id field.");
            }
            data.setVendorId(Integer.parseInt(vendorID));
            String vendorName = sensorInfo.getAttribute("VendorName");
            if (vendorName != null && !vendorName.isEmpty()) {
                data.setVendorName(vendorName);
            } else {
                data.setVendorName(SensorDataManager.findVendorNameById(Integer.parseInt(vendorID), searchNameByIdInUser, platform));
            }
            data.setFriendlyVendorName(data.getVendorName());
            if (data.getObjectType() != ManagerEnums.ObjectTypes.LIBRARY) {
                String typeID = sensorInfo.getAttribute("SensorTypeId");
                if (typeID == null || typeID.isEmpty()) {
                    throw new Exception("This " + componentName + "'s metadata is missing the content of the Type Id field.");
                }
                data.setTypeId(Integer.parseInt(typeID));
                data.setTypeName(SensorDataManager.findSensorTypeNameById(Integer.parseInt(typeID), searchNameByIdInUser, platform));
                String friendlyName = sensorInfo.getAttribute("FriendlyName");
                if (friendlyName == null || friendlyName.isEmpty()) {
                    friendlyName = data.getTypeName();
                }
                if (!Character.isDigit(friendlyName.charAt(0))) {
                    data.setFriendlyName(friendlyName);
                } else {
                    data.setFriendlyName("UNKNOWN");
                }
            }
            if (data.getObjectType() == ManagerEnums.ObjectTypes.PHYSICAL) {
                NodeList busTypes = sensorInfo.getElementsByTagName("BusType");
                int i = 0;
                while (i < busTypes.getLength()) {
                    String busType = busTypes.item(i).getTextContent();
                    if (busType.equals(ManagerEnums.BusTypes.I2C.name())) {
                        data.addBusType(ManagerEnums.BusTypes.I2C);
                        NodeList addresses = sensorInfo.getElementsByTagName("Address");
                        if (addresses.getLength() == 0) {
                            throw new Exception("This " + componentName + "'s metadata is missing the content of the Address field.");
                        }
                        int j = 0;
                        while (j < addresses.getLength()) {
                            Element address = (Element)addresses.item(j);
                            data.addAddress(Integer.parseInt(address.getTextContent()));
                            ++j;
                        }
                    } else if (busType.equals(ManagerEnums.BusTypes.UART.name())) {
                        data.addBusType(ManagerEnums.BusTypes.UART);
                    } else if (busType.equals(ManagerEnums.BusTypes.SPI.name())) {
                        data.addBusType(ManagerEnums.BusTypes.SPI);
                        SPI spi = new SPI();
                        NodeList spiDetail = sensorInfo.getElementsByTagName("SPI");
                        if (spiDetail.getLength() != 0) {
                            String phaStr;
                            String polStr;
                            String fzStr;
                            String speedStr = sensorInfo.getAttribute("Speed");
                            if (speedStr != null && !speedStr.isEmpty()) {
                                spi.setSpeed(Integer.parseInt(speedStr));
                            }
                            if ((fzStr = sensorInfo.getAttribute("FrameSize")) != null && !fzStr.isEmpty()) {
                                spi.setFrameSize(Integer.parseInt(fzStr));
                            }
                            if ((polStr = sensorInfo.getAttribute("Polarity")) != null && !polStr.isEmpty()) {
                                spi.setPrpolarity(Integer.parseInt(polStr));
                            }
                            if ((phaStr = sensorInfo.getAttribute("Phase")) != null && !phaStr.isEmpty()) {
                                spi.setPhase(Integer.parseInt(phaStr));
                            }
                        }
                        data.setSpi(spi);
                    } else if (busType.equals(ManagerEnums.BusTypes.IIPC.name())) {
                        data.addBusType(ManagerEnums.BusTypes.IIPC);
                    }
                    ++i;
                }
                Element GPInputs = (Element)sensorInfo.getElementsByTagName("GPInputs").item(0);
                if (GPInputs != null) {
                    NodeList GPInputsList = GPInputs.getElementsByTagName("GPInput");
                    int i2 = 0;
                    while (i2 < GPInputsList.getLength()) {
                        Element GPInput = (Element)GPInputsList.item(i2);
                        Interrupt interruptData = new Interrupt();
                        Element name = (Element)GPInput.getElementsByTagName("Name").item(0);
                        Element purposeId = (Element)GPInput.getElementsByTagName("PurposeId").item(0);
                        interruptData.setName(name.getTextContent());
                        interruptData.setPurposeId(Integer.parseInt(purposeId.getTextContent()));
                        data.addGPInput(interruptData);
                        ++i2;
                    }
                } else {
                    busTypes.getLength();
                }
            }
            if (data.getObjectType() != ManagerEnums.ObjectTypes.LIBRARY) {
                Element calibrationFormats;
                Element GPOutputs = (Element)sensorInfo.getElementsByTagName("GPOutputs").item(0);
                if (GPOutputs != null) {
                    NodeList GPOutputsList = GPOutputs.getElementsByTagName("GPOutput");
                    int i = 0;
                    while (i < GPOutputsList.getLength()) {
                        Element GPOutput = (Element)GPOutputsList.item(i);
                        Interrupt interruptData = new Interrupt();
                        Element name = (Element)GPOutput.getElementsByTagName("Name").item(0);
                        Element purposeId = (Element)GPOutput.getElementsByTagName("PurposeId").item(0);
                        interruptData.setName(name.getTextContent());
                        interruptData.setPurposeId(Integer.parseInt(purposeId.getTextContent()));
                        data.addGPOutput(interruptData);
                        ++i;
                    }
                }
                if ((calibrationFormats = (Element)sensorInfo.getElementsByTagName("SupportedCalibrationFormats").item(0)) != null) {
                    NodeList calibrationFormatsList = calibrationFormats.getElementsByTagName("FormatId");
                    int i = 0;
                    while (i < calibrationFormatsList.getLength()) {
                        Element format = (Element)calibrationFormatsList.item(i);
                        data.addCalibrationFormat(Integer.parseInt(format.getTextContent()));
                        ++i;
                    }
                }
            }
            if (data.getObjectType() != ManagerEnums.ObjectTypes.VIRTUAL) return data;
            Element sensorAttributes = (Element)sensorInfo.getElementsByTagName("SensorAttributes").item(0);
            if (sensorAttributes != null) {
                Element override;
                Element alwaysOn;
                Element wakeFromCS;
                Element stateDriven;
                ArrayList<ManagerEnums.SensorAttributes> sensorAttributesList = new ArrayList<ManagerEnums.SensorAttributes>();
                Element eventDriven = (Element)sensorAttributes.getElementsByTagName("IsEventDriven").item(0);
                if (eventDriven != null && Boolean.parseBoolean(eventDriven.getTextContent())) {
                    sensorAttributesList.add(ManagerEnums.SensorAttributes.EVENT_DRIVEN);
                }
                if ((stateDriven = (Element)sensorAttributes.getElementsByTagName("IsStateDriven").item(0)) != null && Boolean.parseBoolean(stateDriven.getTextContent())) {
                    sensorAttributesList.add(ManagerEnums.SensorAttributes.STATE_DRIVEN);
                }
                if ((wakeFromCS = (Element)sensorAttributes.getElementsByTagName("IsWakeFromCS").item(0)) != null && Boolean.parseBoolean(wakeFromCS.getTextContent())) {
                    sensorAttributesList.add(ManagerEnums.SensorAttributes.WAKE_FROM_CS);
                }
                if ((alwaysOn = (Element)sensorAttributes.getElementsByTagName("IsAlwaysOn").item(0)) != null && Boolean.parseBoolean(alwaysOn.getTextContent())) {
                    sensorAttributesList.add(ManagerEnums.SensorAttributes.ALWAYS_ON);
                }
                if ((override = (Element)sensorAttributes.getElementsByTagName("IsOverrideStrings").item(0)) != null && Boolean.parseBoolean(override.getTextContent())) {
                    sensorAttributesList.add(ManagerEnums.SensorAttributes.OVERRIDE_SENSOR_STRINGS);
                }
                data.setSensorAttributes(sensorAttributesList);
            }
            if ((callbacks = (Element)sensorInfo.getElementsByTagName("Callbacks").item(0)) != null) {
                ArrayList<String> callbackList = new ArrayList<String>();
                NodeList callbackNodeList = callbacks.getElementsByTagName("Callback");
                int i = 0;
                while (i < callbackNodeList.getLength()) {
                    Element callback = (Element)callbackNodeList.item(i);
                    callbackList.add(callback.getTextContent());
                    ++i;
                }
                data.setCallbacks(callbackList);
            }
            if ((systemEvents = (Element)sensorInfo.getElementsByTagName("SystemEvents").item(0)) != null) {
                Element isTimerExpired;
                ArrayList<ManagerEnums.SystemEvents> systemEventsList = new ArrayList<ManagerEnums.SystemEvents>();
                Element isWorkItemResult = (Element)systemEvents.getElementsByTagName("IsWorkItemResult").item(0);
                if (isWorkItemResult != null && Boolean.parseBoolean(isWorkItemResult.getTextContent())) {
                    systemEventsList.add(ManagerEnums.SystemEvents.WORKITEM_RESULT);
                }
                if ((isTimerExpired = (Element)systemEvents.getElementsByTagName("IsTimerExpired").item(0)) != null && Boolean.parseBoolean(isTimerExpired.getTextContent())) {
                    systemEventsList.add(ManagerEnums.SystemEvents.TIMER_EXPIRED);
                }
                data.setSystemEvents(systemEventsList);
            }
            Element fields = (Element)sensorInfo.getElementsByTagName("Fields").item(0);
            ArrayList<Field> fieldsList = new ArrayList<Field>();
            if (fields != null) {
                Element userDefined = (Element)fields.getElementsByTagName("UserDefined").item(0);
                if (userDefined != null) {
                    if (Boolean.parseBoolean(userDefined.getTextContent())) {
                        data.setUserDefinedOutput(true);
                    } else {
                        data.setUserDefinedOutput(false);
                    }
                }
                NodeList fieldsNodeList = fields.getElementsByTagName("Field");
                int i = 0;
                while (i < fieldsNodeList.getLength()) {
                    String fisAbsoluteSensitivity;
                    String fsensitivityExponent;
                    String fsensitivityType;
                    String fsensitive;
                    String funit;
                    String fexponent;
                    String fid;
                    Element field = (Element)fieldsNodeList.item(i);
                    Field fieldData = new Field();
                    String fname = field.getAttribute("FieldName");
                    if (fname != null && !fname.isEmpty()) {
                        fieldData.setName(fname);
                    }
                    if ((fid = field.getAttribute("FieldId")) != null && !fid.isEmpty()) {
                        fieldData.setId(fid);
                    }
                    if ((ftype = field.getAttribute("FieldType")) != null && !ftype.isEmpty()) {
                        fieldData.setType(ManagerEnums.FieldTypes.getFieldTypeByValue(Integer.parseInt(ftype)));
                    }
                    if ((fexponent = field.getAttribute("Exponent")) != null && !fexponent.isEmpty()) {
                        fieldData.setExponent(Integer.parseInt(fexponent));
                    }
                    if ((funit = field.getAttribute("Unit")) != null && !funit.isEmpty()) {
                        fieldData.setUnit(funit);
                    }
                    if ((fsensitive = field.getAttribute("Sensitive")) != null && !fsensitive.isEmpty()) {
                        fieldData.setIsSensitive(Boolean.parseBoolean(fsensitive));
                    }
                    if ((fsensitivityType = field.getAttribute("SensitivityType")) != null && !fsensitivityType.isEmpty()) {
                        fieldData.setSensitivityType(ManagerEnums.SensitivityTypes.getSensitivityTypeByValue(Integer.parseInt(fsensitivityType)));
                    }
                    if ((fsensitivityExponent = field.getAttribute("SensitivityExponent")) != null && !fsensitivityExponent.isEmpty()) {
                        fieldData.setSensitivityExponent(Integer.parseInt(fsensitivityExponent));
                    }
                    if ((fisAbsoluteSensitivity = field.getAttribute("IsAbsoluteSensitivity")) != null && !fisAbsoluteSensitivity.isEmpty()) {
                        fieldData.setIsAbsoluteSensitivity(Boolean.parseBoolean(fisAbsoluteSensitivity));
                    }
                    fieldsList.add(fieldData);
                    ++i;
                }
            } else {
                data.setUserDefinedOutput(false);
            }
            data.setFields(fieldsList);
            Element properties = (Element)sensorInfo.getElementsByTagName("PublicProperties").item(0);
            if (properties != null) {
                ArrayList<Field> propertiesList = new ArrayList<Field>();
                NodeList propertiesNodeList = properties.getElementsByTagName("Property");
                int i = 0;
                while (i < propertiesNodeList.getLength()) {
                    Element property = (Element)propertiesNodeList.item(i);
                    Field propertyData = new Field();
                    String fname = property.getAttribute("PropertyName");
                    if (fname != null && !fname.isEmpty()) {
                        propertyData.setName(fname);
                    }
                    if ((ftype = property.getAttribute("PropertyType")) != null && !ftype.isEmpty()) {
                        propertyData.setType(ManagerEnums.FieldTypes.getFieldTypeByValue(Integer.parseInt(ftype)));
                    }
                    propertiesList.add(propertyData);
                    ++i;
                }
                data.setProperties(propertiesList);
            }
            if ((customFlagValue = sensorInfo.getAttribute("CustomFlag")) != null && !customFlagValue.isEmpty()) {
                data.setCustomFlagvalue(ManagerEnums.FlagValues.getValueByFriendlyName(customFlagValue));
            }
            if ((notExposedFlagValue = sensorInfo.getAttribute("NotExposedFlag")) != null && !notExposedFlagValue.isEmpty()) {
                data.setNotExposedFlagvalue(ManagerEnums.FlagValues.getValueByFriendlyName(notExposedFlagValue));
            }
            if ((dependencies = (Element)sensorInfo.getElementsByTagName("Dependencies").item(0)) != null) {
                NodeList dependenciesList = dependencies.getElementsByTagName("Dependency");
                int i = 0;
                while (i < dependenciesList.getLength()) {
                    ManagerEnums.Configurations config;
                    String depFriendlyName;
                    Element dependency = (Element)dependenciesList.item(i);
                    SensorData dependencyData = new SensorData();
                    String depModelID = dependency.getAttribute("ModelId");
                    if (depModelID != null && !depModelID.isEmpty()) {
                        dependencyData.setModelId(Integer.parseInt(depModelID));
                    } else {
                        dependencyData.setModelId(-1);
                    }
                    String depModelName = dependency.getAttribute("ModelName");
                    if (depModelName != null && !depModelName.isEmpty()) {
                        dependencyData.setModelName(depModelName);
                    } else {
                        dependencyData.setModelName("");
                    }
                    dependencyData.setFriendlyModelName(dependencyData.getModelName());
                    String depFlags = dependency.getAttribute("Flags");
                    if (depFlags != null && !depFlags.isEmpty()) {
                        dependencyData.setFlags(Integer.parseInt(depFlags));
                    } else {
                        dependencyData.setFlags(null);
                    }
                    String depVendorID = dependency.getAttribute("VendorId");
                    if (depVendorID != null && !depVendorID.isEmpty()) {
                        dependencyData.setVendorId(Integer.parseInt(depVendorID));
                        dependencyData.setVendorName(SensorDataManager.findVendorNameById(Integer.parseInt(depVendorID), searchNameByIdInUser, platform));
                        dependencyData.setFriendlyVendorName(dependencyData.getVendorName());
                    } else {
                        dependencyData.setVendorId(-1);
                    }
                    String depTypeID = dependency.getAttribute("SensorTypeId");
                    if (depTypeID == null || depTypeID.isEmpty()) {
                        throw new Exception("This " + componentName + "'s metadata is missing the content of the Reporter Type Id field.");
                    }
                    dependencyData.setTypeId(Integer.parseInt(depTypeID));
                    dependencyData.setTypeName(SensorDataManager.findSensorTypeNameById(Integer.parseInt(depTypeID), searchNameByIdInUser, platform));
                    String depName = dependency.getAttribute("Name");
                    if (depName != null && !depName.isEmpty()) {
                        dependencyData.setName(depName);
                    }
                    if ((depFriendlyName = dependency.getAttribute("FriendlyName")) == null || depFriendlyName.isEmpty()) {
                        depFriendlyName = dependencyData.getTypeName();
                    }
                    if (!Character.isDigit(depFriendlyName.charAt(0))) {
                        dependencyData.setFriendlyName(depFriendlyName);
                    } else {
                        dependencyData.setFriendlyName("UNKNOWN");
                    }
                    String instanceID = dependency.getAttribute("InstanceId");
                    if (instanceID == null || instanceID.isEmpty()) {
                        throw new Exception("This " + componentName + "'s metadata is missing the content of the Reporter Instance ID field.");
                    }
                    dependencyData.setInstanceId(Integer.parseInt(instanceID));
                    String dependencyType = dependency.getAttribute("DependencyType");
                    if (dependencyType != null && !dependencyType.isEmpty()) {
                        dependencyData.setDependencyType(ManagerEnums.DependencyTypes.getDependencyByValue(Integer.parseInt(dependencyType)));
                    } else {
                        String mandatory = dependency.getAttribute("Mandatory");
                        if (mandatory != null && !mandatory.isEmpty()) {
                            if (Integer.parseInt(mandatory) == 1) {
                                dependencyData.setDependencyType(ManagerEnums.DependencyTypes.MANDATORY);
                            } else {
                                dependencyData.setDependencyType(ManagerEnums.DependencyTypes.IF_AVAILABLE);
                            }
                        }
                    }
                    String configuration = dependency.getAttribute("Configuration");
                    if (configuration != null && !configuration.isEmpty() && (config = ManagerEnums.Configurations.getConfigurationByValue(Integer.parseInt(configuration))) != null) {
                        dependencyData.setConfiguration(config);
                        if (dependencyData.getConfiguration().equals((Object)ManagerEnums.Configurations.AUTO)) {
                            String reportIntervalMin = dependency.getAttribute("ReportIntervalMin");
                            if (reportIntervalMin != null && !reportIntervalMin.isEmpty()) {
                                dependencyData.setReportIntervalMin(Integer.parseInt(reportIntervalMin));
                            } else {
                                dependencyData.setReportIntervalMin(-1);
                            }
                            String reportIntervalMax = dependency.getAttribute("ReportIntervalMax");
                            if (reportIntervalMax != null && !reportIntervalMax.isEmpty()) {
                                dependencyData.setReportIntervalMax(Integer.parseInt(reportIntervalMax));
                            } else {
                                dependencyData.setReportIntervalMax(-1);
                            }
                            String sensitivity = dependency.getAttribute("Sensitivity");
                            if (sensitivity != null && !sensitivity.isEmpty()) {
                                dependencyData.setSensitivity(Integer.parseInt(sensitivity));
                            } else {
                                dependencyData.setSensitivity(-1);
                            }
                        }
                    }
                    data.addDependency(dependencyData);
                    ++i;
                }
                return data;
            } else {
                if (!toForceExtraFields) return data;
                throw new Exception("This " + componentName + "'s metadata is missing the content of the Dependency field.");
            }
        }
        catch (Exception e) {
            throw new Exception("Failed to get the data from the meta data XML element. \n  " + (e != null && e.getMessage() != null ? "Exception: " + e.getMessage().replaceAll("\n  ", "\n    ") : ""));
        }
    }

    public static String findSensorTypeNameById(int sensorTypeID, boolean searchInUser, Platform platform) throws Exception {
        String sensorTypeName = null;
        try {
            Document doc = new File("ISS_Sensor_Definitions.xml").exists() ? SensorDataManager.readFromXML(new File("ISS_Sensor_Definitions.xml")) : SensorDataManager.readFromXML(new File(ManagerFileUtils.getIntelSensorDefinitionsFilePath(platform)));
            sensorTypeName = SensorDataManager.getTypeNameByIDFromDoc(sensorTypeID, doc);
            if (searchInUser && (sensorTypeName == null || sensorTypeName.isEmpty())) {
                File file = new File(ManagerFileUtils.getUserSensorDefinitionsFilePath());
                if (!file.exists()) {
                    throw new Exception();
                }
                doc = SensorDataManager.readFromXML(file);
                sensorTypeName = SensorDataManager.getTypeNameByIDFromDoc(sensorTypeID, doc);
            }
            if (sensorTypeName == null || sensorTypeName.isEmpty()) {
                sensorTypeName = Integer.toString(sensorTypeID);
            }
        }
        catch (Exception e) {
            sensorTypeName = Integer.toString(sensorTypeID);
        }
        return sensorTypeName;
    }

    public static String findVendorNameById(int vendorID, boolean searchInUser, Platform platform) throws Exception {
        String vendorName = null;
        try {
            Document doc;
            if (VendorListConfiguration.getInstance() != null) {
                BiMap<Integer, String> vendorsDefinitionsTemp = VendorListConfiguration.getInstance().getVendorList();
                vendorName = vendorsDefinitionsTemp.getForward(vendorID);
            } else {
                doc = new File("ISS_Sensor_Definitions.xml").exists() ? SensorDataManager.readFromXML(new File("ISS_Sensor_Definitions.xml")) : SensorDataManager.readFromXML(new File(ManagerFileUtils.getIntelSensorDefinitionsFilePath(platform)));
                vendorName = SensorDataManager.getVendorNameByIDFromDoc(vendorID, doc);
            }
            if (searchInUser && (vendorName == null || vendorName.isEmpty())) {
                File file = new File(ManagerFileUtils.getUserSensorDefinitionsFilePath());
                if (!file.exists()) {
                    throw new Exception();
                }
                doc = SensorDataManager.readFromXML(file);
                vendorName = SensorDataManager.getVendorNameByIDFromDoc(vendorID, doc);
            }
            if (vendorName == null || vendorName.isEmpty()) {
                vendorName = Integer.toString(vendorID);
            }
        }
        catch (Exception e) {
            vendorName = Integer.toString(vendorID);
        }
        return vendorName;
    }

    private static String getVendorNameByIDFromDoc(int vendorId, Document doc) {
        NodeList vendors = doc.getElementsByTagName("Vendor");
        int i = 0;
        while (i < vendors.getLength()) {
            Element vendorElement = (Element)vendors.item(i);
            if (vendorElement.getParentNode().getNodeName().equals("SensorVendors") && vendorElement.getAttribute("VendorId").equals(Integer.toString(vendorId))) {
                return vendorElement.getAttribute("VendorName");
            }
            ++i;
        }
        return null;
    }

    private static String getTypeNameByIDFromDoc(int typeId, Document doc) {
        NodeList sensorTypes = doc.getElementsByTagName("SensorType");
        int i = 0;
        while (i < sensorTypes.getLength()) {
            Element sensorType = (Element)sensorTypes.item(i);
            if (sensorType.getParentNode().getNodeName().equals("SensorTypes") && sensorType.getAttribute("SensorTypeId").equals(Integer.toString(typeId))) {
                return sensorType.getAttribute("Name");
            }
            ++i;
        }
        return null;
    }

    private static String findOFilePath(String sensorName, String filesPath) {
        String oFile = "";
        if (!filesPath.isEmpty()) {
            if (filesPath != null) {
                oFile = SensorDataManager.findFileInDir(sensorName, filesPath);
            }
        } else {
            File f = new File(String.valueOf(sensorName) + ".o");
            if (f.exists()) {
                oFile = f.getAbsolutePath();
            }
        }
        return oFile;
    }

    private static String findFileInDir(String sensorName, String path) {
        File dir = new File(path);
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File arg0) {
                    return arg0.getName().endsWith(".o");
                }
            });
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().toLowerCase().equals(String.valueOf(sensorName.toLowerCase()) + ".o")) {
                    return f.getAbsolutePath();
                }
                ++n2;
            }
        }
        return "";
    }

    public static String ExtractXmlFromOFile(String filePath, String gccDir) throws Exception {
        String updatedxmlTempFileName = "updated_sensor_metadata.xml";
        return SensorDataManager.ExtractXmlFromOFile(filePath, gccDir, updatedxmlTempFileName);
    }

    public static String ExtractXmlFromOFile(String filePath, String gccDir, String updatedxmlTempFileName) throws Exception {
        String xmlTempFileName = "sensor_metadata.xml";
        Random rand = new Random();
        int randomNumber = rand.nextInt(1000000);
        Path randomFolder = Paths.get(ManagerFileUtils.getSysTempFolder(), String.valueOf(randomNumber));
        Path xmlTempPath = randomFolder.resolve(xmlTempFileName);
        Path updatedxmlTempPath = randomFolder.resolve(updatedxmlTempFileName);
        try {
            File updatedOutputFile;
            File outputFile;
            if (!randomFolder.toFile().exists()) {
                randomFolder.toFile().mkdir();
            }
            if ((outputFile = xmlTempPath.toFile()).exists()) {
                outputFile.delete();
            }
            if ((updatedOutputFile = updatedxmlTempPath.toFile()).exists()) {
                updatedOutputFile.delete();
            }
            String objCopyCmd = "i486-elf-objcopy.exe";
            String sectionName = ".sensor_metadata_section";
            Runtime runTime = Runtime.getRuntime();
            Process process = runTime.exec(String.valueOf(gccDir) + "\\bin\\" + objCopyCmd + " -O binary --only-section=" + sectionName + "  \"" + filePath + "\"  " + xmlTempPath.toString());
            int res = process.waitFor();
            if (res != 0) {
                throw new Exception();
            }
            if (!outputFile.exists()) {
                throw new Exception("Could not extract sensor metadata from the .o file. It may be missing or corrupted.");
            }
            if (outputFile.length() == 0L) {
                throw new Exception("Could not extract sensor metadata from the .o file. It may be missing or corrupted.");
            }
            SensorDataManager.removeTrailingNull(xmlTempPath.toString(), updatedxmlTempPath.toString());
        }
        catch (Exception e) {
            throw new Exception("Failed to extract xml from file: " + (e != null && e.getMessage() != null ? e.getMessage() : ""));
        }
        return updatedxmlTempPath.toString();
    }

    public static ArrayList<ManagerEnums.Flags> getFlagsFromInt(int intFlag) {
        ArrayList<ManagerEnums.Flags> flags = new ArrayList<ManagerEnums.Flags>();
        ManagerEnums.Flags[] flagsArray = ManagerEnums.Flags.values();
        if (intFlag == 0) {
            flags.add(ManagerEnums.Flags.SC_LUID_FLAG_NONE);
            return flags;
        }
        String binStringFlags = Integer.toBinaryString(intFlag);
        String zeroPadding = new String();
        int i = binStringFlags.length();
        while (i < 8) {
            zeroPadding = String.valueOf(zeroPadding) + "0";
            ++i;
        }
        binStringFlags = String.valueOf(zeroPadding) + binStringFlags;
        i = 1;
        while (i <= 8) {
            if (binStringFlags.charAt(8 - i) == '1') {
                flags.add(flagsArray[i]);
            }
            ++i;
        }
        return flags;
    }

    public static boolean compareSensorFlags(int firstFlags, int secondFlags, boolean ignorUnnecessaryFlags) {
        if (ignorUnnecessaryFlags) {
            ArrayList<ManagerEnums.Flags> f1 = SensorDataManager.getFlagsFromInt(firstFlags);
            ArrayList<ManagerEnums.Flags> f2 = SensorDataManager.getFlagsFromInt(secondFlags);
            return f1.contains((Object)ManagerEnums.Flags.SC_LUID_FLAG_CALIBRATED) == f2.contains((Object)ManagerEnums.Flags.SC_LUID_FLAG_CALIBRATED) && f1.contains((Object)ManagerEnums.Flags.SC_LUID_FLAG_PHYSICAL) == f2.contains((Object)ManagerEnums.Flags.SC_LUID_FLAG_PHYSICAL);
        }
        return firstFlags == secondFlags;
    }

    private static void removeTrailingNull(String xmlTempFile, String updatedxmlTempFile) throws Exception {
        File file = new File(xmlTempFile);
        Scanner scanner = new Scanner(file);
        PrintWriter writer = new PrintWriter(updatedxmlTempFile, "UTF-8");
        writer.print("<ISS>");
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            int index = line.indexOf("UTF");
            if (index > -1) {
                line = line.substring(index + 8);
            }
            String newLine = "";
            int i = 0;
            while (i < line.length()) {
                if (line.charAt(i) != '\u0000') {
                    newLine = String.valueOf(newLine) + line.charAt(i);
                }
                ++i;
            }
            writer.println(newLine);
        }
        writer.print("</ISS>");
        writer.close();
        scanner.close();
        file.setWritable(true);
        System.gc();
        file.delete();
    }

    private static Document readFromXML(File file) throws Exception {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(file);
            doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            throw new Exception("failed to read from xml " + e.getMessage());
        }
        return doc;
    }

    private static Document getXMLDocumentFromOFiles(String filesPath) throws Exception {
        try {
            File sensorsDir = new File(filesPath);
            if (sensorsDir.exists() && sensorsDir.isDirectory()) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.newDocument();
                Element root = doc.createElement("ISS");
                doc.appendChild(root);
                doc.getDocumentElement().normalize();
                File[] fileArray = sensorsDir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File sensorFile = fileArray[n2];
                    if (sensorFile.getName().endsWith(".o")) {
                        String sensorXMLPath = SensorDataManager.ExtractXmlFromOFile(sensorFile.getAbsolutePath(), ManagerFileUtils.DEFAULT_GCC_DIR());
                        File xmlFile = new File(sensorXMLPath);
                        Document sensorDoc = SensorDataManager.readFromXML(xmlFile);
                        NodeList nodeList = sensorDoc.getElementsByTagName("Sensor");
                        int i = 0;
                        while (i < nodeList.getLength()) {
                            Element sensorInfo = (Element)nodeList.item(i);
                            Element copySensorInfo = (Element)doc.importNode(sensorInfo, true);
                            doc.getDocumentElement().appendChild(copySensorInfo);
                            ++i;
                        }
                        if (xmlFile.exists()) {
                            xmlFile.delete();
                        }
                    }
                    ++n2;
                }
                doc.getDocumentElement().normalize();
                return doc;
            }
            throw new Exception("The supplied files path doesn't exist, or is not a directory");
        }
        catch (Exception e) {
            if (!e.getMessage().contains("Process failed to create xml file")) {
                throw new Exception("Failed to create xml file from " + filesPath + " folder " + e.getMessage());
            }
            return null;
        }
    }

    private static Transformer getNewTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "5");
        return transformer;
    }

    public static void createXMLFileFromOFiles(String filesPath, String outputFilePath) throws Exception {
        Transformer transformer = SensorDataManager.getNewTransformer();
        Document doc = SensorDataManager.getXMLDocumentFromOFiles(filesPath);
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new File(outputFilePath));
        transformer.transform(source, result);
    }

    public static String getXMLStringFromOFiles(String filesPath) throws Exception {
        Transformer transformer = SensorDataManager.getNewTransformer();
        Document doc = SensorDataManager.getXMLDocumentFromOFiles(filesPath);
        if (doc == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        StreamResult res = new StreamResult(sw);
        DOMSource source = new DOMSource(doc.getDocumentElement());
        transformer.transform(source, res);
        String xmlString = sw.toString();
        return xmlString;
    }

    public static void createXMLFileFromElf(String elfPath, String outputFilePath) throws Exception {
        File elfFile = new File(elfPath);
        if (elfFile.exists() && elfFile.getName().endsWith(".elf")) {
            String xmlFilePath = SensorDataManager.ExtractXmlFromOFile(elfPath, ManagerFileUtils.DEFAULT_GCC_DIR(), outputFilePath);
            File xmlFile = new File(xmlFilePath);
            if (xmlFile.exists()) {
                xmlFile.delete();
            }
        } else {
            throw new Exception("Either this file does not exist, or it is not of type .elf.");
        }
        Document doc = SensorDataManager.readFromXML(new File(outputFilePath));
        Transformer transformer = SensorDataManager.getNewTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new File(outputFilePath));
        transformer.transform(source, result);
    }

    public static boolean hasMetadata(String path, Platform projPlatform) {
        File file = new File(path);
        try {
            ArrayList<SensorData> data = SensorDataManager.getSensorsInfo(file.getName(), file.getParent(), true, projPlatform);
            return data != null && data.size() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasMetadata(String path, String gccLocation, Platform projPlatform) {
        File file = new File(path);
        try {
            ArrayList<SensorData> data = SensorDataManager.getSensorsInfo(file.getName(), file.getParent(), gccLocation, true, projPlatform);
            return data != null && data.size() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ArrayList<SensorData> getSensorsInfoFromFiles(String path, Platform projPlatform) throws Exception {
        ArrayList<SensorData> sensors = new ArrayList<SensorData>();
        File file = new File(path);
        if (path.endsWith(".o")) {
            sensors.addAll(SensorDataManager.getSensorsInfo(file.getName(), file.getParent(), true, projPlatform));
        } else if (file.isDirectory()) {
            File[] files;
            File dir = new File(path);
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                if (file2.isFile()) {
                    sensors.addAll(SensorDataManager.getSensorsInfo(file2.getName(), file2.getParent(), true, projPlatform));
                }
                ++n2;
            }
        } else if (path.endsWith("BuildSettings.txt")) {
            sensors.addAll(SensorDataManager.getSensorsInfoFromSettingsFile(path));
        } else {
            throw new Exception("The path type is not recognized or the file does not exist: " + path);
        }
        return sensors;
    }

    public static ArrayList<SensorData> getSensorsInfoFromSettingsFile(String path) throws Exception {
        try {
            ArrayList<String> sensorList = new ArrayList<String>();
            ArrayList<String> sensorLuidList = new ArrayList<String>();
            String platform = "";
            String firmware = null;
            File f = new File(path);
            FileInputStream fs = new FileInputStream(f);
            BufferedReader buf = new BufferedReader(new InputStreamReader(new DataInputStream(fs)));
            try {
                String line;
                while ((line = buf.readLine()) != null) {
                    if (line.startsWith("userMD:")) {
                        String uid = line.substring(7);
                        sensorList.add(uid);
                        continue;
                    }
                    if (line.startsWith("otherLuid:")) {
                        sensorLuidList.add(line.substring(10));
                        continue;
                    }
                    if (line.startsWith("version:")) {
                        platform = line.substring(8);
                        continue;
                    }
                    if (!line.startsWith("firmware:")) continue;
                    firmware = line.substring(9);
                }
            }
            finally {
                if (fs != null) {
                    fs.close();
                }
            }
            buf.close();
            return SensorDataManager.getSensorsFromLists(sensorList, sensorLuidList, "", null, "", platform, firmware, null);
        }
        catch (Exception e) {
            throw new Exception("Failed to get sensor info from: " + path + ": " + e.getMessage());
        }
    }

    public static ArrayList<SensorData> getSensorsForSensorPlat(ArrayList<String> sensorList, ArrayList<String> sensorLuidList, String gccLocation, ArrayList<String> errorList, String path, String platformString, String version, File buildSettingFile) {
        ArrayList<SensorData> allSensors;
        block11: {
            allSensors = new ArrayList<SensorData>();
            Platform platform = ManagerUtils.getPlatformFromString(platformString);
            if (platform == null) {
                return allSensors;
            }
            try {
                FileInputStream fs = new FileInputStream(buildSettingFile);
                BufferedReader buf = new BufferedReader(new InputStreamReader(new DataInputStream(fs)));
                try {
                    String line;
                    while ((line = buf.readLine()) != null) {
                        ArrayList<SensorData> sds;
                        String libpath;
                        if (line.startsWith("userMD:")) {
                            libpath = line.substring("userMD:".length());
                            sds = SensorDataManager.parseSensorForbinary(libpath, gccLocation, platform, buildSettingFile);
                            allSensors.addAll(sds);
                            continue;
                        }
                        if (!line.startsWith("otherMD:")) continue;
                        libpath = line.substring("otherMD:".length());
                        sds = SensorDataManager.parseSensorForbinary(libpath, gccLocation, platform, buildSettingFile);
                        for (SensorData sensor : sds) {
                            if (!sensorLuidList.contains(sensor.getLuidString())) continue;
                            allSensors.add(sensor);
                        }
                    }
                }
                finally {
                    if (fs != null) {
                        fs.close();
                    }
                }
                buf.close();
            }
            catch (Exception e) {
                if (errorList == null || e == null || e.getMessage() == null) break block11;
                errorList.add(e.getMessage());
            }
        }
        return allSensors;
    }

    private static ArrayList<SensorData> parseSensorForbinary(String libPath, String gccLocation, Platform platform, File buildSettingFile) throws Exception {
        File libFile;
        String sensorLibPath = libPath;
        if (sensorLibPath.startsWith(" ") || sensorLibPath.startsWith("\t")) {
            sensorLibPath = sensorLibPath.substring(1);
        }
        if (!sensorLibPath.endsWith(".o") && !sensorLibPath.endsWith(".a")) {
            sensorLibPath = sensorLibPath.substring(0, sensorLibPath.length() - 1);
        }
        if (!(libFile = new File(sensorLibPath)).exists()) {
            throw new Exception(String.valueOf(libPath) + " not existed.");
        }
        String sensorNameExt = libFile.getName();
        String sensorName = sensorNameExt.substring(0, sensorNameExt.length() - 2);
        if (gccLocation.isEmpty()) {
            gccLocation = ManagerFileUtils.DEFAULT_GCC_DIR();
        }
        if (sensorNameExt.endsWith(".o")) {
            return SensorDataManager.getSensorsInfo(sensorName, libFile.getParentFile().getAbsolutePath(), gccLocation, true, platform);
        }
        return SensorDataManager.getSensorsFromAFile(sensorName, libFile, gccLocation, platform, buildSettingFile);
    }

    public static ArrayList<SensorData> getSensorsFromAFile(String sensorLibName, File sensorLibFile, String gccLocation, Platform platform, File buildSettingFile) throws Exception {
        ArrayList<SensorData> ret = new ArrayList<SensorData>();
        File aFilesTempDir = new File(String.valueOf(buildSettingFile.getParent()) + "\\newSensors\\a");
        File oFilesTempDir = new File(String.valueOf(buildSettingFile.getParent()) + "\\newSensors\\o");
        try {
            if (aFilesTempDir.exists()) {
                ManagerFileUtils.fastDeleteFileOrDirectory(aFilesTempDir);
            }
            aFilesTempDir.mkdirs();
            if (oFilesTempDir.exists()) {
                ManagerFileUtils.fastDeleteFileOrDirectory(oFilesTempDir);
            }
            oFilesTempDir.mkdirs();
            ManagerFileUtils.copyFile(sensorLibFile, new File(String.valueOf(aFilesTempDir.getPath()) + File.separator + sensorLibName + ".a"));
            ManagerExternalLibraryUtils.importStaticLibrary(String.valueOf(aFilesTempDir.getPath()) + File.separator + sensorLibName + ".a", oFilesTempDir.getPath(), gccLocation);
            File[] fileArray = oFilesTempDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File currentFile = fileArray[n2];
                if (SensorDataManager.hasMetadata(currentFile.getAbsolutePath(), gccLocation, platform)) {
                    ArrayList<SensorData> sensors = SensorDataManager.getSensorsInfo(currentFile.getName(), currentFile.getParentFile().getAbsolutePath(), gccLocation, true, platform);
                    ret.addAll(sensors);
                }
                ++n2;
            }
        }
        finally {
            File tempFile = new File(String.valueOf(buildSettingFile.getParent()) + "\\newSensors");
            if (tempFile.exists()) {
                ManagerFileUtils.fastDeleteFileOrDirectory(tempFile);
            }
        }
        return ret;
    }

    public static ArrayList<SensorData> getSensorsFromLists(ArrayList<String> sensorList, ArrayList<String> sensorLuidList, String gccLocation, ArrayList<String> errorList, String path, String platformString, String version, String fdkToolsDir) {
        Platform platform = ManagerUtils.getPlatformFromString(platformString);
        ArrayList<SensorData> allSensors = new ArrayList<SensorData>();
        if (platform == null) {
            return allSensors;
        }
        for (String sensor : sensorList) {
            try {
                String sensorName = sensor.substring(0, sensor.length() - 2);
                if (gccLocation.isEmpty()) {
                    allSensors.addAll(SensorDataManager.getSensorsInfo(sensorName, path, false, platform));
                    continue;
                }
                File f = new File(String.valueOf(sensorName) + ".o");
                if (f.exists()) {
                    allSensors.addAll(SensorDataManager.getSensorsInfo(sensorName, path, gccLocation, false, platform));
                    continue;
                }
                File aFile = new File(String.valueOf(sensorName) + ".a");
                if (!aFile.exists()) continue;
                allSensors.addAll(SensorDataManager.getSensorsInfoFromAFile(sensorName, path, gccLocation, false, platform));
            }
            catch (Exception e) {
                if (e == null || e.getMessage() == null || e.getMessage().contains("Could not extract sensor metadata from the .o file. It may be missing or corrupted") || errorList == null) continue;
                errorList.add(e.getMessage());
            }
        }
        if (sensorLuidList != null) {
            for (String luid : sensorLuidList) {
                try {
                    SensorData sensor = SensorDataManager.getSensorInfoFromKnownXMLs(luid, platform, version, fdkToolsDir);
                    if (sensor == null) {
                        SensorDataWrapper sdw = PackUtils.getSensorFromInstalledPath(luid, null, null, platform);
                        if (sdw == null) continue;
                        sensor = sdw.getData();
                        allSensors.add(sensor);
                        continue;
                    }
                    allSensors.add(sensor);
                }
                catch (Exception e) {
                    if (errorList == null || e == null || e.getMessage() == null) continue;
                    errorList.add(e.getMessage());
                }
            }
        }
        return allSensors;
    }

    public static ArrayList<SensorData> getSensorsFromListsForFullBuild(ArrayList<String> sensorList, ArrayList<String> sensorLuidList, String gccLocation, ArrayList<String> errorList, String path, String platformString, String sensorFile) {
        Platform platform = ManagerUtils.getPlatformFromString(platformString);
        ArrayList<SensorData> allSensors = new ArrayList<SensorData>();
        for (String sensor : sensorList) {
            try {
                String sensorName = sensor.substring(0, sensor.length() - 2);
                if (gccLocation.isEmpty()) {
                    allSensors.addAll(SensorDataManager.getSensorsInfo(sensorName, path, false, platform));
                    continue;
                }
                allSensors.addAll(SensorDataManager.getSensorsInfo(sensorName, path, gccLocation, false, platform));
            }
            catch (Exception e) {
                if (e == null || e.getMessage() == null || e.getMessage().contains("Could not extract sensor metadata from the .o file. It may be missing or corrupted") || errorList == null) continue;
                errorList.add(e.getMessage());
            }
        }
        if (sensorLuidList != null) {
            for (String luid : sensorLuidList) {
                SensorData sensor = null;
                try {
                    block18: {
                        try {
                            if (platform != null) {
                                sensor = SensorDataManager.getSensorInfoFromKnownXML(luid, platform, null, sensorFile, true);
                            }
                        }
                        catch (Exception e) {
                            if (e == null || e.getMessage().contains("failed to read from xml")) break block18;
                            throw e;
                        }
                    }
                    if (sensor == null) {
                        String userInstallFolder = null;
                        try {
                            userInstallFolder = ManagerFileUtils.getUserFDKDir();
                        }
                        catch (Exception e) {
                            userInstallFolder = null;
                        }
                        if (userInstallFolder != null) {
                            sensor = SensorDataManager.getSensorInfoFromKnownXML(luid, platform, null, ManagerFileUtils.getUserInstalledSensorsFilePath(), false);
                        } else {
                            File knownSensorFile;
                            if (platform != null && platform.getName().startsWith("ISH5.4")) {
                                platform = new Platform("LKF");
                            }
                            if ((knownSensorFile = new File(sensorFile)).exists()) {
                                String userInstallFile = String.valueOf(knownSensorFile.getAbsolutePath()) + "/../../../../../../../UserInstalledSensors/InstalledSensors.xml";
                                sensor = SensorDataManager.getSensorInfoFromKnownXML(luid, platform, null, userInstallFile, false);
                            }
                        }
                    }
                    if (sensor == null) continue;
                    allSensors.add(sensor);
                }
                catch (Exception e) {
                    if (errorList == null || e == null || e.getMessage() == null) continue;
                    errorList.add(e.getMessage());
                }
            }
        }
        return allSensors;
    }

    public static SensorData getSensorInfoFromKnownXMLs(String sensorLuid, Platform platform, String version, String fdkTooldDir) throws Exception {
        SensorData sensor;
        block7: {
            sensor = null;
            try {
                sensor = SensorDataManager.getSensorInfoFromKnownXML(sensorLuid, platform, version, ManagerFileUtils.getFDKInstalledSensorsFilePath(), false);
            }
            catch (Exception e) {
                if (e.getMessage().contains("failed to read from xml")) {
                    try {
                        sensor = SensorDataManager.getSensorInfoFromKnownXML(sensorLuid, platform, null, ManagerFileUtils.getKnownIntelSensorsFilePath(platform, fdkTooldDir, version), true);
                    }
                    catch (Exception e1) {
                        if (e1.getMessage().contains("failed to read from xml")) {
                            sensor = SensorDataManager.getSensorInfoFromKnownXML(sensorLuid, platform, null, ManagerFileUtils.getFDKInstalledSensorsFilePath(platform, fdkTooldDir), true);
                        }
                        break block7;
                    }
                }
                throw e;
            }
        }
        if (sensor == null) {
            sensor = SensorDataManager.getSensorInfoFromKnownXML(sensorLuid, platform, null, ManagerFileUtils.getUserInstalledSensorsFilePath(), false);
        }
        return sensor;
    }

    public static SensorData getSensorInfoFromKnownXML(String sensorLuid, Platform plat, String version, String filePath, boolean isSpecificPlatformFile) throws Exception {
        Document doc = SensorDataManager.readFromXML(new File(filePath).getAbsoluteFile());
        NodeList nodes = doc.getElementsByTagName("Platform");
        int i = 0;
        while (i < nodes.getLength()) {
            boolean platformCheckPass;
            Element node = (Element)nodes.item(i);
            Platform pf = null;
            String pName = node.getAttribute("ISSVersion");
            boolean firmwareCheckPass = true;
            if (!isSpecificPlatformFile) {
                String verAttr;
                try {
                    double ver = Double.parseDouble(pName);
                    pf = ManagerConfigs.getPlatformByValue(ver);
                }
                catch (Exception e) {
                    try {
                        pf = ManagerConfigs.getPlatformByName(pName);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                if (version != null && !version.isEmpty() && (verAttr = node.getAttribute("Firmware")) != null && !verAttr.equals(version)) {
                    firmwareCheckPass = false;
                }
            }
            boolean bl = platformCheckPass = pf != null && plat != null && pf.getName().equals(plat.getName()) || pName != null && plat != null && pName.equalsIgnoreCase(plat.getName());
            if (isSpecificPlatformFile || platformCheckPass && firmwareCheckPass) {
                NodeList sensors = node.getElementsByTagName("Sensor");
                int j = 0;
                while (j < sensors.getLength()) {
                    SensorData data = SensorDataManager.getSensorDataByElement((Element)sensors.item(j), false, false, plat);
                    if (data.getLuidString().equals(sensorLuid)) {
                        return data;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }
}

