/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.BoardDescriptionTable;

public class I2cBoardDescriptionTable
extends BoardDescriptionTable {
    public static final int BDT_TYPE = 0;
    private ArrayList<BusObject> _buses = new ArrayList();

    public I2cBoardDescriptionTable() {
        this.setType(0);
    }

    public I2cBoardDescriptionTable(BinReader reader, Node payloadXmlNode) {
        this.setType(0);
        int numOfBuses = reader.readNewField((String)"NumOfBuses", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        for (int j = 1; j <= numOfBuses; ++j) {
            Element busInfoElement = reader.readNewField((String)new StringBuilder().append((String)"BusInfo").append((int)j).toString(), (Node)payloadXmlNode).xmlElement;
            BusObject newBus = new BusObject();
            newBus.instanceId = reader.readNewField((String)"InstanceId", (int)1, (boolean)false, (Node)busInfoElement).value;
            Element sdtSpeedElement = reader.readNewField((String)"SdtSpeed", (Node)busInfoElement).xmlElement;
            newBus.sdtSpeedHcnt = reader.readNewField((String)"Hcnt", (int)2, (boolean)false, (Node)sdtSpeedElement).value;
            newBus.stdSpeedLcnt = reader.readNewField((String)"Lcnt", (int)2, (boolean)false, (Node)sdtSpeedElement).value;
            newBus.stdSpeedSdaHold = reader.readNewField((String)"SdaHold", (int)2, (boolean)false, (Node)sdtSpeedElement).value;
            Element fastSpeedElement = reader.readNewField((String)"FastSpeed", (Node)busInfoElement).xmlElement;
            newBus.fastSpeedHcnt = reader.readNewField((String)"Hcnt", (int)2, (boolean)false, (Node)fastSpeedElement).value;
            newBus.fastSpeedLcnt = reader.readNewField((String)"Lcnt", (int)2, (boolean)false, (Node)fastSpeedElement).value;
            newBus.fastSpeedSdaHold = reader.readNewField((String)"SdaHold", (int)2, (boolean)false, (Node)fastSpeedElement).value;
            Element highSpeedElement = reader.readNewField((String)"HighSpeed", (Node)busInfoElement).xmlElement;
            newBus.highSpeedHcnt = reader.readNewField((String)"Hcnt", (int)2, (boolean)false, (Node)highSpeedElement).value;
            newBus.highSpeedLcnt = reader.readNewField((String)"Lcnt", (int)2, (boolean)false, (Node)highSpeedElement).value;
            newBus.highSpeedSdaHold = reader.readNewField((String)"SdaHold", (int)2, (boolean)false, (Node)highSpeedElement).value;
            this.addBus(newBus);
        }
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        writer.writeNewField("Type", 1, this.getType(), (Node)parent);
        Common.Field lengthField = writer.writeNewField("Length", 2, 0, (Node)parent);
        writer.addSizeCounter(lengthField);
        ArrayList<BusObject> busObjects = this.getBuses();
        writer.writeNewField("NumOfBuses", 1, busObjects.size(), (Node)parent);
        for (int j = 1; j <= busObjects.size(); ++j) {
            BusObject busObject = busObjects.get(j - 1);
            Element busInfoElement = writer.writeNewField((String)new StringBuilder().append((String)"BusInfo").append((int)j).toString(), (Node)parent).xmlElement;
            writer.writeNewField("InstanceId", 1, busObject.instanceId, (Node)busInfoElement);
            Element sdtSpeedElement = writer.writeNewField((String)"SdtSpeed", (Node)busInfoElement).xmlElement;
            writer.writeNewField("Hcnt", 2, busObject.sdtSpeedHcnt, (Node)sdtSpeedElement);
            writer.writeNewField("Lcnt", 2, busObject.stdSpeedLcnt, (Node)sdtSpeedElement);
            writer.writeNewField("SdaHold", 2, busObject.stdSpeedSdaHold, (Node)sdtSpeedElement);
            Element fastSpeedElement = writer.writeNewField((String)"FastSpeed", (Node)busInfoElement).xmlElement;
            writer.writeNewField("Hcnt", 2, busObject.fastSpeedHcnt, (Node)fastSpeedElement);
            writer.writeNewField("Lcnt", 2, busObject.fastSpeedLcnt, (Node)fastSpeedElement);
            writer.writeNewField("SdaHold", 2, busObject.fastSpeedSdaHold, (Node)fastSpeedElement);
            Element highSpeedElement = writer.writeNewField((String)"HighSpeed", (Node)busInfoElement).xmlElement;
            writer.writeNewField("Hcnt", 2, busObject.highSpeedHcnt, (Node)highSpeedElement);
            writer.writeNewField("Lcnt", 2, busObject.highSpeedLcnt, (Node)highSpeedElement);
            writer.writeNewField("SdaHold", 2, busObject.highSpeedSdaHold, (Node)highSpeedElement);
        }
        writer.removeSizeCounter(lengthField);
    }

    public ArrayList<BusObject> getBuses() {
        return this._buses;
    }

    public void setBuses(ArrayList<BusObject> buses) {
        this._buses = buses;
    }

    public void addBus(BusObject newBus) {
        this._buses.add(newBus);
    }

    public static class BusObject {
        public static final int INSTANCE_ID_FIELD_SIZE = 1;
        public static final int STD_SPEED_HCNT_FIELD_SIZE = 2;
        public static final int STD_SPEED_LCNT_FIELD_SIZE = 2;
        public static final int STD_SPEED_SDA_HOLD_FIELD_SIZE = 2;
        public static final int FAST_SPEED_HCNT_FIELD_SIZE = 2;
        public static final int FAST_SPEED_LCNT_FIELD_SIZE = 2;
        public static final int FAST_SPEED_SDA_HOLD_FIELD_SIZE = 2;
        public static final int HIGH_SPEED_HCNT_FIELD_SIZE = 2;
        public static final int HIGH_SPEED_LCNT_FIELD_SIZE = 2;
        public static final int HIGH_SPEED_SDA_HOLD_FIELD_SIZE = 2;
        public static final int INSTANCE_ID_FIELD_MAX_VALUE = (int)Math.pow(2.0, 8.0) - 1;
        public static final int STD_SPEED_HCNT_FIELD_SIZE_MAX_VALUE = (int)Math.pow(2.0, 16.0) - 1;
        public static final int STD_SPEED_LCNT_FIELD_MAX_VALUE = (int)Math.pow(2.0, 16.0) - 1;
        public static final int STD_SPEED_SDA_HOLD_FIELD_MAX_VALUE = (int)Math.pow(2.0, 16.0) - 1;
        public static final int FAST_SPEED_HCNT_FIELD_MAX_VALUE = (int)Math.pow(2.0, 16.0) - 1;
        public static final int FAST_SPEED_LCNT_FIELD_MAX_VALUE = (int)Math.pow(2.0, 16.0) - 1;
        public static final int FAST_SPEED_SDA_HOLD_FIELD_MAX_VALUE = (int)Math.pow(2.0, 16.0) - 1;
        public static final int HIGH_SPEED_HCNT_FIELD_MAX_VALUE = (int)Math.pow(2.0, 16.0) - 1;
        public static final int HIGH_SPEED_LCNT_FIELD_MAX_VALUE = (int)Math.pow(2.0, 16.0) - 1;
        public static final int HIGH_SPEED_SDA_HOLD_FIELD_MAX_VALUE = (int)Math.pow(2.0, 16.0) - 1;
        public int instanceId;
        public int sdtSpeedHcnt;
        public int stdSpeedLcnt;
        public int stdSpeedSdaHold;
        public int fastSpeedHcnt;
        public int fastSpeedLcnt;
        public int fastSpeedSdaHold;
        public int highSpeedHcnt;
        public int highSpeedLcnt;
        public int highSpeedSdaHold;
    }
}

