/*************************************************************************************************************
 *                                                                                                           *
 *  Copyright (c) 2016 - 2024, Intel Corporation                                                             *
 *                                                                                                           *
 *  Redistribution and use in source and binary forms, with or without                                       *
 *  modification, are permitted provided that the following conditions are met:                              *
 *                                                                                                           *
 *      * Redistributions of source code must retain the above copyright notice,                             *
 *        this list of conditions and the following disclaimer.                                              *
 *      * Redistributions in binary form must reproduce the above copyright                                  *
 *        notice, this list of conditions and the following disclaimer in the                                *
 *        documentation and/or other materials provided with the distribution.                               *
 *      * Neither the name of Intel Corporation nor the names of its contributors                            *
 *        may be used to endorse or promote products derived from this software                              *
 *        without specific prior written permission.                                                         *
 *                                                                                                           *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"                              *
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE                                *
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE                           *
 *  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE                              *
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL                               *
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR                               *
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER                               *
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,                            *
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE                            *
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                     *
 *                                                                                                           *
 *************************************************************************************************************
 *                                                                                                           *
 *  Module name:                                                                                             *
 *      freebsdnalioctl.h                                                                                    *
 *                                                                                                           *
 *  Abstract:                                                                                                *
 *      This file contains freebsdnalioctl.h                                                                 *
 *                                                                                                           *
 ************************************************************************************************************/
#ifndef INC_FREEBSD_FREEBSDDEFS_H_
#define INC_FREEBSD_FREEBSDDEFS_H_

#ifndef IFNAMSIZ
#define IFNAMSIZ                                        16
#elif IFNAMSIZ != 16
#error IFNAMSIZ defined different as 16 - the freebsddefs.h file should be updated
#endif
#define IFACE_NAME_SYSCTL_OUTPUT_BUF_LENGTH             100
#define NAL_OS_SPEC_ETH_IOCTL                           SIOCGDRVSPEC
#define NAL_OS_SPEC_WETH_IOCTL                          SIOCSDRVSPEC
#define NAL_OS_SPEC_MAX_PCI_DEVICES                     256
#define NAL_OS_SPEC_BASE_DRIVER_NAME_MAX_LENGTH         256

#define NAL_OS_SPEC_PCI_BAR_0_REGISTER_OFFSET           0x10
#define NAL_OS_SPEC_PCI_BAR_1_REGISTER_OFFSET           0x14
#define NAL_OS_SPEC_PCI_BAR_2_REGISTER_OFFSET           0x18
#define NAL_OS_SPEC_PCI_BAR_3_REGISTER_OFFSET           0x1C
#define NAL_OS_SPEC_PCI_BAR_4_REGISTER_OFFSET           0x20
#define NAL_OS_SPEC_PCI_BAR_5_REGISTER_OFFSET           0x24

#define NAL_OS_SPEC_DRIVER_MAJOR_VERSION                1
#define NAL_OS_SPEC_DRIVER_MINOR_VERSION                2
#define NAL_OS_SPEC_DRIVER_BUILD_VERSION                0
#define NAL_OS_SPEC_DRIVER_FIX_VERSION                  14

#define NAL_OS_SPEC_MAKE_VERSION_STRING_HELPER(M,N,B,F) #M "." #N "." #B "." #F
#define NAL_OS_SPEC_MAKE_VERSION_STRING(M,N,B,F)        NAL_OS_SPEC_MAKE_VERSION_STRING_HELPER(M,N,B,F)
#define NAL_OS_SPEC_DRIVER_VERSION                      NAL_OS_SPEC_MAKE_VERSION_STRING(NAL_OS_SPEC_DRIVER_MAJOR_VERSION,NAL_OS_SPEC_DRIVER_MINOR_VERSION,NAL_OS_SPEC_DRIVER_BUILD_VERSION,NAL_OS_SPEC_DRIVER_FIX_VERSION)
#define NAL_OS_SPEC_DRIVER_DESCRIPTION                  NAL_OS_SPEC_DRIVER_VERSION

#define NAL_OS_SPEC_IOCTL_GROUP_NUMBER                  0x80

#define NAL_OS_SPEC_MEM_DRIVER_PATH                     "/dev/mem"
#define NAL_OS_SPEC_KMEM_DRIVER_PATH                    "/dev/kmem"
#define NAL_OS_SPEC_IO_DRIVER_PATH                      "/dev/io"
#define NAL_OS_SPEC_PCI_DRIVER_PATH                     "/dev/pci"
#define NAL_OS_SPEC_QV_DRIVER_PATH                      "/dev/nal"
#define NAL_OS_SPEC_QV_DRIVER_FILE_NAME                 "iqvfreebsd.ko"
#define NAL_OS_SPEC_QV_DRIVER_FILE_PATH                 "/boot/kernel/" NAL_OS_SPEC_QV_DRIVER_FILE_NAME
#define NAL_OS_SPEC_LOG_FILE_PATH                       "/var/log/iqvfreebsd.log"
#define NAL_OS_SPEC_SDK_LOG_FILE_PATH                   "./qvsdk.log"

#define NAL_OS_SPEC_MAX_TIMERS                          2
#define NAL_OS_SPEC_MAX_MEMORY_ALLOCATIONS              50000
#define NAL_OS_SPEC_MAX_CONTIGUOUS_MEMORY_ALLOCATION    (128 * 1024)
#define NAL_OS_SPEC_MAX_NON_PAGED_MEMORY_ALLOCATIONS    50000
#define NAL_OS_SPEC_INTERRUPT_SIGNATURE                 0xA5BABA5A
#define NAL_OS_SPEC_MS_DELAY_FOR_CALCULATION            100

/*
 * Flag if threads in the FreeBSD should be used. If it is set to FALSE, then instead of threads,
 * the function will be called just in current thread. If it is set to TRUE, then it is required
 * to add -lpthread library to the buildenv/makefreebsdapp.mak file to LDADD variable. Note, that
 * this library can causes some problems with stack size (when size of the stack is something
 * about 23 MB)
 */
#define NAL_OS_SPEC_THREADS_ACTIVE                      FALSE

#define NAL_OS_SPEC_I40E_IOC          ((((((('E' << 4) + '1') << 4) \
                                           + 'K') << 4) + 'G') << 4)
#define NAL_OS_SPEC_I40E_NVM_ACCESS       (NAL_OS_SPEC_I40E_IOC | 5)    /* used by nvm update */
#define NAL_OS_SPEC_I40E_STOP_DRIVER      (1)
#define NAL_OS_SPEC_I40E_START_DRIVER     (2)

#ifndef NAL_DRIVER
// /////////////////////////////////////////////////////
/*           NAL compiler definitions                 */
// /////////////////////////////////////////////////////
#   define DO_PRAGMA(X)                                    _Pragma (#X)
#   define NAL_COMPILER_MESSAGE(MESSAGE)                   DO_PRAGMA(message(MESSAGE))
#   define NAL_STATIC_ASSERT(CONDITION,MESSAGE)            _Static_assert( CONDITION , MESSAGE )

// /////////////////////////////////////////////////////
/*           POSIX safe functions configuration       */
// /////////////////////////////////////////////////////
#   define USE_NAL_INSTEAD_OF_POSIX
#   define USE_AUTO_BUFFER_SIZE_DETECTION
#   define FORCE_USING_NAL_INSTEAD_OF_POSIX
#   define NalVPrintStringFormattedSafe                      vsnprintf

#   define UNREFERENCED_PARAMETER(x)                        (void)x
#endif

#endif /* INC_FREEBSD_FREEBSDDEFS_H_ */
