/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads;

import binTools.BinReader;
import binTools.BinWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.payloads.BusPayload;

public class BusPayloadUart
extends BusPayload {
    public static final int BUS_TYPE = 1;
    private static final int ENABLE_RTS_CTS_BIT = 0;
    private boolean _enableRtsCts;

    public BusPayloadUart(int busIndex, int busSpeed, boolean enableRtcCts) {
        super(1, busIndex, 0, busSpeed);
        this._enableRtsCts = enableRtcCts;
    }

    protected BusPayloadUart(BinReader reader, Element payloadXmlNode) {
        super(reader, payloadXmlNode);
        this.setBusType(1);
        int additionalValue = reader.readNewField((String)"AdditionalValue", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        this._enableRtsCts = (additionalValue & 1) > 0;
        reader.addComment("AdditionalValue: EnableCtsRts = " + this._enableRtsCts, payloadXmlNode);
    }

    public BusPayloadUart(BusPayloadUart other) {
        super(other);
        this._enableRtsCts = other._enableRtsCts;
    }

    @Override
    public void writeBusData(BinWriter writer, Element parent) {
        this.writeFirstBusFields(writer, parent);
        int additinalValue = 0;
        writer.writeNewField("AdditionalValue", 1, additinalValue |= this._enableRtsCts ? 1 : 0, (Node)parent);
        writer.addComment("AdditionalValue: EnableCtsRts = " + this._enableRtsCts, parent);
    }

    @Override
    public BusPayload clone() {
        return new BusPayloadUart(this);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof BusPayloadUart)) {
            return false;
        }
        BusPayloadUart other = (BusPayloadUart)arg0;
        return super.equals(other) && this._enableRtsCts == other._enableRtsCts;
    }

    @Override
    public boolean isEnableRtsCts() {
        return this._enableRtsCts;
    }

    public void setEnableRtsCts(boolean enableRtsCts) {
        this._enableRtsCts = enableRtsCts;
    }

    @Override
    public boolean isCsNative() {
        return false;
    }

    @Override
    public int getCsPin() {
        return 0;
    }

    @Override
    public boolean isIbiEnable() {
        return false;
    }

    @Override
    public int getIbiPurpose() {
        return 0;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

