/*
 * Decompiled with CFR 0.152.
 */
package manager.configure;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import manager.configure.Firmware;
import manager.configure.Platform;
import manager.utils.ManagerConfigs;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="platform")
public class InstalledFirmwares {
    @XmlAttribute(name="name")
    private String platformName;
    @XmlAttribute(name="default")
    private String defaultFwVersion;
    @XmlElement(name="firmware")
    private List<Firmware> firmwares = new ArrayList<Firmware>();

    public InstalledFirmwares() {
    }

    public InstalledFirmwares(String name) {
        this.platformName = name;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public void setFirmwares(List<Firmware> firmwares) {
        if (firmwares != null) {
            this.firmwares = firmwares;
        }
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public List<Firmware> getFirmwares() {
        return this.firmwares;
    }

    public String getDefaultFwVersion() {
        return this.defaultFwVersion;
    }

    public void setDefaultFwVersion(String defaultFwVersion) {
        this.defaultFwVersion = defaultFwVersion;
    }

    public Firmware getDefaultFirmware() {
        Firmware ret = null;
        if (this.defaultFwVersion != null && !this.defaultFwVersion.isEmpty()) {
            ret = this.getFirmwareByVersion(this.defaultFwVersion);
        }
        if (ret == null) {
            ret = this.getFirstFw("FDK");
        }
        if (ret == null) {
            ret = this.getFirstFw("SWAP");
        }
        if (ret == null) {
            ret = this.getFirstFw("USER");
        }
        return ret;
    }

    private Firmware getFirstFw(String flag) {
        for (Firmware fm : this.firmwares) {
            if (!fm.getFlag().equals(flag)) continue;
            return fm;
        }
        return null;
    }

    public Firmware getFirmwareByVersion(String version) {
        for (Firmware fm : this.firmwares) {
            if (!fm.getVersion().equals(version)) continue;
            return fm;
        }
        return null;
    }

    public List<Firmware> getNoFDKFirmwares() {
        ArrayList<Firmware> fms = new ArrayList<Firmware>();
        for (Firmware fm : this.firmwares) {
            if (fm.isFDKInstalled()) continue;
            fms.add(fm);
        }
        return fms;
    }

    public void updateFirmware() throws Exception {
        Platform plat = ManagerConfigs.getPlatformByName(this.platformName);
        if (plat == null) {
            return;
        }
        for (Firmware fm : this.firmwares) {
            fm.setPlatform(plat);
        }
    }

    public String dump() {
        String s = "";
        s = String.valueOf(s) + "[" + this.platformName + "]\n";
        if (this.firmwares != null) {
            for (Firmware fw : this.firmwares) {
                s = String.valueOf(s) + fw.dump() + "\n";
            }
        }
        return s;
    }
}

