/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.common.utils;

import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.common.utils.JREVersion;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public class WinRegistry {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int REG_SUCCESS = 0;
    private static final int KEY_READ = 131097;
    private static Preferences userRoot = Preferences.userRoot();
    private static Preferences systemRoot = Preferences.systemRoot();
    private static Class<? extends Preferences> userClass = userRoot.getClass();
    private static Method regOpenKey = null;
    private static Method regCloseKey = null;
    private static Method regQueryValueEx = null;
    private static Method regEnumValue = null;
    private static Method regQueryInfoKey = null;
    private static Method regEnumKeyEx = null;

    static {
        try {
            regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            regOpenKey.setAccessible(true);
            regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            regCloseKey.setAccessible(true);
            regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            regQueryValueEx.setAccessible(true);
            regEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumValue.setAccessible(true);
            regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Integer.TYPE);
            regQueryInfoKey.setAccessible(true);
            regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regEnumKeyEx.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception e) {
            ISSLogger.e(e);
        }
    }

    public static String readString(int hkey, String key, String valueName) throws Exception {
        if (JREVersion.isJava8() || JREVersion.isJava7()) {
            return WinRegistry.readStringInJRE8(hkey, key, valueName);
        }
        if (JREVersion.isJava11()) {
            return WinRegistry.readStringInJRE11(hkey, valueName, valueName);
        }
        throw new Exception("Can not read reg: " + valueName + "due to incompability of your JRE version.");
    }

    private static String readStringInJRE11(int hkey, String key, String valueName) throws Exception {
        try {
            if (hkey == -2147483646) {
                return System.getenv(valueName);
            }
            if (hkey == -2147483647) {
                return System.getenv(valueName);
            }
            throw new IllegalArgumentException("hkey=" + hkey);
        }
        catch (Exception exception) {
            throw new Exception("The " + valueName + " environment variable is missing.");
        }
    }

    private static String readStringInJRE8(int hkey, String key, String valueName) throws Exception {
        try {
            if (hkey == -2147483646) {
                return WinRegistry.readString(systemRoot, hkey, key, valueName);
            }
            if (hkey == -2147483647) {
                return WinRegistry.readString(userRoot, hkey, key, valueName);
            }
            throw new IllegalArgumentException("hkey=" + hkey);
        }
        catch (Exception exception) {
            throw new Exception("The " + valueName + " environment variable is missing.");
        }
    }

    public static Map<String, String> readStringValues(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, Exception {
        if (hkey == -2147483646) {
            return WinRegistry.readStringValues(systemRoot, hkey, key);
        }
        if (hkey == -2147483647) {
            return WinRegistry.readStringValues(userRoot, hkey, key);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    public static List<String> readStringSubKeys(int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646) {
            return WinRegistry.readStringSubKeys(systemRoot, hkey, key);
        }
        if (hkey == -2147483647) {
            return WinRegistry.readStringSubKeys(userRoot, hkey, key);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    private static String readString(Preferences root, int hkey, String key, String value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int[] handles = (int[])regOpenKey.invoke((Object)root, hkey, WinRegistry.toCstr(key), 131097);
        if (handles[1] != 0) {
            return null;
        }
        byte[] valb = (byte[])regQueryValueEx.invoke((Object)root, handles[0], WinRegistry.toCstr(value));
        regCloseKey.invoke((Object)root, handles[0]);
        return valb != null ? new String(valb).trim() : null;
    }

    private static Map<String, String> readStringValues(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, Exception {
        HashMap<String, String> results = new HashMap<String, String>();
        int[] handles = (int[])regOpenKey.invoke((Object)root, hkey, WinRegistry.toCstr(key), 131097);
        if (handles[1] != 0) {
            return null;
        }
        int[] info = (int[])regQueryInfoKey.invoke((Object)root, handles[0]);
        int count = info[2];
        int maxlen = info[3];
        int index = 0;
        while (index < count) {
            byte[] name = (byte[])regEnumValue.invoke((Object)root, handles[0], index, maxlen + 1);
            String value = WinRegistry.readString(hkey, key, new String(name));
            results.put(new String(name).trim(), value);
            ++index;
        }
        regCloseKey.invoke((Object)root, handles[0]);
        return results;
    }

    private static List<String> readStringSubKeys(Preferences root, int hkey, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> results = new ArrayList<String>();
        int[] handles = (int[])regOpenKey.invoke((Object)root, hkey, WinRegistry.toCstr(key), 131097);
        if (handles[1] != 0) {
            return null;
        }
        int[] info = (int[])regQueryInfoKey.invoke((Object)root, handles[0]);
        int count = info[0];
        int maxlen = info[3];
        int index = 0;
        while (index < count) {
            byte[] name = (byte[])regEnumKeyEx.invoke((Object)root, handles[0], index, maxlen + 1);
            results.add(new String(name).trim());
            ++index;
        }
        regCloseKey.invoke((Object)root, handles[0]);
        return results;
    }

    private static byte[] toCstr(String str) {
        byte[] result = new byte[str.length() + 1];
        int i = 0;
        while (i < str.length()) {
            result[i] = (byte)str.charAt(i);
            ++i;
        }
        result[str.length()] = 0;
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isProgramInstalled(String programName) {
        try {
            String str;
            String key;
            String temp;
            Map<String, String> tr;
            List<String> keys = WinRegistry.readStringSubKeys(-2147483646, "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall");
            Iterator<String> iterator = keys.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((tr = WinRegistry.readStringValues(-2147483646, temp = "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + (key = iterator.next()))).isEmpty() || !tr.containsKey("DisplayName") || !(str = tr.get("DisplayName")).contains(programName));
            return true;
        }
        catch (Exception e) {
            ISSLogger.e(e);
        }
        return false;
    }
}

