/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.calibration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.calibration.CalibrationEditor;
import pdtEditor.gui.calibration.CalibrationEditorOpener;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.payloads.calibrations.CustomCalibrationPayload;
import resources.CustomSpinner;

public class CustomCalibrationEditor
implements CalibrationEditor {
    protected Shell shlEditCalibration;
    private CustomSpinner formatID;
    private Display display;
    private ArrayList<Byte> _tempVendorData = null;
    private CalibrationEditorOpener _parent = null;
    private Sensor _sensor = null;
    private boolean _modified = false;
    private CustomCalibrationPayload _data = null;
    private Button btnVenDataBrowse;
    private Button btnVenDataExport;
    private Label lblDataStatus;
    private Button btnClear;
    private Label vesrionLabel;
    private CustomSpinner spnVersion;
    private String _givenFormatId;

    public static void main(String[] args) {
        try {
            CustomCalibrationEditor window = new CustomCalibrationEditor(null, null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CustomCalibrationEditor(CalibrationEditorOpener parent, CustomCalibrationPayload data, Sensor sensor) {
        this._parent = parent;
        this._data = data;
        this._sensor = sensor;
    }

    @Override
    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlEditCalibration.open();
        this.shlEditCalibration.layout();
        while (!this.shlEditCalibration.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    @Override
    public String getCalibrationFormatName() {
        return "Vendor custom calibration data";
    }

    public void exportVendorData() {
        if (this._tempVendorData == null || this._tempVendorData.size() == 0) {
            return;
        }
        FileDialog fd = new FileDialog(this.shlEditCalibration, 8192);
        fd.setText("Export Vendor Data");
        fd.setFilterPath("C:/");
        String[] filterExt = new String[]{"*.*"};
        fd.setFilterExtensions(filterExt);
        String path = fd.open();
        if (path == null || path.isEmpty()) {
            return;
        }
        byte[] toWrite = new byte[this._tempVendorData.size()];
        for (int i = 0; i < toWrite.length; ++i) {
            toWrite[i] = this._tempVendorData.get(i);
        }
        try {
            Files.write(Paths.get(path, new String[0]), toWrite, new OpenOption[0]);
        }
        catch (IOException e) {
            MessageBox messageBox = new MessageBox(this.shlEditCalibration, 33);
            messageBox.setText("Exporting Vendor Data");
            messageBox.setMessage("Exporting The Vendor Data Failed");
            messageBox.open();
        }
    }

    public void browseVendorData() {
        if (this._tempVendorData != null && this._tempVendorData.size() > 0) {
            MessageBox messageBox = new MessageBox(this.shlEditCalibration, 296);
            messageBox.setText("Loading New Vendor Defined Data");
            messageBox.setMessage("Loading new data will override the old data. Do you want to continue?");
            if (messageBox.open() != 32) {
                return;
            }
        }
        if (this._tempVendorData == null) {
            this._tempVendorData = new ArrayList();
        } else {
            this._tempVendorData.clear();
        }
        FileDialog fd = new FileDialog(this.shlEditCalibration, 4096);
        fd.setText("Import Vendor Data");
        fd.setFilterPath("C:/");
        String[] filterExt = new String[]{"*.*"};
        fd.setFilterExtensions(filterExt);
        String path = fd.open();
        if (path == null || path.isEmpty()) {
            return;
        }
        try {
            byte[] binaryData = Files.readAllBytes(Paths.get(path, new String[0]));
            if (binaryData.length > 65000) {
                MessageBox messageBox = new MessageBox(this.shlEditCalibration, 33);
                messageBox.setText("Loading Failed");
                messageBox.setMessage("The size of the selected file (" + binaryData.length + " bytes) exceeds the maximal file size (" + 65000 + " bytes).");
                messageBox.open();
                return;
            }
            for (int i = 0; i < binaryData.length; ++i) {
                this._tempVendorData.add(binaryData[i]);
            }
        }
        catch (IOException e) {
            MessageBox messageBox = new MessageBox(this.shlEditCalibration, 33);
            messageBox.setText("Loading Failed");
            messageBox.setMessage("Loading the new data failed");
            messageBox.open();
        }
        this.updateVendorDataComponents();
        this._modified = true;
    }

    public void updateVendorDataComponents() {
        if (this._tempVendorData != null && this._tempVendorData.size() > 0) {
            this.lblDataStatus.setText("Contains Data");
            this.btnVenDataExport.setEnabled(true);
            this.btnClear.setEnabled(true);
        } else {
            this.lblDataStatus.setText("No Data");
            this.btnVenDataExport.setEnabled(false);
            this.btnClear.setEnabled(false);
        }
    }

    public void saveData() {
        boolean newCalibration = false;
        CustomCalibrationPayload data = this._data;
        if (data == null) {
            data = new CustomCalibrationPayload();
            newCalibration = true;
        }
        try {
            MessageBox messageBox;
            int formatId = this.formatID.getSelection();
            if (formatId < 128 && !this.formatID.getText().equals(this._givenFormatId)) {
                messageBox = new MessageBox(this.shlEditCalibration, 200);
                messageBox.setText("Illegal value");
                messageBox.setMessage("The minimum value for 'Calibration Format ID' is 128. Values that are lower then this value are Intel-reserved. Are you sure that you want to continue?");
                if (messageBox.open() == 128) {
                    return;
                }
            }
            if (Integer.valueOf(this.spnVersion.getText()) < 0) {
                messageBox = new MessageBox(this.shlEditCalibration, 33);
                messageBox.setText("Illegal value");
                messageBox.setMessage("The value of the 'Version' field cannot be less then zero.");
                messageBox.open();
                return;
            }
        }
        catch (NumberFormatException e) {
            MessageBox messageBox = new MessageBox(this.shlEditCalibration, 33);
            messageBox.setText("Illegal value");
            messageBox.setMessage("One of the fields contains an illegal value");
            messageBox.open();
            return;
        }
        data.setFormatID(this.formatID.getSelection());
        data.setVersion(this.spnVersion.getSelection());
        data.setVendorDefinedData(this._tempVendorData);
        if (newCalibration) {
            this._parent.addNewCalibration(this._sensor, data);
        }
        this._data = data;
        this._modified = false;
        this._parent.setModified();
        this._parent.refreshCalibrationData();
        this.shlEditCalibration.close();
    }

    public void fillData() {
        if (this._data == null) {
            if (this._sensor != null) {
                List<Integer> possibleFormats = this._sensor.getPossibleCalibrationFormats();
                if (possibleFormats != null) {
                    for (Integer format : possibleFormats) {
                        if (format < 128) continue;
                        this.formatID.setSelection(format);
                        break;
                    }
                } else {
                    this.formatID.setSelection(128);
                }
            } else {
                this.formatID.setSelection(128);
            }
            this.spnVersion.setSelection(0);
            this._modified = false;
            return;
        }
        this.formatID.setSelection(this._data.getFormatID());
        this._givenFormatId = String.valueOf(this._data.getFormatID());
        this.spnVersion.setSelection(this._data.getVersion());
        if (this._tempVendorData == null) {
            this._tempVendorData = new ArrayList();
        }
        this._tempVendorData.clear();
        if (this._data.getVendorDefinedData() != null) {
            for (Byte oneByte : this._data.getVendorDefinedData()) {
                this._tempVendorData.add(oneByte);
            }
        }
        this.updateVendorDataComponents();
        this._modified = false;
    }

    protected void createContents() {
        this.shlEditCalibration = new Shell(65760);
        this.shlEditCalibration.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (CustomCalibrationEditor.this._modified) {
                    MessageBox messageBox = new MessageBox(CustomCalibrationEditor.this.shlEditCalibration, 296);
                    messageBox.setText("Closing The 'Edit Calibration' Window");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to close the 'Calibration Modifier' window?");
                    if (messageBox.open() != 32) {
                        e.doit = false;
                        return;
                    }
                }
            }
        });
        this.shlEditCalibration.setImage(SWTResourceManager.getImage(CustomCalibrationEditor.class, "/resources/Intel.ico"));
        this.shlEditCalibration.setText("Calibration Modifier");
        GuiUtils.setGridLayoutToComposite((Composite)this.shlEditCalibration, 1);
        Group group = GuiUtils.addGroupToComposite("", (Composite)this.shlEditCalibration, 0, 4, 128, true, false, 1, 1, 3);
        GuiUtils.addLabelToComposite("Calibration Format ID:", (Composite)group, 0, 16384, 0x1000000, false, false, 1, 1);
        this.formatID = GuiUtils.addCustomSpinnerToComposite(CalibrationPayload.FORMAT_ID_MAX_VALUE, this.shlEditCalibration, (Composite)group, 2048, 16384, 0x1000000, true, false, 1, 1);
        Label lbSpacer = GuiUtils.addLabelToComposite("", (Composite)group, 0, 4, 0x1000000, true, false, 1, 1);
        this.vesrionLabel = GuiUtils.addLabelToComposite("Calibration Version:", (Composite)group, 0, 16384, 0x1000000, false, false, 1, 1);
        this.spnVersion = GuiUtils.addCustomSpinnerToComposite(CalibrationPayload.VERSION_MAX_VALUE, this.shlEditCalibration, (Composite)group, 2048, 16384, 0x1000000, true, false, 1, 1);
        Group grpVendorDefinedData = GuiUtils.addGroupToComposite("Vendor-defined Data (Binary files only)", (Composite)this.shlEditCalibration, 0, 4, 128, true, false, 1, 1, 1);
        this.lblDataStatus = GuiUtils.addLabelToComposite("No Data", (Composite)grpVendorDefinedData, 0, 16384, 0x1000000, false, false, 1, 1);
        Composite compositeBusInfoButton = GuiUtils.addCompositeToComposite((Composite)grpVendorDefinedData, 0, 4, 0x1000000, false, false, 1, 1, 3);
        this.btnVenDataBrowse = GuiUtils.addButtonToComposite("Browse", "", compositeBusInfoButton, 0, 16384, 0x1000000, true, false, 1, 1);
        this.btnVenDataExport = GuiUtils.addButtonToComposite("Export", "", compositeBusInfoButton, 0, 16384, 0x1000000, true, false, 1, 1);
        this.btnClear = GuiUtils.addButtonToComposite("Clear", "", compositeBusInfoButton, 0, 16384, 0x1000000, true, false, 1, 1);
        Composite compositeShellButton = GuiUtils.addCompositeToComposite((Composite)this.shlEditCalibration, 0, 131072, 0x1000000, false, false, 1, 1, 2);
        Button btnSave = GuiUtils.addButtonToComposite("Save and Close", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        Button btnCancel = GuiUtils.addButtonToComposite("Cancel", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        this.btnVenDataBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomCalibrationEditor.this.browseVendorData();
            }
        });
        this.btnVenDataExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomCalibrationEditor.this.exportVendorData();
            }
        });
        this.btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomCalibrationEditor.this._tempVendorData != null && CustomCalibrationEditor.this._tempVendorData.size() > 0) {
                    MessageBox messageBox = new MessageBox(CustomCalibrationEditor.this.shlEditCalibration, 296);
                    messageBox.setText("Clearing The Vendor Defined Data");
                    messageBox.setMessage("You are about to clear the vendor defined data. Do you want to continue?");
                    if (messageBox.open() != 32) {
                        return;
                    }
                    CustomCalibrationEditor.this._tempVendorData.clear();
                    CustomCalibrationEditor.this.updateVendorDataComponents();
                }
            }
        });
        this.formatID.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CustomCalibrationEditor.this._modified = true;
            }
        });
        this.spnVersion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CustomCalibrationEditor.this._modified = true;
            }
        });
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomCalibrationEditor.this.saveData();
            }
        });
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomCalibrationEditor.this.shlEditCalibration.close();
            }
        });
        this.spnVersion.setSelection(0);
        this.btnVenDataExport.setEnabled(false);
        this.btnClear.setEnabled(false);
        int spinnerMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shlEditCalibration) * 1.5);
        int longButtonMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shlEditCalibration) * 1.5);
        int shortButtonMinWidth = GuiUtils.getButtonWidth((Control)this.shlEditCalibration);
        ((GridData)this.formatID.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.spnVersion.getLayoutData()).minimumWidth = spinnerMinWidth;
        ((GridData)this.btnVenDataBrowse.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)this.btnVenDataExport.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)this.btnClear.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)btnSave.getLayoutData()).minimumWidth = longButtonMinWidth;
        ((GridData)btnCancel.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)lbSpacer.getLayoutData()).widthHint = spinnerMinWidth;
        ((GridLayout)compositeShellButton.getLayout()).marginHeight = 0;
        ((GridLayout)compositeShellButton.getLayout()).marginWidth = 0;
        ((GridLayout)compositeBusInfoButton.getLayout()).marginHeight = 0;
        ((GridLayout)compositeBusInfoButton.getLayout()).marginWidth = 0;
        this.shlEditCalibration.setSize(this.shlEditCalibration.computeSize(-1, -1));
        this.shlEditCalibration.setLocation(GuiUtils.getMiddleLocation(this.shlEditCalibration, this.display));
    }
}

