<?php
class ActionDeleteHyperDuo extends UserAction
{
	protected $LD_ID;
	protected $HBAID = 0;
	const DeleteCheckPara = "DeleteCheck";
	private $deleteChecked = 0;
	const MBRCheckPara = "MBRCheck";
	private $mbrChecked = 0;
	const ToDeleteMBR = "ToDeleteMBR";
	private $toDeleteMBR = 0;
	private $toStop = 0;
	private $isOffline = 0;
	private $isForeign = 0;
	private $Actions = BgaControl::BGA_CONTROL_TERMINATE_IMMEDIATE;
	
	private $stopBGASuccess = 1;
	
	private $Continue = 1;//should be 1 for true
	
	protected function initActionPara()
	{
		$this->LD_ID = getRequestPara("LDID");
		$this->HBAID = $this->getAdapterID();
		$this->deleteChecked = getRequestPara(self::DeleteCheckPara);
		$this->mbrChecked = getRequestPara(self::MBRCheckPara);
		$this->toDeleteMBR = getRequestPara(self::ToDeleteMBR);
	}
	
	protected function validatePara()
	{
		//check the http request parameters
	}
	
	private function doDelete()
	{
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_HyperDuo_Delete);
		$this->ApiCmd->setCommandPara("AdapterID",$this->HBAID);
		$this->ApiCmd->setCommandPara("HyperDuo_ID",$this->LD_ID);
		$this->ApiCmd->setCommandPara("deleteMBR",$this->toDeleteMBR);
		$this->ApiCmd->issueCommand();
		
		if ($this->ApiCmd->getResult()->RetVal . "") {
			$this->setLDCmdXmlRetFail();
		}
		else {
			//delete related bga schedule when deleting VD
			$this->deleteRelatedSchedule();
			$this->setDeleteLDXmlRetSuccess();
		}
		
	}
	
	protected function setDeleteLDXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName
			. "?Target=" . Target::getHBADetail . "&ID=" . $this->HBAID ;
	}
	
	private function setFlags()
	{
		include_once("../phpsrc/baseclass/LD.class.php");
		include_once("../phpsrc/baseclass/Block.class.php");
		include_once("../phpsrc/baseclass/LdDetail.class.php");
		$ldDetail = new LdDetail();
		$ldDetail->setAdapterID($this->HBAID);
		$ldDetail->setID($this->LD_ID);
		$ldDetail->toGetLDInfo();
		$ldDetail->toGetLDStatus();
		
		$this->toStop = 0;
		$ld = $ldDetail->getBaseDetail();
		if (!$ld) {
			$this->toStop = 0;
			$this->toDeleteMBR = 0;
			return;
		}
		
		if ($ld->getStatus() == LDStatus::LD_STATUS_OFFLINE) {
			$this->isOffline = 1;
		}
		if ($ld->getStatus() == LDStatus::LD_STATUS_FOREIGN){
			$this->isForeign = 1;
		}
		
		if ($this->isOffline || $this->isForeign) {
			$this->toStop = 0;
		}else if ($ld->getBga() != LdBgaStatus::LD_BGA_NONE) {
			$this->toStop = 1;
			$this->Actions = BgaControl::BGA_CONTROL_TERMINATE_IMMEDIATE;
			/*
			if ($ld->getBga() == LdBgaStatus::LD_BGA_MIGRATION) {
				$this->Actions = BgaControl::BGA_CONTROL_TERMINATE_IMMEDIATE;
			}
			else {
				$this->Actions = BgaControl::BGA_CONTROL_ABORT;
			}
			*/
		}
		else {
			$this->toStop = 0;
		}
		
		/*
		if ($ld->getBgaState() == LdBgaState::LD_BGA_STATE_PAUSED) {
			$this->toDeleteMBR = 0;
		}
		*/
	}
	
	private function deleteRelatedSchedule()
	{
		$da = new BGAJobDataAccess();
		$da->deleteBGAJobByVDID($this->LD_ID, $this->getAdapterID()); //TODO
	}
	
	protected function doAction()
	{
		$cmdName = trim(getRequestPara("cmdName"));
		$this->setFlags();
		if (getRequestPara(self::MBRCheckPara) == null //check for the first time in, whether popup msg box of check mbr.
		&& (!$this->isOffline) && (!$this->isForeign)) {
			$this->mbrChecked = 1;
			$YesUrl = getBaseURL() . PHPPageName::CmdPageName 
				. "?cmdName=" . $cmdName ;
			$YesUrl .=  "&LDID" . "=" . $this->LD_ID . "&HBAID=" . $this->HBAID;
			$YesUrl .=  "&" . self::MBRCheckPara  . "=" . $this->mbrChecked;				
			$YesUrl .=  "&" . self::ToDeleteMBR   . "=" . "1";
		
			$NoUrl = getBaseURL() 
					. PHPPageName::CmdPageName . "?cmdName=".$cmdName;
			$NoUrl .=  "&" . self::MBRCheckPara  . "=" . $this->mbrChecked;
			$NoUrl .=  "&LDID" . "=" . $this->LD_ID . "&HBAID=" . $this->HBAID;
			$NoUrl .=  "&" . self::ToDeleteMBR   . "=" . 0;
			
			$this->xmlRet = new ContXMLRet();
			$this->xmlRet->Msg = 
				AlertMsg::LDINFO_DELETE_MBR;
			$this->xmlRet->YesUrl = $YesUrl;
			$this->xmlRet->NoUrl = $NoUrl;
			$this->xmlRet->YesUrlType = XMLRetUrlType::CmdUrl;
			$this->xmlRet->NoUrlType = XMLRetUrlType::CmdUrl;
		}		
	
		if ($this->xmlRet == null) {
                    $this->setFlags();

                    $this->doDelete();
		}
	}
}
?>