/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import java.util.ArrayList;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.InformationStore;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.configuration.DevicePostureConfiguration;
import pdtEditor.gui.configuration.LidModeConfiguration;
import pdtEditor.payloads.configurations.LidModeConfigurationPayload;
import resources.CustomSpinner;

public class LidModeActionModifier {
    protected Shell shlEditConfigurationValues;
    private Display display;
    private Object _parent;
    private TableItem _currentItem = null;
    private CustomSpinner mode;
    private CustomSpinner gpioPurposeId;
    private Combo action;
    private Label lblGpioId;
    private InformationStore infoStore = null;

    public static void main(String[] args) {
        try {
            LidModeActionModifier window = new LidModeActionModifier(null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LidModeActionModifier(Object parent, TableItem currentItem) {
        this._parent = parent;
        this._currentItem = currentItem;
    }

    public void open() {
        this.display = Display.getDefault();
        try {
            this.infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shlEditConfigurationValues, 513);
            messageBox.setText("Cannot load file");
            messageBox.setMessage("Cannot load the sensor definitions file - the file is missing or damaged. Aborting.");
            messageBox.open();
            return;
        }
        this.createContents();
        this.fillData();
        this.shlEditConfigurationValues.open();
        this.shlEditConfigurationValues.layout();
        while (!this.shlEditConfigurationValues.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void fillData() {
        if (this._currentItem == null) {
            return;
        }
        for (int i = 0; i < this.action.getItemCount(); ++i) {
            if (!this.action.getItem(i).equals(this._currentItem.getText(2))) continue;
            this.action.select(i);
        }
        this.mode.setSelection(Integer.valueOf(this._currentItem.getText(0)));
        if (this.gpioPurposeId.isEnabled()) {
            this.gpioPurposeId.setSelection(Integer.valueOf(this._currentItem.getText(1)));
        }
    }

    public void save() {
        if (this.action.getText().length() == 0) {
            MessageBox messageBox = new MessageBox(this.shlEditConfigurationValues, 513);
            messageBox.setText("Action Is Missing");
            messageBox.setMessage("The 'Action' filed has not been set");
            messageBox.open();
            return;
        }
        try {
            if (this._parent.getClass() == LidModeConfiguration.class) {
                if (this.gpioPurposeId.isEnabled()) {
                    ((LidModeConfiguration)this._parent).checkActionValues(this.mode.getSelection(), this.gpioPurposeId.getSelection());
                } else {
                    ((LidModeConfiguration)this._parent).checkActionValues(this.mode.getSelection());
                }
            } else if (this._parent.getClass() == DevicePostureConfiguration.class) {
                if (this.gpioPurposeId.isEnabled()) {
                    ((DevicePostureConfiguration)this._parent).checkActionValues(this.mode.getSelection(), this.gpioPurposeId.getSelection());
                } else {
                    ((DevicePostureConfiguration)this._parent).checkActionValues(this.mode.getSelection());
                }
            }
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shlEditConfigurationValues, 513);
            messageBox.setText("Value Mismatch");
            messageBox.setMessage(e.getMessage());
            messageBox.open();
            return;
        }
        String[] data = new String[]{this.mode.getText(), this.gpioPurposeId.isEnabled() ? this.gpioPurposeId.getText() : "-", this.action.getText()};
        if (this._currentItem == null) {
            if (this._parent.getClass() == LidModeConfiguration.class) {
                ((LidModeConfiguration)this._parent).addActionLine(data);
            } else if (this._parent.getClass() == DevicePostureConfiguration.class) {
                ((DevicePostureConfiguration)this._parent).addActionLine(data);
            }
        } else {
            this._currentItem.setText(data);
        }
        if (this._parent.getClass() == LidModeConfiguration.class) {
            ((LidModeConfiguration)this._parent).setModified();
        } else if (this._parent.getClass() == DevicePostureConfiguration.class) {
            ((DevicePostureConfiguration)this._parent).setModified();
        }
        this.shlEditConfigurationValues.close();
    }

    protected void createContents() {
        this.shlEditConfigurationValues = new Shell(65760);
        this.shlEditConfigurationValues.setImage(SWTResourceManager.getImage(LidModeActionModifier.class, "/resources/Intel.ico"));
        this.shlEditConfigurationValues.setText("Edit Action Values");
        this.shlEditConfigurationValues.setLayout((Layout)new GridLayout(2, false));
        Group group = new Group((Composite)this.shlEditConfigurationValues, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label lblExitAngle = new Label((Composite)group, 0);
        lblExitAngle.setText("Action:");
        this.action = new Combo((Composite)group, 8);
        GridData gd_action = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_action.widthHint = GuiUtils.getButtonWidth((Control)this.shlEditConfigurationValues) * 3 / 2;
        this.action.setLayoutData((Object)gd_action);
        this.action.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                LidModeConfigurationPayload.ActionInfo actionInfo = LidModeActionModifier.this.infoStore.getPlmActionByName(LidModeActionModifier.this.action.getText());
                if (actionInfo != null) {
                    LidModeActionModifier.this.lblGpioId.setEnabled(actionInfo.needGpio);
                    LidModeActionModifier.this.gpioPurposeId.setEnabled(actionInfo.needGpio);
                }
            }
        });
        this.action.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                GuiUtils.chooseComboItemByValue(LidModeActionModifier.this.action);
            }
        });
        ArrayList<LidModeConfigurationPayload.ActionInfo> actions = this.infoStore.getAllPlmActions();
        for (LidModeConfigurationPayload.ActionInfo iterAction : actions) {
            this.action.add(iterAction.name);
        }
        Label lblModeId = new Label((Composite)group, 0);
        lblModeId.setText("Mode ID:");
        this.mode = new CustomSpinner((Composite)group, 2048, this.shlEditConfigurationValues);
        this.mode.setMaximum((int)Math.pow(2.0, 8.0) - 1);
        this.mode.setMinimum(1);
        GridData gd_mode = new GridData(4, 0x1000000, true, false, 1, 1);
        this.mode.setLayoutData(gd_mode);
        this.lblGpioId = new Label((Composite)group, 0);
        this.lblGpioId.setText("GPIO Purpose ID:");
        this.gpioPurposeId = new CustomSpinner((Composite)group, 2048, this.shlEditConfigurationValues);
        this.gpioPurposeId.setMaximum((int)Math.pow(2.0, 8.0) - 1);
        GridData gd_gpioPurposeId = new GridData(4, 0x1000000, true, false, 1, 1);
        this.gpioPurposeId.setLayoutData(gd_gpioPurposeId);
        Button btnOk = new Button((Composite)this.shlEditConfigurationValues, 0);
        GridData gd_btnOk = new GridData(131072, 4, true, false, 1, 1);
        gd_btnOk.widthHint = GuiUtils.getButtonWidth((Control)this.shlEditConfigurationValues);
        btnOk.setLayoutData((Object)gd_btnOk);
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LidModeActionModifier.this.save();
            }
        });
        btnOk.setText("OK");
        Button btnCancel = new Button((Composite)this.shlEditConfigurationValues, 0);
        GridData gd_btnCancel = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shlEditConfigurationValues);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                LidModeActionModifier.this.shlEditConfigurationValues.close();
            }
        });
        btnCancel.setText("Cancel");
        this.shlEditConfigurationValues.setSize(this.shlEditConfigurationValues.computeSize(-1, -1));
        this.shlEditConfigurationValues.setLocation(GuiUtils.getMiddleLocation(this.shlEditConfigurationValues, this.display));
    }
}

