<?php
class ActionAppAccelerate extends UserAction
{
    private $autoModifiedStr;
    private $fixedModifiedStr;
    private $startImmediately;
    private $Volume;
        
	protected function validatePara()
	{
            //check the http request parameters
	}
        
	protected function initActionPara()
	{
		$this->autoModifiedStr = getRequestPara("autoModifiedStr");
		$this->fixedModifiedStr = getRequestPara("fixedModifiedStr");
        $this->startImmediately = getRequestPara("startImmediately");
		$this->Volume = getRequestPara("volName");
	}
	
	private function doUpdateApp()
	{
        $appDA = new ApplicationDataAccess();
        //$applications = $appDA->findAll();

		$autoModifiedArr = explode(" ",$this->autoModifiedStr);
		$fixedModifiedArr = explode(" ",$this->fixedModifiedStr);
		//var_dump($autoModifiedArr);
		foreach ($autoModifiedArr as $auto)
		{
			$autoFlag = explode("_",$auto); //keyId, auto flag
			if (sizeof($autoFlag) == 2) {
				$keyId = $autoFlag[0];
				$isAuto = $autoFlag[1];
        		$app = $appDA->findById($keyId);
        		
        		if ($isAuto)
        			$app->setAppType($app->getAppType() | AppType::TYPE_AUTO);
        		else
        			$app->setAppType($app->getAppType() & (~AppType::TYPE_AUTO));
        
				$appDA->updateAppType($app);
			}
		}
					
		foreach ($fixedModifiedArr as $fixed) {
			$fixedFlag = explode("_",$fixed); //keyId, fixed flag
			if (sizeof($fixedFlag) == 2) {
				$keyId = $fixedFlag[0];
				$isFixed = $fixedFlag[1];
        		$app = $appDA->findById($keyId);
        		
        		if ($isFixed)
        			$app->setAppType($app->getAppType() | AppType::TYPE_FIXED );
        		else
        			$app->setAppType($app->getAppType() & ~AppType::TYPE_FIXED);
	        			
				$appDA->updateAppType($app);
			}
		}
	}
	
	private function checkRunningStatus()
	{
		$ApiCmd = new XMLAPICommand();
		$ApiCmd->setCommand(XMLAPICommand::MV_Accelerator_IsRunning);
		
		$ApiCmd->issueCommand();
		
		if ($ApiCmd->getResult()->IsRunning) {
			$stopCmd = new XMLAPICommand();
			$stopCmd->setCommand(XMLAPICommand::MV_Accelerator_Stop);
			
			$stopCmd->issueCommand();
		}
		
	}
	
	private function autoSelect()
	{
        $appDA = new ApplicationDataAccess();
        $taskDA = new AcceleratorTaskDataAccess();
        $taskDA->deleteAll();

		//prepare
		$volList = new AccelerateVolumeList();
		$volList->toGetAccelerateVolumeInfo();
		$baseclasses = $volList->getBaseClasses();
		foreach ($baseclasses as $vol)
		{
			$volName = trim($vol->getVolumeName());
			if ($volName != "") {
	            $prepareTask = new AcceleratorTask();
	            $prepareTask->setTaskType(AcceleratorTaskType::TASK_TYPE_PREPARE);
	            $prepareTask->setTaskParam("" . $volName);
	            $taskDA->addTask($prepareTask); 
			}
		}
		
		//accelerate
        //will be moved to MvAccelerator.
        $appList = $appDA->findAll();
        foreach($appList as $app) {
            if(($app->getAppType() & AppType::TYPE_FIXED)
                    || ($app->getAppType() & AppType::TYPE_AUTO)) {
                if($app->getPinStatus() != PinStatus::STATUS_PINNED) {
                    //add it to
                    $task = new AcceleratorTask();
                    $task->setTaskType(AcceleratorTaskType::TASK_TYPE_PIN_APP);
                    $task->setTaskParam("" . $app->getKeyId());
                    $taskDA->addTask($task);                        
                }
            }
        }
            
            
		//trim TODO
	}

	private function doAcc()
	{
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_Accelerator_AutoSelectApp);
		$this->ApiCmd->setCommandPara("Volume",$this->Volume);
		//var_dump($this->ApiCmd);
		$this->ApiCmd->issueCommand();

		if ($this->ApiCmd->getResult()->RetVal . "") {
			$this->setAccelerateCmdXmlRetFail();
		}
		else {
			$this->setAccelerateCmdXmlRetSuccess();
		}
	}
	
	private function setAccelerateCmdXmlRetFail()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getAccelerator;

			$Err = AcceleratorError::getErrStr(intval($XMLRoot->RetVal));//ComError::getErrStr(intval($XMLRoot->RetVal));
			$this->xmlRet->Msg = $Err;
		}
	}
	
	private function setAccelerateCmdXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = "JumpPage.php?Target=" . Target::getAccelerator;
	}

	protected function doAction()
	{
		$this->doUpdateApp();
                if ($this->startImmediately){
                    $this->doAcc();
                } else {
                    $this->setAccelerateCmdXmlRetSuccess();
                }
	}
}

?>
