<?php
class ActionCreatePackageVD extends UserAction
{
    private $RaidMode = 0;
    private $StripeSize = 0;
    private $InitType = 0;
    private $HDs = 0;
    private $LDName = 0;
    private $LDSize = 0;
    private $ReadCache;
    private $WriteCache;
    private $DiskCache;
    private $GBRounding = 0;
    private $NumParityDisk = 0;
    private $UseThorSizePolicy = 0;
    private $HBAID = 0;
    private $VDID = GET_ALL;

    protected function validatePara()
    {
        //check the http request parameters
    }
    protected function initActionPara()
    {
        $this->HBAID = $this->getAdapterID();
        $this->RaidMode = getRequestPara("RaidMode");

        $this->LDName = getRequestPara("LDName");
        $this->InitType = getRequestPara("InitType");
        $this->LDSize = getRequestPara("LDSize");
        $this->HDs = trim(getRequestPara("HDs"));
        $this->ReadCache = getRequestPara("ReadCache");
        $this->WriteCache = getRequestPara("WriteCache");
        $this->DiskCache = getRequestPara("DiskCache");
        $this->GBRounding = getRequestPara("GBRounding");
        $this->StripeSize = getRequestPara("StripeSize");
        if ($this->RaidMode == RAIDMode::LD_MODE_RAID6 || $this->RaidMode == RAIDMode::LD_MODE_RAID60) {
            $this->NumParityDisk = getRequestPara("NumOfParityDisk");
        }

        $sysFeature = AdapterFeature::getInstance($this->HBAID);
        $this->UseThorSizePolicy = $sysFeature->isThor;

    }

    private function doCreateLD()
    {
        include_once("../phpsrc/baseclass/PackageVD.class.php");
        include_once("../phpsrc/baseclass/PackageVDList.class.php");
        $oldVDs = new PackageVDList();
        $oldVDs->setAdapterID($this->HBAID);
        $oldVDs->toGetLDInfo();

        $oldVDIDs = array();
        foreach ($oldVDs->getBaseClasses() as $vd)
        {
            $oldVDIDs[] = $vd->getID();
        }

        $this->ApiCmd = new XMLAPICommand();
        $this->ApiCmd->setCommand(XMLAPICommand::MV_Package_VD_Create);
        $this->ApiCmd->setCommandPara("AdapterID",$this->HBAID);
        $this->ApiCmd->setCommandPara("RaidMode",$this->RaidMode);
        $this->ApiCmd->setCommandPara("RoundingScheme",$this->GBRounding);
        $this->ApiCmd->setCommandPara("SubVDCount",0);
        $this->ApiCmd->setCommandPara("StripeBlockSize",$this->StripeSize);
        $this->ApiCmd->setCommandPara("InitializationOption",$this->InitType);
        //$this->ApiCmd->setCommandPara("SectorCoefficient",LDSectorSize::SectorSize512B);
        $this->ApiCmd->setCommandPara("Name",$this->LDName);
        $this->ApiCmd->setCommandPara("NumParityDisk",$this->NumParityDisk);

        //cache
        $CachePolicy = intval($this->ReadCache) | intval($this->WriteCache);
        $this->ApiCmd->setCommandPara("CachePolicy",$CachePolicy);
        //in frontend,0-enable,1-disable for default display enable.
        //in backend 1-enable,0-disable
        $this->ApiCmd->setCommandPara("DiskCache",!($this->DiskCache));

        //HDCount
        $HDCount = 0;
        $hds = explode(" ",$this->HDs);
        foreach ($hds as $Hd)
        {
            if (trim($Hd) != "") {
                $HDCount ++;
            }
        }
        $this->ApiCmd->setCommandPara("PDCount",$HDCount);
        $this->ApiCmd->setCommandPara("PDIDs",$this->HDs);

        $this->ApiCmd->issueCommand();

        if ($this->ApiCmd->getResult()->RetVal . "") {
            $this->setLDCreateFail();
        }
        else {
            $newVDs = new PackageVDList();
            $newVDs->setAdapterID($this->getAdapterID());
            $newVDs->toGetLDInfo();

            $newVDIDs = array();
            foreach ($newVDs->getBaseClasses() as $vd)
            {
                $newVDIDs[] = $vd->getID();
            }
            $arr = array_diff($newVDIDs, $oldVDIDs);
            if ($arr) {
                $this->VDID = array_shift($arr);
            }
            $this->setLDCreateCmdXmlRetSuccess();
        }
    }

    private function setLDCreateCmdXmlRetSuccess()
    {
        $this->xmlRet = new SuccessXMLRet();
        $this->xmlRet->Msg = "";
        $this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName
        ."?Target=" . Target::getPackageVDPage . "&ID=" . $this->VDID . "&HBAID=" . $this->HBAID;
    }

    private function setLDCreateFail()
    {
        $this->xmlRet = new FailXMLRet();
        $XMLRoot = $this->ApiCmd->getResult();
        if ($XMLRoot->RetVal . "") {
            $this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target=" . Target::getHBADetail . "&ID=" . $this->HBAID ;
            $Err = ComError::getErrStr(intval($XMLRoot->RetVal));
            $this->xmlRet->Msg = $Err;
        }
    }

    private function setHDSpareCheckFailXMLRet()
    {
        $this->xmlRet = new FailXMLRet();
        $this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target=" . Target::getHBADetail . "&ID=" . $this->HBAID;
        $Err = ComError::ERR_HD_IS_SPARE_STR;
        $this->xmlRet->Msg = $Err;
    }

    public function doCheckSpare()
    {
        include_once("../phpsrc/baseclass/Device.class.php");
        include_once("../phpsrc/baseclass/SASDevice.class.php");
        include_once("../phpsrc/baseclass/DeviceFactory.class.php");
        include_once("../phpsrc/baseclass/PortDevice.class.php");
        include_once("../phpsrc/baseclass/Block.class.php");
        include_once("../phpsrc/baseclass/HD.class.php");
        include_once("../phpsrc/baseclass/PM.class.php");
        include_once("../phpsrc/baseclass/ExpanderDevice.class.php");

        include_once("../phpsrc/baseclass/HdList.class.php");

        $HdList = new HdList();
        $HdList->setAdapterID($this->HBAID);
        $HdList->toGetHDRaidStatus();

        $HDs = $HdList->getBaseClasses();
        $hds = explode(" ",$this->HDs);
        foreach ($hds as $Hd)
        {
            if (trim($Hd) != "") {
                unset($Hd);
            }
        }
        foreach ($HDs as $HD)
        {
            if ($HD->isSpare()) {
                $HDID = trim($HD->getDeviceID());
                foreach ($hds as $id)
                {
                    if ($HDID == $id) {
                        return false;
                    }
                }
            }
        }

        return true;
    }

    protected function doAction()
    {
        if (! $this->doCheckSpare()) {
            // the create want to create is larger than max create size
            // report resource unvaliable error.
            $this->setHDSpareCheckFailXMLRet();
            return;
        }
        $this->doCreateLD();
    }
}
?>