<?php
class GetAcceleratingStatus {

    private $TplFile;
    private $smarty;
    private $ApiCmd;
    private $xmlRet;//the xml result
    private $status;
    private $finished = 1;
    private $IsRunnning = 0;
    private $hasRunningTask = 0;

    public function IsRunning() {
        return $this->IsRunnning;
    }

    public function hasRunningTask() {
        return $this->hasRunningTask;
    }

    public function setAcceleratingStatus() {
        $accStatus = new AcceleratorStatus();

        if ($accStatus->isDefragging()) {
            $this->IsRunnning = $accStatus->isDefragging();

            $taskDA = new AcceleratorTaskDataAccess();
            $fileDA = new ApplicationFileDataAccess();

            $tasks = $taskDA->findAll();
            $completedTaskNum = 0;
            $totalNum = sizeof($tasks);
            $prepareTaskPriority = 3;
            $commonPriority = 1;
            $currentTask = null;
            foreach($tasks as $task) {
                if($task->getTaskStatus() == AcceleratorTaskStatus::STATUS_NOT_RUN) {
                    $currentTask = $task;
                    break;
                }
                if($task->getTaskStatus() == AcceleratorTaskStatus::STATUS_RUNNING
                        || $task->getTaskStatus() == AcceleratorTaskStatus::STATUS_PAUSED) {
                    $currentTask = $task;
                    break;
                }

                if($task->getTaskType() == AcceleratorTaskType::TASK_TYPE_PREPARE) {
                    $totalNum += $prepareTaskPriority - 1;
                    $completedTaskNum += $prepareTaskPriority;
                } else {
                    $completedTaskNum += $commonPriority;
                    $totalNum += $commonPriority - 1;
                }
            }

            if ($totalNum == $completedTaskNum) {
                //$this->smarty->assign("taskDone", 1);
                $this->smarty->assign("typeStr", "Done");
                $this->smarty->assign("CurrentMovingApp", "");
                $this->smarty->assign("Percentage", 100);
            }

            if($currentTask) {
                $type = $currentTask->getTaskType();
                $typeStr = AcceleratorTaskType::getTaskType($type);

                if ($type == AcceleratorTaskType::TASK_TYPE_PREPARE || $type == AcceleratorTaskType::TASK_TYPE_TRIM) {
                    $param = $currentTask->getTaskParam();
                    $volumeChar = $param[0];
                    $this->smarty->assign("CurrentMovingApp", strtoupper($volumeChar . ":\\"));
                    
                    $percentage = intval(($completedTaskNum * 100 + $currentTask->getTaskProgress() * $prepareTaskPriority) / ($totalNum + $prepareTaskPriority - 1));
                } else {
                    $keyId = intval($currentTask->getTaskParam());
                    $appDA = new ApplicationDataAccess();
                    $app = $appDA->findById($keyId);

                    $appInfo = new ApplicationInfo();
                    if($app) {
                        $appInfo->setApplicationListInfo($app);
                    }
                    $this->smarty->assign("CurrentMovingApp", $appInfo->appName);

                    $percentage = intval(($completedTaskNum * 100 + $currentTask->getTaskProgress() * $commonPriority) / ($totalNum + $commonPriority - 1));
                }

                $this->finished = 0;
                $this->smarty->assign("typeStr","Optimize :");
                $this->smarty->assign("Percentage", $percentage);
                if($currentTask->getTaskStatus() == AcceleratorTaskStatus::STATUS_RUNNING)
                    $this->hasRunningTask = 1;
            } else {
                $this->finished = 1;
            }
        }

        $this->smarty->assign("hasRunningTask", $this->hasRunningTask);
        $this->smarty->assign("Finished", $this->finished);
    }

    public function displayResultXML() {
        $this->TplFile = "XML_AccelerateStatus.tpl";
        $this->setAcceleratingStatus();
        $this->smarty->display($this->TplFile);
    }

    public function smartyAssign($smarty) {
        $this->smarty = $smarty;
    }
}

?>