<?php
class PackageVD extends LD
{
    private $DGID;
    private $TotalManagedSpace;
    private $RemainingManagedSpace;
    private $SmallestAvailablePDSize;
    private $PDCount;
    private $PDIDs = array();
	private $HDList = array();
    private $SparePDCount;
    private $SparePDIDs = array();
	private $SpareHDList = array();
    private $BlockSize;
    private $BgaType;
    private $WriteCacheOn;
    private $PDBgaRunning;
	private $NumParityDisk = 0;
 	//Status;
	private $Bga = 0;
	private $BgaPercentage = 0;
	private $BgaState = 0;
    private $BgaExt = 0;

	public function setNumParityDisk($NumParityDisk)
	{
		$this->NumParityDisk = $NumParityDisk;
	}
	public function getNumParityDisk()
	{
		return $this->NumParityDisk;
	}
	public function setBga($Bga)
	{
		$this->Bga = $Bga;
	}
	public function getBga()
	{
		return $this->Bga;
	}

	public function setBgaPercentage($BgaPercentage)
	{
		$this->BgaPercentage = $BgaPercentage;
	}
	public function getBgaPercentage()
	{
		return $this->BgaPercentage;
	}

	public function setBgaState($BgaState)
	{
		$this->BgaState = $BgaState;
	}
	public function getBgaState()
	{
		return $this->BgaState;
	}

	public function setBgaExt($BgaExt)
	{
		$this->BgaExt = $BgaExt;
	}

	public function getBgaExt()
	{
		return $this->BgaExt;
	}
    
	public function setDGID($DGID)
	{
		$this->DGID = $DGID;
	}
	public function getDGID()
	{
		return $this->DGID;
	}

	public function setTotalManagedSpace($TotalManagedSpace)
	{
		$this->TotalManagedSpace = $TotalManagedSpace;
	}
	public function getTotalManagedSpace()
	{
		return $this->TotalManagedSpace;
	}

	public function setRemainingManagedSpace($RemainingManagedSpace)
	{
		$this->RemainingManagedSpace = $RemainingManagedSpace;
	}
	public function getRemainingManagedSpace()
	{
		return $this->RemainingManagedSpace;
	}

	public function setSmallestAvailablePDSize($SmallestAvailablePDSize)
	{
		$this->SmallestAvailablePDSize = $SmallestAvailablePDSize;
	}
	public function getSmallestAvailablePDSize()
	{
		return $this->SmallestAvailablePDSize;
	}

	public function setPDCount($PDCount)
	{
		$this->PDCount = $PDCount;
	}
	public function getPDCount()
	{
		return $this->PDCount;
	}

	public function setPDIDs($PDIDs)
	{
		$this->PDIDs = $PDIDs;
	}
	public function getPDIDs()
	{
		return $this->PDIDs;
	}

	public function setSparePDCount($SparePDCount)
	{
		$this->SparePDCount = $SparePDCount;
	}
	public function getSparePDCount()
	{
		return $this->SparePDCount;
	}

	public function setSparePDIDs($SparePDIDs)
	{
		$this->SparePDIDs = $SparePDIDs;
	}
	public function getSparePDIDs()
	{
		return $this->SparePDIDs;
	}

	public function setSpareHDList($SpareHDList)
	{
		$this->SpareHDList = $SpareHDList;
	}
	public function getSpareHDList()
	{
		return $this->SpareHDList;
	}

	public function setHDList($HDList)
	{
		$this->HDList = $HDList;
	}
	
	public function getHDList()
	{
		return $this->HDList;
	}

	public function setBlockSize($BlockSize)
	{
		$this->BlockSize = $BlockSize;
	}
	public function getBlockSize()
	{
		return $this->BlockSize;
	}

	public function setBgaType($BgaType)
	{
		$this->BgaType = $BgaType;
	}
	public function getBgaType()
	{
		return $this->BgaType;
	}

	public function setWriteCacheOn($WriteCacheOn)
	{
		$this->WriteCacheOn = $WriteCacheOn;
	}
	public function getWriteCacheOn()
	{
		return $this->WriteCacheOn;
	}

    public function setPDBgaRunning($PDBgaRunning)
    {
        $this->PDBgaRunning = $PDBgaRunning;
    }

    public function getPDBgaRunning()
    {
        return $this->PDBgaRunning;
    }
    
	public function setLdInfo($Info)
	{
        parent::setLdInfo($Info);
        
 		if (isset($Info->DGID)) {
 			$this->DGID = trim($Info->DGID);
 		}
 		if (isset($Info->TotalManagedSpace)) {
 			$this->TotalManagedSpace = trim($Info->TotalManagedSpace);
 		}
 		if (isset($Info->RemainingManagedSpace)) {
 			$this->RemainingManagedSpace = trim($Info->RemainingManagedSpace);
 		}
 		if (isset($Info->SmallestAvailablePDSize)) {
 			$this->SmallestAvailablePDSize = trim($Info->SmallestAvailablePDSize);
 		}
 		if (isset($Info->PDCount)) {
 			$this->PDCount = trim($Info->PDCount);
 		}
 		if (isset($Info->PDIDs)) {
 			$this->PDIDs = array();
 			$hds = explode(" ", trim($Info->PDIDs));
 			$i = 0;
 			foreach ($hds as $id)
 			{
 				if($id != 65535 && trim($id) != "" && $i < $this->PDCount)
 				{
 					$this->PDIDs[] = $id;
 					$i++;
 				}
 			}
 		}

 		if (isset($Info->SparePDCount)) {
 			$this->SparePDCount = trim($Info->SparePDCount);
 		}
 		if (isset($Info->SparePDIDs)) {
 			$this->SparePDIDs = array();
 			$hds = explode(" ", trim($Info->SparePDIDs));
 			$i = 0;
 			foreach ($hds as $id)
 			{
 				if($id != 65535 && trim($id) !== "" && $i < $this->SparePDCount)
 				{
 					$this->SparePDIDs[] = $id;
 					$i++;
 				}
 			}
 		}
 		if (isset($Info->BlockSize)) {
 			$this->BlockSize = trim($Info->BlockSize);
 		}
 		if (isset($Info->BgaType)) {
 			$this->BgaType = trim($Info->BgaType);
 		}
 		if (isset($Info->PDBgaRunning)) {
            $this->PDBgaRunning = trim($Info->PDBgaRunning);
        }
        if($Info->RaidMode == RAIDMode::LD_MODE_RAID6 || $Info->RaidMode == RAIDMode::LD_MODE_RAID60){
            $this->NumParityDisk = trim($Info->NumParityDisk);//raid6/60 Redundancy
        }
        if (isset($Info->Bga)) {
            $this->Bga = (trim($Info->Bga));
        }
        if (isset($Info->BgaPercentage)) {
			$this->BgaPercentage = (trim($Info->BgaPercentage));
		}
		if (isset($Info->BgaState)) {
			$this->BgaState = (trim($Info->BgaState));
		}
		if (isset($Info->BgaExt)) {
			$this->BgaExt = (trim($Info->BgaExt));
		}
	}
	
	public function setLdConfig($Config)
	{
        parent::setLdConfig($Config);
        
		if (isset($Config->WriteCacheOn)) {
			$this->WriteCacheOn = trim($Config->WriteCacheOn);
		}
	}
	
}

?>