/*
 * Decompiled with CFR 0.152.
 */
package manager.common;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import manager.utils.ManagerEnums;

public class PathDetails
implements Comparable<PathDetails> {
    private String relativePath;
    private String projectPath;
    private String workspacePath;
    private ManagerEnums.PathSaveOption saveOption;

    public PathDetails(String shortPath, ManagerEnums.PathSaveOption pathSaveOption, String projectPath, String workspacePath) {
        this.relativePath = shortPath;
        this.saveOption = pathSaveOption;
        this.projectPath = projectPath;
        this.workspacePath = workspacePath;
    }

    public PathDetails(PathDetails otherPathDetails) {
        this.relativePath = otherPathDetails.relativePath;
        this.saveOption = otherPathDetails.saveOption;
        this.projectPath = otherPathDetails.projectPath;
        this.workspacePath = otherPathDetails.workspacePath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getWorkspacePath() {
        return this.workspacePath;
    }

    public String getRelativePath() {
        return this.relativePath == null ? "" : this.relativePath;
    }

    public void setRelativePath(String shortPath) {
        this.relativePath = shortPath;
    }

    public ManagerEnums.PathSaveOption getSaveOption() {
        return this.saveOption;
    }

    public void setPathSaveOption(ManagerEnums.PathSaveOption pathSaveOption) {
        String dest = this.getFullPath();
        this.saveOption = pathSaveOption;
        this.updateRelativePath(dest);
    }

    public void updateRelativePath(String destPath) {
        Path src = null;
        Path relative = null;
        Path dest = FileSystems.getDefault().getPath(destPath, new String[0]);
        if (this.saveOption.equals((Object)ManagerEnums.PathSaveOption.FULL)) {
            relative = dest;
        } else {
            src = this.saveOption.equals((Object)ManagerEnums.PathSaveOption.WORKSPACE) ? FileSystems.getDefault().getPath(this.workspacePath, new String[0]) : FileSystems.getDefault().getPath(this.projectPath, new String[0]);
            try {
                relative = src.relativize(dest);
            }
            catch (IllegalArgumentException e) {
                relative = dest;
            }
        }
        String relativeString = src != null && src.equals(dest) ? "\\" : relative.toString();
        this.setRelativePath(relativeString);
    }

    public String getFullPath() {
        String fullPathString = "";
        if (this.relativePath == null || this.relativePath.isEmpty()) {
            return "";
        }
        try {
            if (this.saveOption.equals((Object)ManagerEnums.PathSaveOption.FULL)) {
                fullPathString = this.relativePath;
            } else if (this.saveOption.equals((Object)ManagerEnums.PathSaveOption.PROJECT)) {
                Path fullPath = FileSystems.getDefault().getPath(String.valueOf(this.projectPath) + "\\" + this.relativePath, new String[0]);
                fullPathString = fullPath.normalize().toString();
            } else if (this.saveOption.equals((Object)ManagerEnums.PathSaveOption.WORKSPACE)) {
                Path fullPath = FileSystems.getDefault().getPath(String.valueOf(this.workspacePath) + "\\" + this.relativePath, new String[0]);
                fullPathString = fullPath.normalize().toString();
            }
        }
        catch (Exception e) {
            return "";
        }
        return fullPathString;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof PathDetails)) {
            return false;
        }
        PathDetails other = (PathDetails)arg0;
        return this.getFullPath().equals(other.getFullPath());
    }

    @Override
    public int compareTo(PathDetails other) {
        return this.getRelativePath().compareToIgnoreCase(other.getRelativePath());
    }
}

