/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.BoardDescriptionTable;

public class PlatformIdTable
extends BoardDescriptionTable {
    private static long PLATFORM_ID_ENABLED = 0xFFFFFFFEL;
    private static long PLATFORM_ID_DISABLED = 0xFFFFFFFFL;
    public static final int BDT_TYPE = 6;
    private boolean isEnablePlatformId = false;
    private long platformId = PLATFORM_ID_DISABLED;

    public boolean isEnablePlatformId() {
        return this.isEnablePlatformId;
    }

    public void setEnablePlatformId(boolean isEnablePlatformId) {
        this.isEnablePlatformId = isEnablePlatformId;
        this.platformId = isEnablePlatformId ? PLATFORM_ID_ENABLED : PLATFORM_ID_DISABLED;
    }

    public String getCurrentPlatformIdString() {
        return String.format("%1$02X", (int)this.platformId);
    }

    public String getPlatformIdString(boolean isEnabled) {
        String ret = isEnabled ? String.format("%1$02X", (int)PLATFORM_ID_ENABLED) : String.format("%1$02X", (int)PLATFORM_ID_DISABLED);
        return ret;
    }

    public PlatformIdTable() {
        this.setType(6);
    }

    public PlatformIdTable(BinReader reader, Element payloadXmlNode) {
        this.setType(6);
        this.platformId = reader.readNewHexField((String)"PlatformId", (int)4, (boolean)false, (Node)payloadXmlNode).longValue;
        this.isEnablePlatformId = this.platformId != PLATFORM_ID_DISABLED;
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        writer.writeNewField("Type", 1, this.getType(), (Node)parent);
        Common.Field lengthField = writer.writeNewField("Length", 2, 0, (Node)parent);
        writer.addSizeCounter(lengthField);
        writer.writeNewField("PlatformId", 4, this.platformId, (Node)parent);
        writer.removeSizeCounter(lengthField);
    }
}

