/*
 * Decompiled with CFR 0.152.
 */
package manager.project;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import manager.app.AppData;
import manager.app.ISSApps;
import manager.common.BuildSetting;
import manager.common.PathDetails;
import manager.configure.Firmware;
import manager.configure.Platform;
import manager.project.ProjectModificationTracker;
import manager.sensor.Sensor;
import manager.sensor.SensorDataWrapper;
import manager.utils.ManagerConfigs;
import manager.utils.ManagerEnums;
import manager.utils.ManagerFileUtils;
import manager.utils.ManagerUtils;
import manager.utils.ManagerXMLUtils;
import manager.utils.log.LogManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ISSProjectData {
    private ArrayList<PathDetails> additionalIncludePaths;
    private ArrayList<PathDetails> additionalObjectPaths;
    private TreeMap<String, String> additionalSymbols;
    private Boolean alwaysResetEmulauncher;
    private Boolean toLoadInstalledSensors;
    private Boolean adjuseEmuSettings;
    private Boolean useCommandForAllVersions;
    private Boolean runCommandOnlyOnce;
    private ArrayList<SensorDataWrapper> availableSensors;
    private PathDetails buildScriptPath;
    private ManagerEnums.CompilationMode compilationMode;
    private ManagerEnums.ConnectionType connectionType;
    private ManagerEnums.ExecutionEnvironments environment;
    private HashMap<ManagerEnums.OutputFileType, PathDetails> outputPaths;
    private ManagerEnums.PdtMode pdtMode;
    private Platform platform;
    private HashMap<Platform, String> postBuildCommands;
    private String projectPath;
    private String userProjectLocation;
    private String buildScriptArgs;
    private String IPAddress;
    private String projectName;
    private String projectDescription;
    private String alignedWithFwVersion;
    private String compilationFlags;
    private String searchText;
    private String copyRightNotice;
    private String debugPort;
    private String pdtName;
    private String fdkVersion;
    private int oemProjectVersion;
    private ProjectModificationTracker ProjectModificationTracker;
    private ManagerEnums.ProjectType projectType;
    private ArrayList<Sensor> selectedSensors;
    private HashMap<Platform, Boolean> batchBuildOptions;
    private BuildSetting buildSetting;
    private ISSApps apps;

    public ISSProjectData(String projectName, String projectDescription, Boolean alwaysResetEmulauncher, Boolean toLoadInstalledSensors, Platform platform, ManagerEnums.ExecutionEnvironments environment, Boolean adjuseEmuSettings, String alignedWithFwVersion, ArrayList<PathDetails> additionalIncludePaths, TreeMap<String, String> additionalSymbols, ArrayList<PathDetails> additionalObjectPaths, ManagerEnums.PdtMode pdtMode, String pdtName, ManagerEnums.CompilationMode compilationMode, String compilationFlags, String searchText, String copyRightNotice, String debugPort, int oemProjectVersion, HashMap<Platform, String> postBuildCommands, boolean useCommandForAllVersions, boolean runCommandOnlyOnce, ManagerEnums.ConnectionType connectionType, String ipAddress, ManagerEnums.ProjectType projectType, PathDetails buildScriptPath, String buildArgs, HashMap<ManagerEnums.OutputFileType, PathDetails> outputPaths, String projectPath, String fdkVersion, HashMap<Platform, Boolean> batchBuildOpt, BuildSetting buildSetting, ISSApps apps) {
        this.projectName = projectName;
        this.projectDescription = projectDescription;
        this.alwaysResetEmulauncher = alwaysResetEmulauncher;
        this.toLoadInstalledSensors = toLoadInstalledSensors;
        this.platform = platform;
        this.environment = environment;
        this.adjuseEmuSettings = adjuseEmuSettings;
        this.alignedWithFwVersion = alignedWithFwVersion;
        this.additionalIncludePaths = additionalIncludePaths;
        this.additionalObjectPaths = additionalObjectPaths;
        this.additionalSymbols = additionalSymbols;
        this.pdtMode = pdtMode;
        this.pdtName = pdtName;
        this.compilationMode = compilationMode;
        this.compilationFlags = compilationFlags;
        this.searchText = searchText;
        this.copyRightNotice = copyRightNotice;
        this.debugPort = debugPort;
        this.oemProjectVersion = oemProjectVersion;
        this.postBuildCommands = new HashMap();
        if (postBuildCommands != null) {
            this.postBuildCommands.putAll(postBuildCommands);
        }
        for (Platform plat : ManagerConfigs.getPlatforms()) {
            if (plat.isDeprecated() || this.postBuildCommands.get(plat) != null) continue;
            this.postBuildCommands.put(plat, "");
        }
        this.useCommandForAllVersions = useCommandForAllVersions;
        this.runCommandOnlyOnce = runCommandOnlyOnce;
        this.connectionType = connectionType;
        this.IPAddress = ipAddress;
        this.projectType = projectType;
        this.buildScriptArgs = buildArgs;
        this.buildScriptPath = buildScriptPath;
        this.outputPaths = outputPaths;
        this.projectPath = projectPath;
        this.fdkVersion = fdkVersion;
        this.buildSetting = buildSetting;
        if (this.projectType == ManagerEnums.ProjectType.FDK) {
            this.initProjectModificationTracker();
        }
        this.apps = this.apps == null ? new ISSApps() : apps;
        this.setBatchBuildOptions(batchBuildOpt);
    }

    public void addAvailableSensor(SensorDataWrapper sensor) {
        if (this.availableSensors.contains(sensor)) {
            this.availableSensors.set(this.availableSensors.lastIndexOf(sensor), sensor);
            return;
        }
        this.availableSensors.add(sensor);
    }

    public void addSelectedSensor(Sensor sensor) {
        this.ProjectModificationTracker.reportModification();
        if (this.selectedSensors.contains(sensor)) {
            this.selectedSensors.set(this.selectedSensors.lastIndexOf(sensor), sensor);
            return;
        }
        this.selectedSensors.add(sensor);
    }

    public ArrayList<PathDetails> getAdditionalIncludePaths() {
        return this.additionalIncludePaths;
    }

    public ArrayList<PathDetails> getAdditionalObjectPaths() {
        return this.additionalObjectPaths;
    }

    public TreeMap<String, String> getAdditionalSymbols() {
        return this.additionalSymbols;
    }

    public Boolean getAdjustEmuSettings() {
        return this.adjuseEmuSettings;
    }

    public String getAlignedWithFwVersion() {
        return this.alignedWithFwVersion;
    }

    public Boolean getAlwaysResetEmulauncher() {
        return this.alwaysResetEmulauncher;
    }

    public ArrayList<SensorDataWrapper> getAvailableSensors() {
        return this.availableSensors;
    }

    public String getBuildScriptArgs(boolean realPaths) {
        String realBuildScriptArgs = this.buildScriptArgs;
        if (realPaths) {
            try {
                realBuildScriptArgs = ManagerUtils.replaceVarsInPath(realBuildScriptArgs, this.platform);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (realBuildScriptArgs != null) {
            return realBuildScriptArgs;
        }
        return "";
    }

    public PathDetails getBuildScriptPath(boolean realPath) {
        PathDetails realBuildScriptPath = new PathDetails(this.buildScriptPath);
        if (realPath) {
            try {
                realBuildScriptPath.setRelativePath(ManagerUtils.replaceVarsInPath(realBuildScriptPath.getRelativePath(), this.platform));
            }
            catch (Exception e) {
                return this.buildScriptPath;
            }
        }
        return realBuildScriptPath;
    }

    public String getCompilationFlags() {
        return this.compilationFlags;
    }

    public ManagerEnums.CompilationMode getCompilationMode(ManagerEnums.BuildReason reason) {
        if (reason == ManagerEnums.BuildReason.EXPORT || reason == ManagerEnums.BuildReason.INSTALL || reason == ManagerEnums.BuildReason.BATCH_INSTALL || reason == ManagerEnums.BuildReason.BATCH_EXPORT) {
            return ManagerEnums.CompilationMode.Release;
        }
        return this.compilationMode;
    }

    public ManagerEnums.ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public String getCopyRightNotice() {
        return this.copyRightNotice;
    }

    public String getDebugPort() {
        return this.debugPort;
    }

    public ManagerEnums.ExecutionEnvironments getEnvironment() {
        return this.environment;
    }

    public ArrayList<SensorDataWrapper> getInstalledAvailableSensors() {
        ArrayList<SensorDataWrapper> installedSensors = new ArrayList<SensorDataWrapper>();
        for (SensorDataWrapper sensor : this.getAvailableSensors()) {
            if (sensor.getOwner() == ManagerEnums.ComponentOwner.USER) continue;
            installedSensors.add(sensor);
        }
        return installedSensors;
    }

    public ArrayList<SensorDataWrapper> getIntelAvailableSensors() {
        ArrayList<SensorDataWrapper> intelSensors = new ArrayList<SensorDataWrapper>();
        for (SensorDataWrapper sensor : this.getAvailableSensors()) {
            if (sensor.getOwner() != ManagerEnums.ComponentOwner.INTEL) continue;
            intelSensors.add(sensor);
        }
        return intelSensors;
    }

    public ArrayList<SensorDataWrapper> getUserAvailableSensors() {
        ArrayList<SensorDataWrapper> userSensors = new ArrayList<SensorDataWrapper>();
        for (SensorDataWrapper sensor : this.getAvailableSensors()) {
            if (sensor.getOwner() != ManagerEnums.ComponentOwner.USER) continue;
            userSensors.add(sensor);
        }
        return userSensors;
    }

    public String getIPAddress() {
        return this.IPAddress;
    }

    public int getOemProjectVersion() {
        return this.oemProjectVersion;
    }

    public HashMap<ManagerEnums.OutputFileType, PathDetails> getOutputPaths() {
        return this.outputPaths;
    }

    public ManagerEnums.PdtMode getPdtMode() {
        return this.pdtMode;
    }

    public String getPdtName() {
        return this.pdtName;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public HashMap<Platform, String> getPostBuildCommands() {
        return this.postBuildCommands;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public ManagerEnums.ProjectType getProjectType() {
        return this.projectType;
    }

    public boolean getRunCommandOnlyOnce() {
        return this.runCommandOnlyOnce;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public ArrayList<Sensor> getSelectedSensors() {
        return this.selectedSensors;
    }

    public ArrayList<SensorDataWrapper> getThirdPartyAvailableSensors() {
        ArrayList<SensorDataWrapper> thirdPartySensors = new ArrayList<SensorDataWrapper>();
        for (SensorDataWrapper sensor : this.getAvailableSensors()) {
            if (sensor.getOwner() != ManagerEnums.ComponentOwner.THIRD_PARTY) continue;
            thirdPartySensors.add(sensor);
        }
        return thirdPartySensors;
    }

    public Boolean getToLoadInstalledSensors() {
        return this.toLoadInstalledSensors;
    }

    public ArrayList<SensorDataWrapper> getUnselectedSensors() {
        ArrayList<SensorDataWrapper> unselectedSensors = new ArrayList<SensorDataWrapper>();
        for (SensorDataWrapper wrapper : this.getAvailableSensors()) {
            boolean selected = false;
            for (Sensor selectedSensor : this.getSelectedSensors()) {
                if (!selectedSensor.getSensorData().equals(wrapper)) continue;
                selected = true;
                break;
            }
            if (selected) continue;
            unselectedSensors.add(wrapper);
        }
        return unselectedSensors;
    }

    public boolean getUseCommandForAllVersions() {
        return this.useCommandForAllVersions;
    }

    public String getUserProjectLocation() {
        return this.userProjectLocation;
    }

    public ArrayList<Sensor> getUserSelectedSensors() {
        ArrayList<Sensor> userSensors = new ArrayList<Sensor>();
        for (Sensor sensor : this.getSelectedSensors()) {
            if (sensor.getSensorData().getOwner() != ManagerEnums.ComponentOwner.USER) continue;
            userSensors.add(sensor);
        }
        return userSensors;
    }

    public void initLists() {
        this.availableSensors = new ArrayList();
        this.selectedSensors = new ArrayList();
        this.apps = new ISSApps();
    }

    public void removeAllAvailableSensors() {
        this.availableSensors.clear();
    }

    public void removeAllSelectedSensors() {
        this.ProjectModificationTracker.reportModification();
        this.selectedSensors.clear();
    }

    public void removeAvailableSensor(SensorDataWrapper sensor) {
        this.availableSensors.remove(sensor);
    }

    public void removeSelectedSensor(Sensor sensor) {
        this.ProjectModificationTracker.reportModification();
        this.selectedSensors.remove(sensor);
    }

    public void setAdditionalIncludePaths(ArrayList<PathDetails> includePaths) {
        this.additionalIncludePaths.clear();
        this.additionalIncludePaths.addAll(includePaths);
    }

    public void setAdditionalObjectPaths(ArrayList<PathDetails> objectPaths) {
        this.additionalObjectPaths.clear();
        this.additionalObjectPaths.addAll(objectPaths);
    }

    public void setAdditionalSymbols(Map<String, String> additionalSymbols) {
        this.additionalSymbols.clear();
        this.additionalSymbols.putAll(additionalSymbols);
    }

    public void setAdjustEmuSettings(Boolean adjuseEmuSettings) {
        this.adjuseEmuSettings = adjuseEmuSettings;
    }

    public void setAlignedWithFwVersion(String alignedWithFwVersion) {
        this.alignedWithFwVersion = alignedWithFwVersion;
    }

    public void setAlwaysResetEmulauncher(Boolean alwaysResetEmulauncher) {
        this.alwaysResetEmulauncher = alwaysResetEmulauncher;
    }

    public void setAvailableSensors(ArrayList<SensorDataWrapper> availableSensors) {
        this.availableSensors = availableSensors;
    }

    public void setBuildScriptArgs(String buildArgs) {
        this.buildScriptArgs = buildArgs;
    }

    public void setBuildScriptPath(PathDetails buildScriptPath) {
        this.buildScriptPath = buildScriptPath;
    }

    public void setCompilationFlags(String compilationFlags) {
        this.compilationFlags = compilationFlags;
    }

    public void setCompilationMode(ManagerEnums.CompilationMode currConf, ManagerEnums.CompilationMode newConf) {
        this.compilationMode = newConf;
        if (this.getProjectType() == ManagerEnums.ProjectType.FDK) {
            ManagerEnums.OutputFileType[] outputFileTypeArray = ManagerEnums.OutputFileType.values();
            int n = outputFileTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PathDetails pd;
                ManagerEnums.OutputFileType outputType = outputFileTypeArray[n2];
                if ((outputType == ManagerEnums.OutputFileType.IMAGE || outputType == ManagerEnums.OutputFileType.IMAGE_COMPRESSED || outputType == ManagerEnums.OutputFileType.ELF || outputType == ManagerEnums.OutputFileType.MAP) && (pd = this.getOutputPaths().get((Object)outputType)) != null) {
                    String fullPath = ManagerUtils.replaceLast(pd.getFullPath(), "\\" + (Object)((Object)currConf) + "\\", "\\" + (Object)((Object)newConf) + "\\");
                    pd.updateRelativePath(fullPath);
                }
                ++n2;
            }
        }
    }

    public void setConnectionType(ManagerEnums.ConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public void setCopyRightNotice(String copyRightNotice) {
        this.copyRightNotice = copyRightNotice;
    }

    public void setDebugPort(String debugPort) {
        this.debugPort = debugPort;
    }

    public void setEnvironment(ManagerEnums.ExecutionEnvironments environment) {
        this.environment = environment;
    }

    public void setIPAddress(String IPAddress) {
        this.IPAddress = IPAddress;
    }

    public void setOemProjectVersion(int oemVer) {
        this.oemProjectVersion = oemVer;
    }

    public void setOutputPaths(HashMap<ManagerEnums.OutputFileType, PathDetails> outputPaths) {
        this.outputPaths = outputPaths;
    }

    public void setPdtMode(ManagerEnums.PdtMode pdtMode) {
        this.pdtMode = pdtMode;
    }

    public void setPdtName(String pdtName) {
        this.pdtName = pdtName;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public void setPostBuildCommands(HashMap<Platform, String> postBuildCommands) {
        this.postBuildCommands = new HashMap();
        this.postBuildCommands.putAll(postBuildCommands);
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setProjectType(ManagerEnums.ProjectType projectType) {
        this.projectType = projectType;
    }

    public void setRunCommandOnlyOnce(boolean runCommandOnlyOnce) {
        this.runCommandOnlyOnce = runCommandOnlyOnce;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public void setSelectedSensors(ArrayList<Sensor> selectedSensors) {
        this.selectedSensors = selectedSensors;
    }

    public void setToLoadInstalledSensors(Boolean toLoadInstalledSensors) {
        this.toLoadInstalledSensors = toLoadInstalledSensors;
    }

    public void setUseCommandForAllVersions(boolean useCommandForAllVersions) {
        this.useCommandForAllVersions = useCommandForAllVersions;
    }

    public void setUserProjectLocation(String userProjectLocation) {
        this.userProjectLocation = userProjectLocation;
    }

    public String getFdkVersion() {
        return this.fdkVersion;
    }

    public void setFdkVersion(String fdkVersion) {
        this.fdkVersion = fdkVersion;
    }

    public static ISSProjectData getProjectDataFromXml(String ProjectSettingsFilePath, String projectPath, String workspacePath) throws Exception {
        try {
            Node buildScriptArgsNode;
            Node runCommandOnlyOnceNode;
            Node useCommandForAllVersionsNode;
            Node compilationFlagsNode;
            ManagerEnums.CompilationMode compMode;
            Node buildConfNode;
            Document doc = ManagerXMLUtils.getXMLDocument(new File(ProjectSettingsFilePath));
            String projectName = doc.getElementsByTagName("ProjectName").item(0).getTextContent();
            String projectDescription = doc.getElementsByTagName("ProjectDescription").item(0).getTextContent();
            String copyRightNotice = "/*\n\n*/";
            try {
                copyRightNotice = doc.getElementsByTagName("CopyRightNotice").item(0).getTextContent();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Boolean alwaysResetEmulauncher = Boolean.parseBoolean(doc.getElementsByTagName("AlwaysResetEmulauncher").item(0).getTextContent());
            Node loadInstalledNode = doc.getElementsByTagName("LoadInstalledSensors").item(0);
            Boolean loadInstalledSensors = loadInstalledNode == null ? Boolean.valueOf(Boolean.parseBoolean(doc.getElementsByTagName("LoadIntelSensors").item(0).getTextContent())) : Boolean.valueOf(Boolean.parseBoolean(loadInstalledNode.getTextContent()));
            Boolean adjustEmuSettings = Boolean.parseBoolean(doc.getElementsByTagName("AdjustEmulauncherSettings").item(0).getTextContent());
            String fdkVerison = "Unknown";
            Node fdkVersionNode = doc.getElementsByTagName("FDKVersion").item(0);
            if (fdkVersionNode != null) {
                fdkVerison = fdkVersionNode.getTextContent();
            }
            Platform platform = ISSProjectData.parsePlatform(doc);
            ManagerEnums.ExecutionEnvironments environment = ISSProjectData.parseEnvironment(doc);
            String fwVersion = "";
            Node versionNode = doc.getElementsByTagName("AlignedWithFwVersion").item(0);
            if (versionNode != null) {
                fwVersion = versionNode.getTextContent();
            }
            ArrayList<PathDetails> additionalObjectPaths = ISSProjectData.parseObjectPath(doc, projectPath, workspacePath);
            ArrayList<PathDetails> additionalIncludePaths = ISSProjectData.parseIncludePaths(doc, projectPath, workspacePath);
            TreeMap<String, String> symbols = new TreeMap<String, String>();
            NodeList symbolsList = doc.getElementsByTagName("Symbol");
            int i = 0;
            while (i < symbolsList.getLength()) {
                NamedNodeMap symbolAttributes = symbolsList.item(i).getAttributes();
                String sName = symbolAttributes.getNamedItem("Name").getNodeValue();
                if (sName.equals("VER_FDK")) {
                    try {
                        symbols.put("VER_FDK", ManagerUtils.getDefaultBuildFdkVersion());
                    }
                    catch (Exception e) {
                        symbols.put("VER_FDK", symbolAttributes.getNamedItem("Value").getNodeValue());
                    }
                } else {
                    symbols.put(symbolAttributes.getNamedItem("Name").getNodeValue(), symbolAttributes.getNamedItem("Value").getNodeValue());
                }
                ++i;
            }
            ManagerEnums.PdtMode pdtMode = ISSProjectData.parsePDTMode(doc);
            String defalutPdtName = String.valueOf(platform.getName()) + "_PDT";
            String pdtName = ISSProjectData.parsePdtName(doc, defalutPdtName);
            if (pdtMode == ManagerEnums.PdtMode.Platform && !pdtName.equals(defalutPdtName)) {
                pdtMode = ManagerEnums.PdtMode.Manual;
            }
            if ((buildConfNode = doc.getElementsByTagName("BuildConfiguration").item(0)) == null) {
                compMode = ManagerEnums.CompilationMode.Debug;
            } else {
                String buildConfString = buildConfNode.getTextContent();
                compMode = ManagerEnums.CompilationMode.getValueByName(buildConfString);
            }
            if (compMode == null) {
                compMode = ManagerEnums.CompilationMode.Debug;
            }
            String compilationFlags = (compilationFlagsNode = doc.getElementsByTagName("CompilationFlags").item(0)) == null ? "" : compilationFlagsNode.getTextContent();
            Node searchTextNode = doc.getElementsByTagName("SearchText").item(0);
            String searchText = searchTextNode == null ? "" : searchTextNode.getTextContent();
            String debugPort = "9998";
            Node debugPortNode = doc.getElementsByTagName("DebugPort").item(0);
            if (debugPortNode != null) {
                debugPort = debugPortNode.getTextContent();
            }
            int oemVer = 1;
            Node oemProjectVersionNode = doc.getElementsByTagName("OemProjectVersion").item(0);
            if (oemProjectVersionNode != null) {
                oemVer = Integer.parseInt(oemProjectVersionNode.getTextContent());
            }
            boolean useCommandForAllVersions = false;
            boolean runCommandOnlyOnce = false;
            HashMap<Platform, String> postBuildCommands = new HashMap<Platform, String>();
            HashMap<Platform, Boolean> batchBuildOpt = new HashMap<Platform, Boolean>();
            Element platformConfigurationsElement = (Element)doc.getElementsByTagName("PlatformConfigurations").item(0);
            if (platformConfigurationsElement != null) {
                Node batchBuildNode;
                Node postBuildCommandNode;
                for (Platform plat : ManagerConfigs.getPlatforms()) {
                    Node batchBuildNode2;
                    Element platformNode;
                    if (plat.isDeprecated() || (platformNode = (Element)platformConfigurationsElement.getElementsByTagName(plat.getName()).item(0)) == null) continue;
                    Node postBuildCommandNode2 = platformNode.getElementsByTagName("PostBuildCommand").item(0);
                    if (postBuildCommandNode2 != null) {
                        postBuildCommands.put(plat, postBuildCommandNode2.getTextContent());
                    }
                    if ((batchBuildNode2 = platformNode.getElementsByTagName("BatchBuild").item(0)) == null) continue;
                    batchBuildOpt.put(plat, Boolean.parseBoolean(batchBuildNode2.getTextContent()));
                }
                Element platformNode = (Element)platformConfigurationsElement.getElementsByTagName("SPT_RS1").item(0);
                if (platformNode != null) {
                    postBuildCommandNode = platformNode.getElementsByTagName("PostBuildCommand").item(0);
                    if (postBuildCommandNode != null) {
                        postBuildCommands.put(ManagerUtils.getPlatformFromString("SKL"), postBuildCommandNode.getTextContent());
                        postBuildCommands.put(ManagerUtils.getPlatformFromString("KBL"), postBuildCommandNode.getTextContent());
                    }
                    if ((batchBuildNode = platformNode.getElementsByTagName("BatchBuild").item(0)) != null) {
                        batchBuildOpt.put(ManagerUtils.getPlatformFromString("SKL"), Boolean.parseBoolean(batchBuildNode.getTextContent()));
                        batchBuildOpt.put(ManagerUtils.getPlatformFromString("KBL"), Boolean.parseBoolean(batchBuildNode.getTextContent()));
                    }
                }
                if ((platformNode = (Element)platformConfigurationsElement.getElementsByTagName("BXT_RS1").item(0)) != null) {
                    postBuildCommandNode = platformNode.getElementsByTagName("PostBuildCommand").item(0);
                    if (postBuildCommandNode != null) {
                        postBuildCommands.put(ManagerUtils.getPlatformFromString("BXT"), postBuildCommandNode.getTextContent());
                        postBuildCommands.put(ManagerUtils.getPlatformFromString("GLK"), postBuildCommandNode.getTextContent());
                    }
                    if ((batchBuildNode = platformNode.getElementsByTagName("BatchBuild").item(0)) != null) {
                        batchBuildOpt.put(ManagerUtils.getPlatformFromString("BXT"), Boolean.parseBoolean(batchBuildNode.getTextContent()));
                        batchBuildOpt.put(ManagerUtils.getPlatformFromString("GLK"), Boolean.parseBoolean(batchBuildNode.getTextContent()));
                    }
                }
            }
            if ((useCommandForAllVersionsNode = doc.getElementsByTagName("UseCommandForAllVersions").item(0)) != null) {
                useCommandForAllVersions = Boolean.parseBoolean(useCommandForAllVersionsNode.getTextContent());
            }
            if ((runCommandOnlyOnceNode = doc.getElementsByTagName("RunCommandOnlyOnce").item(0)) != null) {
                runCommandOnlyOnce = Boolean.parseBoolean(runCommandOnlyOnceNode.getTextContent());
            }
            ManagerEnums.ConnectionType connType = ManagerEnums.ConnectionType.NETWORK;
            Node connTypeNode = doc.getElementsByTagName("ConnectionType").item(0);
            if (connTypeNode != null) {
                connType = ManagerEnums.ConnectionType.getValueByName(connTypeNode.getTextContent());
            }
            String ip = "";
            Node ipNode = doc.getElementsByTagName("IPAddress").item(0);
            if (ipNode != null) {
                ip = ipNode.getTextContent();
            }
            ManagerEnums.ProjectType projectType = ManagerEnums.ProjectType.FDK;
            Node projectTypeNode = doc.getElementsByTagName("ProjectType").item(0);
            if (projectTypeNode != null) {
                projectType = ManagerEnums.ProjectType.getValueByFriendlyName(projectTypeNode.getTextContent());
            }
            String buildScriptArgs = "";
            if (projectType == ManagerEnums.ProjectType.USER && (buildScriptArgsNode = doc.getElementsByTagName("BuildScriptArgs").item(0)) != null) {
                buildScriptArgs = buildScriptArgsNode.getTextContent();
            }
            PathDetails buildScriptPath = null;
            Node buildScriptPathNode = doc.getElementsByTagName("BuildScriptPath").item(0);
            if (buildScriptPathNode == null) {
                buildScriptPath = new PathDetails(ManagerFileUtils.getImageBuilderBatPath(false), ManagerEnums.PathSaveOption.FULL, projectPath, workspacePath);
            } else {
                ManagerEnums.PathSaveOption option = ManagerEnums.PathSaveOption.getSaveOptionByValue(Integer.valueOf(((Element)buildScriptPathNode).getElementsByTagName("SaveOption").item(0).getTextContent()));
                String path = ((Element)buildScriptPathNode).getElementsByTagName("Path").item(0).getTextContent();
                buildScriptPath = new PathDetails(path, option, projectType == ManagerEnums.ProjectType.FDK ? projectPath : null, workspacePath);
            }
            BuildSetting buildConfig = ISSProjectData.parseBuildSetting(doc, platform);
            HashMap<ManagerEnums.OutputFileType, PathDetails> outputPaths = ISSProjectData.parseOutputPath(doc, platform, compMode, projectPath, workspacePath, projectType, pdtMode);
            ISSApps apps = new ISSApps();
            ISSProjectData pData = new ISSProjectData(projectName, projectDescription, alwaysResetEmulauncher, loadInstalledSensors, platform, environment, adjustEmuSettings, fwVersion, additionalIncludePaths, symbols, additionalObjectPaths, pdtMode, pdtName, compMode, compilationFlags, searchText, copyRightNotice, debugPort, oemVer, postBuildCommands, useCommandForAllVersions, runCommandOnlyOnce, connType, ip, projectType, buildScriptPath, buildScriptArgs, outputPaths, null, fdkVerison, batchBuildOpt, buildConfig, apps);
            return pData;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Could not load the project data.\n  " + (e != null && e.getMessage() != null ? "Exception: " + e.getMessage().replaceAll("\n  ", "\n    ") : ""));
        }
    }

    public static void saveProjectData(ISSProjectData projectData, String pluginVersion) throws Exception {
        try {
            ArrayList<PathDetails> objectPaths;
            Document doc = ManagerXMLUtils.getNewDocument();
            Element rootElement = doc.createElement("ISSProjectSettings");
            doc.appendChild(rootElement);
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "ProjectName", projectData.getProjectName()));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "ProjectDescription", projectData.getProjectDescription()));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "CopyRightNotice", projectData.getCopyRightNotice()));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "Platform", projectData.getPlatform().getName()));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "ISSVersion", projectData.getPlatform().getIssVersion()));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "FDKVersion", projectData.getFdkVersion()));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "AlignedWithFwVersion", projectData.getAlignedWithFwVersion()));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "PluginVersion", pluginVersion));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "ExecutionEnvironment", projectData.getEnvironment().name()));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "AlwaysResetEmulauncher", Boolean.toString(projectData.getAlwaysResetEmulauncher())));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "LoadInstalledSensors", Boolean.toString(projectData.getToLoadInstalledSensors())));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "SearchText", projectData.getSearchText()));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "DebugPort", projectData.getDebugPort()));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "OemProjectVersion", Integer.toString(projectData.getOemProjectVersion())));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "AdjustEmulauncherSettings", Boolean.toString(projectData.getAdjustEmuSettings())));
            ArrayList<PathDetails> includePaths = projectData.getAdditionalIncludePaths();
            if (includePaths != null && includePaths.size() != 0) {
                Element includesElement = doc.createElement("AdditionalIncludePaths");
                for (PathDetails pathDetails : includePaths) {
                    Element includeElement = doc.createElement("IncludePath");
                    includeElement.appendChild(ManagerXMLUtils.createTextNode(doc, "Path", pathDetails.getRelativePath()));
                    includeElement.appendChild(ManagerXMLUtils.createTextNode(doc, "SaveOption", String.valueOf(pathDetails.getSaveOption().getValue())));
                    includesElement.appendChild(includeElement);
                }
                rootElement.appendChild(includesElement);
            }
            if ((objectPaths = projectData.getAdditionalObjectPaths()) != null && objectPaths.size() != 0) {
                Element objectsElement = doc.createElement("AdditionalObjectPaths");
                for (PathDetails pathDetails : objectPaths) {
                    Element objectElement = doc.createElement("ObjectPath");
                    objectElement.appendChild(ManagerXMLUtils.createTextNode(doc, "Path", pathDetails.getRelativePath()));
                    objectElement.appendChild(ManagerXMLUtils.createTextNode(doc, "SaveOption", String.valueOf(pathDetails.getSaveOption().getValue())));
                    objectsElement.appendChild(objectElement);
                }
                rootElement.appendChild(objectsElement);
            }
            TreeMap<String, String> symbols = new TreeMap<String, String>();
            if (projectData.getAdditionalSymbols() != null) {
                symbols.putAll(projectData.getAdditionalSymbols());
            }
            symbols.put("VER_FDK", ManagerUtils.getDefaultBuildFdkVersion());
            if (symbols != null && symbols.values().size() != 0) {
                Element symbolsElement = doc.createElement("AdditionalSymbols");
                for (String key : symbols.keySet()) {
                    Element symbol = doc.createElement("Symbol");
                    symbol.setAttribute("Name", key);
                    symbol.setAttribute("Value", (String)symbols.get(key));
                    symbolsElement.appendChild(symbol);
                }
                rootElement.appendChild(symbolsElement);
            }
            ManagerEnums.PdtMode pdtMode = projectData.getPdtMode() == null ? ManagerEnums.PdtMode.Manual : projectData.getPdtMode();
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "PdtMode", pdtMode.name()));
            String pdtName = projectData.getPdtName() == null ? "PDT" : projectData.getPdtName();
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "PdtName", pdtName));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "BuildConfiguration", projectData.getCompilationMode(null).name()));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "CompilationFlags", projectData.getCompilationFlags()));
            Element platformConfigurationsElement = doc.createElement("PlatformConfigurations");
            rootElement.appendChild(platformConfigurationsElement);
            for (Platform plat : ManagerConfigs.getPlatforms()) {
                HashMap<Platform, Boolean> bbopt;
                if (plat.isDeprecated()) continue;
                Element platformNode = doc.createElement(plat.getName());
                platformConfigurationsElement.appendChild(platformNode);
                if (projectData.getPostBuildCommands() != null && projectData.getPostBuildCommands().get(plat) != null) {
                    platformNode.appendChild(ManagerXMLUtils.createTextNode(doc, "PostBuildCommand", projectData.getPostBuildCommands().get(plat)));
                }
                if ((bbopt = projectData.getBatchBuildOptions()) == null || bbopt.get(plat) == null) continue;
                String opt = bbopt.get(plat).toString();
                Element bbNode = ManagerXMLUtils.createTextNode(doc, "BatchBuild", opt);
                platformNode.appendChild(bbNode);
            }
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "UseCommandForAllVersions", Boolean.toString(projectData.getUseCommandForAllVersions())));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "RunCommandOnlyOnce", Boolean.toString(projectData.getRunCommandOnlyOnce())));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "ConnectionType", projectData.getConnectionType().name()));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "IPAddress", projectData.getIPAddress()));
            rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "ProjectType", projectData.getProjectType().getFriendlyName()));
            Element buildScriptPathElement = doc.createElement("BuildScriptPath");
            buildScriptPathElement.appendChild(ManagerXMLUtils.createTextNode(doc, "Path", projectData.getBuildScriptPath(false).getRelativePath()));
            buildScriptPathElement.appendChild(ManagerXMLUtils.createTextNode(doc, "SaveOption", String.valueOf(projectData.getBuildScriptPath(false).getSaveOption().getValue())));
            rootElement.appendChild(buildScriptPathElement);
            if (projectData.getProjectType() == ManagerEnums.ProjectType.USER) {
                rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "BuildScriptArgs", projectData.getBuildScriptArgs(false)));
            }
            projectData.updateFirmware(projectData.getPlatform());
            Element bcElement = doc.createElement("BuildSetting");
            BuildSetting bc = projectData.getBuildSetting();
            if (bc != null) {
                bcElement.appendChild(ManagerXMLUtils.createTextNode(doc, "FullBuild", Boolean.toString(bc.isFullBuild())));
                bcElement.appendChild(ManagerXMLUtils.createTextNode(doc, "Firmware", bc.getFirmwareVersion()));
                rootElement.appendChild(bcElement);
            }
            if (projectData.getProjectType() == ManagerEnums.ProjectType.USER) {
                rootElement.appendChild(ManagerXMLUtils.createTextNode(doc, "BuildScriptArgs", projectData.getBuildScriptArgs(false)));
            }
            Element outputPathsElement = doc.createElement("OutputPaths");
            for (ManagerEnums.OutputFileType outputType : projectData.getOutputPaths().keySet()) {
                Element outputPathElement = doc.createElement("OutputPath");
                PathDetails outputPathDetails = projectData.getOutputPaths().get((Object)outputType);
                outputPathElement.appendChild(ManagerXMLUtils.createTextNode(doc, "Path", outputPathDetails == null ? "" : outputPathDetails.getRelativePath()));
                outputPathElement.appendChild(ManagerXMLUtils.createTextNode(doc, "SaveOption", String.valueOf(outputPathDetails == null ? ManagerEnums.PathSaveOption.PROJECT.getValue() : outputPathDetails.getSaveOption().getValue())));
                outputPathElement.appendChild(ManagerXMLUtils.createTextNode(doc, "Type", outputType.name()));
                outputPathsElement.appendChild(outputPathElement);
            }
            rootElement.appendChild(outputPathsElement);
            ManagerXMLUtils.createXMLFile(ManagerFileUtils.getISSProjectSettingsFilePath(projectData), doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Could not create ISSProjectSettings.xml.\n  " + (e != null && e.getMessage() != null ? "Exception: " + e.getMessage().replaceAll("\n  ", "\n    ") : ""));
        }
    }

    private static String parsePdtName(Document doc, String defaultPdtName) {
        String pdtName = defaultPdtName;
        Node pdtNameNode = doc.getElementsByTagName("PdtName").item(0);
        if (pdtNameNode != null) {
            pdtName = pdtNameNode.getTextContent();
        }
        return pdtName;
    }

    private static ManagerEnums.PdtMode parsePDTMode(Document doc) {
        ManagerEnums.PdtMode mode;
        Node pdtModeNode = doc.getElementsByTagName("PdtMode").item(0);
        if (pdtModeNode == null) {
            mode = ManagerEnums.PdtMode.Platform;
        } else {
            try {
                mode = ManagerEnums.PdtMode.getValueByName(pdtModeNode.getTextContent());
            }
            catch (NumberFormatException e) {
                mode = ManagerEnums.PdtMode.Platform;
            }
        }
        return mode;
    }

    private static ArrayList<PathDetails> parseIncludePaths(Document doc, String projPath, String wsPath) {
        ArrayList<PathDetails> additionalIncludePaths = new ArrayList<PathDetails>();
        NodeList includePaths = doc.getElementsByTagName("IncludePath");
        int i = 0;
        while (i < includePaths.getLength()) {
            String path = "";
            ManagerEnums.PathSaveOption option = ManagerEnums.PathSaveOption.FULL;
            Element element = (Element)includePaths.item(i);
            Node pathNode = element.getElementsByTagName("Path").item(0);
            if (pathNode == null) {
                path = includePaths.item(i).getTextContent();
                if (path.startsWith(projPath)) {
                    path = path.substring(projPath.length());
                    option = ManagerEnums.PathSaveOption.PROJECT;
                } else if (path.startsWith(wsPath)) {
                    path = path.substring(wsPath.length());
                    option = ManagerEnums.PathSaveOption.WORKSPACE;
                }
            } else {
                path = pathNode.getTextContent();
                Node optionNode = element.getElementsByTagName("SaveOption").item(0);
                if (optionNode != null) {
                    option = ManagerEnums.PathSaveOption.getSaveOptionByValue(Integer.valueOf(optionNode.getTextContent()));
                }
            }
            additionalIncludePaths.add(new PathDetails(path, option, projPath, wsPath));
            ++i;
        }
        return additionalIncludePaths;
    }

    private static ArrayList<PathDetails> parseObjectPath(Document doc, String projPath, String wsPath) {
        ArrayList<PathDetails> additionalObjectPaths = new ArrayList<PathDetails>();
        NodeList objectPaths = doc.getElementsByTagName("ObjectPath");
        int i = 0;
        while (i < objectPaths.getLength()) {
            String path = "";
            ManagerEnums.PathSaveOption option = ManagerEnums.PathSaveOption.FULL;
            Element objectPathElement = (Element)objectPaths.item(i);
            Node pathNode = objectPathElement.getElementsByTagName("Path").item(0);
            if (pathNode == null) {
                path = objectPaths.item(i).getTextContent();
                if (path.startsWith(projPath)) {
                    path = path.substring(projPath.length());
                    option = ManagerEnums.PathSaveOption.PROJECT;
                } else if (path.startsWith(wsPath)) {
                    path = path.substring(wsPath.length());
                    option = ManagerEnums.PathSaveOption.WORKSPACE;
                }
            } else {
                path = pathNode.getTextContent();
                option = ManagerEnums.PathSaveOption.getSaveOptionByValue(Integer.valueOf(objectPathElement.getElementsByTagName("SaveOption").item(0).getTextContent()));
            }
            additionalObjectPaths.add(new PathDetails(path, option, projPath, wsPath));
            ++i;
        }
        return additionalObjectPaths;
    }

    private static ManagerEnums.ExecutionEnvironments parseEnvironment(Document doc) {
        String galiloMode;
        Node envNode = doc.getElementsByTagName("ExecutionEnvironment").item(0);
        ManagerEnums.ExecutionEnvironments environment = envNode == null ? ((envNode = doc.getElementsByTagName("Environment").item(0)).getTextContent().equals(ManagerEnums.ExecutionEnvironments.SIMICS.toString()) ? ManagerEnums.ExecutionEnvironments.SIMICS : ((galiloMode = doc.getElementsByTagName("GalileoMode").item(0).getTextContent()).equals("FULL") ? ManagerEnums.ExecutionEnvironments.GALILEO_FULL : ManagerEnums.ExecutionEnvironments.GALILEO_LITE)) : ManagerEnums.ExecutionEnvironments.getValueByName(envNode.getTextContent());
        return environment;
    }

    private static HashMap<ManagerEnums.OutputFileType, PathDetails> parseOutputPath(Document doc, Platform plat, ManagerEnums.CompilationMode compMode, String projPath, String wsPath, ManagerEnums.ProjectType projType, ManagerEnums.PdtMode pdtMode) {
        HashMap<ManagerEnums.OutputFileType, PathDetails> ret = new HashMap();
        Node outputPathsNode = doc.getElementsByTagName("OutputPaths").item(0);
        ret = ManagerFileUtils.getDefaultOrEmptyOutputPaths(false, projPath, plat, compMode);
        if (outputPathsNode != null) {
            NodeList pathsList = doc.getElementsByTagName("OutputPath");
            int i = 0;
            while (i < pathsList.getLength()) {
                Element element = (Element)pathsList.item(i);
                String path = element.getElementsByTagName("Path").item(0).getTextContent();
                if (!path.isEmpty()) {
                    PathDetails pathDetails;
                    String optss = element.getElementsByTagName("SaveOption").item(0).getTextContent();
                    String typess = element.getElementsByTagName("Type").item(0).getTextContent();
                    ManagerEnums.PathSaveOption option = ManagerEnums.PathSaveOption.getSaveOptionByValue(Integer.valueOf(optss));
                    ManagerEnums.OutputFileType outputType = ManagerEnums.OutputFileType.getValueByName(typess);
                    if (projType == ManagerEnums.ProjectType.USER) {
                        pathDetails = new PathDetails(path, option, null, wsPath);
                        ret.put(outputType, pathDetails);
                    } else if (projType == ManagerEnums.ProjectType.FDK && pdtMode == ManagerEnums.PdtMode.Manual && (outputType == ManagerEnums.OutputFileType.PDT || outputType == ManagerEnums.OutputFileType.PDT_NVAR)) {
                        pathDetails = new PathDetails(path, option, projPath, wsPath);
                        ret.put(outputType, pathDetails);
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    private static Platform parsePlatform(Document doc) throws Exception {
        NodeList issNodes;
        Platform platform = null;
        NodeList platNodes = doc.getElementsByTagName("Platform");
        if (platNodes != null && platNodes.getLength() > 0) {
            String platStr = platNodes.item(0).getTextContent();
            platform = ManagerConfigs.getPlatformByName(platStr);
        }
        if (platform == null && (issNodes = doc.getElementsByTagName("ISSVersion")) != null && issNodes.getLength() > 0) {
            String issStr = issNodes.item(0).getTextContent();
            platform = ManagerConfigs.getPlatformByIssVersion(issStr);
        }
        if (platform == null) {
            throw new Exception("Invalid platform.");
        }
        return platform;
    }

    private static BuildSetting parseBuildSetting(Document doc, Platform platform) throws Exception {
        Boolean isFullBuild = false;
        String path = "";
        String fwVer = "";
        Node buildConfigNode = doc.getElementsByTagName("BuildSetting").item(0);
        if (buildConfigNode != null) {
            NodeList fwVerNodeList;
            NodeList fbNodeList = ((Element)buildConfigNode).getElementsByTagName("FullBuild");
            if (fbNodeList != null && fbNodeList.getLength() > 0 && ManagerFileUtils.supportFullBuild()) {
                isFullBuild = Boolean.parseBoolean(fbNodeList.item(0).getTextContent());
            }
            if ((fwVerNodeList = ((Element)buildConfigNode).getElementsByTagName("Firmware")) != null && fwVerNodeList.getLength() > 0) {
                fwVer = fwVerNodeList.item(0).getTextContent();
            }
        }
        if (fwVer.isEmpty() || !ManagerConfigs.isFirmwareInstalled(platform, fwVer)) {
            Firmware fw = ManagerConfigs.getDefaultFirmwareVersion(platform);
            if (fw != null) {
                fwVer = fw.getVersion();
            } else if (!platform.isDeprecated()) {
                throw new Exception("No valid firmware installed for platform " + platform.getName());
            }
        }
        path = ManagerFileUtils.getFullBuildFw(platform);
        return new BuildSetting(isFullBuild, path, fwVer);
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        String oldPath = this.projectPath;
        this.projectPath = projectPath;
        if (oldPath == null && this.projectType == ManagerEnums.ProjectType.FDK) {
            this.initProjectModificationTracker();
        }
    }

    public ProjectModificationTracker getProjectModificationTracker() {
        return this.ProjectModificationTracker;
    }

    public void initProjectModificationTracker() {
        try {
            this.ProjectModificationTracker = manager.project.ProjectModificationTracker.deserialize(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.ProjectModificationTracker == null) {
            this.ProjectModificationTracker = new ProjectModificationTracker(this);
        }
    }

    public HashMap<Platform, Boolean> getBatchBuildOptions() {
        return this.batchBuildOptions;
    }

    public void updateBatchBuildOptions(Platform pl, Boolean option) {
        this.batchBuildOptions.put(pl, option);
    }

    public void setBatchBuildOptions(HashMap<Platform, Boolean> batchBuildOpt) {
        this.batchBuildOptions = new HashMap();
        if (batchBuildOpt != null) {
            this.batchBuildOptions.putAll(batchBuildOpt);
        }
        boolean needReset = true;
        for (Platform plat : ManagerConfigs.getPlatforms()) {
            if (plat.isDeprecated()) continue;
            if (this.batchBuildOptions.get(plat) == null) {
                this.batchBuildOptions.put(plat, false);
            }
            if (!this.batchBuildOptions.get(plat).booleanValue()) continue;
            needReset = false;
        }
        if (needReset) {
            for (Platform plat : ManagerConfigs.getPlatforms()) {
                if (plat.isDeprecated()) continue;
                this.batchBuildOptions.put(plat, true);
            }
        }
    }

    public Boolean getBatchBuildOption(Platform plat) {
        if (plat == null) {
            return false;
        }
        if (this.batchBuildOptions == null) {
            return false;
        }
        Boolean ret = this.batchBuildOptions.get(plat);
        return ret != null ? ret : false;
    }

    public boolean isDeprecated() {
        if (this.platform == null) {
            return true;
        }
        if (this.isAlignedFwVersionDeprecated()) {
            return true;
        }
        return this.platform.isDeprecated();
    }

    private boolean isAlignedFwVersionDeprecated() {
        if (this.platform.getName().equals("GALILEO")) {
            try {
                int sv;
                String[] versions = this.alignedWithFwVersion.trim().split("\\.");
                if (versions != null && versions.length >= 3 && (sv = Integer.parseInt(versions[versions.length - 1])) >= 3300) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                LogManager.log("Failed to parse alignedFwVersion: " + this.alignedWithFwVersion);
            }
            return true;
        }
        return false;
    }

    public void updateOutputPaths(Platform newPlat) {
        for (ManagerEnums.OutputFileType fileType : this.outputPaths.keySet()) {
            if (fileType.equals((Object)ManagerEnums.OutputFileType.PDT) || fileType.equals((Object)ManagerEnums.OutputFileType.PDT_NVAR)) continue;
            PathDetails pd = this.outputPaths.get((Object)fileType);
            String fromPlat = this.platform.getName().toLowerCase();
            String toPlat = newPlat.getName().toLowerCase();
            pd.updateRelativePath(ManagerUtils.replaceLast(pd.getFullPath(), "\\" + fromPlat + "\\", "\\" + toPlat + "\\"));
        }
    }

    public void updatePdtPaths(Platform newPlat) {
        String fromPlat = String.valueOf(this.platform.getName()) + "_PDT";
        String toPlat = String.valueOf(newPlat.getName()) + "_PDT";
        PathDetails pdt = this.outputPaths.get((Object)ManagerEnums.OutputFileType.PDT);
        PathDetails nvar = this.outputPaths.get((Object)ManagerEnums.OutputFileType.PDT_NVAR);
        pdt.updateRelativePath(ManagerUtils.replaceLast(pdt.getFullPath(), "\\" + fromPlat + "\\" + fromPlat + ".bin", "\\" + toPlat + "\\" + toPlat + ".bin"));
        nvar.updateRelativePath(ManagerUtils.replaceLast(nvar.getFullPath(), "\\" + fromPlat + "\\" + fromPlat + "_NVAR.bin", "\\" + toPlat + "\\" + toPlat + "_NVAR.bin"));
    }

    public BuildSetting getBuildSetting() {
        return this.buildSetting;
    }

    public void setBuildSetting(BuildSetting bs) {
        this.buildSetting = bs;
    }

    public String getFwVersion() {
        Firmware fw = this.getFirmware();
        if (fw != null) {
            return fw.getVersion();
        }
        return "";
    }

    public Firmware getFirmware() {
        String ver = this.buildSetting.getFirmwareVersion();
        Firmware fm = ManagerConfigs.getFirmwareByVersion(this.platform, ver);
        if (fm == null) {
            fm = ManagerConfigs.getDefaultFirmwareVersion(this.platform);
        }
        return fm;
    }

    public void updateFirmware(Platform newPlat) throws Exception {
        String ver = this.buildSetting.getFirmwareVersion();
        if (!ManagerConfigs.isFirmwareInstalled(newPlat, ver)) {
            Firmware fm = ManagerConfigs.getDefaultFirmwareVersion(newPlat);
            if (fm == null) {
                throw new Exception("No invalid firmware for platform " + newPlat.getName());
            }
            this.buildSetting.setFirmwareVersion(fm.getVersion());
        }
    }

    public String getFirmwareFolder() throws Exception {
        if (ManagerFileUtils.supportFullBuild() && this.buildSetting.isFullBuild() && !this.buildSetting.getFirmwarePath().isEmpty()) {
            String path = String.valueOf(this.buildSetting.getFirmwarePath()) + "//bin";
            ManagerEnums.CompilationMode mode = this.compilationMode;
            return ManagerFileUtils.FDK_TOOLS_VERSION_FOLDER(this.platform, path, mode);
        }
        Firmware fm = this.getFirmware();
        if (fm == null) {
            throw new Exception("No invalid firmware for platform " + this.platform.getName());
        }
        return fm.getPath();
    }

    public void addIssApp(AppData appData) throws Exception {
        if (this.apps == null) {
            this.apps = new ISSApps();
        }
        this.apps.addIssApp(appData);
    }

    public ISSApps getISSApps() {
        if (this.apps != null) {
            return this.apps;
        }
        return new ISSApps();
    }

    public List<AppData> getSelectedApps() {
        return this.getISSApps().getSelectedApps();
    }

    public List<AppData> getAvailableApps() {
        return this.getISSApps().getAvailableApps();
    }

    public void removeApp(AppData appData) throws Exception {
        this.apps.removeIssApp(appData.getName());
    }

    public void removeApp(String appName) throws Exception {
        this.apps.removeIssApp(appName);
    }

    public void clearApps() {
        if (this.apps != null) {
            this.apps.clearApps();
        }
        this.apps = new ISSApps();
    }
}

