/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.common.utils;

import com.intel.sensing.fdk.common.utils.ManagerFileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ManagerZipUtils {
    public static String unzipFileToDest(String pkgFile, String dest) throws Exception {
        ZipFile zipFile = null;
        File tmpDest = null;
        try {
            File file = new File(pkgFile);
            if (file == null || !file.exists()) {
                throw new Exception(file + " is not existed");
            }
            Path fTmpFolder = ManagerFileUtils.getTmpFolder();
            tmpDest = new File(fTmpFolder + File.separator + file.getName().substring(0, file.getName().lastIndexOf(".")));
            ManagerFileUtils.deleteFileOrDirectoryWithContent(tmpDest);
            zipFile = new ZipFile(pkgFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            ZipEntry entry = null;
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                File df = new File(String.valueOf(tmpDest.getAbsolutePath()) + File.separator + entry.getName());
                if (entry.isDirectory()) {
                    df.mkdirs();
                    continue;
                }
                df.getParentFile().mkdirs();
                df.createNewFile();
                InputStream is = zipFile.getInputStream(entry);
                ManagerFileUtils.write(is, df);
            }
            ManagerFileUtils.copyDirectory(tmpDest, new File(dest));
            ManagerFileUtils.deleteFileOrDirectoryWithContent(tmpDest);
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        return dest;
    }
}

