/*
 * Decompiled with CFR 0.152.
 */
package manager.pack.data;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import manager.pack.data.AbstractData;
import manager.pack.data.DataUtils;

public class Category
extends AbstractData {
    private String description;
    private static int index = 0;
    private static AbstractData first = null;
    private static AbstractData last = null;
    public static final Category OS = new Category("os", "os details");
    public static final Category RTOS = new Category("rtos", "os details");
    public static final Category API = new Category("os_api", "os api details");
    public static final Category APP = new Category("apps", "app details");
    public static final Category LIB = new Category("libs", "lib details");
    public static final Category BSP = new Category("bsp", "bsp details");
    public static final Category AON = new Category("aon", "aon details");
    public static final Category SENSOR = new Category("sensors", "sensor details");
    public static final Category UNKNOWN = new Category("unknown", "unknow");

    public Category(String name) {
        this(name, "");
    }

    public Category(String name, String desc) {
        super(name);
        if (first == null) {
            first = this;
        }
        last = this;
        this.description = desc;
    }

    @Override
    protected int nextId() {
        return index++;
    }

    @Override
    protected AbstractData last() {
        return last;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static String[] getItems() {
        return DataUtils.getItems(first);
    }

    public static int getItemIndexByName(String name) {
        String[] item = Category.getItems();
        int i = 0;
        while (i < item.length) {
            if (item[i].equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Category getItemById(int id) {
        return (Category)DataUtils.getItemById(id, first);
    }

    public static Category getItemByName(String name) {
        return (Category)DataUtils.getItemByName(name, first);
    }

    public static List<Category> getList() {
        ArrayList<Category> items = new ArrayList<Category>();
        Enumeration<AbstractData> e = DataUtils.elements(first);
        while (e.hasMoreElements()) {
            Category ca = (Category)e.nextElement();
            items.add(ca);
        }
        return items;
    }
}

