# Intel(R) Context Sensing Technology Changelog

All notable changes to Intel Context Sensing Technology (CST) will be documented in this file.

## [2.1.10300] - 2023-09-21 [WINDOWS]
ICST version 2.1.10300 does not include the latest functional and security updates. ICST version 2.1.10400 is targeted to be released in January 2024 and will include additional functional and security updates. Customers should update to the latest version as it becomes available.

#### General Fixes and Enhancements
- Update .NET SDK to 6.0.414
- [SENSING-4740] Add PTL to INF for evaluation support
- [SENSING-4741] Remove CST Helper Service
- [SENSING-4094] Internal architectural improvements for future IPF-EF support
- [SENSING-4728] Include VC Redistributables and IPF-EF ClientApi in preparation for future CST releases with IPF-EF
- [SENSING-4778] Enable new secure compilation flags
- [SENSING-4744] Optimize IPC server timeout handling
- [SENSING-4726] Delete legacy 2.0 HS Support Service from CST rather than INF
- [SENSING-4664] Resolve sporadic IPF reconnection failure

#### Sample App
- [SENSING-4777] Remove old 3rd-party DLLs (not needed when using CST NuGet package)
- [SENSING-4839] Update compiler flags for more secure compile-time checks

#### Client DLL
- Uprev SDK version to 0.8.16
- [SENSING-3593] Support configuration of HID inactivity timer (on supported versions of IPF)

## [2.1.10200] - 2023-06-12 [WINDOWS]

#### General Fixes and Enhancements
- [SENSING-4454] - CST reports UBRR not capable when receiving IPF primitive result Not Found in DSP
- [SENSING-3763] - Remove misleading SDK mismatch log
- [SENSING-4124] - Fix NLoP message tied to WOA
- [SENSING-4165] - Make Helper log level configurable
- [SENSING-4459] - Allow Adaptive Dimming to ignore HID events
- Update .NET 6 embedded runtime version for CVEs listed in [Microsoft's release notes](https://github.com/dotnet/core/blob/main/release-notes/6.0/6.0.18/6.0.18.md)

#### Client DLL
- Uprev SDK version to 0.8.14
- [SENSING-4468] - Add option for AD to ignore HID input

## [2.1.10104] - 2023-05-05 [WINDOWS]
Please note that the Sample App and Client DLL versions have not changed in this release and are identical to the ones in 2.1.10103.

#### General Fixes and Enhancements
- [SENSING-4484] - Update .NET 6 embedded runtime version for [CVE-2023-28260](https://nvd.nist.gov/vuln/detail/CVE-2023-28260)

## [2.1.10103] - 2022-12-09 [WINDOWS]

#### General Fixes and Enhancements
- [SENSING-3520] - Retry getting vision sensor capabilities on IPF timeout
- [SENSING-3476] - Add configurable throttle for sensor proximity events
- [SENSING-3329] - Update service to run as Automatic (Delayed Start) instead of Automatic
- [SENSING-3607] - Support CVF Wake on Motion feature in Adaptive Dimming by not restoring on vision->non-vision transitions
- [SENSING-2601] - Improvement of client message dispatching performance from the server side
- [SENSING-3698] - Workaround for sporadic failure to restore brightness after WOA
- [SENSING-4197] - Add LNL install support for evaluation only

#### Client DLL
- Uprev SDK version to 0.8.13
- [SENSING-3476] - Add ProximityCooldownTime parameter
- [SENSING-3446] - Allow handshake retries if handshake fails for unknown reason
- [SENSING-3778] - Extend client message timeout to 3s

#### Sample App
- [SENSING-3410] - Cleanup of keywords usage

## [2.1.10102] - 2022-10-7 [WINDOWS]

#### No Lock On Presence
- [SENSING-3681] Revert NLoP to deactivate unconditionally on Disengaged (Reverts SENSING-3043)

## [2.0.10504] - 2022-9-30 [WINDOWS]

#### General Fixes and Enhancements

- [SENSING-3520] - Retry getting vision sensor capabilities on IPF timeout
- [SENSING-3476] - Add configurable throttle for sensor proximity events
- [SENSING-3329] - Update service (and support service) to run as `Automatic (Delayed Start)` instead of `Automatic`
- [SENSING-3607] - Support CVF Wake on Motion feature in Adaptive Dimming by not restoring on vision->non-vision transitions

#### Client DLL
- Uprev SDK version to 0.8.5
- [SENSING-3476] - Add ProximityCooldownTime parameter
- [SENSING-3446] - Allow handshake retries if handshake fails for unknown reason

## [2.1.10101] - 2022-8-19 [WINDOWS]

#### General Fixes and Enhancements

- [SENSING-3224] - Handle instant cancellation in Walk Away Lock; Harden WAL and NLoP options change restarts
- [SENSING-3043] - Disengaged user presence now triggers the NLoP reset timer rather than instantly stopping NLoP
- [SENSING-3224] - Harden AD HandleOptionsChange
- [SENSING-3246] - Update ICST INF documentation to provide an example of how to allow 2 recovery attempts of ICST per day
- [SENSING-3204] - Update service to use in-memory extraction for SAC support and embedded resource file for log4net config
- [SENSING-3284] - Remove DiaSymReader DLL as in-memory extraction doesn't need it
- [SENSING-3299] - Update service INF for Windows 11 22H2 WHQL support
- [SENSING-3327] - Make correlation reset timer configurable
- [SENSING-3118] - Don't send false Windows audio exception to the event log

#### Client DLL
- Uprev SDK version to 0.8.10 (avoids version conflicts with 2.0)
- [SENSING-3327] - Add CorrelationResetTime parameter

#### Sample App
- [SENSING-3300] - Await options refresh before adding subscription to required events

## [2.0.10503] - 2022-8-5 [WINDOWS]

#### General Fixes and Enhancements

- [SENSING-3224] - Handle instant cancellation in Walk Away Lock; Harden WAL and NLoP options change restarts
- [SENSING-3246] - Update ICST INF documentation to provide an example of how to allow 2 recovery attempts of ICST per day
- [SENSING-3204] - Update service to use in-memory extraction for SAC support and embedded resource file for log4net config
- [SENSING-3284] - Remove DiaSymReader DLL as in-memory extraction doesn't need it
- [SENSING-3299] - Update service INF for Windows 11 22H2 WHQL support
- [SENSING-3327] - Make correlation reset timer configurable
- [SENSING-3350] - Defer brightness restore until after CS exit

#### Client DLL
- Uprev SDK version to 0.8.4
- [SENSING-3327] - Add CorrelationResetTime parameter

## [2.1.10100] - 2022-6-24 [WINDOWS]

#### User-based Refresh Rate

- [SENSING-2229] - Implement UBRR

#### Adaptive Dimming

- [SENSING-2229] - Set different dim targets on DE vs NP (UBRR)
- [SENSING-3040] - Update AD default settings

#### Client DLL

- Minor version uprev to v0.8.3
- [SENSING-2229] - Add UBRR options

#### General Fixes and Enhancements

- [SENSING-2229] - CST now runs as NT AUTHORITY\SYSTEM to enable UBRR
- [SENSING-2431] - Move helper service launcher into CST
- [SENSING-3025] - Remove symlinks if detected in the config folder
- [SENSING-3134] - Allow forwards compatibility in IPC DLL
- [SENSING-3203] - Implement log4net.config corruption recovery

## [2.0.10502] - 2022-6-14 [WINDOWS]

#### Power Consumption Improvements

- [SENSING-2539] - DisplayRequiredEventSource Adaptive Polling
- [SENSING-2549] - Unregister from BP sensor when no features are enabled
- [SENSING-2751] - GetHumanPresenceStatus() to return error if BP sensor is not registered
- [SENSING-2778] - Reduce IPC client failsafe poll rate

#### General Fixes and Enhancements

- [SENSING-2428] - [CST 2.0] Adaptive Dimming fails to restore brightness when interrupted rarely
- [SENSING-2731] - [CST 2.0] WOA still takes actions when disabled while CST is stopped
- [SENSING-2735] - [CST 2.0] Onlooker Detection does not dim to new target when switching users after dimming
- [SENSING-2773] - Stopping CST without IPF connection causes multiple errors in event viewer
- [SENSING-2793] - [CST 2.0] Misprediction increases before AD dims if Misprediction timer is active
- [SENSING-3070] - Add Microsoft Diasym DLL so .NET won't try to load it from PATH
- [SENSING-3203] - Implement Log4Net config corruption recovery workaround

## [2.0.10501] - 2022-3-29 [WINDOWS]

#### General Fixes and Enhancements
- SENSING-2797: Improve event re-registration error handling

## [2.0.10500] - 2022-3-18 [WINDOWS]

#### Client DLL

- Minor version uprev to v0.8.2
- SENSING-2600: Allow client connection retry on timeout
- SENSING-2711: Fix DI for non-manual ClientBackendLink construction

#### Sample App

- SENSING-2528: Add HumanPresenceChanged event to defaults
- SENSING-2465: Cancel Onlooker Detection Snooze remains active after cancelling on other users
- SENSING-2432: Unhandled exception on Onlooker Detection snooze

#### CPU Utilization Improvements

- SENSING-2547: Unregister from EnabledEvents dependencies
- SENSING-2602: Refactor unpack of incoming IPF data
- SENSING-2639: High utilization from helper service process when IPF is not running

#### General Fixes and Enhancements

- SENSING-2316: .NET 6
- SENSING-2598: Hardware capabilities detection scaffolding
- SENSING-2502: Make correlation reset after 2min of no HID activity even when user is Disengaged
- SENSING-2659: User presence statuses are INVALID when booting a machine in Face Engaged state.
- SENSING-2712: Improve settings file error checking
- SENSING-2743: Use localized version of LOCAL SERVICE and SYSTEM account names

## [2.0.10502] - 2022-4-29 [WINDOWS]

#### Power Consumption Improvements

- [SENSING-2539] - DisplayRequiredEventSource Adaptive Polling
- [SENSING-2549] - Unregister from BP sensor when no features are enabled
- [SENSING-2751] - GetHumanPresenceStatus() to return error if BP sensor is not registered
- [SENSING-2778] - Reduce IPC client failsafe poll rate
 
#### General Fixes and Enhancements

- [SENSING-2428] - [CST 2.0] Adaptive Dimming fails to restore brightness when interrupted rarely
- [SENSING-2731] - [CST 2.0] WOA still takes actions when disabled while CST is stopped
- [SENSING-2735] - [CST 2.0] Onlooker Detection does not dim to new target when switching users after dimming
- [SENSING-2773] - Stopping CST without IPF connection causes multiple errors in event viewer
- [SENSING-2793] - [CST 2.0] Misprediction increases before AD dims if Misprediction timer is active

## [2.0.10501] - 2022-3-29 [WINDOWS]

#### General Fixes and Enhancements
- SENSING-2797: Improve event re-registration error handling

## [2.0.10500] - 2022-3-18 [WINDOWS]

#### Client DLL

- Minor version uprev to v0.8.2
- SENSING-2600: Allow client connection retry on timeout
- SENSING-2711: Fix DI for non-manual ClientBackendLink construction

#### Sample App

- SENSING-2528: Add HumanPresenceChanged event to defaults
- SENSING-2465: Cancel Onlooker Detection Snooze remains active after cancelling on other users
- SENSING-2432: Unhandled exception on Onlooker Detection snooze

#### CPU Utilization Improvements

- SENSING-2547: Unregister from EnabledEvents dependencies
- SENSING-2602: Refactor unpack of incoming IPF data
- SENSING-2639: High utilization from helper service process when IPF is not running

#### General Fixes and Enhancements

- SENSING-2316: .NET 6
- SENSING-2598: Hardware capabilities detection scaffolding
- SENSING-2502: Make correlation reset after 2min of no HID activity even when user is Disengaged
- SENSING-2659: User presence statuses are INVALID when booting a machine in Face Engaged state.
- SENSING-2712: Improve settings file error checking
- SENSING-2743: Use localized version of LOCAL SERVICE and SYSTEM account names

## [2.0.10400] - 2021-12-17 [WINDOWS]

#### Client DLL

- Major version uprev to v0.80
- SENSING-1021: Remove deprecated settings (LaunchOnUserLogin, Protocol, ExternalMonitor)
- SENSING-2247: Send client events on service start/stop
- SENSING-2263: Send subscribed events to client even after service restart
- SENSING-844:  Provide HumanPresenceStatus as event

#### General Fixes and Enhancements

- SENSING-2225: Internal feature stabilty improvements
- SENSING-2286: Internal event handling stability improvements
- SENSING-2934: Disable Onlooker Detection by default
- SENSING-2283: Make user settings resilient to IPF connection status
- SENSING-2378: Refactor brightness controller

## [2.0.10302] - 2021-11-23 [WINDOWS]

#### Hotfix

- SENSING-2361: Fix race condition in CST-IPF connection status
- SENSING-2299: Recover dropped IPF session in situations where connection terminated callback doesn't happen

## [2.0.10301] - 2021-10-11 [WINDOWS]

#### General Fixes and Enhancements

- SENSING-347:  Report sensor error state
- SENSING-1665: Implement helper service and launcher
- SENSING-1869: Fixed issue where app install notification was not being received
- SENSING-855:  Fix issue where CST does not disable on uninstall until svc restart
- SENSING-2052: Move user-in-call tracking to user context for stability
- SENSING-2051: Add digital signature to Intel.Cst.Ipc dll and nupkg
- SENSING-2077: Separate non-standalone exes into subfolder and add readme
- SENSING-814:  Disable features uniformly when in remote desktop connection
- SENSING-1969: Don't allow invalid initial battery data to break feature initialization

## [2.0.10300] - 2021-9-14 [WINDOWS]

### Changed

#### Onlooker Detection

- SENSING-1640: Unsubscribe from Onlooker Detection sensor in CS
- SENSING-1749: Added EVENT_SNOOZE_COMPLETE to SDK which fires whenever OD snooze runs to completion
- SENSING-1897: Onlooker detection snooze bugfixes and improvements

#### Sensor Correlation

- SENSING-865:  Enable sensor-HID correlation tracking
- SENSING-1952: Update AD, WAL, and NLoP to use correlation data (skip actions if vision sensor is active but miscorrelated)

#### CST SDK and SampleApp

- SENSING-1256: Refactor SDK implementation to use ExecuteCommand in the backend
- SENSING-1556, SENSING-1560: Call GetOptions from the SampleApp whenever the global mode checkbox changes
- SENSING-1834: Make client API ClientBackendLink disposable and add retry capabilities
- SENSING-856:  Add CST SDK version checking and enforcement
- SENSING-1834: Optimize IPC library to improve performance
- SENSING-1915: Don't send events to CST SDK subscribers before receiving first data from IPF

#### General fixes and enhancements

- SENSING-1640: Disable Adaptive Dimming during connected standby
- SENSING-1722: General No Lock on Presence cleanup
- SENSING-1722: Block AD and WAL background tasks from starting if feature is disabled
- SENSING-1597: Add notification and disable CST whenever IPF connection is lost, and restore when connection is fixed
- SENSING-1498: Enable user-in-call tracking and optional enforcement
- SENSING-1798: Update dimming arbitration to keep user-set higher brightnesses when restoring the screen

## [2.0.10200] - 2021-6-11 [WINDOWS]

- SENSING-984:  Implement Onlooker Detection snooze API
- SENSING-1348: Allow predim timer to start, even if power request is active
- SENSING-1631: INF copies settings file by default
- SENSING-1499: Implement support for external vision/ToF sensors
- SENSING-1236: Implement feature capabilities reporting
- SENSING-438:  Mask External Monitor events in connected standby
- SENSING-1438: Limit External Monitor events to 0->1 and 1->0 transitions
- SENSING-987:  Send events when Adaptive Dimming and Onlooker Detection are active/inactive
- SENSING-357:  Send PROXIMITY events from IPF to the client
- SENSING-1265: Dimming always uses the full dim interval

## [2.0.10100] - 2021-4-30 [WINDOWS]

- SENSING-1222: Update CST2.0 client namespace from ContextSensingClient to Intel.Cst.Client
- SENSING-912:  Enable additional configuration options in the Sample App
- SENSING-1295: Allow user to configure AD to obey power requests
- SENSING-1262: Allow global mode user (SYSTEM) to use local mode
- SENSING-382:  Implement Onlooker Detection (simulation only)
- SENSING-1170: Change brightness levels to be relative

## [2.0.10000] - 2021-3-29 [WINDOWS]

### Changed

- SENSING-318: Feature: Adaptive Dimming
- SENSING-431: Clean-up deprecated fields
- SENSING-531: Feature: Vision Sensing Opt-in/Opt-out
- SENSING-726: Global SetOption support
- SENSING-722: Global GetOptions support
- SENSING-767: Implement multi-user support
- SENSING-320: Feature: No Lock on Presence

## [0.8.10000] - 2021-2-16 [WINDOWS]

### Changed

- SENSING-316: Feature: Walk Away Lock
- SENSING-317: Feature: Wake On Approach
- SENSING-322: GetOptions implementation
- SENSING-325: SetOption implementation
- Various infrastructure items

<!-- markdownlint-configure-file { "MD024": { "allow_different_nesting": true } } -->
