/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.common.utils;

import com.intel.sensing.fdk.common.exceptions.ExceptionHandler;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManagerXMLUtils {
    public static void createXMLFile(String xmlFilePath, String rootName) throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement(rootName);
            doc.appendChild(root);
            doc.getDocumentElement().normalize();
            ManagerXMLUtils.createXMLFile(xmlFilePath, doc);
        }
        catch (Exception e) {
            String err = ExceptionHandler.parseException(e);
            throw new Exception("Could not create " + xmlFilePath + ". " + err);
        }
    }

    public static void createXMLFile(String xmlFilePath, Document xmlContent) throws Exception {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "5");
            xmlContent.getDocumentElement().normalize();
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPathExpression xpathExp = xpathFactory.newXPath().compile("//text()[normalize-space(.) = '']");
            NodeList emptyTextNodes = (NodeList)xpathExp.evaluate(xmlContent, XPathConstants.NODESET);
            int i = 0;
            while (i < emptyTextNodes.getLength()) {
                Node emptyTextNode = emptyTextNodes.item(i);
                emptyTextNode.getParentNode().removeChild(emptyTextNode);
                ++i;
            }
            xmlContent.setTextContent("");
            DOMSource source = new DOMSource(xmlContent);
            StreamResult result = new StreamResult(new File(xmlFilePath));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            String err = ExceptionHandler.parseException(e);
            throw new Exception("Could not create " + xmlFilePath + ". " + err);
        }
    }

    public static NodeList getXMLElements(String xmlFilePath, String elementName) throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new File(xmlFilePath));
            return doc.getElementsByTagName(elementName);
        }
        catch (Exception e) {
            String err = ExceptionHandler.parseException(e);
            throw new Exception("Could not read the " + elementName + " element in " + xmlFilePath + ". " + err);
        }
    }

    public static NodeList getXMLElements(String xmlFilePath, String elementName, Document doc) throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new File(xmlFilePath));
            return doc.getElementsByTagName(elementName);
        }
        catch (Exception e) {
            String err = ExceptionHandler.parseException(e);
            throw new Exception("Could not read the " + elementName + " element in " + xmlFilePath + ". " + err);
        }
    }

    public static NodeList getXMLElements(String xmlFilePath, String parentElementName, String childElementName) throws Exception {
        Element parent;
        block3: {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(new File(xmlFilePath));
                parent = (Element)doc.getElementsByTagName(parentElementName).item(0);
                if (parent != null) break block3;
                return null;
            }
            catch (Exception e) {
                String err = ExceptionHandler.parseException(e);
                throw new Exception("Could not read the " + childElementName + " element in " + xmlFilePath + ". " + err);
            }
        }
        return parent.getElementsByTagName(childElementName);
    }

    public static Document getNewDocument() throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            String err = ExceptionHandler.parseException(e);
            throw new Exception("Could not create the xml file." + err);
        }
    }

    public static Element createTextNode(Document doc, String elementName, String elementContent) {
        Element element = doc.createElement(elementName);
        element.appendChild(doc.createTextNode(elementContent));
        return element;
    }

    public static Document getXMLDocument(File file) throws Exception {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(file);
            doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            throw new Exception("Failed to read from xml file " + (e != null && e.getMessage() != null ? e.getMessage() : ""));
        }
        return doc;
    }

    public static void changeElementContent(String filePath, String parentName, String elementName, String elementContent) throws Exception {
        Document doc = ManagerXMLUtils.getXMLDocument(new File(filePath));
        NodeList elementList = doc.getElementsByTagName(elementName);
        if (elementList != null && elementList.getLength() > 0) {
            ((Element)elementList.item(0)).getFirstChild().setNodeValue(elementContent);
        } else {
            Element parent = (Element)doc.getElementsByTagName(parentName).item(0);
            parent.appendChild(ManagerXMLUtils.createTextNode(doc, elementName, elementContent));
        }
        ManagerXMLUtils.createXMLFile(filePath, doc);
    }

    public static void changeElementContent(String filePath, String elementName, String elementContent) throws Exception {
        Document doc = ManagerXMLUtils.getXMLDocument(new File(filePath));
        ((Element)doc.getElementsByTagName(elementName).item(0)).getFirstChild().setNodeValue(elementContent);
        ManagerXMLUtils.createXMLFile(filePath, doc);
    }

    public static void removeAllChildren(String xmlPath, String parentName, String childName) throws Exception {
        try {
            Document doc = ManagerXMLUtils.getXMLDocument(new File(xmlPath));
            Node parentNode = doc.getElementsByTagName(parentName).item(0);
            NodeList list = ((Element)parentNode).getElementsByTagName(childName);
            int i = 0;
            while (i < list.getLength()) {
                Element element = (Element)list.item(i);
                element.getParentNode().removeChild(element);
                --i;
                ++i;
            }
            ManagerXMLUtils.createXMLFile(xmlPath, doc);
        }
        catch (Exception e) {
            String err = ExceptionHandler.parseException(e);
            throw new Exception("Failed to remove elements from " + xmlPath + " file" + err);
        }
    }
}

