/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import pdtEditor.Sensor;
import pdtEditor.gui.InteruptsModifier;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.configuration.ConfigurationEditor;
import pdtEditor.payloads.configurations.SdoConfigurationPayload;

public class SdoConfiguration
implements ConfigurationEditor {
    private SdoConfigurationPayload _payload = null;
    private Sensor _sensor = null;
    protected Shell shell;
    private Display display;
    private SensorModifier _parent;

    public static void main(String[] args) {
        try {
            SdoConfiguration window = new SdoConfiguration(null, null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SdoConfiguration(SensorModifier parent, SdoConfigurationPayload payload, Sensor sensor) {
        this._payload = payload;
        this._sensor = sensor;
        this._parent = parent;
    }

    @Override
    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        if (this._parent == null) {
            return;
        }
        if (this._parent.getGpioInfo().getGpioCount() < 1) {
            new InteruptsModifier(this._parent.getGpioInfo(), this._sensor).open();
        } else {
            new InteruptsModifier(this._parent.getGpioInfo(), this._sensor, 0).open();
        }
        this.saveData();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void saveData() {
        SdoConfigurationPayload payload = this._payload;
        if (payload == null) {
            payload = new SdoConfigurationPayload();
        }
        if (this._parent == null || this._parent.getGpioInfo().getGpioCount() == 0) {
            return;
        }
        this._payload = payload;
        this._parent.addNewConfiguration(this._payload);
        this._parent.setModified();
        this.shell.close();
    }

    protected void createContents() {
        this.shell = new Shell(65760);
    }

    @Override
    public String getConfigurationFormatName() {
        return "Simple Device Orientation Configuration";
    }
}

