/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.persistence.cache.api;

import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.common.utils.ManagerFileUtils;
import com.intel.sensing.fdk.model.ObservableModel;
import com.intel.sensing.fdk.model.dao.DefaultJsonDao;
import com.intel.sensing.fdk.model.persistence.cache.Impl.CacheWatcher;
import com.intel.sensing.fdk.model.persistence.cache.api.ModuleFolderCache;
import com.intel.sensing.fdk.model.service.PersistenceServiceListenName;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ModuleCacheManager
extends ObservableModel {
    private String cacheFileName;
    private ModuleFolderCache cache = null;
    protected Path baseDir;
    private DefaultJsonDao dao = DefaultJsonDao.register(ModuleFolderCache.class);
    private CacheWatcher cacheWatcher;
    private final int oneSecond = 1000;
    private Path cacheFilePath;

    protected ModuleCacheManager(Path baseDir) throws ISSException, IOException {
        this.init(baseDir, true, 0);
    }

    protected ModuleCacheManager(Path baseDir, boolean recursive, int maxDepth) throws ISSException, IOException {
        this.init(baseDir, recursive, maxDepth);
    }

    private void init(Path baseDir, boolean recursive, int maxDepth) throws ISSException, IOException {
        if (baseDir == null || Files.notExists(baseDir, new LinkOption[0])) {
            throw new ISSException("Module base folder not exist: " + baseDir.toAbsolutePath().toString());
        }
        this.baseDir = baseDir;
        this.cacheFileName = baseDir.getFileName() + "Cache";
        Path cacheFileFolder = this.getCacheFolder(this.baseDir);
        this.cacheFilePath = this.getCacheFilePath(cacheFileFolder);
        this.initCache();
        this.initFileWatcher(recursive, maxDepth);
    }

    private void initCache() {
        try {
            this.forceBuildCache();
            this.loadCache();
        }
        catch (Throwable e) {
            ISSLogger.e((Throwable)e);
        }
    }

    private void initFileWatcher(boolean recursive, int maxDepth) {
        try {
            this.cacheWatcher = new CacheWatcher(this.baseDir, recursive, this, maxDepth);
            this.startWatch();
        }
        catch (IOException e) {
            ISSLogger.e((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCache(ModuleFolderCache cache) {
        ModuleFolderCache oldCache = null;
        ModuleCacheManager moduleCacheManager = this;
        synchronized (moduleCacheManager) {
            if (this.cache != cache) {
                oldCache = this.cache;
                this.cache = cache;
            }
        }
        if (oldCache != null && !oldCache.equals(cache)) {
            this.firePropertyChange(PersistenceServiceListenName.ModuleCacheService.getServiceListenName(), oldCache, cache);
        }
    }

    public ModuleFolderCache getCache() {
        return this.cache;
    }

    protected ModuleFolderCache readCacheFile(String filePath) {
        ModuleFolderCache cache = (ModuleFolderCache)this.dao.getEntityByFilePath(filePath);
        return cache;
    }

    public void buildCache() throws Throwable {
        this.buildCache(this.baseDir);
    }

    protected void buildCache(Path folder) throws Throwable {
        if (folder == null || !Files.exists(folder, new LinkOption[0]) || !Files.isDirectory(folder, new LinkOption[0])) {
            throw new FileNotFoundException("Folder " + folder.getFileName() + " not found.");
        }
        this.setCache(this.generateCacheFile());
        this.dao.saveEntity(this.cache);
    }

    public void forceBuildCache() {
        try {
            this.forceBuildCache(this.baseDir);
        }
        catch (Throwable e) {
            ISSLogger.e((Throwable)e);
        }
    }

    protected void forceBuildCache(Path folder) throws Throwable {
        if (folder == null || !Files.exists(folder, new LinkOption[0]) || !Files.isDirectory(folder, new LinkOption[0])) {
            throw new FileNotFoundException("Folder " + folder.getFileName() + "not found.");
        }
        Files.deleteIfExists(this.cacheFilePath);
        this.buildCache(folder);
    }

    public void reBuildCache() {
        try {
            this.forceBuildCache();
        }
        catch (Throwable e) {
            ISSLogger.e((Throwable)e);
        }
    }

    public boolean loadCache() throws Throwable {
        Path cachedFilePath = this.cacheFilePath;
        if (Files.notExists(cachedFilePath, new LinkOption[0])) {
            return false;
        }
        String filePath = cachedFilePath.toFile().getAbsolutePath();
        this.setCache(this.readCacheFile(filePath));
        return true;
    }

    public void reLoadCache() {
        try {
            this.loadCache();
        }
        catch (Throwable e) {
            ISSLogger.e((Throwable)e);
        }
    }

    public boolean isCacheExpired() throws Throwable {
        return this.isCacheExpired(this.cache);
    }

    protected boolean isCacheExpired(ModuleFolderCache cache) throws Throwable {
        if (cache == null) {
            return true;
        }
        long folderModifiedTime = cache.getCachedFolder().toFile().lastModified();
        long fileModifiedTime = this.cacheFilePath.toFile().lastModified();
        return Math.abs(fileModifiedTime - folderModifiedTime) >= 1000L;
    }

    protected ModuleFolderCache generateCacheFile() throws Throwable {
        List<String> allModulePathList = this.generateAllModulePathList();
        ModuleFolderCache entity = new ModuleFolderCache();
        entity.setModulelist(allModulePathList);
        entity.setJsonFilePath(this.cacheFilePath.toString());
        return entity;
    }

    private Path getCacheFilePath(Path folder) {
        return ManagerFileUtils.appendPath((Path)folder, (String)this.cacheFileName);
    }

    private Path getCacheFolder(Path folder) throws IOException {
        String relativeFolder = folder.toAbsolutePath().toString().replace(ManagerFileUtils.getFDKDir(), "");
        Path cacheFolder = ManagerFileUtils.appendPath((Path)ManagerFileUtils.getCacheFolder(), (String)relativeFolder);
        if (!cacheFolder.toFile().exists()) {
            Files.createDirectories(cacheFolder, new FileAttribute[0]);
        }
        return cacheFolder;
    }

    protected List<String> generateAllModulePathList() throws Throwable {
        List categoryList = Files.list(this.baseDir).filter(f -> f != null && f.toFile().isDirectory()).filter(category -> category != null).collect(Collectors.toList());
        List<String> moduleList = categoryList.stream().filter(category -> category != null && category.toFile().isDirectory()).flatMap(category -> Arrays.stream(category.toFile().listFiles())).filter(module -> module != null && module.isDirectory()).map(module -> module.getAbsolutePath()).collect(Collectors.toList());
        return moduleList;
    }

    protected boolean checkMemoryCacheIntegrity() {
        if (this.cache == null) {
            return false;
        }
        return this.cache.getModulelist().stream().allMatch(folderPath -> new File((String)folderPath).exists());
    }

    public void startWatch() {
        Thread watcherThread = new Thread(this.cacheWatcher);
        watcherThread.setName(this.getClass().getSimpleName());
        watcherThread.setDaemon(true);
        watcherThread.start();
    }
}

