<?php
class HyperSSDXmlHandler extends XmlHandler {
    public function handle($XMLRoot) {
        $factory = $this->getFactory();
        if (isset($XMLRoot->hyperssd_list) && !empty($XMLRoot->hyperssd_list)) {
            $List = $XMLRoot->hyperssd_list;
            if (isset($List->hyperssd_information) && !empty($List->hyperssd_information)) {
                foreach($List->hyperssd_information as $info) {
                    $hyperssd = null;
                    $id = intval($info->partition_id);
                    if ($factory->hasObj($id)) {
                        $hyperssd = $factory->getObj($id);
                    } else {
                        $hyperssd = $this->getFactory()->createObj($id);
                    }

                    $hyperssd->setDeviceID($id);
                    $hyperssd->setHyperSSDInfo($info);
                }
            }
        }
    }
}

?>