<?php
class SlotInfo
{
	const FREE = 0;
	const USED = 1;
	
	public $ID;
	public $size;
	public $sizeGB;
	public $status;
	public $VDID;
	public $vd;
	public $percentage;
	public $isFree;
	
	public function setFromVDSlot($vdSlot)
	{
		$this->ID = $vdSlot->getSlotNo();
		$this->size = ConvertSize($vdSlot->getSize());
		$this->sizeGB = FormatSize($vdSlot->getSize());		
		$vd = $vdSlot->getVD();
		
		if (!$vdSlot->isFree()) {
			$this->status = self::USED;
			$this->VDID = $vdSlot->getVDID();
			if (isset($vd)) {
				$this->vd = new LDInfo();
				$this->vd->setLDInfo($vd);
			}
		}
		
		$this->isFree = ($this->status == self::FREE);
	}
}

class DgInfo
{
	public $ID;
	public $Name;
	public $StatusString;
	public $StatusInt=0;
	public $Size;
	public $SizeGB;
	public $RemainingSize;
	public $RemainingSizeGB;
	public $HdCount;
	public $LdCount;
	public $StripeSize;
	public $RaidMode;
	public $RaidModeInt;
	public $WriteCacheOn;
	public $BlockSizeK;
	public $StripeSizeK;
	public $BgaTypeInt;
	public $BgaTypeStr;
	public $BgaStateInt;
	public $BgaStateStr;
	public $NumParityDisk;
	
	//public $CacheEnable=1;
	public $setEnable=0;
	public $enableCreateVDBtn = 0;
	public $canNotSetSizeForVD = 0;
	public $enableSetSpareBtn = 0;
	
	public $enableRebuild = 0;
	public $enableMigrate = 0;
	public $enableDelete = 0;
	
	public $enableStop = 0;
	public $enableResume = 0;
	public $enablePause = 0;
	public $enableRestart = 0;
	/*public $stopStr;
	public $resumeStr;
	public $pauseStr;
	public $restartStr;*/
	
	public $HDIDs = array();
	public $HDList = array();
	public $LDIDs =array();
	public $LDList = array();
	public $spareHDIDs = array();
	public $spareHDList = array();
	
	public $DGImg = "";
	public $LDImg = "";
	
	//details	
	public $Adapters;
	
	public $AdapterID;
	
	public $VDSlotCount = 0;
	public $VDSlots = array();
	public $defaultVDSlot;
	
	public function __construct()
	{
		$this->Adapters = array();
	}
	
	public function setDGInfo($DG)
	{
		$this->ID = $DG->getID();
		$this->Name = htmlspecialchars(trim($DG->getName()),ENT_QUOTES);
		$this->AdapterID = $DG->getAdapterID();
		$this->SizeGB = FormatSize($DG->getSize());
		$this->Size = ConvertSize($DG->getSize());
		$this->RemainingSizeGB = FormatSize($DG->getRemainingSize());
		$this->RemainingSize = ConvertSize($DG->getRemainingSize());
		$this->BlockSizeB = $DG->getBlockSize() . " B";
		$this->StripeSize = $DG->getStripeBlockSize();
		$this->StripeSizeK = $DG->getStripeBlockSize() . " K";
		$this->BgaStateInt = $DG->getBgaState();
		$this->BgaStateStr = LdBgaState::getLdBgaStateStr($this->BgaStateInt);
		$this->BgaTypeInt = $DG->getBgaType();
		$this->BgaTypeStr = LdBgaStatus::getLdBgaStatusStr($this->BgaTypeInt);
		
		$this->RaidModeInt = $DG->getRaid_Level();
		$this->RaidMode = RAIDMode::GetRAIDModeStr($DG->getRaid_Level());
		$this->WriteCacheOn = $DG->getWriteCacheOn();
		$this->NumParityDisk = $DG->getNumParityDisk();

		foreach ($DG->getLDList() as $VdOnDg) {
			$ld = new LDInfo();
			$ld->setLDInfo($VdOnDg);
			$this->LDList[] = $ld;
			//$this->StatusInt = $ld->StatusInt;//set the DG status according to vdondg's Status:API cann't get DG status
		}
	/*	$this->DGImg = DGStatus::getDGImg($this->StatusInt);		 	    
		$TmpStr = DGStatus::getDGStatusStr($this->StatusInt);
	    $this->StatusString = gettext($TmpStr);	
	    $this->LDImg = LDStatus::getLDImg($this->StatusInt);*/
		
		$this->StatusInt = $DG->getStatus();
		$this->DGImg = DGStatus::getDGImg($this->StatusInt);		 	    
		$TmpStr = DGStatus::getDGStatusStr($this->StatusInt);
	    $this->StatusString = gettext($TmpStr);	
	    
	    //set HD info
		foreach ($DG->getHDList() as $hd) {
			$hdInfo = new HDInfo();
			$hdInfo->setHDInfo($hd);
			$hdInfo->setConnectInfo($hd);
			$this->HDList[] = $hdInfo;
		}
		
		//set spare HD info
		foreach ($DG->getSpareHDList() as $hd)
		{
			$hdInfo = new HDInfo();
			$hdInfo->setHDInfo($hd);
			$hdInfo->setConnectInfo($hd);
			$this->spareHDList[] = $hdInfo;
		}		
		//set VD slot info and count slot percentage 
		$this->VDSlotCount = $DG->getVDSlotCount();
		$defaultSlot = null;
		foreach ($DG->getVDSlots() as $vdSlot)
		{
			//filter out invalid V
			if ($vdSlot->getSize() < UNIT_K * 100) {
				continue;
			}
			$slot = new SlotInfo();
			if (((! isset($defaultSlot))
				|| $defaultSlot->getSize() < $vdSlot->getSize())
				&& $vdSlot->isFree()
				) {
				$defaultSlot = $vdSlot;
			}
			$slot->setFromVDSlot($vdSlot);
			$this->VDSlots[] = $slot;
		}
		$this->VDSlotCount = sizeof($this->VDSlots);
		//sett default slot
		if (isset($defaultSlot))
		{
			$this->defaultVDSlot = new SlotInfo();
			$this->defaultVDSlot->setFromVDSlot($defaultSlot);
		}
		$this->countSlotPercentage();
		//
		//enable buttons
		$isAdmin = getSessionPara('isAdmin');
		if ($isAdmin) {// 	
			if ($this->StatusInt == DGStatus::DG_STATUS_FUNCTIONAL  
				||$this->StatusInt == DGStatus::DG_STATUS_PD_MISSING 
				||$this->StatusInt == DGStatus::DG_STATUS_PD_OFFLINE )  //default can not set config
			{
				$this->setEnable = 1;
			}
			
			if ($this->BgaStateInt == LdBgaState::LD_BGA_STATE_NONE) {
				//rebuild
				//if ($this->StatusInt == DGStatus::DG_STATUS_DEGRADED 
				//	|| DGStatus::DG_STATUS_PARTIALLYOPTIMAL == $this->StatusInt) {
				if($DG->getLDCount() != 0){
					$LdInDgHasBga = 0;
					foreach ($this->LDList as $LD) {
						if($LD->BgaStateInt != LdBgaState::LD_BGA_STATE_NONE) {
							$LdInDgHasBga = 1;
							break;
						}
					}
					if (!$LdInDgHasBga) {
						foreach ($this->LDList as $LD)
						{
							if($LD->StatusInt == LDStatus::LD_STATUS_DEGRADED
								|| $LD->StatusInt == LDStatus::LD_STATUS_PARTIALLYOPTIMAL){
								$this->enableRebuild = 1;
							}
							break;
						}
						//if ($LD->StatusInt == LDStatus::LD_STATUS_FUNCTIONAL) {
						//}
						//migrate button, only functional vd can migrate
						if ($this->StatusInt == DGStatus::DG_STATUS_FUNCTIONAL
							&& $this->RaidModeInt != RAIDMode::LD_MODE_JBOD) {		
							$this->enableMigrate = 1;
						}
					}
				}
			}
			
			if(! sizeof($this->LDList)){
				$this->enableDelete = 1;
			}
			
			if ($this->BgaStateInt == LdBgaState::LD_BGA_STATE_RUNNING) {
				//if($this->BgaTypeInt != LdBgaStatus::LD_BGA_MIGRATION) { //migration can not stop
				//	$this->enableStop = 1;	
				//}
				$this->enablePause = 1;
			}
			if ($this->BgaStateInt == LdBgaState::LD_BGA_STATE_PAUSED
				|| $this->BgaStateInt == LdBgaState::LD_BGA_STATE_AUTOPAUSED ) {
				$this->enableResume = 1;
			}
			if ($this->BgaStateInt == LdBgaState::LD_BGA_STATE_ABORTED) {
				$this->enableRestart = 1;
			}
		}
	}
	
	const MIN_PERCENT = 6;
	private function countSlotPercentage()
	{
		$totalSize = $this->Size;	
		
		foreach ($this->VDSlots as $slot)
		{			
			$slot->percentage =  floor($slot->size / $totalSize * 100);
		}
		
		$this->countLoop();
	}
	
	private function countLoop()
	{
		foreach($this->VDSlots as $slot)
		{
			if($slot->percentage < self::MIN_PERCENT)
			{
				$ret = $this->getMaxPercentage();
				if(isset($ret))
				{
					//handle too small percentage
					$ret->percentage -= self::MIN_PERCENT - $slot->percentage;
					$slot->percentage = self::MIN_PERCENT;
				}
			}
		}
	}
	//get max percent which big than 12
	private function getMaxPercentage()
	{
		$ret = null;
		foreach ($this->VDSlots as $slot)
		{
			if($slot->percentage >= self::MIN_PERCENT * 2
				&&
				((! isset($ret)) || ($slot->percentage > $ret->percentage))
			)
			{
				$ret = $slot;
			}
		}
		
		return $ret;
	}
	
	public function setDgDtl($DG)
	{
		$this->ID = $DG->getID();
		$this->LdCount = $DG->getLDCount();

		//ld PD ID list 
		$this->HDIDs = $DG->getHDIDs();
		$this->LDIDs = $DG->getLDIDs();
		
		foreach ($DG->getHDList() as $HD)
		{
			$notfound = true;
			foreach ($this->Adapters as $adpater)
			{
				if (intval($adpater->AdapterID) == $HD->getAdapterID()) {
					$disk = new Disk();
					$disk->setHDInfo($HD);
					$adpater->HDs[$HD->getDeviceID()] = $disk;
					$notfound = false;
				}
			}
			if ($notfound) {
				$adpater = new LDAdapter();
				$adpater->AdapterID = $HD->getAdapterID();
				$disk = new Disk();
				$disk->setHDInfo($HD);
				$adpater->HDs[$HD->getDeviceID()] = $disk;
				$this->Adapters[$adpater->AdapterID] = $adpater;
			}
		}
		
		foreach ($this->Adapters as $adpater)
		{
			ksort($adpater->HDs);
		}
		ksort($this->Adapters);
		
		//enable buttons
		$hbaInfo = HBAFactory::getInstance($this->AdapterID);
		
		$MaxVDPerDG = $hbaInfo->getMaxVDPerDG();
		$isAdmin = getSessionPara('isAdmin');
		if ($isAdmin ) {
				$enableCreate = 0;
				foreach ($this->VDSlots as $slot)
				{
					if (($slot->size >= 0.1) && $slot->isFree) {
						$enableCreate = 1;
						break;
					}
				}
				if (($this->BgaStateInt == LdBgaState::LD_BGA_STATE_NONE) 
					 && ($this->StatusInt == DGStatus::DG_STATUS_FUNCTIONAL) 
					 && ($this->LdCount < $MaxVDPerDG
					 && $enableCreate
					 //&& $this->RemainingSize > 0
					 )
					 ){
					$this->enableCreateVDBtn = 1;			
				}
				if ($this->RaidModeInt != RAIDMode::LD_MODE_RAID0 ) {
					$this->enableSetSpareBtn = 1;
				}
				//add check for create size when number of LD in DG is maxLD;
				if(($DG->getVDSlotCount()) == $MaxVDPerDG || $this->enableCreateVDBtn == 0)
				{
					$this->canNotSetSizeForVD = 1;
				}
		}
	}

}

?>
