<?php
class ActionCreateVdOnDg extends UserAction 
{
	private $DG_ID = 0;
	private $StripeSize = 0;
	private $InitType = 0;
	private $LDName = 0;
	private $LDSize = 0;
	private $ReadCache;
	private $WriteCache;
	private $DGSlotNum=0xff;
	private $GBRounding = 0;
	
	private $VDID;
    const ToStopMP = "ToStopMP";
    private $isRunningMP = 0;
	
	protected function validatePara()
	{
		//check the http request parameters
	}
	protected function initActionPara()
	{
		$this->DG_ID = getRequestPara("DGID");
		$this->LDName = getRequestPara("LDName");
		$this->DGSlotNum = getRequestPara("DGSlotNum");
		$this->LDSize = getRequestPara("LDSize");
		$this->InitType = getRequestPara("InitType");
		$this->ReadCache = getRequestPara("ReadCache");
		$this->WriteCache = getRequestPara("WriteCache");
		$this->GBRounding = getRequestPara("GBRounding");
		$this->StripeSize = getRequestPara("StripeSize");
	}

    private function setFlags()
	{
		include_once("../phpsrc/baseclass/Device.class.php");
		include_once("../phpsrc/baseclass/SASDevice.class.php");
		include_once("../phpsrc/baseclass/DeviceFactory.class.php");
		include_once("../phpsrc/baseclass/PortDevice.class.php");
		include_once("../phpsrc/baseclass/Block.class.php");
		include_once("../phpsrc/baseclass/HD.class.php");
		include_once("../phpsrc/baseclass/PM.class.php");
		include_once("../phpsrc/baseclass/HBA.class.php");
		include_once("../phpsrc/baseclass/ExpanderDevice.class.php");
		include_once("../phpsrc/baseclass/DG.class.php");
		include_once("../phpsrc/baseclass/DgDetail.class.php");
		$dgDtl = new DgDetail();
		$dgDtl->setAdapterID($this->getAdapterID());
		$dgDtl->setDGID($this->DG_ID);
		$dgDtl->toGetDgInfo();

		$base = $dgDtl->getBaseClasses();
		if (sizeof($base)) {
		    $dgDetail = array_shift($base);
            if ($dgDetail->getPDBgaRunning()) {
                $this->isRunningMP = 1;
            }
        }
    }

	private function doCreateVdOnDg()
	{
		include_once("../phpsrc/baseclass/LD.class.php");
		include_once("../phpsrc/baseclass/LdList.class.php");
		$oldVDs = new LdList();
		$oldVDs->setAdapterID($this->getAdapterID());
		$oldVDs->toGetLDInfo();
		
		$oldVDIDs = array();
		foreach ($oldVDs->getBaseClasses() as $vd)
		{
			$oldVDIDs[] = $vd->getID();
		}
		
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_LD_Create_OnDG);
		$this->ApiCmd->setCommandPara("AdapterID",$this->getAdapterID());
		$this->ApiCmd->setCommandPara("DGID",$this->DG_ID);
		$this->ApiCmd->setCommandPara("Name",$this->LDName);
		$this->ApiCmd->setCommandPara("StripeBlockSize",$this->StripeSize);
		$this->ApiCmd->setCommandPara("DGSlotNum", $this->DGSlotNum);
		/*if ($this->LDSize<= 1)
		{
			$this->ApiCmd->setCommandPara("Size",$this->LDSize * UNIT_K);
		}
		else
		{
			$this->ApiCmd->setCommandPara("Size",$this->LDSize * UNIT_KILO);
		}*/
		$this->ApiCmd->setCommandPara("Size",$this->LDSize * UNIT_KILO);
		$this->ApiCmd->setCommandPara("RoundingScheme",$this->GBRounding);
		//cache
		$CachePolicy = intval($this->ReadCache) | intval($this->WriteCache);
		$this->ApiCmd->setCommandPara("CachePolicy",$CachePolicy);
		$this->ApiCmd->setCommandPara("InitializationOption",$this->InitType);
		$this->ApiCmd->setCommandPara("SectorCoefficient",LDSectorSize::SectorSize512B);
		
		$this->ApiCmd->issueCommand();
		if ($this->ApiCmd->getResult()->RetVal . "") {
			$this->setVdOnDgCreateFail();
		}
		else {
			$newVDs = new LdList();
			$newVDs->setAdapterID($this->getAdapterID());
			$newVDs->toGetLDInfo();
			
			$newVDIDs = array();
			foreach ($newVDs->getBaseClasses() as $vd)
			{
				$newVDIDs[] = $vd->getID();
			}
			$arr = array_diff($newVDIDs, $oldVDIDs);
			if ($arr) {
				$this->VDID = array_shift($arr);
			}
			$this->setVdOnDgCreateCmdXmlRetSuccess();
		}
	}
	
	private function setVdOnDgCreateCmdXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName
			."?Target=" . Target::getVDSubPage . "&ID=" . $this->VDID . "&HBAID=" . $this->getAdapterID();
	}
	
	private function setVdOnDgCreateFail()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			$this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target="
				. Target::getArraySubPage . "&ID=" . $this->DG_ID . "&HBAID=" . $this->getAdapterID();
			$Err = ComError::getErrStr(intval($XMLRoot->RetVal));
			$this->xmlRet->Msg = $Err;
		}
	}
	
	private function setVdOnDgCreateCheckFailXMLRet()
	{
		$this->xmlRet = new FailXMLRet();
		$this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target="
				. Target::getArraySubPage . "&ID=" . $this->DG_ID . "&HBAID=" . $this->getAdapterID();
		$Err = ComError::ERR_NO_RESOURCE_STR;
		$this->xmlRet->Msg = $Err;
	}
	
	protected function doAction()
	{
        /*$this->setFlags();
        if ((getRequestPara(self::ToStopMP) == null)
            && $this->isRunningMP){
            $cmdName = trim(getRequestPara("cmdName"));

            $YesUrl = getBaseURL() . PHPPageName::CmdPageName . "?cmdName=" . $cmdName ;
            $YesUrl .=  "&LDName=" . $this->LDName . "&DGSlotNum=" . $this->DGSlotNum
                        . "&LDSize=" . $this->LDSize . "&InitType=" . $this->InitType
                        . "&ReadCache=" . $this->ReadCache . "&WriteCache=" . $this->WriteCache
                        . "&GBRounding=" . $this->GBRounding . "&StripeSize=" . $this->StripeSize
                        . "&DGID=" . $this->DG_ID . "&HBAID=" . $this->getAdapterID()
                        . "&" . self::ToStopMP  . "=1" ;

            $NoUrl = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getArraySubPage
                        . "&ID=" . $this->DG_ID . "&HBAID=" . $this->getAdapterID();

            $this->xmlRet = new ContXMLRet();
            $this->xmlRet->Msg = AlertMsg::CREATEVD_STOP_MP;
            $this->xmlRet->YesUrl = $YesUrl;
            $this->xmlRet->NoUrl = $NoUrl;
            $this->xmlRet->YesUrlType = XMLRetUrlType::CmdUrl;
            $this->xmlRet->NoUrlType = XMLRetUrlType::PageUrl;
            return;
        }*///Bug 2574, need not check mp on create vd on array

        if ($this->xmlRet == null) {
            $this->doCreateVdOnDg();
        }
	}
}
?>