<?php
class ActionSaveHBAConfig extends UserAction 
{
	private $HBAID;
	private $AlarmOn;
	private $AutoRebuildOn;
	private $BGARate;
	private $PollSMARTOn;
	private $MediaPatrolRate;
	private $InterruptCoalescing;
	private $ModuleConsolidate;
	//private $SuspendMode;
	//added 3-19
	private $CopyBack;
	private $SyncRate;
	private $InitRate;
	private $RebuildRate;
	private $MigrationRate;
	private $CopybackRate;
	
	protected function validatePara()
	{
		//check the http request parameters
	}
	protected function initActionPara()
	{
		$this->HBAID = $this->getAdapterID();
		$this->AlarmOn = getRequestPara("AlarmOn");
		$this->AutoRebuildOn = getRequestPara("AutoRebuildOn");
		$this->BGARate = getRequestPara("BGARate");
		$this->PollSMARTOn = getRequestPara("PollSMARTOn");
		$this->InterruptCoalescing = getRequestPara("OCE");
		$this->ModuleConsolidate = getRequestPara("ModuleConsolidate");
		//added 3-19
		$this->SyncRate = getRequestPara("SyncRate");
		$this->InitRate = getRequestPara("InitRate");
		$this->RebuildRate = getRequestPara("RebuildRate");
		$this->MigrationRate = getRequestPara("MigrationRate");
		
		$this->CopyBack = getRequestPara("CopyBack");
		$this->CopybackRate = getRequestPara("CopybackRate");		
		$this->MediaPatrolRate = getRequestPara("MediaPatrolRate");
		
		// get old hba Config before set_hba_config
		$hba = new HBADetail(); 
		$hba->setID($this->HBAID);
		$hba->toGetHBAconfig();
		$hba->initData();
		$hbaList = $hba->getBaseClasses();
		//if Interface not set params,set the old one to the params
		if ($hbaList) {
			$hbaInfo = array_shift($hbaList);
			if($this->AlarmOn == ""){
				$this->AlarmOn = $hbaInfo->isAlarmOn();
			}
			if($this->AutoRebuildOn == ""){
				$this->AutoRebuildOn = $hbaInfo->isAutoRebuildOn();
			}
			if($this->BGARate == ""){
				$this->BGARate = $hbaInfo->getBGARate();
			}
			if($this->PollSMARTOn == ""){
				$this->PollSMARTOn = $hbaInfo->isPollSMARTOn();
			}
			if($this->MediaPatrolRate ==""){
				$this->MediaPatrolRate = $hbaInfo->getMediaPatrolRate();
			}
			if($this->CopyBack == ""){
				$this->CopyBack = $hbaInfo->getCopyBack();
			}
			if($this->SyncRate == ""){
				$this->SyncRate = $hbaInfo->getSyncRate();
			}
			if($this->InitRate == ""){
				$this->InitRate = $hbaInfo->getInitRate();
			}
			if($this->RebuildRate == ""){
				$this->RebuildRate = $hbaInfo->getRebuildRate();
			}
			if($this->MigrationRate == ""){
				$this->MigrationRate = $hbaInfo->getMigrationRate();
			}
			if($this->CopybackRate == ""){
				$this->CopybackRate = $hbaInfo->getCopybackRate();
			}
			if($this->InterruptCoalescing == ""){
				$this->InterruptCoalescing = $hbaInfo->getInterruptCoalescing();
			}		
			if($this->ModuleConsolidate == ""){
				$this->ModuleConsolidate = $hbaInfo->getModuleConsolidate();
			}		
			
		}
	}
	
	private function doSaveHBAConfig()
	{
		//$Rate = BGARate::PercentageToRate($this->BGARate);
		$Rate = $this->BGARate;
		
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_Adapter_SetConfig);
		$this->ApiCmd->setCommandPara("AdapterID",$this->HBAID);
		
		$this->ApiCmd->setCommandPara("AlarmOn",$this->AlarmOn);
		$this->ApiCmd->setCommandPara("AutoRebuildOn",$this->AutoRebuildOn);
		
		//BGA rate now is the same as mp rate
		$this->ApiCmd->setCommandPara("BGARate",$Rate);
		$this->ApiCmd->setCommandPara("PollSMARTStatus",$this->PollSMARTOn);
		$this->ApiCmd->setCommandPara("MediaPatrolRate",$this->MediaPatrolRate);
		$this->ApiCmd->setCommandPara("CopyBack",$this->CopyBack);
		//added 3-19
		$this->ApiCmd->setCommandPara("SyncRate",$this->SyncRate);
		$this->ApiCmd->setCommandPara("InitRate",$this->InitRate);
		$this->ApiCmd->setCommandPara("RebuildRate",$this->RebuildRate);
		$this->ApiCmd->setCommandPara("MigrationRate",$this->MigrationRate);
		$this->ApiCmd->setCommandPara("CopybackRate",$this->CopybackRate);	
		$this->ApiCmd->setCommandPara("InterruptCoalescing",$this->InterruptCoalescing);
		$this->ApiCmd->setCommandPara("ModuleConsolidate",$this->ModuleConsolidate);
		
		$this->ApiCmd->issueCommand();
		
		/*
		if ($this->ApiCmd->getResult()->RetVal . "") {
			$this->setHBACmdXmlRetFail();
			return ;
		}
		
		//this part can be separated to another new class.
		
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_SetDriverMode);
		$this->ApiCmd->setCommandPara("Mode",$this->SuspendMode);
		$this->ApiCmd->issueCommand();
		*/
		if ($this->ApiCmd->getResult()->RetVal . "") {
			$this->setHBACmdXmlRetFail();
		}
		else {
			$this->setHBACmdXmlRetSuccess();
		}
		
	}
	
	protected function doAction()
	{
		$this->doSaveHBAConfig();
	}
}
?>