<?php
class HBAInfo
{
	public $ID;
	public $DriverVersion;
	public $BIOSVersion;
	public $FirmwareVersion;
	public $BootLoaderVersion;
	public $SystemIOBusNumber;
	public $SlotNumber;
	public $BIOSVersionValid = 0;
	public $FirmwareVersionValid = 0;
	public $BootLoaderVersionValid = 0;
	public $DriverVersionValid = 0;
	
	public $VenID;
	public $SubVenID;
	public $DevID;
	public $SubDevID;
	
	public $RevisionID;
	
	public $InterruptLevel;
	public $InterruptVector;
	public $MaxPDPerVD;
	public $MaxPDPerDG;
	public $MaxVDPerDG;
	public $PortCount;
	public $PortSupportType;
	public $Features;
	public $AlarmSupport;
//	public $RAMSupport;
	public $MaxBlockPerPD;
	public $MaxHD;
	public $MaxExpander;
	public $MaxPM;
	public $MaxLogicalDrive;
	public $LogicalDriverMode;
	public $DiskGroupSupport;
	
	public $supportRAID;
	public $isSupportRAID5;
	public $supportRAIDModeStr;
	
	public $supportedStripeSizeStr;
	public $supportedVDCacheStr;

	//details
	public $AlarmOn;
	public $AutoRebuildOn;
	public $BGARate;
	public $MPRate = 1;
	public $PollSMARTOn = 0;
	//public $SuspendMode = 0;
	public $InterruptCoalescing;
	public $ModuleConsolidate;
	
	public $isOdin = 0;
	
	//added 3-19
	public $CopyBack; 
	public $SyncRate; 
	public $InitRate; 
	public $RebuildRate; 
	public $MigrationRate; 
	public $CopybackRate; 
	
	public $AdvancedFeatures;
	public $canChangeCfg = 1;//can change config both RAID and Non-RAID
	public $isSSDAdapter = 0;
	
	public $portSasAddress = array();
	public $serialNo;
	public $StripeSizeSupported;
	public $MaxSpeed;
	public $MaxSpeedStr;
	public $CurrentSpeed;
	public $CurrentSpeedStr;
	public $MaxLinkWidth;
	public $CurrentLinkWidth;
	public $supportPCIEStatus;
	public $ModelNumber;
	public $SSDCount;
	public $supportHyperHDD;
	public $supportHyperHDDStr;
    public $MaxSSDPerHyperDuo;
    //for oem lenovo
    public $PartNumber;
    public $WWN;
    public $CardSKU;
	
	public function setHBAInfo($HBA)
	{
		$this->ID = $HBA->getDeviceID();
		$this->DriverVersion = $HBA->getDriverVersion();
		$this->BIOSVersion = $HBA->getBIOSVersion();
		$this->FirmwareVersion = $HBA->getFirmwareVersion();
		$this->BootLoaderVersion = $HBA->getBootLoaderVersion();
		if (substr($this->BIOSVersion,0,strrpos("$this->BIOSVersion",".")) > 0){//if MajorVersion>0, display it
			$this->BIOSVersionValid = 1;
		}
		if (substr($this->FirmwareVersion,0,strrpos("$this->FirmwareVersion",".")) > 0){
			$this->FirmwareVersionValid = 1;
		}
		if (substr($this->BootLoaderVersion,0,strrpos("$this->BootLoaderVersion",".")) > 0){
			$this->BootLoaderVersionValid = 1;
		}
		if (substr($this->DriverVersion,0,strrpos("$this->DriverVersion",".")) > 0){
			$this->DriverVersionValid = 1;
		}
		$this->SystemIOBusNumber = $HBA->getSystemIOBusNumber();
		$this->SlotNumber = $HBA->getSlotNumber();
		
		$this->VenID = strtoupper(dechex($HBA->getVenID()));
		$this->SubVenID = strtoupper(dechex($HBA->getSubVenID()));
		$this->DevID = strtoupper(dechex($HBA->getDevID()));
		$this->SubDevID = strtoupper(dechex($HBA->getSubDevID()));
		$this->SubDevID = sprintf("%04d", intval($this->SubDevID ));
		$this->RevisionID = strtoupper(dechex($HBA->getRevisionID()));
		$this->InterruptLevel = $HBA->getInterruptLevel();
		$this->InterruptVector = $HBA->getInterruptVector();
		
		$this->MaxPDPerVD = $HBA->getMaxPDPerVD();
		$this->MaxPDPerDG = $HBA->getMaxPDPerDG();
		$this->MaxVDPerDG = $HBA->getMaxVDPerDG();
		
		$this->PortCount = $HBA->getPortCount();
		$this->PortSupportType = $HBA->getPortSupportType();
		$this->Features = $HBA->getFeatures();
		$this->AlarmSupport = $HBA->getAlarmSupport();
		
		//$this->RAMSupport = $HBA->getRAMSupport();
		$this->MaxBlockPerPD = $HBA->getMaxBlockPerPD();
		$this->MaxHD = $HBA->getMaxHD();
		$this->MaxExpander = $HBA->getMaxExpander();
		$this->MaxPM = $HBA->getMaxPM();
		$this->MaxLogicalDrive = $HBA->getMaxLogicalDrive();
		$this->LogicalDriverMode = $HBA->getLogicalDriverMode();
		$this->DiskGroupSupport = $HBA->getDiskGroupSupport();		
		
		$this->isSSDAdapter = $HBA->isSSDAdapter();		
		
		$this->supportRAID = $HBA->supportRAID();
		
		$this->supportHyperHDD = $HBA->supportLDRaidHyperHDD();
		//$str1
		$HyperHDDStr = ($HBA->supportHyperHDDSpan()?RAIDMode::HDDSPAN.", ":"") . ($HBA->supportHyperHDDMirror()?RAIDMode::HDDMirror.", ":"");
		$this->supportHyperHDDStr = substr($HyperHDDStr,0,strlen($HyperHDDStr)-2);
		
		if ($HBA->supportLDRaid0()) $this->supportRAIDModeStr .= "RAID0, ";
		if ($HBA->supportLDRaid1()) $this->supportRAIDModeStr .= "RAID1, ";
		if ($HBA->supportLDRaid10()) $this->supportRAIDModeStr .= "RAID10, ";
		if ($HBA->supportLDRaid1E()) $this->supportRAIDModeStr .= "RAID1E, ";
		if ($HBA->supportLDRaid5()) $this->supportRAIDModeStr .= "RAID5, ";
		if ($HBA->supportLDRaid50()) $this->supportRAIDModeStr .= "RAID50, ";
		if ($HBA->supportLDRaid6()) $this->supportRAIDModeStr .= "RAID6, ";
		if ($HBA->supportLDRaid60()) $this->supportRAIDModeStr .= "RAID60, ";
		if ($HBA->supportLDRaidJBOD()) $this->supportRAIDModeStr .= "JBOD, ";
		if ($HBA->supportHyperHDDSpan()) $this->supportRAIDModeStr .= RAIDMode::HDDSPAN_L . ", ";
		if ($HBA->supportHyperHDDMirror()) $this->supportRAIDModeStr .= RAIDMode::HDDMirror_L . ", ";

                $this->supportRAIDModeStr = trim($this->supportRAIDModeStr);
                $this->supportRAIDModeStr = substr($this->supportRAIDModeStr, 0, strlen($this->supportRAIDModeStr)-1);
		
		if ($HBA->supportStripeSize16()) $this->supportedStripeSizeStr .= "16K ";
		if ($HBA->supportStripeSize32()) $this->supportedStripeSizeStr .= "32K ";
		if ($HBA->supportStripeSize64()) $this->supportedStripeSizeStr .= "64K ";
		if ($HBA->supportStripeSize128()) $this->supportedStripeSizeStr .= "128K ";
		if ($HBA->supportStripeSize256()) $this->supportedStripeSizeStr .= "256K ";
		if ($HBA->supportStripeSize512()) $this->supportedStripeSizeStr .= "512K ";
		if ($HBA->supportStripeSize1024()) $this->supportedStripeSizeStr .= "1024K";
		
		if($HBA->supportVDReadCache() || $HBA->supportVDWriteCache())
		{
			if ($HBA->supportVDReadCache()) $this->supportedVDCacheStr .= "Read ";
			if ($HBA->supportVDWriteCache()) $this->supportedVDCacheStr .= "Write";
		}
		else
		{
			$this->supportedVDCacheStr .= "None";
		}
		
				
		$this->isSupportRAID5 = $HBA->supportLDRaid5();
		$this->isOdin = $HBA->getMaxExpander() != 0 ? 1 : 0;
		
		$this->AdvancedFeatures = $HBA->getAdvancedFeatures();
		$this->StripeSizeSupported = $HBA->getStripeSizeSupported();
		$this->MaxSpeed = $HBA->getMaxSpeed();
		$this->MaxSpeedStr = PCIESpeed::getPCIESpeedStr($this->MaxSpeed);
		$this->CurrentSpeed = $HBA->getCurrentSpeed();
		$this->CurrentSpeedStr = PCIESpeed::getPCIESpeedStr($this->CurrentSpeed);
		$this->CurrentLinkWidth = $HBA->getCurrentLinkWidth();
		$this->MaxLinkWidth = $HBA->getMaxLinkWidth();
		$this->supportPCIEStatus = $HBA->supportPCIEStatus();
		
		$this->ModelNumber = $HBA->getModelNumber();
		$this->SSDCount = $HBA->getSSDCount();
		
		//add sasaddresses and serialNo
		$this->serialNo = $HBA->getSerialNo();
		$sasAddr = $HBA->getPortSasAddr();
		
		foreach ($sasAddr as $id => $addr)
		{
			if ($addr->isValid()) 
			{
				if (isset($this->portSasAddress[$addr.""])) {
					$this->portSasAddress[$addr.""] .= "," . $id;
				}
				else 
				{
					$this->portSasAddress[$addr.""] = $id;
				}
			}
		}
		$this->MaxSSDPerHyperDuo = $HBA->getMaxSSDPerHyperDuo();
//for oem lenovo
        $this->PartNumber = $HBA->getPartNumber();
        $this->WWN = $HBA->getWWN();
        $this->CardSKU = $HBA->getCardSKU();
	}
	
	public function setHBADtl($HBA)
	{
		//config
		//if ($this->supportRAID) $this->canChangeCfg = 1;
		$this->AlarmSupport = $HBA->getAlarmSupport();
		$this->AlarmOn = $HBA->isAlarmOn();
		$this->AutoRebuildOn = $HBA->isAutoRebuildOn();
		$this->PollSMARTOn = $HBA->isPollSMARTOn();
		//$this->BGARate = BGARate::RateToPercentage($HBA->getBGARate());
		$this->BGARate =$HBA->getBGARate();
		$this->InterruptCoalescing = $HBA->getInterruptCoalescing();
		$this->ModuleConsolidate = $HBA->getModuleConsolidate();
		
		//added 3-19 for 4 rate		
		$this->SyncRate =$HBA->getSyncRate();
		$this->InitRate =$HBA->getInitRate();
		$this->RebuildRate =$HBA->getRebuildRate();
		$this->MigrationRate =$HBA->getMigrationRate();

		$this->CopyBack =$HBA->getCopyBack();
		$this->CopybackRate =$HBA->getCopybackRate();
		$this->MPRate =$HBA->getMediaPatrolRate();
		
		//bga rate is the same as MP rate
		/*
		if ($HBA->getMediaPatrolRate() == null) 
		{
			$this->MPRate = 1;
		}
		else 
		{
			$this->MPRate = $HBA->getMediaPatrolRate();
		}
		*/
		//$this->SuspendMode  = $HBA->isSuspendModeOn();
	}
}
?>