<?php
class SSDAdapterInfo {
    public $ID;
    public $OEMID;
    public $Model;
    public $SerialNo;
    public $SectorSize;
    public $FlashSize;
    public $MaxPartitionsSupport;
    public $PCIeSpeed;
    public $PCIeSpeedStr;
    public $PCIeLinkWidth;
    public $NumberOfCE;
    public $NANDFlashID;
    public $NANDType;
    public $NANDTypeStr;
    public $NANDSize;
    public $CurrentTimingMode;
    public $CurrentTimingModeStr;
    public $MaxSyncTimingMode;
    public $MaxAsyncTimingMode;
    public $MuiltiPlane;
    public $MuiltiPlaneStr;
    public $MuiltiLUN;
    public $MuiltiLUNStr;
    public $EccCurrectionPower;
    public $PagesPerBlock;
    public $SpareSize;
    public $PageSize;
    public $MaxBadBlocks;
    public $NumberOfWERU;
    
    public $max_partitions;
    public $num_partitions;
    public $features;
    public $featuresStr;
    public $nr_channel;
    public $endurance;
    public $bit_per_cell;
    public $FirmwareVersion;
    public $FirmwareVersionValid=0;
    public $needReboot=0;

    public function setSSDAdapterInfo($info) {
        $this->ID = $info->getDeviceID();
        $this->OEMID = $info->get_oem_id();//strtoupper(dechex());
        $this->Model = $info->get_model_name();
        $this->SerialNo = $info->get_serial_num();
        $this->SectorSize = $info->get_sector_size();
        $this->FlashSize = FormatSize($info->get_size());
        //$this->MaxPartitionsSupport
        $this->PCIeSpeed = $info->get_pci_speed();
        if ($this->PCIeSpeed == 1)
            $this->PCIeSpeedStr = "GEN 1 (2.5 Gbps)";
        else if ($this->PCIeSpeed == 2)
            $this->PCIeSpeedStr = "GEN 2 (5.0 Gbps)";
        else
            $this->PCIeSpeedStr = "Unknown";

        $this->PCIeLinkWidth = "x" . $info->get_pci_width();
        //$this->NumberOfCE = $info->();
        $this->NANDFlashID = $info->get_flash_id();
        $this->NANDType = $info->get_nand_type();
        $this->bit_per_cell = $info->get_bit_per_cell();

        $this->NANDTypeStr = $this->getNANDTypeStr();

        $this->NANDSize = $info->get_total_space_in_gbit();
        $this->CurrentTimingMode = $info->get_timing_mode();

        if ($this->CurrentTimingMode & 0x10)
            $this->CurrentTimingModeStr =  "Sync ";
        else
            $this->CurrentTimingModeStr =  "Async ";
        $this->CurrentTimingModeStr .= $this->CurrentTimingMode & 0xf;

        $this->MaxSyncTimingMode = $info->get_max_sync_timing_mode();
        $this->MaxAsyncTimingMode = $info->get_max_async_timing_mode();
        $this->MuiltiPlane = $info->get_nr_plane();
        $this->MuiltiPlaneStr = (($this->MuiltiPlane & 0x10) ? "Enabled" : "Disabled") . ", " . ($this->MuiltiPlane & 0xf) . " plane(s)";
        $this->MuiltiLUN = $info->get_nr_lun();
        $this->MuiltiLUNStr = (($this->MuiltiLUN & 0x10) ? "Enabled" : "Disabled") . ", " . ($this->MuiltiLUN & 0xf) . " LUN(s)";
        $this->EccCurrectionPower = $info->get_ecc_power();
        $this->PagesPerBlock = $info->get_nr_page_per_block();
        $this->SpareSize = $info->get_spare_sz();
        $this->PageSize = $info->get_page_sz();
        $this->MaxBadBlocks = $info->get_nr_bad_blocks_max();
        $this->NumberOfWERU = $info->get_nr_weru();

        $this->max_partitions = $info->get_max_partitions();
        $this->num_partitions = $info->get_num_partitions();
        $this->features = $info->get_features();
        $this->featuresStr = SSDAdapterFeatures::getStatusStr($this->features);
        $this->nr_channel = $info->get_nr_channel();
        $this->endurance = $info->get_endurance();
        $this->FirmwareVersion = $info->getFirmwareVersion();
        if (substr($this->FirmwareVersion,0,strrpos("$this->FirmwareVersion",".")) > 0) {
            $this->FirmwareVersionValid = 1;
        }
        $this->needReboot = $info->needReboot();
    }

    private function getNANDTypeStr()
    {
        $str = "";
        if (($this->bit_per_cell & 0xF) == 0){
		$str = "SLC, ";
	}
	else{
		$str = "MLC (" . $this->bit_per_cel . " bits per cell), ";
	}


	$mode = ($this->NANDType >> 4) & 0xF;
	if ((($this->NANDType >> 4) & 0xF) == 0){
		$str .= "CONVENTIONAL, ASYNC, ";
	}
	else{
		if ($this->NANDType & 0x10){
			$str .= "JEDEC, ";
		}
		if ($this->NANDType & 0x20){
			$str .= "TOGGLE, ";
		}
		if ($this->NANDType & 0x40){
			$str .= "ONFI, ";
		}
		if ($this->NANDType & 0x80){
			$str .= "SYNC, ";
		}
		else{
			$str .= "ASYNC, ";
		}
	}

	$nandManufacture = array("MICRON", "SAMSUNG", "TOSHIBA", "HYNIX", "Unknown Manufacture");

	$nandManufactureIdx = $this->NANDType & 0xF;
	if ($nandManufactureIdx >= 4){
		$nandManufactureIdx = 4;
	}
	$str .= $nandManufacture[$nandManufactureIdx];

        return $str;
    }
    
}
?>
