<?php
include_once("Device.class.php");

abstract class SASDevice extends Device 
{
	private $SASAddr;
	private $SMPSupport;
	private $SSPSupport;
	private $STPSupport;
	
	private $ParentSASAddr;
	
	public function getParentSASAddr()
	{
		return $this->ParentSASAddr;
	}
	
	public function getSASAddr()
	{
		return $this->SASAddr;
	}
	
	public function supportSMP()
	{
		return $this->SMPSupport;
	}
	
	public function supportSSP()
	{
		return $this->SSPSupport;
	}
	
	public function supportSTP()
	{
		return $this->STPSupport;
	}
	
	private function setSASInfo($LinkXML)
	{
		foreach ($LinkXML->Self as $SelfInfo)
		{
			$this->setSelfSASInfo($SelfInfo);	
		}
		foreach ($LinkXML->Parent as $ParentInfo)
		{
			$this->setParentSASInfo($ParentInfo);
		}
	}
	
	private function setParentSASInfo($ParentInfo)
	{
		if (isset($ParentInfo->SAS_Address)) {
			$this->ParentSASAddr = $this->FormSASAddress($ParentInfo->SAS_Address);
		}
	}
	
	private function setSelfSASInfo($SelfInfo)
	{
		if (isset($SelfInfo->SAS_Address)) {
			$this->SASAddr = $this->FormSASAddress($SelfInfo->SAS_Address);
		}
	}
	
	private function FormSASAddress($addr)
	{
		$sas = explode(' ', trim($addr), 8);
		return sprintf("%02X%02X%02X%02X%02X%02X%02X%02X", $sas[0], $sas[1],$sas[2],$sas[3],$sas[4],$sas[5],$sas[6],$sas[7]);
	}
	
	public function setTopologyLink($LinkXML)
	{
		$this->setSASInfo($LinkXML);
		parent::setTopologyLink($LinkXML);
	}
}
?>