<?php
class CtnAcceleratorAppDisplayer extends CtnAcceleratorStatusDisplayer {
    protected function initPage() {
        $smarty = $this->smarty;

        $hasOperationRunning = 0;

        $noValidVolume = 0;
        $volList = new CtnAccelerateVolumeList();//Hyper HDD Volumes
        $volList->smartyAssign($smarty);
        $volList->initContainer();
        $vols = $volList->getInfos();
        if (sizeof($vols) == 0) {
            $noValidVolume = 1;
            $smarty->assign("noValidVolume", 1);
        } else {
            $DefaultVolume = array_shift($vols);

            $this->handlerAppStatusByVol($DefaultVolume->DisplayVolumeName);
            $appList = array();
            foreach ($this->applications as $app) {
                $appInfo = new ApplicationInfo();
                $appInfo->setRunningStatus($this->accStatus->isDefragging());
                $appInfo->setApplicationListInfo($app);
                $appList[] = $appInfo;
            }

            $smarty->assign("appList", $appList);
            $smarty->assign("appCount", sizeof($appList));
            $smarty->assign("noApp", (sizeof($appList)==0)?1:0);

            //get fixed size, if has no valid volume, no need to caculate size
            $appDA = new ApplicationDataAccess();
            $fixedApps = $appDA->findByType(AppType::TYPE_FIXED);
            $fixedSize = 0;
            $fixedAccedSize = 0;
            foreach ($fixedApps as $app) {
                $fixedSize += intval($app->getTotalSize());
            }

            $isRebuildingVolume = $DefaultVolume->isRebuilding;
            $this->hasOperationRunning |= $isRebuildingVolume;
            
            $smarty->assign("isRebuildingVolume", $isRebuildingVolume);
            $smarty->assign("hasOperationRunning", $this->hasOperationRunning);

            $this->smarty->assign("DefaultVolume",$DefaultVolume);
        }

        $disableAcc = $this->hasOperationRunning || $noValidVolume;
        $smarty->assign("disableAcc", $disableAcc); //disable auto/fix/submit

        $this->setPageName("XML_Accelerator_App.tpl");
    }
}

?>