<?php
//include_once("PageDisplayer.class.php");

class PgCreateVdOnDgDisplayer extends PageDisplayer
{
	protected function initPage()
	{

		if(!getSessionPara('isAdmin'))
		{
			$this->displayDefaultPage(Target::getSystemSubPage);
			return;
		}
		
		$smarty = $this->smarty;
		
		//get request para
		$DG_ID = getRequestPara('ID');
		$CancelAlert = gettext(AlertMsg::CREATE_CANCEL)."?";
		
		$container = new CtnDgDetail();
		$container->setAdapterID($this->getAdapterID());		
		$container->setDGID($DG_ID);		
		$container->toGetDgInfo();
		$container->toGetDGConfig();
		$container->toGetDgLDInfo();
		$container->smartyAssign($smarty);
		$container->initContainer();
		$dg = $container->getBase()->getBaseDetail();
		
		if(!$dg){
			$this->displayDefaultPage(Target::getSystemSubPage);
			return;
		}
		
		$RaidMode = $dg->getRaid_Level();
		$RaidModeStr = RAIDMode::GetRAIDModeStr($RaidMode);
		//$ArrayRemainingSize = ConvertSize($dg->getRemainingSize());
		//$ArrayRemainingSizeGB = FormatSize($dg->getRemainingSize());
		
		//set default name
	/*	if (trim($LDName) == "") {
			include_once("../phpsrc/baseclass/LdList.class.php");
			$ldlist = new LDList();
			$ldlist->toGetLDInfo();
			$ldlist->initData();
			$count = sizeof($ldlist->getBaseClasses()) + 1;
			$RaidType = "";
			switch ($RaidMode)
			{
				case RAIDMode::LD_MODE_RAID0 : $RaidType = "R0"; break;
				case RAIDMode::LD_MODE_RAID1 : $RaidType = "R1"; break;
				case RAIDMode::LD_MODE_RAID1E : $RaidType = "R1E"; break;
				case RAIDMode::LD_MODE_RAID5 : $RaidType = "R5"; break;
				case RAIDMode::LD_MODE_RAID6 : $RaidType = "R6"; break;
				case RAIDMode::LD_MODE_JBOD : $RaidType = "JBOD"; break;
				case RAIDMode::LD_MODE_RAID10 : $RaidType = "R10"; break;
				case RAIDMode::LD_MODE_RAID50 : $RaidType = "R50"; break;
				case RAIDMode::LD_MODE_RAID60 : $RaidType = "R60"; break;
			}
			$LDName = "VD_" . $RaidType ."_" .$count;
		}
		
		//default raid mode
		if ($RaidMode == null) {
			$RaidMode = RAIDMode::LD_MODE_RAID1 ;
		}
		
		if ($StripeSize == null) {
			$StripeSize = LDStripeSize::StripeSize64K ;
		}
			*/
	
		$sysFeature = AdapterFeature::getInstance($this->getAdapterID());
		
    	$quickInit = gettext(LdBgaStatus::LD_BGA_INIT_QUICK_STR);
    	$bgInit = gettext(LdBgaStatus::LD_BGA_INIT_BACK_STR);
    	$fgInit = gettext(LdBgaStatus::LD_BGA_INIT_FORE_STR);
    	$noInit = gettext("No Initialization");
    	
    	$InitOption1 = array(InitType::INIT_QUICK=>$quickInit);
    	$InitOption2 = array(InitType::INIT_NONE =>$noInit);
    	$InitOption3 = array(InitType::INIT_FULLBACKGROUND =>$bgInit);
    	$InitOption4 = array(InitType::INIT_FULLFOREGROUND =>$fgInit);
    	
		if ($sysFeature->supportForegroundInit || $sysFeature->supportBackgroundInit){
			$InitOptions = $InitOption2 + $InitOption1;
			
			if ($RaidMode != RAIDMode::LD_MODE_RAID0) {//Raid0 can only do quick/none
			
				if ($sysFeature->supportForegroundInit) {
					$InitOptions += $InitOption4;
				}
				if ($sysFeature->supportBackgroundInit) {
					$InitOptions += $InitOption3;
				}
				
			}
			$smarty->assign("enableInitOptions",1);
		}else{ //do not support, eg.Magni, disable init options
			$InitOptions = $InitOption2;
			$smarty->assign("enableInitOptions",0);
		}

		include_once("../phpsrc/action/GetCreateDefaultVal.class.php");
		$cmd = new GetCreateDefaultVal();
		$cmd->smartyAssign($smarty);
		$cmd->setAdapterID($this->getAdapterID());
		$cmd->setCreateDefaultVal();

		$defaultWriteCache = $cmd->getDefaultWriteCache();
		$defaultReadCache = $cmd->getDefaultReadCache();
                
		$WriteCache = $defaultWriteCache ;
		$ReadCache = $defaultReadCache ;
		
		//write cache
		$wBack = gettext(LDCacheMode::WRITEBACK_ENABLE_STR );
	    $wThru = gettext(LDCacheMode::WRITETHRU_ENABLE_STR );
	    $wAdaptive = gettext(LDCacheMode::AUTO_ENABLE_STR );
    	    
		$wCacheOptions = 
			array(
				LDCacheMode::WRITEBACK_ENABLE=>$wBack,
				LDCacheMode::WRITETHRU_ENABLE =>$wThru  //default value
			);

		if (!$sysFeature->supportVDWriteCache){
			$smarty->assign("writeCacheDisabled",1);
		}

        $bbuCtn = new CtnBBUDetail();
        $bbuCtn->setAdapterID($this->getAdapterID());
        $bbuCtn->toGetBBUInfo();
        $bbuCtn->smartyAssign($smarty);
        $bbuCtn->initContainer();
        $bbu = $bbuCtn->getInfos();//for bug #906

		if ($sysFeature->supportAdaptiveCache && $bbu) {
			$wCacheOptions[LDCacheMode::AUTO_ENABLE] = $wAdaptive;
		}
		
		//read cache	
    	$rAhead = gettext(LDCacheMode::LOOKAHEAD_ENABLE_STR );
    	$rNone = gettext(LDCacheMode::NO_LOOKAHEAD_STR );

		if ($sysFeature->supportVDReadCache){
		$rCacheOptions = 
			array(
				0 =>$rNone,
				LDCacheMode::LOOKAHEAD_ENABLE =>$rAhead   //default value
			);
		}else{
			$rCacheOptions =
				array(
					0 =>$rNone            //if not support, default "no read ahead" and disable select
				);
			$smarty->assign("readCacheDisabled",1);

		}
        
		//read cache	
    	$None = gettext("None");
   	
		$GBRoundingOptions = 
			array(
				Rounding_Scheme::ROUNDING_SCHEME_NONE  => $None, 
				Rounding_Scheme::ROUNDING_SCHEME_1GB  => "1G", //default value 
				Rounding_Scheme::ROUNDING_SCHEME_10GB   => "10G"
			);

/*		if ($RaidMode == RAIDMode::LD_MODE_RAID50
			 || $RaidMode == RAIDMode::LD_MODE_RAID5 
			 || $RaidMode == RAIDMode::LD_MODE_RAID6 
			 || $RaidMode == RAIDMode::LD_MODE_RAID60 )
		{
			$stripeOptions = 
				array(
					LDStripeSize::StripeSize64K =>LDStripeSize::StripeSize64KStr
				);	
		}
		else {
			$stripeOptions = 
				array(
					LDStripeSize::StripeSize16K =>LDStripeSize::StripeSize16KStr,
					LDStripeSize::StripeSize32K =>LDStripeSize::StripeSize32KStr,
					LDStripeSize::StripeSize64K =>LDStripeSize::StripeSize64KStr,
					LDStripeSize::StripeSize128K =>LDStripeSize::StripeSize128KStr,
					LDStripeSize::StripeSize256K =>LDStripeSize::StripeSize256KStr,
					LDStripeSize::StripeSize512K =>LDStripeSize::StripeSize512KStr,
					LDStripeSize::StripeSize1024K =>LDStripeSize::StripeSize1024KStr 
				);
		//}
		
		$sectorOptions = 
			array(
				LDSectorSize::SectorSize512B =>LDSectorSize::SectorSize512BStr,
				LDSectorSize::SectorSize1024B =>LDSectorSize::SectorSize1024BStr,
				LDSectorSize::SectorSize2048B =>LDSectorSize::SectorSize2048BStr,
				LDSectorSize::SectorSize4096B =>LDSectorSize::SectorSize4096BStr
			);
			$smarty->assign("sectorOptions",$sectorOptions);
*/
		//get info for sub btns
		/*$stripeOptions1 = 
			array(
				LDStripeSize::StripeSize16K =>LDStripeSize::StripeSize16KStr,
				LDStripeSize::StripeSize32K =>LDStripeSize::StripeSize32KStr,
				LDStripeSize::StripeSize64K =>LDStripeSize::StripeSize64KStr,
				LDStripeSize::StripeSize128K =>LDStripeSize::StripeSize128KStr
			);
			
		$stripeOptions2 = 
			array(
				LDStripeSize::StripeSize256K =>LDStripeSize::StripeSize256KStr,
				LDStripeSize::StripeSize512K =>LDStripeSize::StripeSize512KStr,
				LDStripeSize::StripeSize1024K =>LDStripeSize::StripeSize1024KStr 
			);*/

		$hba = HBAFactory::getInstance($this->getAdapterID());
		
		$stripeOptions = array();
	
		if ($hba->supportStripeSize16()){
			$stripeOptions[LDStripeSize::StripeSize16K] = LDStripeSize::StripeSize16KStr;
		}
		if ($hba->supportStripeSize32()){
			$stripeOptions[LDStripeSize::StripeSize32K] = LDStripeSize::StripeSize32KStr;
		}
		if ($hba->supportStripeSize64()){
			$stripeOptions[LDStripeSize::StripeSize64K] = LDStripeSize::StripeSize64KStr;
		}
		if ($hba->supportStripeSize128()){
			$stripeOptions[LDStripeSize::StripeSize128K] = LDStripeSize::StripeSize128KStr;
		}
		if ($hba->supportStripeSize256()){
			$stripeOptions[LDStripeSize::StripeSize256K] = LDStripeSize::StripeSize256KStr;
		}
		if ($hba->supportStripeSize512()){
			$stripeOptions[LDStripeSize::StripeSize512K] = LDStripeSize::StripeSize512KStr;
		}
		if ($hba->supportStripeSize1024()){
			$stripeOptions[LDStripeSize::StripeSize1024K] = LDStripeSize::StripeSize1024KStr;
		}
	/*	if (! $hba->supportBigStripe()) {//$hba->advancedStripe TODO
			$stripeOptions = $stripeOptions1;
		} else {
			$stripeOptions = ($stripeOptions1 + $stripeOptions2);
		}*/
		
		$smarty->assign("DGID", $DG_ID);
		$smarty->assign("HBAID", $this->getAdapterID());
		$smarty->assign("InitOptions",$InitOptions);
		$smarty->assign("wCacheOptions",$wCacheOptions);
		$smarty->assign("rCacheOptions",$rCacheOptions);
		$smarty->assign("WriteCache", $WriteCache);
		$smarty->assign("ReadCache", $ReadCache);
		$smarty->assign("stripeOptions",$stripeOptions);
		$smarty->assign("GBRoundingOptions",$GBRoundingOptions);
			
		//$smarty->assign("ArrayRemainingSize", $ArrayRemainingSize);
		//$smarty->assign("ArrayRemainingSizeGB", $ArrayRemainingSizeGB);
		$smarty->assign("ArrayRaidMode", $RaidModeStr);	
		$smarty->assign("CancelAlert", $CancelAlert);
		
		$this->setPageName(Target::CreateVdOnDgPage . ".tpl");
	}
}
?>