<?php
//include_once("PageDisplayer.class.php");

class PgMigrateDisplayer extends BGAPageDisplayer
{
	protected function setDisplayInfo()
	{
		if ($this->cmdPara != null) {
			$HDs = getUrlPropertyValue($this->cmdPara,'HDs');
			$RaidMode = getUrlPropertyValue($this->cmdPara,'RaidMode');
			$NumOfParityDisk = getUrlPropertyValue($this->cmdPara,'NumOfParityDisk');
			
			$HDs = explode(' ',$HDs);
			
			$this->smarty->assign('SelectedHDs',$HDs);
			$this->smarty->assign('RaidMode',$RaidMode);
			$this->smarty->assign('NumOfParityDisk',$NumOfParityDisk);
		}

		$this->setPageName(Target::MigratePage . ".tpl");
		$this->smarty->assign("ScheduledBgaType",ScheduledBGAType::LD_BGA_MIGRATION);
	}
	
	protected function setInfo()
	{
		$smarty = $this->smarty;
		
		$ID = getRequestPara('ID');
		
		if ($ID == null) {
			$this->displayDefaultPage(Target::getSystemSubPage);
			return;
		}
		
		$container = new CtnLdDetail();
		$container->setAdapterID($this->getAdapterID());
		$container->setLDID($ID);
		$container->toGetLDInfo();
		$container->toGetHdInfo();
		$container->toGetBlockInfo();
		$container->smartyAssign($smarty);
		$container->initContainer();
		
		$ldlst = $container->getBase()->getBaseClasses();
		if (!sizeof($ldlst)) {
			//this VD not exist
			/*
			if ($type == 'saveModify') {
				$this->displayDefaultPage(Target::BgaSchedulePage);
			}
			else
			{
				//check for LD does not exist
				$this->displayDefaultPage(Target::LdListPage);
			}
			return;
			*/
			$VDnotExist = new LDInfo();
			$VDnotExist->ID = gettext('Not Exist');
			$VDnotExist->SizeGB = '';
			$VDnotExist->RaidMode = '';
			$smarty->assign('ldInfo',$VDnotExist);
			$smarty->assign('VDNotExist',1);
		}
		else {
			$ldDetail = array_shift($ldlst);
			$blklst = $ldDetail->getBlockList();
			
			if ($blklst) {
				$hds = array();
				foreach ($blklst as $aBlk)
				{
					$aHd = $aBlk->belongHD();
					$hds[] = $aHd;
				}
				
				$blk = array_shift($blklst);
				$blkSize = $blk->getSize();			
								
				if ($hds) {
					$filter = new HdMigrateFilter($blkSize, $hds);
					
					$hdList = new CtnHdList();
					$hdList->setAdapterID($this->getAdapterID());
					$hdList->toGetHDInfo();
					$hdList->toGetValidSize();
					$hdList->toGetSpareInfo();
					$hdList->toGetHdFreeInfo();
					$hdList->setFilter($filter);
					$hdList->smartyAssign($smarty);
					$hdList->initContainer();
				}
				
				$HBAInfo = new HBADetail();
				$HBAInfo->setID($this->getAdapterID());
				$HBAInfo->toGetHBAInfo();
				$HBAInfo->initData();
				
				$hbalst = $HBAInfo->getBaseClasses();
				if ($hbalst) {
					$hba = array_shift($hbalst);
					//raid mode can be migrated to
					$this->setMigrateRaidModes($hba,$ldDetail);
				}
			}
		}
			
    	$CancelAlert = gettext(AlertMsg::MIGRATE_CANCEL)."?";
    	$smarty->assign("CancelAlert",$CancelAlert);
		$smarty->assign("ID", $ID);
    	$smarty->assign("HBAID",$this->getAdapterID());
	}
	
	protected function setMigrateRaidModes($hba,$ldDetail)
	{
		$supportRaids = array();
		//raid 0 can be migrated to all raid level
		//Allows migrate to the same or higher redundant mode only (if source VD is not RAID50 or RAID60). 
		//For example, RAID1 to RAID5 is okay but not vice versa.  Treat RAID10 and RAID1E as RAID1. 
		//raid 50 and raid 60 can not do migration now
		//the following are migration support table
		/*
		            	From
		 TO				JBOD   Raid0 Raid1/1E Raid10   Raid5  Raid50  Raid6 Raid60             
		 JBOD            No     No    No       No       No     No      No    No                
		 Raid0           No     Yes   No       No       No     No      No    No                
		 Raid1/1E        No     Yes   Yes      Yes      No     No      No    No                
		 Raid10          No     Yes   Yes      Yes      No     No      No    No                
		 Raid5           No     Yes   Yes      Yes      Yes    No      No    No                
		 Raid50          No     Yes   Yes      Yes      Yes    No      No    No                
		 Raid6           No     Yes   Yes      Yes      Yes    No      Yes   No                
		 Raid60          No     Yes   Yes      Yes      Yes    No      Yes   No    
		*/
		if ($ldDetail->getRaid_Level() == RAIDMode::LD_MODE_RAID0) {
			if ($hba->supportLDRaid0()) {
				$supportRaids[RAIDMode::LD_MODE_RAID0] = RAIDMode::RAID0;
			}
	/*		if ($hba->supportLDRaid1()) {
				$supportRaids[RAIDMode::LD_MODE_RAID1] = RAIDMode::RAID1;
			}*/ //R0 should can not migrate to R1
			if ($hba->supportLDRaid10()) {
				$supportRaids[RAIDMode::LD_MODE_RAID10] = RAIDMode::RAID10;
			}
			if ($hba->supportLDRaid1E()) {
				$supportRaids[RAIDMode::LD_MODE_RAID1E] = RAIDMode::RAID1E;
			}
			if ($hba->supportLDRaid5()) {
				$supportRaids[RAIDMode::LD_MODE_RAID5] = RAIDMode::RAID5;
			}
			if ($hba->supportLDRaid50()) {
				$supportRaids[RAIDMode::LD_MODE_RAID50] = RAIDMode::RAID50;
			}
			if ($hba->supportLDRaid6()) {
				$supportRaids[RAIDMode::LD_MODE_RAID6] = RAIDMode::RAID6;
			}
			if ($hba->supportLDRaid60()) {
				$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
			}
		}
		else if ($ldDetail->getRaid_Level() == RAIDMode::LD_MODE_RAID1) 
		{
//			if ($hba->supportLDRaid1()) {
//				$supportRaids[RAIDMode::LD_MODE_RAID1] = RAIDMode::RAID1;
//			}//R1 should can not migrate to R1, for the original member disks can not remove
			if ($hba->supportLDRaid10()) {
				$supportRaids[RAIDMode::LD_MODE_RAID10] = RAIDMode::RAID10;
			}
			if ($hba->supportLDRaid1E()) {
				$supportRaids[RAIDMode::LD_MODE_RAID1E] = RAIDMode::RAID1E;
			}
			if ($hba->supportLDRaid5()) {
				$supportRaids[RAIDMode::LD_MODE_RAID5] = RAIDMode::RAID5;
			}
			if ($hba->supportLDRaid50()) {
				$supportRaids[RAIDMode::LD_MODE_RAID50] = RAIDMode::RAID50;
			}
			if ($hba->supportLDRaid6()) {
				$supportRaids[RAIDMode::LD_MODE_RAID6] = RAIDMode::RAID6;
			}
			if ($hba->supportLDRaid60()) {
				$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
			}
		}
		else if ($ldDetail->getRaid_Level() == RAIDMode::LD_MODE_RAID10) 
		{
			if ($hba->supportLDRaid10()) {
				$supportRaids[RAIDMode::LD_MODE_RAID10] = RAIDMode::RAID10;
			}
			if ($hba->supportLDRaid1E()) {
				$supportRaids[RAIDMode::LD_MODE_RAID1E] = RAIDMode::RAID1E;
			}
			if ($hba->supportLDRaid5()) {
				$supportRaids[RAIDMode::LD_MODE_RAID5] = RAIDMode::RAID5;
			}
			if ($hba->supportLDRaid50()) {
				$supportRaids[RAIDMode::LD_MODE_RAID50] = RAIDMode::RAID50;
			}
			if ($hba->supportLDRaid6()) {
				$supportRaids[RAIDMode::LD_MODE_RAID6] = RAIDMode::RAID6;
			}
			if ($hba->supportLDRaid60()) {
				$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
			}
		}
		else if ($ldDetail->getRaid_Level() == RAIDMode::LD_MODE_RAID1E) 
		{
			if ($hba->supportLDRaid1E()) {
				$supportRaids[RAIDMode::LD_MODE_RAID1E] = RAIDMode::RAID1E;
			}
			if ($hba->supportLDRaid10()) {
				$supportRaids[RAIDMode::LD_MODE_RAID10] = RAIDMode::RAID10;
			}
			if ($hba->supportLDRaid5()) {
				$supportRaids[RAIDMode::LD_MODE_RAID5] = RAIDMode::RAID5;
			}
			if ($hba->supportLDRaid50()) {
				$supportRaids[RAIDMode::LD_MODE_RAID50] = RAIDMode::RAID50;
			}
			if ($hba->supportLDRaid6()) {
				$supportRaids[RAIDMode::LD_MODE_RAID6] = RAIDMode::RAID6;
			}
			if ($hba->supportLDRaid60()) {
				$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
			}
		}
		else if ($ldDetail->getRaid_Level() == RAIDMode::LD_MODE_RAID5) 
		{
			if ($hba->supportLDRaid5()) {
				$supportRaids[RAIDMode::LD_MODE_RAID5] = RAIDMode::RAID5;
			}
			if ($hba->supportLDRaid50()) {
				$supportRaids[RAIDMode::LD_MODE_RAID50] = RAIDMode::RAID50;
			}
			if ($hba->supportLDRaid6()) {
				$supportRaids[RAIDMode::LD_MODE_RAID6] = RAIDMode::RAID6;
			}
			if ($hba->supportLDRaid60()) {
				$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
			}
		}
		else if ($ldDetail->getRaid_Level() == RAIDMode::LD_MODE_RAID6) 
		{
			if ($hba->supportLDRaid6()) {
				$supportRaids[RAIDMode::LD_MODE_RAID6] = RAIDMode::RAID6;
			}
			if ($hba->supportLDRaid60()) {
				$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
			}
		}
		else if ($ldDetail->getRaid_Level() == RAIDMode::LD_MODE_RAID50) 
		{
			if ($hba->supportLDRaid50()) {
				$supportRaids[RAIDMode::LD_MODE_RAID50] = RAIDMode::RAID50;
			}
			if ($hba->supportLDRaid6()) {
				$supportRaids[RAIDMode::LD_MODE_RAID6] = RAIDMode::RAID6;
			}
			if ($hba->supportLDRaid60()) {
				$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
			}
		}
		else if ($ldDetail->getRaid_Level() == RAIDMode::LD_MODE_RAID60) 
		{
			if ($hba->supportLDRaid60()) {
				$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
			}
		}
		$this->smarty->assign("supportRaids", $supportRaids);
	}
}
?>