/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.calibration;

import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.calibration.AlsCalibrationEditorDialog;
import pdtEditor.gui.calibration.CalibrationEditor;
import pdtEditor.gui.calibration.CalibrationEditorOpener;
import pdtEditor.gui.calibration.VendorCalibrationGroup;
import pdtEditor.payloads.calibrations.AlsCalibrationPayload;
import resources.DoubleHolder;

public class AlsCalibrationEditor
implements CalibrationEditor {
    private static final int MINIMUM_FORMAT_FOR_MULTIPLIER = 1;
    private static final int DOUBLE_PRECISION = 2;
    protected Shell shlEditCalibration;
    private Text txtFormatID;
    private Display display;
    private CalibrationEditorOpener _parent = null;
    private boolean _modified = false;
    private AlsCalibrationPayload _data = null;
    private Sensor _sensor = null;
    private Table table;
    private Button btnEdit;
    private Button btnDelete;
    private DoubleHolder txtMultiplier;
    private Label lblMultiplierNote;
    private Button btnUpgradeToLatest;
    private Button btnAddNew;
    private Label lblMultiplier;
    private ArrayList<Byte> _tempVendorData = null;
    private VendorCalibrationGroup vendorCalibrationGroup;

    public static void main(String[] args) {
        try {
            AlsCalibrationEditor window = new AlsCalibrationEditor(null, null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AlsCalibrationEditor(CalibrationEditorOpener parent, AlsCalibrationPayload data, Sensor sensor) {
        this._parent = parent;
        this._data = data;
        this._sensor = sensor;
    }

    @Override
    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlEditCalibration.open();
        this.shlEditCalibration.layout();
        while (!this.shlEditCalibration.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    @Override
    public String getCalibrationFormatName() {
        return "Intel Ambient Light Calibration";
    }

    public void refreshButtonsEnablement() {
        if (this.table.getItemCount() >= AlsCalibrationPayload.MAX_NUMBER_OF_STEPS) {
            this.btnAddNew.setEnabled(false);
        } else {
            this.btnAddNew.setEnabled(true);
        }
        if (this.table.getSelectionCount() == 1) {
            this.btnEdit.setEnabled(true);
        } else {
            this.btnEdit.setEnabled(false);
        }
        this.btnDelete.setEnabled(this.table.getSelectionCount() > 0);
    }

    public void editSelectedStep() {
        if (this.table.getSelectionCount() > 1) {
            return;
        }
        int selectionIndex = this.table.getSelectionIndex();
        if (selectionIndex >= 0) {
            new AlsCalibrationEditorDialog(this, Integer.valueOf(this.table.getItem(selectionIndex).getText(0)), Integer.valueOf(this.table.getItem(selectionIndex).getText(1))).open();
        } else {
            new AlsCalibrationEditorDialog(this).open();
        }
    }

    public void saveData() {
        AlsCalibrationPayload data;
        boolean newCalibration = false;
        if (this._data == null) {
            data = new AlsCalibrationPayload();
            newCalibration = true;
        } else {
            data = this._data.clone();
        }
        data.setFormatID(Integer.valueOf(this.txtFormatID.getText()));
        try {
            double multiplier = this.txtMultiplier.getValue();
            if (multiplier < 0.0) {
                throw new NumberFormatException();
            }
            data.setMultiplier(multiplier);
        }
        catch (NumberFormatException e) {
            MessageBox messageBox = new MessageBox(this.shlEditCalibration, 33);
            messageBox.setText("Invalid Multiplier Value");
            messageBox.setMessage("The 'Multiplier' value must be a non-negative integer.");
            messageBox.open();
            return;
        }
        if (this.table.getItemCount() < 3 || this.table.getItemCount() > AlsCalibrationPayload.MAX_NUMBER_OF_STEPS) {
            MessageBox messageBox = new MessageBox(this.shlEditCalibration, 33);
            messageBox.setText("Invalid Number Of Steps");
            messageBox.setMessage("The number of steps must be between 3 and " + AlsCalibrationPayload.MAX_NUMBER_OF_STEPS + ".");
            messageBox.open();
            return;
        }
        ArrayList<AlsCalibrationPayload.Step> steps = new ArrayList<AlsCalibrationPayload.Step>();
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            AlsCalibrationPayload.Step step = new AlsCalibrationPayload.Step();
            step._brightnessPercent = Integer.valueOf(this.table.getItem(i).getText(0));
            step._luxValue = Integer.valueOf(this.table.getItem(i).getText(1));
            steps.add(step);
        }
        data.setSteps(steps);
        if (this._tempVendorData == null) {
            this._tempVendorData = new ArrayList();
        }
        data.setVendorDefinedData(this._tempVendorData);
        if (newCalibration) {
            this._parent.addNewCalibration(this._sensor, data);
        } else {
            this._data.copyContent(data);
        }
        this._modified = false;
        this.vendorCalibrationGroup.setModified(false);
        this._parent.setModified();
        this._parent.refreshCalibrationData();
        this.shlEditCalibration.close();
    }

    public void updateStepModification(int brightness, int luxValue) {
        int selectionIndex;
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            if (this.table.isSelected(i) || !this.table.getItem(i).getText(0).equals(String.valueOf(brightness)) || !this.table.getItem(i).getText(1).equals(String.valueOf(luxValue))) continue;
            MessageBox messageBox = new MessageBox(this.shlEditCalibration, 200);
            messageBox.setText("Duplicated Stpes");
            messageBox.setMessage("The steps table already contains the (" + brightness + "," + luxValue + ") step. Are you sure that you want to create the duplication?");
            if (messageBox.open() == 64) break;
            throw new CancellationException();
        }
        if ((selectionIndex = this.table.getSelectionIndex()) >= 0) {
            this.table.getItem(selectionIndex).setText(0, String.valueOf(brightness));
            this.table.getItem(selectionIndex).setText(1, String.valueOf(luxValue));
        } else {
            this.addNewStep(brightness, luxValue);
        }
        this._modified = true;
    }

    public void addNewStep(int brightnessPercent, int luxValue) {
        TableItem item = new TableItem(this.table, 0);
        item.setText(new String[]{String.valueOf(brightnessPercent), String.valueOf(luxValue)});
        this.table.setSelection(item);
        this.refreshButtonsEnablement();
    }

    public void commitFormatVersionChanges() {
        int formatID = Integer.valueOf(this.txtFormatID.getText());
        if (formatID < AlsCalibrationPayload.getLatestFormatVersion()) {
            this.btnUpgradeToLatest.setVisible(true);
        } else {
            this.btnUpgradeToLatest.setVisible(false);
        }
        if (formatID < 1) {
            this.lblMultiplier.setEnabled(false);
            this.txtMultiplier.setEnabled(false);
            this.lblMultiplierNote.setVisible(true);
        } else {
            this.lblMultiplier.setEnabled(true);
            this.txtMultiplier.setEnabled(true);
            this.lblMultiplierNote.setVisible(false);
        }
    }

    public void fillData() {
        if (this._data == null) {
            this.txtFormatID.setText(String.valueOf(AlsCalibrationPayload.getLatestFormatVersion()));
            this._modified = false;
            this.commitFormatVersionChanges();
            return;
        }
        this.txtFormatID.setText(String.valueOf(this._data.getFormatID()));
        this.txtMultiplier.setValue(this._data.getMultiplier());
        ArrayList<AlsCalibrationPayload.Step> steps = this._data.getSteps();
        for (AlsCalibrationPayload.Step step : steps) {
            this.addNewStep(step._brightnessPercent, step._luxValue);
        }
        this.table.setSelection(-1);
        this.refreshButtonsEnablement();
        if (this._tempVendorData == null) {
            this._tempVendorData = new ArrayList();
        }
        this._tempVendorData.clear();
        if (this._data.getVendorDefinedData() != null) {
            for (Byte oneByte : this._data.getVendorDefinedData()) {
                this._tempVendorData.add(oneByte);
            }
        }
        this.vendorCalibrationGroup.updateVendorDataComponents();
        this.commitFormatVersionChanges();
        this._modified = false;
    }

    protected void createContents() {
        this.shlEditCalibration = new Shell(65760);
        this.shlEditCalibration.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (AlsCalibrationEditor.this._modified || AlsCalibrationEditor.this.vendorCalibrationGroup.getModified()) {
                    MessageBox messageBox = new MessageBox(AlsCalibrationEditor.this.shlEditCalibration, 296);
                    messageBox.setText("Closing The 'Edit Calibration' Window");
                    messageBox.setMessage("Unsaved changes will be lost. Are you sure that you want to close the 'Edit Calibration' window?");
                    if (messageBox.open() != 32) {
                        e.doit = false;
                        return;
                    }
                }
            }
        });
        this.shlEditCalibration.setImage(SWTResourceManager.getImage(AlsCalibrationEditor.class, "/resources/Intel.ico"));
        this.shlEditCalibration.setText("Calibration Modifier");
        GuiUtils.setGridLayoutToComposite((Composite)this.shlEditCalibration, 2);
        Group group = new Group((Composite)this.shlEditCalibration, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        GuiUtils.setGridLayoutToComposite((Composite)group, 3);
        Label lblCalibrationFormatId = new Label((Composite)group, 0);
        lblCalibrationFormatId.setEnabled(false);
        lblCalibrationFormatId.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblCalibrationFormatId.setText("Calibration Format ID:");
        this.txtFormatID = new Text((Composite)group, 2048);
        GridData gd_txtFormatID = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtFormatID.widthHint = GuiUtils.getButtonWidth((Control)this.shlEditCalibration);
        this.txtFormatID.setLayoutData((Object)gd_txtFormatID);
        this.txtFormatID.setEnabled(false);
        this.txtFormatID.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AlsCalibrationEditor.this._modified = true;
            }
        });
        this.btnUpgradeToLatest = new Button((Composite)group, 0);
        this.btnUpgradeToLatest.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnUpgradeToLatest.setText("Upgrade to latest format");
        this.btnUpgradeToLatest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AlsCalibrationEditor.this.txtFormatID.setText(String.valueOf(1));
                AlsCalibrationEditor.this.commitFormatVersionChanges();
            }
        });
        this.lblMultiplier = new Label((Composite)group, 0);
        this.lblMultiplier.setText("Multiplier:");
        this.lblMultiplier.setEnabled(false);
        this.lblMultiplier.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.txtMultiplier = new DoubleHolder((Composite)group, 2048, this.shlEditCalibration, 2);
        this.txtMultiplier.setMinimum(0);
        this.txtMultiplier.setMaximum(AlsCalibrationPayload.SCALE_FACTOR_MAX_VALUE);
        this.txtMultiplier.setValue(1.0);
        this.txtMultiplier.setEnabled(false);
        GridData gd_txtMultiplier = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtMultiplier.widthHint = GuiUtils.getButtonWidth((Control)this.shlEditCalibration);
        this.txtMultiplier.setLayoutData(gd_txtMultiplier);
        this.lblMultiplierNote = new Label((Composite)group, 0);
        this.lblMultiplierNote.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblMultiplierNote.setText("(Available from format 1)");
        Group grpSteps = new Group((Composite)this.shlEditCalibration, 0);
        grpSteps.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        grpSteps.setText("Steps");
        GuiUtils.setGridLayoutToComposite((Composite)grpSteps, 3);
        this.table = new Table((Composite)grpSteps, 67586);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                AlsCalibrationEditor.this.editSelectedStep();
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlsCalibrationEditor.this.refreshButtonsEnablement();
            }
        });
        ControlAdapter resizeColHandler = new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                if (((TableColumn)arg0.getSource()).getWidth() < 50) {
                    ((TableColumn)arg0.getSource()).setWidth(50);
                }
            }
        };
        final TableColumn tblclmnbrightnessPercent = new TableColumn(this.table, 0);
        tblclmnbrightnessPercent.addControlListener((ControlListener)resizeColHandler);
        tblclmnbrightnessPercent.setText("Brightness Percent");
        final TableColumn tblclmnLuxValue = new TableColumn(this.table, 0);
        tblclmnLuxValue.addControlListener((ControlListener)resizeColHandler);
        tblclmnLuxValue.setText("Lux Value");
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int oneWidth = ((AlsCalibrationEditor)AlsCalibrationEditor.this).table.getClientArea().width / 2;
                tblclmnbrightnessPercent.setWidth(oneWidth);
                tblclmnLuxValue.setWidth(oneWidth);
            }
        });
        this.btnAddNew = new Button((Composite)grpSteps, 0);
        this.btnAddNew.setText("Create New");
        GridData gd_btnAddNew = new GridData(131072, 4, true, false, 1, 1);
        gd_btnAddNew.widthHint = GuiUtils.getButtonWidth((Control)this.shlEditCalibration);
        this.btnAddNew.setLayoutData((Object)gd_btnAddNew);
        this.btnAddNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlsCalibrationEditor.this.table.setSelection(-1);
                AlsCalibrationEditor.this.refreshButtonsEnablement();
                AlsCalibrationEditor.this.editSelectedStep();
            }
        });
        this.btnEdit = new Button((Composite)grpSteps, 0);
        this.btnEdit.setText("Edit");
        GridData gd_btnEdit = new GridData(4, 4, false, false, 1, 1);
        gd_btnEdit.widthHint = GuiUtils.getButtonWidth((Control)this.shlEditCalibration);
        this.btnEdit.setLayoutData((Object)gd_btnEdit);
        this.btnEdit.setEnabled(false);
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlsCalibrationEditor.this.editSelectedStep();
            }
        });
        this.btnDelete = new Button((Composite)grpSteps, 0);
        GridData gd_btnDelete = new GridData(4, 4, false, false, 1, 1);
        gd_btnDelete.widthHint = GuiUtils.getButtonWidth((Control)this.shlEditCalibration);
        this.btnDelete.setLayoutData((Object)gd_btnDelete);
        this.btnDelete.setEnabled(false);
        this.btnDelete.setText("Delete");
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlsCalibrationEditor.this.table.remove(AlsCalibrationEditor.this.table.getSelectionIndices());
                AlsCalibrationEditor.this.refreshButtonsEnablement();
                AlsCalibrationEditor.this._modified = true;
            }
        });
        this._tempVendorData = new ArrayList();
        this.vendorCalibrationGroup = new VendorCalibrationGroup(this.shlEditCalibration, this._tempVendorData);
        GridData gdVendorDefined = new GridData(4, 0x1000000, true, false, 2, 1);
        this.vendorCalibrationGroup.grpVendorDefinedData.setLayoutData((Object)gdVendorDefined);
        Button btnSave = new Button((Composite)this.shlEditCalibration, 0);
        GridData gd_btnSave = new GridData(131072, 4, true, false, 1, 1);
        gd_btnSave.widthHint = GuiUtils.getButtonWidth((Control)this.shlEditCalibration);
        btnSave.setLayoutData((Object)gd_btnSave);
        btnSave.setText("Save and Close");
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlsCalibrationEditor.this.saveData();
            }
        });
        Button btnCancel = new Button((Composite)this.shlEditCalibration, 0);
        GridData gd_btnCancel = new GridData(4, 4, false, false, 1, 1);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shlEditCalibration);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        btnCancel.setText("Cancel");
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlsCalibrationEditor.this.shlEditCalibration.close();
            }
        });
        this.shlEditCalibration.setSize(lblCalibrationFormatId.computeSize((int)-1, (int)-1).x * 4, lblCalibrationFormatId.computeSize((int)-1, (int)-1).x * 5);
        this.shlEditCalibration.setLocation(GuiUtils.getMiddleLocation(this.shlEditCalibration, this.display));
    }
}

