/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.utils;

import java.util.HashMap;

public class TypeUtils {
    public static HashMap<Integer, SensorType> supportedTypesMap;

    public static void fillMap() {
        supportedTypesMap = new HashMap();
        supportedTypesMap.put(115, SensorType.ACCELEROMETER);
        supportedTypesMap.put(118, SensorType.GYROMETER);
        supportedTypesMap.put(527, SensorType.MAGNETOMETER);
        supportedTypesMap.put(65, SensorType.AMBIENT_LIGHT);
        supportedTypesMap.put(49, SensorType.BAROMETER);
        supportedTypesMap.put(51, SensorType.TEMPERATURE);
        supportedTypesMap.put(50, SensorType.HUMIDITY);
        supportedTypesMap.put(592, SensorType.UV);
        supportedTypesMap.put(17, SensorType.HUMAN_PRESENCE);
        supportedTypesMap.put(609, SensorType.HALL);
        supportedTypesMap.put(225, SensorType.CUSTOM);
    }

    public static String getStructByType(SensorType type) {
        String res = "";
        switch (type) {
            case ACCELEROMETER: {
                res = "accel_phy_data_t";
                break;
            }
            case GYROMETER: {
                res = "gyro_phy_data_t";
                break;
            }
            case MAGNETOMETER: {
                res = "compass_phy_data_t";
                break;
            }
            case BAROMETER: {
                res = "baro_phy_data_t";
                break;
            }
            case TEMPERATURE: {
                res = "temp_phy_data_t";
                break;
            }
            case HUMIDITY: {
                res = "humi_phy_data_t";
                break;
            }
            case AMBIENT_LIGHT: {
                res = "als_phy_data_t";
                break;
            }
            case UV: {
                res = "uv_phy_data_t";
                break;
            }
            case HUMAN_PRESENCE: {
                res = "human_presence_phy_data_t";
                break;
            }
            case HALL: {
                res = "hall_data_t";
                break;
            }
        }
        return res;
    }

    public static String getDataByType(SensorType type) {
        String res = "";
        switch (type) {
            case ACCELEROMETER: {
                res = "data";
                break;
            }
            case GYROMETER: {
                res = "data";
                break;
            }
            case MAGNETOMETER: {
                res = "data";
                break;
            }
            case BAROMETER: {
                res = "p";
                break;
            }
            case TEMPERATURE: {
                res = "t";
                break;
            }
            case HUMIDITY: {
                res = "h";
                break;
            }
            case AMBIENT_LIGHT: {
                res = "lux";
                break;
            }
            case UV: {
                res = "uvi";
                break;
            }
            case HUMAN_PRESENCE: {
                res = "present";
                break;
            }
            case HALL: {
                res = "HallPresent";
                break;
            }
        }
        return res;
    }

    public static enum SensorType {
        ACCELEROMETER,
        GYROMETER,
        MAGNETOMETER,
        AMBIENT_LIGHT,
        BAROMETER,
        TEMPERATURE,
        HUMIDITY,
        UV,
        HUMAN_PRESENCE,
        HALL,
        CUSTOM;

    }
}

