/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

public final class PatternProps {
    private static final byte[] latin1;
    private static final byte[] index2000;
    private static final int[] syntax2000;
    private static final int[] syntaxOrWhiteSpace2000;

    static {
        byte[] byArray = new byte[256];
        byArray[9] = 5;
        byArray[10] = 5;
        byArray[11] = 5;
        byArray[12] = 5;
        byArray[13] = 5;
        byArray[32] = 5;
        byArray[33] = 3;
        byArray[34] = 3;
        byArray[35] = 3;
        byArray[36] = 3;
        byArray[37] = 3;
        byArray[38] = 3;
        byArray[39] = 3;
        byArray[40] = 3;
        byArray[41] = 3;
        byArray[42] = 3;
        byArray[43] = 3;
        byArray[44] = 3;
        byArray[45] = 3;
        byArray[46] = 3;
        byArray[47] = 3;
        byArray[58] = 3;
        byArray[59] = 3;
        byArray[60] = 3;
        byArray[61] = 3;
        byArray[62] = 3;
        byArray[63] = 3;
        byArray[64] = 3;
        byArray[91] = 3;
        byArray[92] = 3;
        byArray[93] = 3;
        byArray[94] = 3;
        byArray[96] = 3;
        byArray[123] = 3;
        byArray[124] = 3;
        byArray[125] = 3;
        byArray[126] = 3;
        byArray[133] = 5;
        byArray[161] = 3;
        byArray[162] = 3;
        byArray[163] = 3;
        byArray[164] = 3;
        byArray[165] = 3;
        byArray[166] = 3;
        byArray[167] = 3;
        byArray[169] = 3;
        byArray[171] = 3;
        byArray[172] = 3;
        byArray[174] = 3;
        byArray[176] = 3;
        byArray[177] = 3;
        byArray[182] = 3;
        byArray[187] = 3;
        byArray[191] = 3;
        byArray[215] = 3;
        byArray[247] = 3;
        latin1 = byArray;
        byte[] byArray2 = new byte[130];
        byArray2[0] = 2;
        byArray2[1] = 3;
        byArray2[2] = 4;
        byArray2[12] = 5;
        byArray2[13] = 1;
        byArray2[14] = 1;
        byArray2[15] = 1;
        byArray2[16] = 1;
        byArray2[17] = 1;
        byArray2[18] = 1;
        byArray2[19] = 1;
        byArray2[20] = 1;
        byArray2[21] = 1;
        byArray2[22] = 1;
        byArray2[23] = 1;
        byArray2[24] = 1;
        byArray2[25] = 1;
        byArray2[26] = 1;
        byArray2[27] = 1;
        byArray2[28] = 1;
        byArray2[29] = 1;
        byArray2[30] = 1;
        byArray2[31] = 1;
        byArray2[32] = 1;
        byArray2[33] = 1;
        byArray2[34] = 1;
        byArray2[40] = 1;
        byArray2[41] = 1;
        byArray2[42] = 1;
        byArray2[43] = 1;
        byArray2[44] = 1;
        byArray2[45] = 1;
        byArray2[46] = 1;
        byArray2[47] = 1;
        byArray2[48] = 1;
        byArray2[49] = 1;
        byArray2[50] = 1;
        byArray2[51] = 1;
        byArray2[52] = 1;
        byArray2[53] = 1;
        byArray2[54] = 1;
        byArray2[55] = 1;
        byArray2[56] = 1;
        byArray2[57] = 1;
        byArray2[58] = 1;
        byArray2[59] = 6;
        byArray2[60] = 7;
        byArray2[61] = 1;
        byArray2[62] = 1;
        byArray2[63] = 1;
        byArray2[64] = 1;
        byArray2[65] = 1;
        byArray2[66] = 1;
        byArray2[67] = 1;
        byArray2[68] = 1;
        byArray2[69] = 1;
        byArray2[70] = 1;
        byArray2[71] = 1;
        byArray2[72] = 1;
        byArray2[73] = 1;
        byArray2[74] = 1;
        byArray2[75] = 1;
        byArray2[76] = 1;
        byArray2[77] = 1;
        byArray2[78] = 1;
        byArray2[79] = 1;
        byArray2[80] = 1;
        byArray2[81] = 1;
        byArray2[82] = 1;
        byArray2[83] = 1;
        byArray2[84] = 1;
        byArray2[85] = 1;
        byArray2[86] = 1;
        byArray2[87] = 1;
        byArray2[88] = 1;
        byArray2[89] = 1;
        byArray2[90] = 1;
        byArray2[91] = 1;
        byArray2[92] = 1;
        byArray2[93] = 1;
        byArray2[94] = 1;
        byArray2[95] = 1;
        byArray2[112] = 1;
        byArray2[113] = 1;
        byArray2[114] = 1;
        byArray2[115] = 1;
        byArray2[128] = 8;
        byArray2[129] = 9;
        index2000 = byArray2;
        int[] nArray = new int[10];
        nArray[1] = -1;
        nArray[2] = -65536;
        nArray[3] = 0x7FFF00FF;
        nArray[4] = 0x7FEFFFFE;
        nArray[5] = -65536;
        nArray[6] = 0x3FFFFF;
        nArray[7] = -1048576;
        nArray[8] = -242;
        nArray[9] = 65537;
        syntax2000 = nArray;
        int[] nArray2 = new int[10];
        nArray2[1] = -1;
        nArray2[2] = -16384;
        nArray2[3] = 2147419135;
        nArray2[4] = 0x7FEFFFFE;
        nArray2[5] = -65536;
        nArray2[6] = 0x3FFFFF;
        nArray2[7] = -1048576;
        nArray2[8] = -242;
        nArray2[9] = 65537;
        syntaxOrWhiteSpace2000 = nArray2;
    }

    public static boolean isSyntax(int c) {
        if (c < 0) {
            return false;
        }
        if (c <= 255) {
            return latin1[c] == 3;
        }
        if (c < 8208) {
            return false;
        }
        if (c <= 12336) {
            int bits = syntax2000[index2000[c - 8192 >> 5]];
            return (bits >> (c & 0x1F) & 1) != 0;
        }
        if (64830 <= c && c <= 65094) {
            return c <= 64831 || 65093 <= c;
        }
        return false;
    }

    public static boolean isSyntaxOrWhiteSpace(int c) {
        if (c < 0) {
            return false;
        }
        if (c <= 255) {
            return latin1[c] != 0;
        }
        if (c < 8206) {
            return false;
        }
        if (c <= 12336) {
            int bits = syntaxOrWhiteSpace2000[index2000[c - 8192 >> 5]];
            return (bits >> (c & 0x1F) & 1) != 0;
        }
        if (64830 <= c && c <= 65094) {
            return c <= 64831 || 65093 <= c;
        }
        return false;
    }

    public static boolean isWhiteSpace(int c) {
        if (c < 0) {
            return false;
        }
        if (c <= 255) {
            return latin1[c] == 5;
        }
        if (8206 <= c && c <= 8233) {
            return c <= 8207 || 8232 <= c;
        }
        return false;
    }

    public static int skipWhiteSpace(CharSequence s, int i) {
        while (i < s.length() && PatternProps.isWhiteSpace(s.charAt(i))) {
            ++i;
        }
        return i;
    }

    public static String trimWhiteSpace(String s) {
        if (s.length() == 0 || !PatternProps.isWhiteSpace(s.charAt(0)) && !PatternProps.isWhiteSpace(s.charAt(s.length() - 1))) {
            return s;
        }
        int start = 0;
        int limit = s.length();
        while (start < limit && PatternProps.isWhiteSpace(s.charAt(start))) {
            ++start;
        }
        if (start < limit) {
            while (PatternProps.isWhiteSpace(s.charAt(limit - 1))) {
                --limit;
            }
        }
        return s.substring(start, limit);
    }

    public static boolean isIdentifier(CharSequence s) {
        int limit = s.length();
        if (limit == 0) {
            return false;
        }
        int start = 0;
        do {
            if (!PatternProps.isSyntaxOrWhiteSpace(s.charAt(start++))) continue;
            return false;
        } while (start < limit);
        return true;
    }

    public static boolean isIdentifier(CharSequence s, int start, int limit) {
        if (start >= limit) {
            return false;
        }
        do {
            if (!PatternProps.isSyntaxOrWhiteSpace(s.charAt(start++))) continue;
            return false;
        } while (start < limit);
        return true;
    }

    public static int skipIdentifier(CharSequence s, int i) {
        while (i < s.length() && !PatternProps.isSyntaxOrWhiteSpace(s.charAt(i))) {
            ++i;
        }
        return i;
    }
}

