# Script to customize the firmware image file based on the four part
# ids and update the device firmware with the customized image.
# The script uses flashUpdate2 and customclx2 tools.
Write-Host "Getting four part IDs..."
$output = ./flashUpdate2 -i
$ids = $output | Select-String "FourPartIDs:" | %{$_.Line.Split(":")}
Start-Sleep -Seconds 2
If ($ids -eq $null -or $ids.count -eq 0) {
	Write-Host "Failed to get four part IDs...Exiting."
	exit 1
}
Start-Sleep -Seconds 2
Write-Host "Read four part IDs from the device:" $ids[1]"(VID)," $ids[2]"(DID)," $ids[3]"(SVID)," $ids[4]"(SDID)"

# Validate the four part ids
If (($ids.count -ne 5) -or ($ids[1] -eq "0x0000") -or ($ids[2] -eq "0x0000") -or ($ids[3] -eq "0x0000") -or ($ids[4] -eq "0x0000")) {
    Write-Host "Invalid four part IDs: VID:"$ids[1]", DID:"$ids[2]", SVID:" $ids[3]", SDID:"$ids[4]
    exit 1
}

If (Test-Path -Path ./updated.clx ) {
    Write-Host "Deleting the existing updated.clx file..."
    del updated.clx
}

Write-Host "Updating the clx file..."
Write-Host ./customclx2 $ids[1] $ids[2] $ids[3] $ids[4] updatedata.xml updated.clx
./customclx2 $ids[1] $ids[2] $ids[3] $ids[4] updatedata.xml updated.clx

If (Test-Path -Path ./updated.clx ) {
    Write-Host "Flashing the device with updated.clx..."
    ./flashUpdate2 --update  ATL2-8.0.1_agent_SIGN.clx updated.clx
	Write-Host "Kickstarting new firmware..."
	./kickstart2
}
Else {
	Write-Host "Could not find the updated firmware image: updated.clx."
}