/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.configurations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.configurations.ConfigurationPayload;
import pdtEditor.validation.Validator;

public class DynamicKeyboardLightingPayload
extends ConfigurationPayload {
    public static final int CONFIGURATION_TYPE = 110;
    public static final String CALIBRATION_FORMAT_STRING = "Dynamic Keyboard Lighting Configuration";
    private static final int LATEST_FORMAT_ID = 0;
    public static final int DISABLE_ALWAYS_ON_ENABLE = 0;
    public static final int DISABLE_ALWAYS_ON_DISABLE = 1;
    public static final int PLM_NOT_AVAILABLE_VALUE = -1;
    public static final int DKL_FALLING_THRESHOLD_DEFAULT_VALUE = 40;
    public static final int DKL_RISING_THRESHOLD_DEFAULT_VALUE = 60;
    public static final int DKL_DELAY_DEFAULT_VALUE = 200;
    public static final int DISABLE_ALWAYS_ON_FIELD_SIZE = 1;
    public static final int PLM_MODE_ID_FIELD_SIZE = 4;
    public static final int FALLING_THRESHOLD_FIELD_SIZE = 2;
    public static final int RISING_THRESHOLD_FIELD_SIZE = 2;
    public static final int DELAY_FIELD_SIZE = 2;
    private int _formatID = 0;
    private int _version;
    public int disableAlwaysOn;
    public int plmModeId;
    public int fallingThreshold1;
    public int fallingThreshold2;
    public int fallingThreshold3;
    public int risingThreshold1;
    public int risingThreshold2;
    public int risingThreshold3;
    public int delay1;
    public int delay2;
    public int delay3;

    public DynamicKeyboardLightingPayload() {
    }

    public DynamicKeyboardLightingPayload(DynamicKeyboardLightingPayload other) {
        super(other);
        this._formatID = other._formatID;
        this._version = other._version;
        this.disableAlwaysOn = other.disableAlwaysOn;
        this.plmModeId = other.plmModeId;
        this.fallingThreshold1 = other.fallingThreshold1;
        this.fallingThreshold2 = other.fallingThreshold2;
        this.fallingThreshold3 = other.fallingThreshold3;
        this.risingThreshold1 = other.risingThreshold1;
        this.risingThreshold2 = other.risingThreshold2;
        this.risingThreshold3 = other.risingThreshold3;
        this.delay1 = other.delay1;
        this.delay2 = other.delay2;
        this.delay3 = other.delay3;
    }

    public DynamicKeyboardLightingPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        this._formatID = formatId;
        if (this._formatID > 0) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element configurationElement = reader.readNewField((String)"DynamicKeyboardLightingConfiguration", (Node)payloadXmlNode).xmlElement;
        this.disableAlwaysOn = reader.readNewField((String)"DisableAlwaysOn", (int)1, (boolean)true, (Node)configurationElement).value;
        this.plmModeId = reader.readNewField((String)"PlmModeID", (int)4, (boolean)true, (Node)configurationElement).value;
        this.fallingThreshold1 = reader.readNewField((String)"FallingThreshold1", (int)2, (boolean)true, (Node)configurationElement).value;
        this.risingThreshold1 = reader.readNewField((String)"RisingThreshold1", (int)2, (boolean)true, (Node)configurationElement).value;
        this.delay1 = reader.readNewField((String)"Delay1", (int)2, (boolean)true, (Node)configurationElement).value;
        this.fallingThreshold2 = reader.readNewField((String)"FallingThreshold2", (int)2, (boolean)true, (Node)configurationElement).value;
        this.risingThreshold2 = reader.readNewField((String)"RisingThreshold2", (int)2, (boolean)true, (Node)configurationElement).value;
        this.delay2 = reader.readNewField((String)"Delay2", (int)2, (boolean)true, (Node)configurationElement).value;
        this.fallingThreshold3 = reader.readNewField((String)"FallingThreshold3", (int)2, (boolean)true, (Node)configurationElement).value;
        this.risingThreshold3 = reader.readNewField((String)"RisingThreshold3", (int)2, (boolean)true, (Node)configurationElement).value;
        this.delay3 = reader.readNewField((String)"Delay3", (int)2, (boolean)true, (Node)configurationElement).value;
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element configurationElement = writer.writeNewField((String)"DynamicKeyboardLightingConfiguration", (Node)parent).xmlElement;
        writer.writeNewField("DisableAlwaysOn", 1, this.disableAlwaysOn, (Node)configurationElement);
        writer.writeNewField("PlmModeID", 4, this.plmModeId, (Node)configurationElement);
        writer.writeNewField("FallingThreshold1", 2, this.fallingThreshold1, (Node)configurationElement);
        writer.writeNewField("RisingThreshold1", 2, this.risingThreshold1, (Node)configurationElement);
        writer.writeNewField("Delay1", 2, this.delay1, (Node)configurationElement);
        writer.writeNewField("FallingThreshold2", 2, this.fallingThreshold2, (Node)configurationElement);
        writer.writeNewField("RisingThreshold2", 2, this.risingThreshold2, (Node)configurationElement);
        writer.writeNewField("Delay2", 2, this.delay2, (Node)configurationElement);
        writer.writeNewField("FallingThreshold3", 2, this.fallingThreshold3, (Node)configurationElement);
        writer.writeNewField("RisingThreshold3", 2, this.risingThreshold3, (Node)configurationElement);
        writer.writeNewField("Delay3", 2, this.delay3, (Node)configurationElement);
        writer.removeSizeCounter(payloadDataLength);
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    @Override
    public ConfigurationPayload clone() {
        return new DynamicKeyboardLightingPayload(this);
    }

    @Override
    public String getConfigurationFormatString() {
        return CALIBRATION_FORMAT_STRING;
    }

    @Override
    public String getConfigurationDataString() {
        return "";
    }

    @Override
    public boolean controllsBusData() {
        return false;
    }

    @Override
    public boolean controllsGpioData() {
        return false;
    }

    public int getDisableAlwaysOn() {
        return this.disableAlwaysOn;
    }

    public void setDisableAlwaysOn(int disableAlwaysOn) {
        this.disableAlwaysOn = disableAlwaysOn;
    }

    public int getPlmModeId() {
        return this.plmModeId;
    }

    public void setPlmModeId(int plmModeId) {
        this.plmModeId = plmModeId;
    }

    public int getFallingThreshold1() {
        return this.fallingThreshold1;
    }

    public void setFallingThreshold1(int fallingThreshold1) {
        this.fallingThreshold1 = fallingThreshold1;
    }

    public int getFallingThreshold2() {
        return this.fallingThreshold2;
    }

    public void setFallingThreshold2(int fallingThreshold2) {
        this.fallingThreshold2 = fallingThreshold2;
    }

    public int getFallingThreshold3() {
        return this.fallingThreshold3;
    }

    public void setFallingThreshold3(int fallingThreshold3) {
        this.fallingThreshold3 = fallingThreshold3;
    }

    public int getRisingThreshold1() {
        return this.risingThreshold1;
    }

    public void setRisingThreshold1(int risingThreshold1) {
        this.risingThreshold1 = risingThreshold1;
    }

    public int getRisingThreshold2() {
        return this.risingThreshold2;
    }

    public void setRisingThreshold2(int risingThreshold2) {
        this.risingThreshold2 = risingThreshold2;
    }

    public int getRisingThreshold3() {
        return this.risingThreshold3;
    }

    public void setRisingThreshold3(int risingThreshold3) {
        this.risingThreshold3 = risingThreshold3;
    }

    public int getDelay1() {
        return this.delay1;
    }

    public void setDelay1(int delay1) {
        this.delay1 = delay1;
    }

    public int getDelay2() {
        return this.delay2;
    }

    public void setDelay2(int delay2) {
        this.delay2 = delay2;
    }

    public int getDelay3() {
        return this.delay3;
    }

    public void setDelay3(int delay3) {
        this.delay3 = delay3;
    }
}

