/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.dao;

import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.model.dao.AbstractJsonDao;
import com.intel.sensing.fdk.model.entity.VendorListEntity;
import com.intel.sensing.fdk.model.entity.VendorMapEntity;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class VendorListDao
extends AbstractJsonDao<VendorListEntity> {
    @Override
    public VendorListEntity getEntityByFilePath(String filePath) throws ISSException {
        VendorListEntity entity = (VendorListEntity)super.getEntityByFilePath(filePath, VendorListEntity.class);
        Assert.isNotNull((Object)entity);
        return entity;
    }

    public void removeVendor(VendorListEntity VendorListItem, VendorMapEntity VendorMapItem) throws ISSException {
        List<VendorMapEntity> VendorList = VendorListItem.getSensorVendorList();
        Assert.isNotNull(VendorList);
        Assert.isTrue((VendorList.size() >= 0 ? 1 : 0) != 0);
        String err = "Couldn't remove vendor define from list. ";
        for (VendorMapEntity data : VendorList) {
            if (data.getVendorID() != VendorMapItem.getVendorID() || !data.getVendorName().equals(VendorMapItem.getVendorName())) continue;
            if (VendorList.remove(data)) {
                return;
            }
            throw new ISSException("Failed to remove vendor from list");
        }
        throw new ISSException(String.valueOf(err) + "Not found Vendor - " + VendorMapItem.getVendorName());
    }

    public void addVendor(VendorListEntity VendorListItem, VendorMapEntity VendorMapItem) throws ISSException {
        List<VendorMapEntity> VendorList = VendorListItem.getSensorVendorList();
        Assert.isNotNull(VendorList);
        Assert.isTrue((VendorList.size() >= 0 ? 1 : 0) != 0);
        String err = "Couldn't add vendor define to list. ";
        if (VendorList != null) {
            for (VendorMapEntity data : VendorList) {
                if (data.getVendorID() != VendorMapItem.getVendorID() || !data.getVendorName().equals(VendorMapItem.getVendorName())) continue;
                throw new ISSException(String.valueOf(err) + "Vendor already in the list - " + VendorMapItem.getVendorName());
            }
            if (VendorList.add(VendorMapItem)) {
                return;
            }
        }
        throw new ISSException("Failed to add vendor to list");
    }
}

