/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.common.log;

import com.intel.sensing.fdk.common.log.HtmlFormatter;
import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class ISSLogger {
    private static Logger logger = null;
    private static FileHandler fileTxt;
    private static SimpleFormatter formatterTxt;
    private static FileHandler fileHTML;
    private static Formatter formatterHTML;
    private static Level logLevel;
    public static final String SHORT_SPACE = "\n  ";
    public static final String LONG_SPACE = "\n    ";

    static {
        logLevel = Level.ALL;
    }

    public static void setup(String logsFolder, Level level) throws SecurityException, IOException {
        if (!new File(logsFolder).exists()) {
            new File(logsFolder).mkdirs();
        }
        fileTxt = new FileHandler(String.valueOf(logsFolder) + "/log.txt");
        fileHTML = new FileHandler(String.valueOf(logsFolder) + "/log.html");
        logger = Logger.getLogger("global");
        logger.setLevel(level);
        logLevel = level;
        formatterTxt = new SimpleFormatter();
        fileTxt.setFormatter(formatterTxt);
        logger.addHandler(fileTxt);
        formatterHTML = new HtmlFormatter();
        fileHTML.setFormatter(formatterHTML);
        logger.addHandler(fileHTML);
        Logger rootLogger = Logger.getLogger("");
        Handler[] handlers = rootLogger.getHandlers();
        if (handlers != null && handlers.length > 0 && handlers[0] instanceof ConsoleHandler) {
            rootLogger.removeHandler(handlers[0]);
        }
    }

    public static void i(String msg) {
        ISSLogger.log(Level.INFO, msg);
    }

    public static void w(String msg) {
        ISSLogger.log(Level.WARNING, msg);
    }

    public static void e(String msg) {
        ISSLogger.log(Level.SEVERE, msg);
    }

    public static void w(Exception e) {
        ISSLogger.log(Level.WARNING, e.toString());
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement traceElement = stackTraceElementArray[n2];
            if (traceElement != null) {
                ISSLogger.log(Level.WARNING, traceElement.toString());
            }
            ++n2;
        }
        String msg = "";
        String error = e.getMessage();
        if (error != null) {
            msg = "Warning: " + error.trim();
            ISSLogger.log(Level.WARNING, msg);
        } else {
            ISSLogger.log(Level.WARNING, "Warning!");
        }
    }

    public static void e(Exception e) {
        ISSLogger.log(Level.SEVERE, e.toString());
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement traceElement = stackTraceElementArray[n2];
            if (traceElement != null) {
                ISSLogger.log(Level.SEVERE, traceElement.toString());
            }
            ++n2;
        }
        String msg = "";
        String error = e.getMessage();
        if (error != null) {
            msg = "Exception: " + error.trim();
            ISSLogger.log(Level.SEVERE, msg);
        } else {
            ISSLogger.log(Level.SEVERE, "Exception!");
        }
    }

    public static void e(Throwable e) {
        ISSLogger.log(Level.SEVERE, e.toString());
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement traceElement = stackTraceElementArray[n2];
            if (traceElement != null) {
                ISSLogger.log(Level.SEVERE, traceElement.toString());
            }
            ++n2;
        }
        String msg = "";
        String error = e.getMessage();
        if (error != null) {
            msg = "Exception: " + error.trim();
            ISSLogger.log(Level.SEVERE, msg);
        } else {
            ISSLogger.log(Level.SEVERE, "Exception!");
        }
    }

    public static void log(Level level, String message) {
        if (level.intValue() >= logLevel.intValue()) {
            System.out.println("[" + ISSLogger.getCallerMethodName() + "] " + message);
        }
        if (logger != null) {
            ISSLogger.log(logLevel, ISSLogger.getCallerClassName(), ISSLogger.getCallerMethodName(), message);
        }
    }

    private static void log(Level logLevel, String sourceClass, String sourceMethod, String message) {
        logger.logp(logLevel, sourceClass, sourceMethod, message);
    }

    public static void log(String message) {
        ISSLogger.log(Level.INFO, ISSLogger.getCallerClassName(), ISSLogger.getCallerMethodName(), message);
    }

    private static String getCallerMethodName() {
        StackTraceElement traceElement = Thread.currentThread().getStackTrace()[4];
        return traceElement.getMethodName();
    }

    private static String getCallerClassName() {
        StackTraceElement traceElement = Thread.currentThread().getStackTrace()[4];
        return traceElement.getClassName();
    }

    public static void e(String generalError, Exception exception) {
        ISSLogger.e(generalError);
        ISSLogger.e(exception);
    }
}

