/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import java.util.ArrayList;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.InformationStore;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.configuration.ConfigurationEditor;
import pdtEditor.gui.configuration.HingeAngleConfigurationModifier;
import pdtEditor.gui.configuration.HingeAngleHallConfiguration;
import pdtEditor.gui.configuration.LidModeConfiguration;
import pdtEditor.payloads.configurations.HingeAngleConfigurationPayload;
import pdtEditor.payloads.configurations.LidModeConfigurationPayload;

public class HingeAngleConfiguration
implements ConfigurationEditor {
    private static final int HINGE_ANGLE_FIXED_COL_SIZE = 6;
    private Display display;
    protected Shell shell;
    private HingeAngleConfigurationPayload _payload = null;
    ArrayList<HingeAngleConfigurationPayload.HallConfig> _hallConfigs = new ArrayList();
    private SensorModifier _parent;
    private Sensor _sensor = null;
    private boolean _modified = false;
    private InformationStore infoStore = null;
    private HingeAngleConfiguration _thisInstance = this;
    private Table tblHallConfig;
    private Table tblHingeAngleConfig;
    private TableViewer tbvHingeAngle;
    private Button btnEditHall;
    private Button btnDeleteHall;
    private Button btnAddHall;
    private Button btnAddHingeAngle;
    private Button btnDeleteHingeAngle;
    private Button btnEditHingeAngle;
    private Button btnSaveAndClose;
    private ControlAdapter resizeColHandler = new ControlAdapter(){

        public void controlResized(ControlEvent arg0) {
            if (((TableColumn)arg0.getSource()).getWidth() < 50) {
                ((TableColumn)arg0.getSource()).setWidth(50);
            }
        }
    };

    public static void main(String[] args) {
        try {
            HingeAngleConfiguration window = new HingeAngleConfiguration(null, null, null);
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HingeAngleConfiguration(SensorModifier parent, HingeAngleConfigurationPayload payload, Sensor sensor) {
        this._payload = payload;
        this._sensor = sensor;
        this._parent = parent;
    }

    public void refreshHallConfigButtonsEnablility() {
        if (this.tblHallConfig.getItemCount() >= 6) {
            this.btnAddHall.setEnabled(false);
        } else {
            this.btnAddHall.setEnabled(true);
        }
        if (this.tblHallConfig.getSelectionCount() == 0) {
            this.btnEditHall.setEnabled(false);
            this.btnDeleteHall.setEnabled(false);
        } else {
            this.btnEditHall.setEnabled(true);
            this.btnDeleteHall.setEnabled(true);
        }
    }

    public void addHallConfig(int instanceId, String sensorName) {
        HingeAngleConfigurationPayload.HallConfig hallConfig = new HingeAngleConfigurationPayload.HallConfig();
        TableItem item = new TableItem(this.tblHallConfig, 0);
        TableViewerColumn tbvcNewSensorType = new TableViewerColumn(this.tbvHingeAngle, 0);
        TableColumn tblclmnNewSensorType = tbvcNewSensorType.getColumn();
        int oneWidth = this.tblHingeAngleConfig.getClientArea().width / 20;
        String headText = sensorName + "(" + instanceId + ")";
        LidModeConfigurationPayload.PlmSupportSensorType supportSensorType = this.infoStore.getPlmSupportSensorTypeByName(sensorName);
        if (supportSensorType != null) {
            hallConfig.sensorType = supportSensorType.sensorType;
        }
        for (TableItem tbitmCurrentItem : this.tblHingeAngleConfig.getItems()) {
            tbitmCurrentItem.setText(this.tblHingeAngleConfig.getColumnCount() - 1, "Not Applicable");
        }
        hallConfig.instanceId = instanceId;
        hallConfig.sensorName = sensorName;
        this._hallConfigs.add(hallConfig);
        item.setText(0, sensorName);
        item.setText(1, Integer.toString(instanceId));
        tblclmnNewSensorType.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnNewSensorType.setText(headText);
        tblclmnNewSensorType.setWidth(oneWidth * 4);
        this.refreshHallConfigButtonsEnablility();
    }

    public void editHallConfig(int instanceId, String sensorName, int rowIndex) {
        String headText = sensorName + "(" + instanceId + ")";
        LidModeConfigurationPayload.PlmSupportSensorType supportSensorType = this.infoStore.getPlmSupportSensorTypeByName(sensorName);
        if (supportSensorType != null) {
            this._hallConfigs.get((int)rowIndex).sensorType = supportSensorType.sensorType;
        }
        this._hallConfigs.get((int)rowIndex).sensorName = sensorName;
        this._hallConfigs.get((int)rowIndex).instanceId = instanceId;
        this.tblHallConfig.getItem(rowIndex).setText(0, sensorName);
        this.tblHallConfig.getItem(rowIndex).setText(1, Integer.toString(instanceId));
        this.tbvHingeAngle.getTable().getColumn(6 + rowIndex).setText(headText);
    }

    public void deleteHallConfig() {
        int[] selectedIndices = this.tblHallConfig.getSelectionIndices();
        for (int i = 0; i < selectedIndices.length; ++i) {
            this.tbvHingeAngle.getTable().getColumn(6 + selectedIndices[i]).dispose();
            this.tblHallConfig.remove(selectedIndices[i]);
            this._hallConfigs.remove(selectedIndices[i]);
        }
        this.refreshHallConfigButtonsEnablility();
        this.setModified();
    }

    public void checkHallConfigValues(int instanceId, String sensorName) {
        for (int i = 0; i < this._hallConfigs.size(); ++i) {
            if (this._hallConfigs.get((int)i).instanceId != instanceId || !this._hallConfigs.get((int)i).sensorName.equals(sensorName)) continue;
            throw new RuntimeException("An instance has already been selected for this Sensor Type.");
        }
    }

    public void editHingeAngleConfigTableItem() {
        TableItem[] selectedItems = this.tblHingeAngleConfig.getSelection();
        if (selectedItems.length != 1) {
            return;
        }
        new HingeAngleConfigurationModifier(this._thisInstance, selectedItems[0], this._hallConfigs).open();
    }

    public void addHingeAngleLine(String[] data) {
        TableItem item = new TableItem(this.tblHingeAngleConfig, 0);
        item.setText(data);
        this.refreshButtonsAfterConfNumChange();
    }

    public void refreshButtonsAfterConfNumChange() {
        if (this.tblHingeAngleConfig.getItemCount() < 1) {
            this.btnSaveAndClose.setEnabled(false);
        } else {
            this.btnSaveAndClose.setEnabled(true);
        }
        if (this.tblHingeAngleConfig.getItemCount() >= 15) {
            this.btnAddHingeAngle.setEnabled(false);
        } else {
            this.btnAddHingeAngle.setEnabled(true);
        }
    }

    @Override
    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        try {
            this.infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            GuiUtils.showErrorMessage(this.shell, "Cannot load file", "Cannot load the sensor definitions file - the file is missing or damaged. Aborting.");
            return;
        }
        this.fillData();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void fillData() {
        if (this._payload == null) {
            return;
        }
        this.tblHallConfig.removeAll();
        this.tblHingeAngleConfig.removeAll();
        ArrayList<HingeAngleConfigurationPayload.HingeAngleConfig> hallAngleConfigs = this._payload.getHingeAngleConfigs();
        for (int i = 0; i < this._payload.getHallConfigs().size(); ++i) {
            this.addHallConfig(this._payload.getHallConfigs().get((int)i).instanceId, this._payload.getHallConfigs().get((int)i).sensorName);
        }
        for (HingeAngleConfigurationPayload.HingeAngleConfig hingeAngleConfig : hallAngleConfigs) {
            ArrayList<String> tempArray = new ArrayList<String>();
            tempArray.add(String.valueOf(hingeAngleConfig.angleOutput));
            tempArray.add(String.valueOf(hingeAngleConfig.entryAngle));
            tempArray.add(String.valueOf(hingeAngleConfig.exitAngle));
            tempArray.add(String.valueOf(hingeAngleConfig.t1Delta));
            tempArray.add(String.valueOf(hingeAngleConfig.t2Delta));
            tempArray.add(String.valueOf(hingeAngleConfig.th));
            for (int i = 0; i < this._hallConfigs.size(); ++i) {
                if (hingeAngleConfig.hallStates[i] == 0) {
                    tempArray.add("Inactive");
                    continue;
                }
                if (hingeAngleConfig.hallStates[i] == 1) {
                    tempArray.add("Active");
                    continue;
                }
                tempArray.add("Not Applicable");
            }
            String[] data = new String[]{};
            data = tempArray.toArray(data);
            this.addHingeAngleLine(data);
        }
        this._modified = false;
    }

    protected void createContents() {
        this.shell = new Shell(65760);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent arg0) {
                if (HingeAngleConfiguration.this._modified) {
                    MessageBox messageBox = new MessageBox(HingeAngleConfiguration.this.shell, 296);
                    messageBox.setText("Closing The Configuration Window");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to continue?");
                    if (messageBox.open() != 32) {
                        arg0.doit = false;
                        return;
                    }
                }
            }
        });
        this.shell.setImage(SWTResourceManager.getImage(LidModeConfiguration.class, "/resources/Intel.ico"));
        this.shell.setText("Hinge Angle Configuration");
        GridLayout shlHingeAngleGridLayout = new GridLayout(1, true);
        shlHingeAngleGridLayout.marginWidth = 10;
        shlHingeAngleGridLayout.marginHeight = 10;
        shlHingeAngleGridLayout.horizontalSpacing = 10;
        shlHingeAngleGridLayout.verticalSpacing = 10;
        this.shell.setLayout((Layout)shlHingeAngleGridLayout);
        Group grpHallConfig = GuiUtils.addGroupToComposite("Hall Config Table", (Composite)this.shell, 0, 4, 4, true, true, 1, 1, 3);
        TableViewer tvHallConfig = new TableViewer((Composite)grpHallConfig, 67586);
        this.tblHallConfig = tvHallConfig.getTable();
        this.tblHallConfig.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.tblHallConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int itemsSelected = HingeAngleConfiguration.this.tblHallConfig.getSelectionCount();
                if (itemsSelected == 1) {
                    HingeAngleConfiguration.this.btnEditHall.setEnabled(true);
                    HingeAngleConfiguration.this.btnDeleteHall.setEnabled(true);
                } else {
                    HingeAngleConfiguration.this.btnEditHall.setEnabled(false);
                    if (itemsSelected > 1) {
                        HingeAngleConfiguration.this.btnDeleteHall.setEnabled(true);
                    } else {
                        HingeAngleConfiguration.this.btnDeleteHall.setEnabled(false);
                    }
                }
            }
        });
        this.tblHallConfig.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                TableItem[] selectedItems = HingeAngleConfiguration.this.tblHallConfig.getSelection();
                if (selectedItems.length != 1) {
                    return;
                }
                new HingeAngleHallConfiguration(HingeAngleConfiguration.this._thisInstance, selectedItems[0], HingeAngleConfiguration.this.tblHallConfig.getSelectionIndex()).open();
            }
        });
        this.tblHallConfig.setLinesVisible(true);
        this.tblHallConfig.setHeaderVisible(true);
        final TableColumn tblclmnSensorType = new TableColumn(this.tblHallConfig, 0);
        tblclmnSensorType.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnSensorType.setText("SensorType");
        final TableColumn tblclmnInstanceId = new TableColumn(this.tblHallConfig, 0);
        tblclmnInstanceId.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnInstanceId.setText("Instance ID");
        this.tblHallConfig.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int oneWidth = ((HingeAngleConfiguration)HingeAngleConfiguration.this).tblHallConfig.getClientArea().width / 2;
                tblclmnSensorType.setWidth(oneWidth);
                tblclmnInstanceId.setWidth(oneWidth);
            }
        });
        this.btnAddHall = new Button((Composite)grpHallConfig, 0);
        GridData gd_btnAddHall = new GridData(131072, 4, true, false, 1, 1);
        gd_btnAddHall.widthHint = GuiUtils.getButtonWidth((Control)grpHallConfig);
        this.btnAddHall.setLayoutData((Object)gd_btnAddHall);
        this.btnAddHall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                HingeAngleConfiguration.this.tblHallConfig.deselectAll();
                if (HingeAngleConfiguration.this.tblHallConfig.getItemCount() < 6) {
                    new HingeAngleHallConfiguration(HingeAngleConfiguration.this._thisInstance, null, 0).open();
                } else {
                    GuiUtils.showErrorMessage(HingeAngleConfiguration.this.shell, "Error", "The hall config cannot exceed 6.");
                }
            }
        });
        this.btnAddHall.setText("Add");
        this.btnEditHall = new Button((Composite)grpHallConfig, 0);
        GridData gd_btnEditHall = new GridData(4, 4, false, false, 1, 1);
        gd_btnEditHall.widthHint = GuiUtils.getButtonWidth((Control)grpHallConfig);
        this.btnEditHall.setLayoutData((Object)gd_btnEditHall);
        this.btnEditHall.setEnabled(false);
        this.btnEditHall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TableItem[] selectedItems = HingeAngleConfiguration.this.tblHallConfig.getSelection();
                if (selectedItems.length != 1) {
                    return;
                }
                new HingeAngleHallConfiguration(HingeAngleConfiguration.this._thisInstance, selectedItems[0], HingeAngleConfiguration.this.tblHallConfig.getSelectionIndex()).open();
            }
        });
        this.btnEditHall.setText("Edit");
        this.btnDeleteHall = new Button((Composite)grpHallConfig, 0);
        GridData gd_btnDeleteHall = new GridData(4, 4, false, false, 1, 1);
        gd_btnDeleteHall.widthHint = GuiUtils.getButtonWidth((Control)grpHallConfig);
        this.btnDeleteHall.setLayoutData((Object)gd_btnDeleteHall);
        this.btnDeleteHall.setEnabled(false);
        this.btnDeleteHall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                HingeAngleConfiguration.this.deleteHallConfig();
            }
        });
        this.btnDeleteHall.setText("Delete");
        Group grpHingeAngle = GuiUtils.addGroupToComposite("Hinge Angle Config Table", (Composite)this.shell, 0, 4, 4, true, true, 1, 1, 3);
        this.tbvHingeAngle = new TableViewer((Composite)grpHingeAngle, 67586);
        this.tblHingeAngleConfig = this.tbvHingeAngle.getTable();
        this.tblHingeAngleConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int itemsSelected = HingeAngleConfiguration.this.tblHingeAngleConfig.getSelectionCount();
                if (itemsSelected == 1) {
                    HingeAngleConfiguration.this.btnEditHingeAngle.setEnabled(true);
                    HingeAngleConfiguration.this.btnDeleteHingeAngle.setEnabled(true);
                } else {
                    HingeAngleConfiguration.this.btnEditHingeAngle.setEnabled(false);
                    if (itemsSelected > 1) {
                        HingeAngleConfiguration.this.btnDeleteHingeAngle.setEnabled(true);
                    } else {
                        HingeAngleConfiguration.this.btnDeleteHingeAngle.setEnabled(false);
                    }
                }
            }
        });
        this.tblHingeAngleConfig.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                HingeAngleConfiguration.this.editHingeAngleConfigTableItem();
            }
        });
        this.tblHingeAngleConfig.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.tblHingeAngleConfig.setHeaderVisible(true);
        this.tblHingeAngleConfig.setLinesVisible(true);
        TableViewerColumn tbvcAngleOutput = new TableViewerColumn(this.tbvHingeAngle, 0);
        final TableColumn tblclmnAngleOutput = tbvcAngleOutput.getColumn();
        tblclmnAngleOutput.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnAngleOutput.setText("Angle Output");
        TableViewerColumn tbvcEntryAngle = new TableViewerColumn(this.tbvHingeAngle, 0);
        final TableColumn tblclmnEntryAngle = tbvcEntryAngle.getColumn();
        tblclmnEntryAngle.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnEntryAngle.setText("Entry Angle");
        TableViewerColumn tbvcExitAngle = new TableViewerColumn(this.tbvHingeAngle, 0);
        final TableColumn tblclmnExitAngle = tbvcExitAngle.getColumn();
        tblclmnExitAngle.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnExitAngle.setText("Exit Angle");
        TableViewerColumn tbvcDeltaT1 = new TableViewerColumn(this.tbvHingeAngle, 0);
        final TableColumn tblclmnDeltaT1 = tbvcDeltaT1.getColumn();
        tblclmnDeltaT1.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnDeltaT1.setText("Entry Angle Tolerance");
        TableViewerColumn tbvcDeltaT2 = new TableViewerColumn(this.tbvHingeAngle, 0);
        final TableColumn tblclmnDeltaT2 = tbvcDeltaT2.getColumn();
        tblclmnDeltaT2.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnDeltaT2.setText("Exit Angle Tolerance");
        TableViewerColumn tbvcTh = new TableViewerColumn(this.tbvHingeAngle, 0);
        final TableColumn tblclmnTh = tbvcTh.getColumn();
        tblclmnTh.addControlListener((ControlListener)this.resizeColHandler);
        tblclmnTh.setText("Time Hysteresis");
        this.tblHingeAngleConfig.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int oneWidth = ((HingeAngleConfiguration)HingeAngleConfiguration.this).tblHingeAngleConfig.getClientArea().width / 20;
                tblclmnAngleOutput.setWidth(oneWidth * 3);
                tblclmnEntryAngle.setWidth(oneWidth * 3);
                tblclmnExitAngle.setWidth(oneWidth * 3);
                tblclmnDeltaT1.setWidth(oneWidth * 4);
                tblclmnDeltaT2.setWidth(oneWidth * 4);
                tblclmnTh.setWidth(oneWidth * 3);
            }
        });
        this.btnAddHingeAngle = new Button((Composite)grpHingeAngle, 0);
        GridData gd_btnAddEntry = new GridData(131072, 4, true, false, 1, 1);
        gd_btnAddEntry.widthHint = GuiUtils.getButtonWidth((Control)grpHingeAngle);
        this.btnAddHingeAngle.setLayoutData((Object)gd_btnAddEntry);
        this.btnAddHingeAngle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                HingeAngleConfiguration.this.tblHingeAngleConfig.setSelection(new int[0]);
                new HingeAngleConfigurationModifier(HingeAngleConfiguration.this._thisInstance, null, HingeAngleConfiguration.this._hallConfigs).open();
            }
        });
        this.btnAddHingeAngle.setText("Add");
        this.btnEditHingeAngle = new Button((Composite)grpHingeAngle, 0);
        GridData gd_btnEditEntry = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_btnEditEntry.widthHint = GuiUtils.getButtonWidth((Control)grpHingeAngle);
        this.btnEditHingeAngle.setLayoutData((Object)gd_btnEditEntry);
        this.btnEditHingeAngle.setEnabled(false);
        this.btnEditHingeAngle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                HingeAngleConfiguration.this.editHingeAngleConfigTableItem();
            }
        });
        this.btnEditHingeAngle.setText("Edit");
        this.btnDeleteHingeAngle = new Button((Composite)grpHingeAngle, 0);
        this.btnDeleteHingeAngle.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        GridData gd_btnDeleteEntry = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnDeleteEntry.widthHint = GuiUtils.getButtonWidth((Control)grpHingeAngle);
        this.btnDeleteHingeAngle.setLayoutData((Object)gd_btnDeleteEntry);
        this.btnDeleteHingeAngle.setEnabled(false);
        this.btnDeleteHingeAngle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] selectedIndices = HingeAngleConfiguration.this.tblHingeAngleConfig.getSelectionIndices();
                if (selectedIndices.length > 0) {
                    HingeAngleConfiguration.this.tblHingeAngleConfig.remove(selectedIndices);
                }
                HingeAngleConfiguration.this.btnEditHingeAngle.setEnabled(false);
                HingeAngleConfiguration.this.btnDeleteHingeAngle.setEnabled(false);
                HingeAngleConfiguration.this.refreshButtonsAfterConfNumChange();
                HingeAngleConfiguration.this.setModified();
            }
        });
        this.btnDeleteHingeAngle.setText("Delete");
        Composite cmpBottomButtons = GuiUtils.addCompositeToComposite((Composite)this.shell, 0, 4, 4, true, false, 3, 1, 2);
        this.btnSaveAndClose = new Button(cmpBottomButtons, 0);
        GridData gd_btnSaveAndClose = new GridData(131072, 4, true, false, 1, 1);
        gd_btnSaveAndClose.widthHint = GuiUtils.getButtonWidth((Control)cmpBottomButtons);
        this.btnSaveAndClose.setLayoutData((Object)gd_btnSaveAndClose);
        this.btnSaveAndClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                HingeAngleConfiguration.this.saveData();
            }
        });
        this.btnSaveAndClose.setText("Save and Close");
        Button btnCancel = new Button(cmpBottomButtons, 0);
        GridData gd_btnCancel = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)cmpBottomButtons);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                HingeAngleConfiguration.this.shell.close();
            }
        });
        btnCancel.setText("Cancel");
        this.shell.setSize(GuiUtils.getPixelSizeWidth((Control)this.shell) * 156, GuiUtils.getPixelSizeHeight((Control)this.shell) * 45);
        this.shell.setLocation(GuiUtils.getMiddleLocation(this.shell, this.display));
    }

    public void saveData() {
        boolean newConfiguration = false;
        if (DataStore.getInstance().getCurrentPdtFile() == null) {
            System.err.println("null PDT file");
        }
        ArrayList<HingeAngleConfigurationPayload.HingeAngleConfig> hingeAngleConfigList = new ArrayList<HingeAngleConfigurationPayload.HingeAngleConfig>();
        for (int i = 0; i < this.tblHingeAngleConfig.getItemCount(); ++i) {
            TableItem configTableItem = this.tblHingeAngleConfig.getItem(i);
            HingeAngleConfigurationPayload.HingeAngleConfig hingeAngleConfig = new HingeAngleConfigurationPayload.HingeAngleConfig();
            hingeAngleConfig.angleOutput = Integer.valueOf(configTableItem.getText(0));
            hingeAngleConfig.entryAngle = Integer.valueOf(configTableItem.getText(1));
            hingeAngleConfig.exitAngle = Integer.valueOf(configTableItem.getText(2));
            hingeAngleConfig.t1Delta = Integer.valueOf(configTableItem.getText(3));
            hingeAngleConfig.t2Delta = Integer.valueOf(configTableItem.getText(4));
            hingeAngleConfig.th = Integer.valueOf(configTableItem.getText(5));
            for (int j = 0; j < this._hallConfigs.size(); ++j) {
                String currentHallState = configTableItem.getText(6 + j);
                hingeAngleConfig.hallStates[j] = currentHallState.equals("Inactive") ? 0 : (currentHallState.equals("Active") ? 1 : 255);
            }
            hingeAngleConfigList.add(hingeAngleConfig);
        }
        if (this._payload == null) {
            this._payload = new HingeAngleConfigurationPayload();
            newConfiguration = true;
        }
        this._payload.setHingeAngleConfigs(hingeAngleConfigList);
        this._payload.setHallConfigs(this._hallConfigs);
        if (newConfiguration) {
            if (this._sensor != null) {
                this._sensor.addPayload(this._payload);
            }
            if (this._parent != null) {
                this._parent.addNewConfiguration(this._payload);
            }
        }
        this._modified = false;
        if (this._parent != null) {
            this._parent.setModified();
        }
        this.shell.close();
    }

    public void setModified() {
        this._modified = true;
    }

    @Override
    public String getConfigurationFormatName() {
        return "Hinge Angle Configuration";
    }
}

