/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import pdtEditor.InformationStore;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.InterruptsModifierOpener;
import pdtEditor.gui.InteruptsModifier;
import pdtEditor.payloads.GpioPayload;

public class GpioInfo
implements InterruptsModifierOpener {
    GuiUtils.WindowProperties _parentProperties = null;
    private Group grpGpioInfo;
    private Composite _parent;
    private TableViewer tblVwrInterrupts;
    private Table tblInterrupts;
    private TableColumn tblclmnPurpose;
    private TableColumn tblclmnPurposeId;
    private TableColumn tblclmnGPIOID;
    private TableColumn tblclmnMode;
    private Button btnRemove;
    private Button btnEdit;
    private InformationStore infoStore = InformationStore.getInstance();
    private Sensor _sensor = null;
    private Shell _shell;

    public GpioInfo(GuiUtils.WindowProperties parentProperties) throws Exception {
        this._parentProperties = parentProperties;
    }

    public void copyGpioInfo(GpioInfo other) {
        if (this.grpGpioInfo == null || this.grpGpioInfo.isDisposed()) {
            throw new UnsupportedOperationException("You must draw the GPIO info before coping data into it.");
        }
        TableItem[] items = other.tblInterrupts.getItems();
        this.clear();
        for (TableItem otherItem : items) {
            TableItem item = new TableItem(this.tblInterrupts, 0);
            for (int i = 0; i < otherItem.getParent().getColumnCount(); ++i) {
                item.setText(i, otherItem.getText(i));
            }
        }
        this._sensor = other._sensor;
    }

    @Override
    public void setModified() {
        this._parentProperties.setModified(true);
    }

    public void fillData(GpioPayload gpio) {
        if (gpio != null) {
            for (GpioPayload.Gpio gpioEntry : gpio.getGpios()) {
                this.addGpioToTable(String.valueOf(gpioEntry.getPurpose()), String.valueOf(gpioEntry.getPinNumber()), this.infoStore.getGpioModeName(gpioEntry.getModeGPIO()));
            }
        }
    }

    public GpioPayload gpioPayloadFromFields() {
        GpioPayload gpioPayload = new GpioPayload(new ArrayList<GpioPayload.Gpio>());
        TableItem[] gpioTableItems = this.tblInterrupts.getItems();
        if (gpioTableItems.length > 0) {
            for (int i = 0; i < gpioTableItems.length; ++i) {
                int mode;
                int purpose = Integer.valueOf(gpioTableItems[i].getText(1));
                int pinNumber = Integer.valueOf(gpioTableItems[i].getText(2));
                try {
                    mode = Integer.valueOf(gpioTableItems[i].getText(3));
                }
                catch (NumberFormatException e) {
                    mode = this.infoStore.getGpioModeId(gpioTableItems[i].getText(3));
                }
                gpioPayload.addGpio(purpose, pinNumber, mode);
            }
        }
        return gpioPayload;
    }

    public void setEnabled(boolean enabled) {
        this.grpGpioInfo.setEnabled(enabled);
        for (Control control : this.grpGpioInfo.getChildren()) {
            control.setEnabled(enabled);
        }
    }

    public void setSensor(Sensor sensor) {
        this._sensor = sensor;
    }

    public void clear() {
        this.tblInterrupts.removeAll();
    }

    public void editGPIO() {
        int selectedLine = this.tblInterrupts.getSelectionIndex();
        if (selectedLine == -1) {
            return;
        }
        InteruptsModifier interMod = new InteruptsModifier(this, this._sensor, selectedLine);
        interMod.open();
    }

    public void addGPIO() {
        InteruptsModifier interMod = new InteruptsModifier(this, this._sensor);
        this.tblInterrupts.deselectAll();
        interMod.open();
    }

    public void removeGPIO() {
        this.tblInterrupts.remove(this.tblInterrupts.getSelectionIndices());
        this.btnRemove.setEnabled(false);
        this.btnEdit.setEnabled(false);
    }

    @Override
    public int[] getGpioSelectionIndices() {
        return this.tblInterrupts.getSelectionIndices();
    }

    @Override
    public int getGpioCount() {
        return this.tblInterrupts.getItemCount();
    }

    @Override
    public void addGpioToTable(String purposeID, String pinNumber, String modelGpio) {
        TableItem item = new TableItem(this.tblInterrupts, 0);
        item.setText(new String[]{InteruptsModifier.getPurposeById(this._sensor, Integer.valueOf(purposeID)), String.valueOf(purposeID), String.valueOf(pinNumber), String.valueOf(modelGpio)});
    }

    @Override
    public void updateGpioLine(int lineIndex, HashMap<String, String> values) {
        TableItem item = this.tblInterrupts.getItem(lineIndex);
        item.setText(0, InteruptsModifier.getPurposeById(this._sensor, Integer.valueOf(values.get("purposeID"))));
        item.setText(1, values.get("purposeID"));
        item.setText(2, values.get("pinNumber"));
        item.setText(3, values.get("modeGpio"));
    }

    @Override
    public HashMap<String, String> getLineValues(int lineIndex) {
        HashMap<String, String> res = new HashMap<String, String>();
        TableItem item = this.tblInterrupts.getItem(lineIndex);
        res.put("purpose", item.getText(0));
        res.put("purposeID", item.getText(1));
        res.put("pinNumber", item.getText(2));
        res.put("modeGpio", item.getText(3));
        return res;
    }

    public TableItem[] getAllGpioLines() {
        return this.tblInterrupts.getItems();
    }

    @Override
    public Shell getShell() {
        return this._shell;
    }

    public Group drawGpioInfo(Shell shell, Composite parent) {
        this._shell = shell;
        this._parent = parent;
        this.grpGpioInfo = GuiUtils.addGroupToComposite("GPIO Information", parent, 0, 4, 4, true, false, 1, 1, 1);
        this.tblVwrInterrupts = new TableViewer((Composite)this.grpGpioInfo, 67586);
        this.tblInterrupts = this.tblVwrInterrupts.getTable();
        this.tblInterrupts.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tblclmnPurpose = new TableColumn(this.tblInterrupts, 0);
        this.tblclmnPurpose.setResizable(false);
        this.tblclmnPurpose.setText("Purpose");
        this.tblclmnPurposeId = new TableColumn(this.tblInterrupts, 0);
        this.tblclmnPurposeId.setText("Purpose ID");
        this.tblclmnGPIOID = new TableColumn(this.tblInterrupts, 0);
        this.tblclmnGPIOID.setText("ISS GPIO ID");
        this.tblclmnMode = new TableColumn(this.tblInterrupts, 0);
        this.tblclmnMode.setText("Mode");
        Composite compositeShellButton = GuiUtils.addCompositeToComposite((Composite)this.grpGpioInfo, 0, 131072, 0x1000000, false, false, 1, 1, 3);
        Button btnAdd = GuiUtils.addButtonToComposite("Add", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        this.btnEdit = GuiUtils.addButtonToComposite("Edit", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        this.btnRemove = GuiUtils.addButtonToComposite("Remove", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GpioInfo.this.addGPIO();
            }
        });
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GpioInfo.this.removeGPIO();
            }
        });
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GpioInfo.this.editGPIO();
            }
        });
        this.tblInterrupts.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GpioInfo.this.tblInterrupts.getSelectionCount() > 0) {
                    GpioInfo.this.btnRemove.setEnabled(true);
                    if (GpioInfo.this.tblInterrupts.getSelectionCount() == 1) {
                        GpioInfo.this.btnEdit.setEnabled(true);
                    } else {
                        GpioInfo.this.btnEdit.setEnabled(false);
                    }
                }
            }
        });
        this.tblInterrupts.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                GpioInfo.this.editGPIO();
            }
        });
        ControlAdapter resizeColHandler = new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                if (((TableColumn)arg0.getSource()).getWidth() < 50) {
                    ((TableColumn)arg0.getSource()).setWidth(50);
                }
            }
        };
        this.btnRemove.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.tblInterrupts.setLinesVisible(true);
        this.tblInterrupts.setHeaderVisible(true);
        this.tblclmnPurpose.addControlListener((ControlListener)resizeColHandler);
        this.tblclmnPurposeId.addControlListener((ControlListener)resizeColHandler);
        this.tblclmnGPIOID.addControlListener((ControlListener)resizeColHandler);
        this.tblclmnMode.addControlListener((ControlListener)resizeColHandler);
        int shortButtonMinWidth = GuiUtils.getButtonWidth((Control)btnAdd);
        int tableMinHeight = GuiUtils.getPixelSizeHeight((Control)this.grpGpioInfo) * 8;
        int tableItemLongWidth = GuiUtils.getButtonWidth((Control)btnAdd) * 3;
        int tableItemShortWidth = (int)((double)GuiUtils.getButtonWidth((Control)btnAdd) * 1.5);
        ((GridData)btnAdd.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)this.btnEdit.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)this.btnRemove.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)this.tblInterrupts.getLayoutData()).heightHint = tableMinHeight;
        ((GridLayout)compositeShellButton.getLayout()).verticalSpacing = 0;
        ((GridLayout)compositeShellButton.getLayout()).marginHeight = 0;
        ((GridLayout)compositeShellButton.getLayout()).marginWidth = 0;
        this.tblclmnPurpose.setWidth(tableItemLongWidth);
        this.tblclmnPurposeId.setWidth(tableItemShortWidth);
        this.tblclmnGPIOID.setWidth(tableItemShortWidth);
        this.tblclmnMode.setWidth(tableItemShortWidth);
        return this.grpGpioInfo;
    }
}

