/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.configuration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.Device;
import pdtEditor.Luid;
import pdtEditor.Sensor;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.calibration.NewCalibration;
import pdtEditor.gui.configuration.ConfigurationEditor;
import pdtEditor.payloads.PayloadUtils;
import pdtEditor.payloads.calibrations.CalibrationPayload;

public class NewConfiguration {
    private DataBindingContext m_bindingContext;
    protected Object result;
    protected Shell shell;
    private SensorModifier _configurationViewer = null;
    private Device _device = null;
    private Sensor _givenSensor = null;
    private ArrayList<ConfigurationEditor> _configurationSuggestions = new ArrayList();
    private ArrayList<Sensor> _configurationlessSensors = null;
    private Display display;
    private Table tblSensors;
    private TableViewer tblVwrSensors;
    private Button btnOk;
    private Table tblConfiguration;
    private TableViewer tblVwrConfiguration;
    private GridData gd_lblSensor;
    private GridData gd_tblSensors;

    public NewConfiguration(int style, SensorModifier configurationViewer, Sensor currSensor) {
        this._configurationViewer = configurationViewer;
        this._device = configurationViewer.getCurrentDevice();
        if (currSensor == null) {
            this._configurationlessSensors = new ArrayList();
            for (Sensor sensor : this._device.getSensors()) {
                if (this._configurationViewer.hasSensorInTable(sensor) || sensor.getPayloadByClass(CalibrationPayload.class) != null) continue;
                this._configurationlessSensors.add(sensor);
            }
        } else {
            this._givenSensor = currSensor;
        }
    }

    public Object open() {
        this.display = Display.getDefault();
        this.createContents();
        if (this._givenSensor != null) {
            int configurationNum = this.updateConfigurationsList(this._givenSensor);
            if (configurationNum == 0) {
                if (this.shell == null) {
                    System.err.println("Failed to show an error message - no avalible configuration types for this sensor.");
                    return null;
                }
                MessageBox messageBox = new MessageBox(this.shell, 296);
                messageBox.setText("No Configuration Suggestions");
                messageBox.setMessage("There are no avalible configuration types for this sensor.");
                messageBox.open();
                return null;
            }
            if (configurationNum == 1) {
                this.tblConfiguration.select(0);
                this._configurationSuggestions.get(0).open();
                return this.result;
            }
        }
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.result;
    }

    private int updateConfigurationsList(Sensor sensor) {
        this.tblConfiguration.removeAll();
        this.updateConfigurationSuggestions(sensor);
        for (ConfigurationEditor editor : this._configurationSuggestions) {
            TableItem item = new TableItem(this.tblConfiguration, 0);
            item.setText(editor.getConfigurationFormatName());
        }
        this.tblConfiguration.setEnabled(true);
        this.btnOk.setEnabled(false);
        return this._configurationSuggestions.size();
    }

    private void updateConfigurationSuggestions(Sensor sensor) {
        try {
            this._configurationSuggestions.clear();
            Luid luid = sensor.getLuid();
            List<CalibrationPayload.PayloadFormatInfo> configurationCodesForSensor = CalibrationPayload.getCalibrationType(luid, -1, false);
            if (configurationCodesForSensor == null) {
                System.err.println("configurationCodesForSensor is null");
                return;
            }
            for (CalibrationPayload.PayloadFormatInfo calibrationNum : configurationCodesForSensor) {
                ConfigurationEditor editor;
                if (calibrationNum.dataType != 1 || (editor = PayloadUtils.getConfigurationEditor(calibrationNum.format, sensor, this._configurationViewer)) == null) continue;
                this._configurationSuggestions.add(editor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void openNewConfigurationWindow() {
        int selection = this.tblConfiguration.getSelectionIndex();
        if (this.tblSensors.getSelectionIndex() < 0 && this._givenSensor == null || this.tblConfiguration.getSelectionIndex() < 0) {
            return;
        }
        this._configurationSuggestions.get(selection).open();
    }

    public void onOkClick() {
        this.shell.setVisible(false);
        this.openNewConfigurationWindow();
        this.shell.close();
    }

    private void createContents() {
        this.shell = new Shell(67648);
        this.shell.setImage(SWTResourceManager.getImage(NewCalibration.class, "/resources/Intel.ico"));
        this.shell.setText("New Calibration");
        GuiUtils.setGridLayoutToComposite((Composite)this.shell, 2);
        Label lblSensor = new Label((Composite)this.shell, 0);
        lblSensor.setText("Select a sensor:");
        lblSensor.setFont(SWTResourceManager.getFont("Segoe UI", 10, 1));
        this.gd_lblSensor = new GridData(4, 0x1000000, false, false, 2, 1);
        lblSensor.setLayoutData((Object)this.gd_lblSensor);
        this.tblVwrSensors = new TableViewer((Composite)this.shell, 67584);
        this.tblSensors = this.tblVwrSensors.getTable();
        this.tblSensors.setLinesVisible(true);
        this.tblSensors.setHeaderVisible(true);
        this.gd_tblSensors = new GridData(4, 4, true, true, 2, 1);
        this.tblSensors.setLayoutData((Object)this.gd_tblSensors);
        this.tblSensors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConfiguration.this.updateConfigurationsList((Sensor)NewConfiguration.this.tblSensors.getSelection()[0].getData());
            }
        });
        ControlAdapter resizeColHandler = new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                if (((TableColumn)arg0.getSource()).getWidth() < 50) {
                    ((TableColumn)arg0.getSource()).setWidth(50);
                }
            }
        };
        TableViewerColumn tblVwrClmnType = new TableViewerColumn(this.tblVwrSensors, 0);
        final TableColumn tblClmnType = tblVwrClmnType.getColumn();
        tblClmnType.addControlListener((ControlListener)resizeColHandler);
        tblClmnType.setText("Sensor Type");
        TableViewerColumn tblVwrClmnModel = new TableViewerColumn(this.tblVwrSensors, 0);
        final TableColumn tblClmnModel = tblVwrClmnModel.getColumn();
        tblClmnModel.addControlListener((ControlListener)resizeColHandler);
        tblClmnModel.setText("Sensor Model");
        TableViewerColumn tblVwrClmnFlags = new TableViewerColumn(this.tblVwrSensors, 0);
        final TableColumn tblClmnFlags = tblVwrClmnFlags.getColumn();
        tblClmnFlags.addControlListener((ControlListener)resizeColHandler);
        tblClmnFlags.setText("Flags");
        TableViewerColumn tblVwrClmnInstance = new TableViewerColumn(this.tblVwrSensors, 0);
        final TableColumn tblClmnInstance = tblVwrClmnInstance.getColumn();
        tblClmnInstance.addControlListener((ControlListener)resizeColHandler);
        tblClmnInstance.setText("Instance");
        this.tblSensors.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int oneWidth = ((NewConfiguration)NewConfiguration.this).tblSensors.getClientArea().width / 6;
                tblClmnType.setWidth(oneWidth * 2);
                tblClmnModel.setWidth(oneWidth);
                tblClmnFlags.setWidth(oneWidth * 2);
                tblClmnInstance.setWidth(oneWidth);
            }
        });
        Label lblConfiguration = new Label((Composite)this.shell, 0);
        lblConfiguration.setFont(SWTResourceManager.getFont("Segoe UI", 10, 1));
        lblConfiguration.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        lblConfiguration.setText("Select a configuraion type:");
        this.tblVwrConfiguration = new TableViewer((Composite)this.shell, 67584);
        this.tblConfiguration = this.tblVwrConfiguration.getTable();
        this.tblConfiguration.setLinesVisible(true);
        this.tblConfiguration.setFont(SWTResourceManager.getFont("Segoe UI", 9, 0));
        this.tblConfiguration.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.tblConfiguration.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                if (NewConfiguration.this.tblConfiguration.getSelectionCount() == 0) {
                    return;
                }
                NewConfiguration.this.onOkClick();
            }
        });
        this.tblConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewConfiguration.this.tblConfiguration.getSelectionIndex() >= 0) {
                    NewConfiguration.this.btnOk.setEnabled(true);
                } else {
                    NewConfiguration.this.btnOk.setEnabled(false);
                }
            }
        });
        TableViewerColumn tblVwrClmnConfiguration = new TableViewerColumn(this.tblVwrConfiguration, 0);
        final TableColumn tblClmnConfiguration = tblVwrClmnConfiguration.getColumn();
        tblClmnConfiguration.setWidth(this.tblConfiguration.getSize().x - 30);
        tblClmnConfiguration.setText("CalibrationName");
        this.tblConfiguration.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int oneWidth = ((NewConfiguration)NewConfiguration.this).tblSensors.getClientArea().width;
                tblClmnConfiguration.setWidth(oneWidth);
            }
        });
        this.btnOk = new Button((Composite)this.shell, 0);
        this.btnOk.setEnabled(false);
        this.btnOk.setText("OK");
        GridData gd_btnOk = new GridData(131072, 0x1000000, true, false, 1, 1);
        this.btnOk.setLayoutData((Object)gd_btnOk);
        gd_btnOk.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        this.btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConfiguration.this.onOkClick();
            }
        });
        Button btnCancel = new Button((Composite)this.shell, 0);
        btnCancel.setText("Cancel");
        GridData gd_btnCancel = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        btnCancel.setLayoutData((Object)gd_btnCancel);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shell);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConfiguration.this.shell.close();
            }
        });
        this.shell.setSize(GuiUtils.getButtonWidth((Control)this.shell) * 8, GuiUtils.getButtonWidth((Control)this.shell) * 5);
        if (this._givenSensor != null) {
            lblSensor.setVisible(false);
            this.gd_lblSensor.exclude = true;
            this.tblSensors.setVisible(false);
            this.gd_tblSensors.exclude = true;
            this.shell.setSize(this.shell.getSize().x, this.shell.getSize().y / 3 * 2);
        }
        this.shell.setLocation(GuiUtils.getMiddleLocation(this.shell, this.display));
        this.m_bindingContext = this.initDataBindings();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap[] observeMaps = PojoObservables.observeMaps((IObservableSet)listContentProvider.getKnownElements(), Sensor.class, (String[])new String[]{"luid.sensorTypeIdStr", "luid.sensorSubTypeIdStr", "luid.flagsStr", "luid.instanceId"});
        this.tblVwrSensors.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps));
        this.tblVwrSensors.setContentProvider((IContentProvider)listContentProvider);
        IObservableList selfList = Properties.selfList(Sensor.class).observe(this._configurationlessSensors);
        this.tblVwrSensors.setInput((Object)selfList);
        return bindingContext;
    }
}

