<?php
class HyperSSD extends Device {
    //put your code here
    private $id;
    //private $part_func_map;
    private $size;
    private $start;
    //private $type;
    private $associatedDisk;
    //private $FilterDriverInstall;
    //private $FilterDriverRun;
    private $status;
    private $bga_percentage;
    private $hyper_policy;
    private $cache_policy;

    public function getAssociatedDisk()
    {
        return $this->associatedDisk;
    }

    public function setAssociatedDisk($associatedDisk)
    {
        $this->associatedDisk = $associatedDisk;
    }

    public function isSAS() {
        return false;
    }

    public function getID() {
        return $this->id;
    }
    
    public function getCachePolicy() {
        return $this->cache_policy;
    }
    
    public function getSize() {
        return $this->size;
    }
    
    public function getStatus() {
        return $this->status;
    }
    
    public function getStart() {
        return $this->start;
    }
    
    public function getBgaPercentage() {
        return $this->bga_percentage;
    }

    public function isHyperSSDRebuilding() {
        return ( ($this->status & HyperSSDStatus::HYPERSSD_STATUS_DISK_BIND)
                && ($this->status & HyperSSDStatus::HYPERSSD_STATUS_REBUILDING) );
    }

    public function isHyperSSDNeedReboot() {
        return ( ($this->status & HyperSSDStatus::HYPERSSD_STATUS_DISK_BIND)
                && ($this->status & HyperSSDStatus::HYPERSSD_STATUS_NON_REBUILT) );
    }

    public function isHyperSSDMissing() {
        return ($this->status & HyperSSDStatus::HYPERSSD_STATUS_DISK_MISSING);
    }

    public function isHyperSSDNoneBind() {
        return !($this->status & HyperSSDStatus::HYPERSSD_STATUS_DISK_BIND)
                && !($this->status & HyperSSDStatus::HYPERSSD_STATUS_DISK_MISSING);
    }

    public function setHyperSSDInfo($info) {
        if(isset($info->partition_id)) {
            $this->id=trim($info->partition_id);
        }
        if(isset($Info->cache_policy)) {
            $this->cache_policy = trim($Info->cache_policy);
        }
        if(isset($Info->hyper_policy)) {
            $this->hyper_policy = trim($Info->hyper_policy);
        }
        if(isset($info->size)) {
            $this->size=trim($info->size);
        }
        if(isset($info->start)) {
            $this->start=trim($info->start);
        }
        if(isset($info->status)) {
            $this->status = trim($info->status);
        }
        if(isset($info->bga_percentage)) {
            $this->bga_percentage=trim($info->bga_percentage);
        }

        if(isset($info->disk_info_t)) {
            $this->associatedDisk = new SystemDisk();
            foreach($info->disk_info_t as $diskInfo) {
                $this->associatedDisk->setSerialNumber(trim($diskInfo->serial));
                //$this->associatedDisk->setSize(trim($diskInfo->DiskSize));
                $this->associatedDisk->setModel(trim($diskInfo->model));
                //$this->associatedDisk->setDevPath(trim($diskInfo->devPath));
                $this->associatedDisk->setDiskNumber(trim($diskInfo->disk_number));
                //$this->associatedDisk->setInstanceID(trim($diskInfo->instanceID));
            }
        }        
    }
}
?>
