<?php
class CtnDgList extends Container
{
	private $toGetDGInfo = false;
	private $toGetDGConfig;
	
	private $adapterId = 0;
	
	public function toGetDGInfo()
	{
		$this->toGetDGInfo = true;
	}
	
	public function toGetDGConfig()
	{
		$this->toGetDGConfig = true;
	}
	
	public function setAdapterID($adapterId)
	{
		$this->adapterId = $adapterId;
	}
	
	protected function setBase()
	{
		$this->base = new DgList();
		$this->base->setAdapterID($this->adapterId);
		if ($this->toGetDGInfo) {
			$this->base->toGetDGInfo();
		}
		
		if ($this->toGetDGConfig) {
			$this->base->toGetDGConfig();
		}
		
		$this->base->toGetDgHDInfo();
		$this->base->toGetDgLDInfo();
	}

	
	public function displayXML()
	{
		$this->display("XML_LdList.tpl");
	}
	
	protected function setDataToPage()
	{
		$DgList = array();
		$baseclasses = $this->filter($this->base->getBaseClasses());
		//var_dump($baseclasses);
		foreach ($baseclasses as $DG)
		{
			$dgInfo = new DgInfo();
			$dgInfo->setDGInfo($DG);
			$DgList[$dgInfo->ID] = $dgInfo;
		}
		
		ksort($DgList);
		$this->setInfo($DgList);
		$this->smarty->assign("DgList",$DgList);

	}
}
?>