<?php
//the class provide xml manipulation by 
//offering query,insert,delete,update functions of BGAJob
class BGAJobDataAccess extends XMLDataAccess 
{
	public function __construct($fileName=null)
	{
		$this->eleName = "Schedule";
		$this->parentName = 'BGASchedules';
		if ($fileName) {
			$this->fileName = $fileName;
		}
		else {
			$this->fileName = realpath("../db/db.xml");
		}
		parent::__construct($this->fileName);
	}
	
	public function __destruct()
	{
		parent::__destruct();
	}
	
	public function getAllBGAJobs()
	{
		$data = array('mykeys' => array());
		return $this->query($data);
	}

        public function getJobsByType($bgaType)
        {
            $data = array('mykeys' => array('bgaType'=>$bgaType));
            return $this->query($data);
        }
	
	public function addJob($job)
	{
		$myvalues = array();
				
		$myvalues['VDID'] = $job->getVDID();
		$myvalues['bgaType'] = $job->getBgaType();
		$myvalues['cmdPara'] = $job->getCmdPara();
		$myvalues['settingType'] = $job->getSettingType();
		$myvalues['settingTime'] = $job->getSettingTime();
		$myvalues['settingDate'] = $job->getSettingDate();
		$myvalues['settingDateSupplement'] = $job->getSettingDateSupplement();
		$myvalues['startTime'] = $job->getStartTime();
		$myvalues['status'] = $job->getStatus();
		$myvalues['result'] = $job->getResult();
		$myvalues['resultText'] = $job->getResultText();
		
		//generate ID
		while (true) {
			$ID = rand(0x1111111,0x9999999);
			$job = $this->getBGAJobByID($ID);
			if ($job) {
				continue;
			}
			else 
			{
				$myvalues['index'] = $ID;
				break;
			}
		}
		
		$data = array('myvalues'=>$myvalues);
		
		$this->insert($data);
		
		return $ID;
	}
	
	public function getBGAJobByID($ID)
	{
		$data = array('mykeys' => array('index' => $ID));
		$jobs = $this->query($data);
		if ($jobs) {
			return $jobs[0];
		}
		else 
			return false;
	}
	
	public function updateBGAJobDetailByID($ID,$bgaType,$cmdPara)
	{
		$mykeys = array('index' => $ID);
		
		$myvalues = array();
		
		$myvalues['bgaType'] = $bgaType;
		$myvalues['cmdPara'] = $cmdPara;
		
		$data = array('mykeys' => $mykeys, 'myvalues'=>$myvalues);
		
		return $this->update($data);
	}
	
	public function updateBGAJobByID($ID,$job)
	{
		$mykeys = array('index' => $ID);
		$myvalues = array();
		
		$myvalues['VDID'] = $job->getVDID();
		$myvalues['bgaType'] = $job->getBgaType();
		$myvalues['cmdPara'] = $job->getCmdPara();
		if($job->getSettingType() != '')
			$myvalues['settingType'] = $job->getSettingType();
		if($job->getSettingTime() != '')
			$myvalues['settingTime'] = $job->getSettingTime();
		if($job->getSettingDate() != '')
			$myvalues['settingDate'] = $job->getSettingDate();
		if($job->getSettingDateSupplement() != '')
			$myvalues['settingDateSupplement'] = $job->getSettingDateSupplement();
		$myvalues['status'] = ScheduleStatus::NOT_RUN;
        
		$data = array('mykeys' => $mykeys, 'myvalues'=>$myvalues);
		
		return $this->update($data);
	}
	
	public function updateJobRunResultByID($ID,$job)
	{
		$mykeys = array('index' => $ID);
		$myvalues = array();
		
		$myvalues['status'] = $job->getStatus();
		$myvalues['result'] = $job->getResult();
		$myvalues['resultText'] = $job->getResultText();
		$myvalues['startTime'] = $job->getStartTime();
		
		$data = array('mykeys' => $mykeys, 'myvalues'=>$myvalues);
		
		return $this->update($data);
	}
	
	public function updateBGAJobTimeByID($ID,$job)
	{
		$mykeys = array('index' => $ID);
		
		$myvalues = array();
		
		$myvalues['settingType'] = $job->getSettingType();
		$myvalues['settingTime'] = $job->getSettingTime();
		$myvalues['settingDate'] = $job->getSettingDate();
		$myvalues['settingDateSupplement'] = $job->getSettingDateSupplement();
		$myvalues['status'] = ScheduleStatus::NOT_RUN;
		
		$data = array('mykeys' => $mykeys, 'myvalues'=>$myvalues);
		
		return $this->update($data);
	}
	
	public function deleteBGAJobByID($ID)
	{
		$data = array('mykeys' => array('index' => $ID));
		
		return $this->delete($data);
	}
	
	public function deleteBGAJobByDGID($DGID, $HBAID)
	{
		$data = array('mykeys' => array('VDID' => $DGID, "bgaType" => ScheduledBGAType::DG_BGA_MIGRATION ));
		$toBeDeleted = $this->query($data);
		$this->deleteBGAs($toBeDeleted, $HBAID);
		
		$data = array('mykeys' => array('VDID' => $DGID, "bgaType" => ScheduledBGAType::DG_BGA_REBUILD ));
		$toBeDeleted = $this->query($data);
		$this->deleteBGAs($toBeDeleted, $HBAID);
		
		return 1;
	}
	
	public function deleteBGAJobByVDID($VDID, $HBAID)
	{
		$data = array('mykeys' => array('VDID' => $VDID,
			"bgaType" => ScheduledBGAType::LD_BGA_CONSISTENCY_CHECK ));
		$toBeDeleted = $this->query($data);
		$this->deleteBGAs($toBeDeleted, $HBAID);
		
		$data = array('mykeys' => array('VDID' => $VDID,
			"bgaType" => ScheduledBGAType::LD_BGA_CONSISTENCY_FIX  ));
		$toBeDeleted = $this->query($data);
		$this->deleteBGAs($toBeDeleted, $HBAID);
		
		$data = array('mykeys' => array('VDID' => $VDID,
			"bgaType" => ScheduledBGAType::LD_BGA_INIT_BACK ));
		$toBeDeleted = $this->query($data);
		$this->deleteBGAs($toBeDeleted, $HBAID);
		
		$data = array('mykeys' => array('VDID' => $VDID,
			"bgaType" => ScheduledBGAType::LD_BGA_MIGRATION ));
		$toBeDeleted = $this->query($data);
		$this->deleteBGAs($toBeDeleted, $HBAID);
		
		$data = array('mykeys' => array('VDID' => $VDID,
			"bgaType" => ScheduledBGAType::LD_BGA_REBUILD ));
		$toBeDeleted = $this->query($data);
		$this->deleteBGAs($toBeDeleted, $HBAID);
		
		return 1;
	}
	
	private function deleteBGAs($jobs, $HBAID)
	{
		foreach ($jobs as $job)
		{
			$hbaID = getUrlPropertyValue($job->getCmdPara(), "HBAID");
			if ($hbaID == $HBAID) {
				$this->deleteBGAJobByID($job->getIndex());
			}
		}
	}

	public function getBBUJob($HBAID)
	{
		$data = array('mykeys' => array('bgaType' => ScheduledBGAType::BBU_BGA_RELEARN));
		$jobs = $this->query($data);
		if ($jobs) {
			foreach ($jobs as $job)
			{
				$hbaID = getUrlPropertyValue($job->getCmdPara(), "HBAID");
				if ($hbaID == $HBAID) {
					return $job;
				}
			}
		}
		else 
			return false;
	}
	
	public function deleteBBUJob($HBAID)
	{
		$job = $this->getBBUJob($HBAID);
		$this->deleteBGAJobByID($job->getIndex());
	}

	
	protected function dataWrapper($element)
	{
		return BGAJob::createBGAJobFromXMLElement($element);
	}
}
?>
