<?php
class SSDVolume
{
	private $ID = 0;
	private $AdapterID = 0;
	private $rawCapacity = 0;
    private $usableCapacity = 0;
    private $opLevel = 0;
    private $totalSSDWrite = 0;
    private $healthStatus = 0;
    private $lifeRemaining = 0;
    private $VDSize = 0;
    private $RaidMode = 0;
    private $VDStatus = 0;
 	private $BlockList = array();
 	private $BlockIDList = array();
    
 	private $BGAStatus = 0;
	private $Bga = 0;
	private $BgaPercentage = 0;
	private $BgaState = 0;
	
	public function __construct()
	{
		$this->BlockList = array();
	}
	
	public function getAdapterID()
	{
		return $this->AdapterID;
	}
	
	public function addBlock($blk)
	{
		$this->BlockList[$blk->getID()] = $blk;
		$blk->linkLD($this);
	}
	
	public function hasBlock($id)
	{
		if (isset($this->BlockList[$id])) {
			return true;
		}
		
		return false;
	}
	
	public function getBlockList()
	{
		return $this->BlockList;
	}
	
	public function getBlockIDList()
	{
		return $this->BlockIDList;
	}
	
	
    public function getRawCapacity()
    {
    	return $this->rawCapacity;
    }
    public function getUsableCapacity()
    {
    	return $this->usableCapacity;
    }
    public function getOpLevel()
    {
    	return $this->opLevel;
    }
    public function getTotalSSDWrite()
    {
    	return $this->totalSSDWrite;
    }
    public function getHealthStatus()
    {
    	return $this->healthStatus;
    }
    public function getLifeRemaining()
    {
    	return $this->lifeRemaining;
    }
    public function getVDSize()
    {
    	return $this->VDSize;
    }
    public function getRaidMode()
    {
    	return $this->RaidMode;
    }
    public function getVDStatus()
    {
    	return $this->VDStatus;
    }
    
	public function getBGAStatus()
	{
		return $this->BGAStatus;
	}
	
	public function getBga()
	{
		return $this->Bga;
	}
	
	public function getBgaPercentage()
	{
		return $this->BgaPercentage;
	}
	
	public function getBgaState()
	{
		return $this->BgaState;
	}
	
    public function setSSDVolumeInfo($Info)
    {
 		if (isset($Info->AdapterID)) {
 			$this->AdapterID = trim($Info->AdapterID);
 		}
		if (isset($Info->rawCapacity)) {
 			$this->rawCapacity = (trim($Info->rawCapacity));
 		}
		if (isset($Info->usableCapacity)) {
 			$this->usableCapacity = (trim($Info->usableCapacity));
 		}
		if (isset($Info->opLevel)) {
 			$this->opLevel = (trim($Info->opLevel));
 		}
		if (isset($Info->totalSSDWrite)) {
 			$this->totalSSDWrite = (trim($Info->totalSSDWrite));
 		}
		if (isset($Info->healthStatus)) {
 			$this->healthStatus = (trim($Info->healthStatus));
 		}
		if (isset($Info->lifeRemaining)) {
 			$this->lifeRemaining = (trim($Info->lifeRemaining));
 		}
		if (isset($Info->VDSize)) {
 			$this->VDSize = (trim($Info->VDSize));
 		}
		if (isset($Info->RaidMode)) {
 			$this->RaidMode = (trim($Info->RaidMode));
 		}
		if (isset($Info->VDStatus)) {
 			$this->VDStatus = (trim($Info->VDStatus));
 		}
 		
 		if (isset($Info->BGAStatus)) {
 			$this->BGAStatus = trim($Info->BGAStatus);
 		}
		if (isset($Info->Bga)) {
			$this->Bga = (trim($Info->Bga));
		}
		if (isset($Info->BgaPercentage)) {
			$this->BgaPercentage = (trim($Info->BgaPercentage));
		}
		if (isset($Info->BgaState)) {
			$this->BgaState = (trim($Info->BgaState));
		}
		
 		if (isset($Info->BlockIDs)) {
 			$this->BlockIDList = array();
 			$blocks = explode(' ', trim($Info->BlockIDs));
 			foreach ($blocks as $id)
 			{
 				if (trim($id) !== "" && $id != INVALID_ID) {
 					$this->BlockIDList[] = $id;
 				}
 			}
 		}
    }

}

?>